/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.MatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.MatchingRuleUse;
import org.opends.server.types.ResultCode;
import org.opends.server.types.Schema;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingRuleUseSyntax
extends AttributeSyntax {
    private static final String CLASS_NAME = "org.opends.server.schema.MatchingRuleUseSyntax";
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    public MatchingRuleUseSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.2", "MatchingRuleUseDescription");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.3", "MatchingRuleUseDescription");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.4", "MatchingRuleUseDescription");
        }
    }

    @Override
    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "MatchingRuleUseDescription";
    }

    @Override
    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.31";
    }

    @Override
    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "Matching Rule Use Description";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        try {
            MatchingRuleUseSyntax.decodeMatchingRuleUse(byteString, DirectoryServer.getSchema());
            return true;
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "valueIsAcceptable", directoryException));
            stringBuilder.append(directoryException.getErrorMessage());
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static MatchingRuleUse decodeMatchingRuleUse(ByteString byteString, Schema schema) throws DirectoryException {
        char c;
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "decodeMatchingRuleUse", String.valueOf(byteString)));
        String string = byteString.stringValue();
        String string2 = StaticUtils.toLowerCase(string);
        int n2 = string.length();
        for (n = 0; n < n2 && string.charAt(n) == ' '; ++n) {
        }
        if (n >= n2) {
            int n3 = 6488224;
            String string3 = MessageHandler.getMessage(n3);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n3);
        }
        if ((c = string.charAt(n++)) != '(') {
            int n4 = 6488225;
            String string4 = MessageHandler.getMessage(n4, string, n - 1, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n4);
        }
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n5 = 6488226;
            String string5 = MessageHandler.getMessage(n5, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n5);
        }
        int n6 = n;
        if (!StaticUtils.isDigit(c)) {
            while (n < n2 && (c = string.charAt(n++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) continue;
                int n7 = 6488229;
                String string6 = MessageHandler.getMessage(n7, string, Character.valueOf(c), n - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string6, n7);
            }
        } else {
            boolean bl = false;
            while (n < n2 && (c = string.charAt(n++)) != ' ') {
                if (c == '.') {
                    if (bl) {
                        int n8 = 6488227;
                        String string7 = MessageHandler.getMessage(n8, string, n - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string7, n8);
                    }
                    bl = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    int n9 = 6488228;
                    String string8 = MessageHandler.getMessage(n9, string, Character.valueOf(c), n - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string8, n9);
                }
                bl = false;
            }
        }
        if (n >= n2) {
            int n10 = 6488226;
            String string9 = MessageHandler.getMessage(n10, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string9, n10);
        }
        String string10 = string2.substring(n6, n - 1);
        MatchingRule matchingRule = schema.getMatchingRule(string10);
        if (matchingRule == null) {
            int n11 = 6488230;
            String string11 = MessageHandler.getMessage(n11, string, string10);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string11, n11);
        }
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n12 = 6488226;
            String string12 = MessageHandler.getMessage(n12, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string12, n12);
        }
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        String string13 = null;
        boolean bl = false;
        CopyOnWriteArraySet copyOnWriteArraySet = null;
        ConcurrentHashMap<String, CopyOnWriteArrayList<String>> concurrentHashMap2 = new ConcurrentHashMap<String, CopyOnWriteArrayList<String>>();
        block5: while (true) {
            Serializable serializable;
            block30: {
                String string14;
                int n13;
                AttributeType attributeType;
                CharSequence charSequence;
                block36: {
                    block34: {
                        String string15;
                        block32: {
                            block35: {
                                String string16;
                                block33: {
                                    block31: {
                                        StringBuilder stringBuilder = new StringBuilder();
                                        n = MatchingRuleUseSyntax.readTokenName(string, stringBuilder, n);
                                        string15 = stringBuilder.toString();
                                        string16 = StaticUtils.toLowerCase(string15);
                                        if (!string15.equals(")")) break block31;
                                        if (n < n2) {
                                            int n14 = 6488231;
                                            charSequence = MessageHandler.getMessage(n14, string, n - 1);
                                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, (String)charSequence, n14);
                                        }
                                        break block32;
                                    }
                                    if (!string16.equals("name")) break block33;
                                    if ((c = string.charAt(n++)) == '\'') {
                                        serializable = new StringBuilder();
                                        charSequence = new StringBuilder();
                                        n = MatchingRuleUseSyntax.readQuotedString(string, string2, (StringBuilder)serializable, (StringBuilder)charSequence, n - 1);
                                        concurrentHashMap.put(((StringBuilder)charSequence).toString(), ((StringBuilder)serializable).toString());
                                        continue;
                                    }
                                    if (c != '(') {
                                        int n15 = 6488232;
                                        charSequence = MessageHandler.getMessage(n15, string, Character.valueOf(c), n - 1);
                                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, (String)charSequence, n15);
                                    }
                                    break block34;
                                }
                                if (string16.equals("desc")) {
                                    serializable = new StringBuilder();
                                    n = MatchingRuleUseSyntax.readQuotedString(string, (StringBuilder)serializable, n);
                                    string13 = ((StringBuilder)serializable).toString();
                                    continue;
                                }
                                if (string16.equals("obsolete")) {
                                    bl = true;
                                    continue;
                                }
                                if (!string16.equals("applies")) break block35;
                                serializable = new LinkedList();
                                if ((c = string.charAt(n++)) == '(') break block36;
                                charSequence = new StringBuilder();
                                n = MatchingRuleUseSyntax.readWOID(string2, (StringBuilder)charSequence, n - 1);
                                attributeType = schema.getAttributeType(((StringBuilder)charSequence).toString());
                                if (attributeType == null) {
                                    n13 = 6488233;
                                    string14 = MessageHandler.getMessage(n13, string10, ((StringBuilder)charSequence).toString());
                                    Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string14, n13);
                                    attributeType = DirectoryServer.getDefaultAttributeType(((StringBuilder)charSequence).toString());
                                }
                                ((LinkedList)serializable).add(attributeType);
                                break block30;
                            }
                            serializable = new CopyOnWriteArrayList();
                            n = MatchingRuleUseSyntax.readExtraParameterValues(string, (CopyOnWriteArrayList<String>)serializable, n);
                            concurrentHashMap2.put(string15, (CopyOnWriteArrayList<String>)serializable);
                            continue;
                        }
                        if (copyOnWriteArraySet == null) {
                            int n16 = 6488234;
                            string15 = MessageHandler.getMessage(n16, string);
                            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string15, n16);
                        }
                        return new MatchingRuleUse(matchingRule, concurrentHashMap, string13, bl, copyOnWriteArraySet, concurrentHashMap2);
                    }
                    serializable = new StringBuilder();
                    charSequence = new StringBuilder();
                    n = MatchingRuleUseSyntax.readQuotedString(string, string2, (StringBuilder)serializable, (StringBuilder)charSequence, n);
                    concurrentHashMap.put(((StringBuilder)charSequence).toString(), ((StringBuilder)serializable).toString());
                    while (true) {
                        if (string.charAt(n) == ')') {
                            ++n;
                            while (true) {
                                if (n >= n2 || (c = string.charAt(n)) != ' ') continue block5;
                                ++n;
                            }
                        }
                        serializable = new StringBuilder();
                        charSequence = new StringBuilder();
                        n = MatchingRuleUseSyntax.readQuotedString(string, string2, (StringBuilder)serializable, (StringBuilder)charSequence, n);
                        concurrentHashMap.put(((StringBuilder)charSequence).toString(), ((StringBuilder)serializable).toString());
                    }
                }
                do {
                    charSequence = new StringBuilder();
                    n = MatchingRuleUseSyntax.readWOID(string2, (StringBuilder)charSequence, n);
                    attributeType = schema.getAttributeType(((StringBuilder)charSequence).toString());
                    if (attributeType == null) {
                        n13 = 6488233;
                        string14 = MessageHandler.getMessage(n13, string10, ((StringBuilder)charSequence).toString());
                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string14, n13);
                        attributeType = DirectoryServer.getDefaultAttributeType(((StringBuilder)charSequence).toString());
                    }
                    ((LinkedList)serializable).add(attributeType);
                    c = string.charAt(n++);
                    if (c == ')') break block30;
                } while (c == '$');
                n13 = 6488232;
                string14 = MessageHandler.getMessage(n13, string, Character.valueOf(c), n - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string14, n13);
            }
            copyOnWriteArraySet = new CopyOnWriteArraySet(serializable);
        }
    }

    private static int readTokenName(String string, StringBuilder stringBuilder, int n) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "readTokenName", String.valueOf(string), "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n2 = string.length();
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n3 = 6488226;
            String string2 = MessageHandler.getMessage(n3, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n3);
        }
        while (n < n2 && (c = string.charAt(n++)) != ' ') {
            stringBuilder.append(c);
        }
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        return n;
    }

    private static int readQuotedString(String string, StringBuilder stringBuilder, int n) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "readQuotedString", String.valueOf(string), "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n2 = string.length();
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n3 = 6488226;
            String string2 = MessageHandler.getMessage(n3, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n3);
        }
        if (c != '\'') {
            int n4 = 6488235;
            String string3 = MessageHandler.getMessage(n4, string, n, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n4);
        }
        ++n;
        while (n < n2 && (c = string.charAt(n)) != '\'') {
            stringBuilder.append(c);
            ++n;
        }
        ++n;
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n5 = 6488226;
            String string4 = MessageHandler.getMessage(n5, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n5);
        }
        return n;
    }

    private static int readQuotedString(String string, String string2, StringBuilder stringBuilder, StringBuilder stringBuilder2, int n) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "readQuotedString", String.valueOf(string), String.valueOf(string2), "java.lang.StringBuilder", "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n2 = string2.length();
        while (n < n2 && (c = string2.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n3 = 6488226;
            String string3 = MessageHandler.getMessage(n3, string2);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n3);
        }
        if (c != '\'') {
            int n4 = 6488235;
            String string4 = MessageHandler.getMessage(n4, string, n, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n4);
        }
        ++n;
        while (n < n2 && (c = string2.charAt(n)) != '\'') {
            stringBuilder2.append(c);
            stringBuilder.append(string.charAt(n));
            ++n;
        }
        ++n;
        while (n < n2 && (c = string2.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n5 = 6488226;
            String string5 = MessageHandler.getMessage(n5, string2);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n5);
        }
        return n;
    }

    private static int readWOID(String string, StringBuilder stringBuilder, int n) throws DirectoryException {
        int n2;
        assert (Debug.debugEnter(CLASS_NAME, "readWOID", String.valueOf(string), "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n3 = string.length();
        while (n < n3 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n3) {
            int n4 = 6488226;
            String string2 = MessageHandler.getMessage(n4, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n4);
        }
        if (StaticUtils.isDigit(c)) {
            n2 = 0;
            while (n < n3 && (c = string.charAt(n++)) != ' ') {
                if (c == '.') {
                    if (n2 != 0) {
                        int n5 = 6488227;
                        String string3 = MessageHandler.getMessage(n5, string, n - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n5);
                    }
                    stringBuilder.append(c);
                    n2 = 1;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    if (c == ')') {
                        return n - 1;
                    }
                    int n6 = 6488228;
                    String string4 = MessageHandler.getMessage(n6, string, Character.valueOf(c), n - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n6);
                }
                stringBuilder.append(c);
                n2 = 0;
            }
        } else if (StaticUtils.isAlpha(c)) {
            while (n < n3 && (c = string.charAt(n++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) {
                    stringBuilder.append(c);
                    continue;
                }
                if (c == ')') {
                    return n - 1;
                }
                int n7 = 6488229;
                String string5 = MessageHandler.getMessage(n7, string, Character.valueOf(c), n - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n7);
            }
        } else {
            int n8 = 6488232;
            String string6 = MessageHandler.getMessage(n8, string, Character.valueOf(c), n);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string6, n8);
        }
        while (n < n3 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n3) {
            n2 = 6488226;
            String string7 = MessageHandler.getMessage(n2, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string7, n2);
        }
        return n;
    }

    private static int readExtraParameterValues(String string, CopyOnWriteArrayList<String> copyOnWriteArrayList, int n) throws DirectoryException {
        StringBuilder stringBuilder;
        assert (Debug.debugEnter(CLASS_NAME, "readExtraParameterValues", String.valueOf(string), "java.util.concurrent.CopyOnWriteArrayList<String>", String.valueOf(n)));
        int n2 = string.length();
        char c = string.charAt(n++);
        while (n < n2 && c == ' ') {
            c = string.charAt(n++);
        }
        if (n >= n2) {
            int n3 = 6488226;
            String string2 = MessageHandler.getMessage(n3, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n3);
        }
        if (c == '\'') {
            stringBuilder = new StringBuilder();
            while (n < n2 && (c = string.charAt(n++)) != '\'') {
                stringBuilder.append(c);
            }
            copyOnWriteArrayList.add(stringBuilder.toString());
        } else if (c == '(') {
            while (true) {
                ++n;
                while (n < n2 && (c = string.charAt(n)) == ' ') {
                    ++n;
                }
                if (n >= n2) {
                    int n4 = 6488226;
                    String string3 = MessageHandler.getMessage(n4, string);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n4);
                }
                if (c != ')') {
                    if (c == '(') {
                        int n5 = 6488232;
                        String string4 = MessageHandler.getMessage(n5, string, Character.valueOf(c), n);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n5);
                    }
                    n = MatchingRuleUseSyntax.readExtraParameterValues(string, copyOnWriteArrayList, n);
                    continue;
                }
                break;
            }
        } else {
            stringBuilder = new StringBuilder();
            while (n < n2 && (c = string.charAt(n++)) != ' ') {
                stringBuilder.append(c);
            }
            copyOnWriteArrayList.add(stringBuilder.toString());
        }
        while (n < n2 && string.charAt(n) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n6 = 6488226;
            String string5 = MessageHandler.getMessage(n6, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n6);
        }
        return n;
    }
}

