/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchingRuleSyntax
extends AttributeSyntax {
    private static final String CLASS_NAME = "org.opends.server.schema.MatchingRuleSyntax";
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    public MatchingRuleSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.2", "MatchingRuleDescription");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.3", "MatchingRuleDescription");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.4", "MatchingRuleDescription");
        }
    }

    @Override
    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "MatchingRuleDescription";
    }

    @Override
    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.30";
    }

    @Override
    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "Matching Rule Description";
    }

    @Override
    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    @Override
    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return this.defaultOrderingMatchingRule;
    }

    @Override
    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return this.defaultSubstringMatchingRule;
    }

    @Override
    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return null;
    }

    @Override
    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        char c;
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        String string = byteString.stringValue();
        String string2 = StaticUtils.toLowerCase(string);
        int n2 = string.length();
        for (n = 0; n < n2 && string.charAt(n) == ' '; ++n) {
        }
        if (n >= n2) {
            int n3 = 6488213;
            stringBuilder.append(MessageHandler.getMessage(n3));
            return false;
        }
        if ((c = string.charAt(n++)) != '(') {
            int n4 = 6488214;
            stringBuilder.append(MessageHandler.getMessage(n4, string, n - 1, Character.valueOf(c)));
            return false;
        }
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n5 = 6488215;
            stringBuilder.append(MessageHandler.getMessage(n5, string));
            return false;
        }
        int n6 = n;
        if (StaticUtils.isDigit(c)) {
            boolean bl = false;
            while (n < n2 && (c = string.charAt(n++)) != ' ') {
                if (c == '.') {
                    if (bl) {
                        int n7 = 6488216;
                        stringBuilder.append(MessageHandler.getMessage(n7, string, n - 1));
                        return false;
                    }
                    bl = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    int n8 = 6488217;
                    stringBuilder.append(MessageHandler.getMessage(n8, string, Character.valueOf(c), n - 1));
                    return false;
                }
                bl = false;
            }
        } else {
            while (n < n2 && (c = string.charAt(n++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) continue;
                int n9 = 6488218;
                stringBuilder.append(MessageHandler.getMessage(n9, string, Character.valueOf(c), n - 1));
                return false;
            }
        }
        if (n >= n2) {
            int n10 = 6488215;
            stringBuilder.append(MessageHandler.getMessage(n10, string));
            return false;
        }
        String string3 = string2.substring(n6, n - 1);
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n11 = 6488215;
            stringBuilder.append(MessageHandler.getMessage(n11, string));
            return false;
        }
        ConcurrentHashMap<String, String> concurrentHashMap = new ConcurrentHashMap<String, String>();
        AttributeSyntax attributeSyntax = null;
        ConcurrentHashMap<String, Serializable> concurrentHashMap2 = new ConcurrentHashMap<String, Serializable>();
        block19: while (true) {
            Serializable serializable;
            StringBuilder stringBuilder2 = new StringBuilder();
            try {
                n = MatchingRuleSyntax.readTokenName(string, stringBuilder2, n);
            }
            catch (DirectoryException directoryException) {
                assert (Debug.debugException(CLASS_NAME, "valueIsAcceptable", directoryException));
                stringBuilder.append(directoryException.getErrorMessage());
                return false;
            }
            String string4 = stringBuilder2.toString();
            String string5 = StaticUtils.toLowerCase(string4);
            if (string4.equals(")")) {
                if (n >= n2) break;
                int n12 = 6488219;
                stringBuilder.append(MessageHandler.getMessage(n12, string, n - 1));
                return false;
            }
            if (string5.equals("name")) {
                if ((c = string.charAt(n++)) == '\'') {
                    serializable = new StringBuilder();
                    StringBuilder stringBuilder3 = new StringBuilder();
                    try {
                        n = MatchingRuleSyntax.readQuotedString(string, string2, (StringBuilder)serializable, stringBuilder3, n - 1);
                    }
                    catch (DirectoryException directoryException) {
                        assert (Debug.debugException(CLASS_NAME, "valueIsAcceptable", directoryException));
                        stringBuilder.append(directoryException.getErrorMessage());
                        return false;
                    }
                    concurrentHashMap.put(stringBuilder3.toString(), ((StringBuilder)serializable).toString());
                    continue;
                }
                if (c == '(') {
                    serializable = new StringBuilder();
                    StringBuilder stringBuilder4 = new StringBuilder();
                    try {
                        n = MatchingRuleSyntax.readQuotedString(string, string2, (StringBuilder)serializable, stringBuilder4, n);
                    }
                    catch (DirectoryException directoryException) {
                        assert (Debug.debugException(CLASS_NAME, "valueIsAcceptable", directoryException));
                        stringBuilder.append(directoryException.getErrorMessage());
                        return false;
                    }
                    concurrentHashMap.put(stringBuilder4.toString(), ((StringBuilder)serializable).toString());
                    while (true) {
                        if (string.charAt(n) == ')') {
                            ++n;
                            while (true) {
                                if (n >= n2 || (c = string.charAt(n)) != ' ') continue block19;
                                ++n;
                            }
                        }
                        serializable = new StringBuilder();
                        stringBuilder4 = new StringBuilder();
                        try {
                            n = MatchingRuleSyntax.readQuotedString(string, string2, (StringBuilder)serializable, stringBuilder4, n);
                        }
                        catch (DirectoryException directoryException) {
                            assert (Debug.debugException(CLASS_NAME, "valueIsAcceptable", directoryException));
                            stringBuilder.append(directoryException.getErrorMessage());
                            return false;
                        }
                        concurrentHashMap.put(stringBuilder4.toString(), ((StringBuilder)serializable).toString());
                    }
                }
                int n13 = 6488220;
                stringBuilder.append(MessageHandler.getMessage(n13, string, Character.valueOf(c), n - 1));
                return false;
            }
            if (string5.equals("desc")) {
                serializable = new StringBuilder();
                try {
                    n = MatchingRuleSyntax.readQuotedString(string, (StringBuilder)serializable, n);
                }
                catch (DirectoryException directoryException) {
                    assert (Debug.debugException(CLASS_NAME, "valueIsAcceptable", directoryException));
                    stringBuilder.append(directoryException.getErrorMessage());
                    return false;
                }
            }
            if (string5.equals("obsolete")) continue;
            if (string5.equals("syntax")) {
                serializable = new StringBuilder();
                try {
                    n = MatchingRuleSyntax.readWOID(string2, (StringBuilder)serializable, n);
                }
                catch (DirectoryException directoryException) {
                    assert (Debug.debugException(CLASS_NAME, "valueIsAcceptable", directoryException));
                    stringBuilder.append(directoryException.getErrorMessage());
                    return false;
                }
                attributeSyntax = DirectoryServer.getAttributeSyntax(((StringBuilder)serializable).toString(), false);
                if (attributeSyntax != null) continue;
                int n14 = 6488221;
                String string6 = MessageHandler.getMessage(n14, string, ((StringBuilder)serializable).toString());
                Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string6, n14);
                attributeSyntax = DirectoryServer.getDefaultAttributeSyntax();
                continue;
            }
            serializable = new CopyOnWriteArrayList();
            try {
                n = MatchingRuleSyntax.readExtraParameterValues(string, (CopyOnWriteArrayList<String>)serializable, n);
            }
            catch (DirectoryException directoryException) {
                assert (Debug.debugException(CLASS_NAME, "valueIsAcceptable", directoryException));
                stringBuilder.append(directoryException.getErrorMessage());
                return false;
            }
            concurrentHashMap2.put(string4, serializable);
        }
        if (attributeSyntax == null) {
            int n15 = 6488222;
            stringBuilder.append(MessageHandler.getMessage(n15, string));
            return false;
        }
        return true;
    }

    private static int readTokenName(String string, StringBuilder stringBuilder, int n) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "readTokenName", String.valueOf(string), "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n2 = string.length();
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n3 = 6488215;
            String string2 = MessageHandler.getMessage(n3, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n3);
        }
        while (n < n2 && (c = string.charAt(n++)) != ' ') {
            stringBuilder.append(c);
        }
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        return n;
    }

    private static int readQuotedString(String string, StringBuilder stringBuilder, int n) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "readQuotedString", String.valueOf(string), "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n2 = string.length();
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n3 = 6488215;
            String string2 = MessageHandler.getMessage(n3, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n3);
        }
        if (c != '\'') {
            int n4 = 6488223;
            String string3 = MessageHandler.getMessage(n4, string, n, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n4);
        }
        ++n;
        while (n < n2 && (c = string.charAt(n)) != '\'') {
            stringBuilder.append(c);
            ++n;
        }
        ++n;
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n5 = 6488215;
            String string4 = MessageHandler.getMessage(n5, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n5);
        }
        return n;
    }

    private static int readQuotedString(String string, String string2, StringBuilder stringBuilder, StringBuilder stringBuilder2, int n) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "readQuotedString", String.valueOf(string), String.valueOf(string2), "java.lang.StringBuilder", "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n2 = string2.length();
        while (n < n2 && (c = string2.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n3 = 6488215;
            String string3 = MessageHandler.getMessage(n3, string2);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n3);
        }
        if (c != '\'') {
            int n4 = 6488223;
            String string4 = MessageHandler.getMessage(n4, string, n, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n4);
        }
        ++n;
        while (n < n2 && (c = string2.charAt(n)) != '\'') {
            stringBuilder2.append(c);
            stringBuilder.append(string.charAt(n));
            ++n;
        }
        ++n;
        while (n < n2 && (c = string2.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n5 = 6488215;
            String string5 = MessageHandler.getMessage(n5, string2);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n5);
        }
        return n;
    }

    private static int readWOID(String string, StringBuilder stringBuilder, int n) throws DirectoryException {
        int n2;
        assert (Debug.debugEnter(CLASS_NAME, "readWOID", String.valueOf(string), "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n3 = string.length();
        while (n < n3 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n3) {
            int n4 = 6488135;
            String string2 = MessageHandler.getMessage(n4, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n4);
        }
        if (StaticUtils.isDigit(c)) {
            n2 = 0;
            while (n < n3 && (c = string.charAt(n++)) != ' ') {
                if (c == '.') {
                    if (n2 != 0) {
                        int n5 = 6488136;
                        String string3 = MessageHandler.getMessage(n5, string, n - 1);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n5);
                    }
                    stringBuilder.append(c);
                    n2 = 1;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    if (c == ')') {
                        return n - 1;
                    }
                    int n6 = 6488137;
                    String string4 = MessageHandler.getMessage(n6, string, Character.valueOf(c), n - 1);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n6);
                }
                stringBuilder.append(c);
                n2 = 0;
            }
        } else if (StaticUtils.isAlpha(c)) {
            while (n < n3 && (c = string.charAt(n++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) {
                    stringBuilder.append(c);
                    continue;
                }
                if (c == ')') {
                    return n - 1;
                }
                int n7 = 6488138;
                String string5 = MessageHandler.getMessage(n7, string, Character.valueOf(c), n - 1);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n7);
            }
        } else {
            int n8 = 6488139;
            String string6 = MessageHandler.getMessage(n8, string, Character.valueOf(c), n);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string6, n8);
        }
        while (n < n3 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n3) {
            n2 = 6488135;
            String string7 = MessageHandler.getMessage(n2, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string7, n2);
        }
        return n;
    }

    private static int readExtraParameterValues(String string, CopyOnWriteArrayList<String> copyOnWriteArrayList, int n) throws DirectoryException {
        StringBuilder stringBuilder;
        assert (Debug.debugEnter(CLASS_NAME, "readExtraParameterValues", String.valueOf(string), "java.util.concurrent.CopyOnWriteArrayList<String>", String.valueOf(n)));
        int n2 = string.length();
        char c = string.charAt(n++);
        while (n < n2 && c == ' ') {
            c = string.charAt(n++);
        }
        if (n >= n2) {
            int n3 = 6488215;
            String string2 = MessageHandler.getMessage(n3, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n3);
        }
        if (c == '\'') {
            stringBuilder = new StringBuilder();
            while (n < n2 && (c = string.charAt(n++)) != '\'') {
                stringBuilder.append(c);
            }
            copyOnWriteArrayList.add(stringBuilder.toString());
        } else if (c == '(') {
            while (true) {
                ++n;
                while (n < n2 && (c = string.charAt(n)) == ' ') {
                    ++n;
                }
                if (n >= n2) {
                    int n4 = 6488215;
                    String string3 = MessageHandler.getMessage(n4, string);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n4);
                }
                if (c != ')') {
                    if (c == '(') {
                        int n5 = 6488220;
                        String string4 = MessageHandler.getMessage(n5, string, Character.valueOf(c), n);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n5);
                    }
                    n = MatchingRuleSyntax.readExtraParameterValues(string, copyOnWriteArrayList, n);
                    continue;
                }
                break;
            }
        } else {
            stringBuilder = new StringBuilder();
            while (n < n2 && (c = string.charAt(n++)) != ' ') {
                stringBuilder.append(c);
            }
            copyOnWriteArrayList.add(stringBuilder.toString());
        }
        while (n < n2 && string.charAt(n) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n6 = 6488215;
            String string5 = MessageHandler.getMessage(n6, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n6);
        }
        return n;
    }
}

