/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

public class CaseExactIA5EqualityMatchingRule
extends EqualityMatchingRule {
    private static final String CLASS_NAME = "org.opends.server.schema.CaseExactIA5EqualityMatchingRule";

    public CaseExactIA5EqualityMatchingRule() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeMatchingRule(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMatchingRule", String.valueOf(configEntry)));
    }

    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        return "caseExactIA5Match";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.1466.109.114.1";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return null;
    }

    public String getSyntaxOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.26";
    }

    public ByteString normalizeValue(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "normalizeValue", String.valueOf(byteString)));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(byteString.stringValue().trim());
        int n = stringBuilder.length();
        if (n == 0) {
            if (byteString.value().length > 0) {
                return new ASN1OctetString(" ");
            }
            return new ASN1OctetString();
        }
        boolean bl = false;
        block4: for (int i = n - 1; i > 0; --i) {
            char c = stringBuilder.charAt(i);
            if (c == ' ') {
                if (stringBuilder.charAt(i - 1) != ' ') continue;
                stringBuilder.delete(i, i + 1);
                continue;
            }
            if ((c & 0x7F) == c) continue;
            int n2 = 6422610;
            String string = MessageHandler.getMessage(n2, byteString.stringValue(), Character.valueOf(c));
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string, n2);
                }
                case WARN: {
                    if (!bl) {
                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string, n2);
                        bl = true;
                    }
                    stringBuilder.delete(i, i + 1);
                    continue block4;
                }
                default: {
                    stringBuilder.delete(i, i + 1);
                }
            }
        }
        return new ASN1OctetString(stringBuilder.toString());
    }

    public boolean areEqual(ByteString byteString, ByteString byteString2) {
        assert (Debug.debugEnter(CLASS_NAME, "areEqual", String.valueOf(byteString), String.valueOf(byteString2)));
        return Arrays.equals(byteString.value(), byteString2.value());
    }
}

