/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.AttributeValueDecoder;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;

public class BooleanSyntax
extends AttributeSyntax {
    private static final String CLASS_NAME = "org.opends.server.schema.BooleanSyntax";
    private EqualityMatchingRule defaultEqualityMatchingRule;
    public static final AttributeValueDecoder<Boolean> DECODER = new AttributeValueDecoder<Boolean>(){

        @Override
        public Boolean decode(AttributeValue attributeValue) throws DirectoryException {
            ByteString byteString = attributeValue.getNormalizedValue();
            return BooleanSyntax.decodeBooleanValue(byteString);
        }
    };

    public BooleanSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.13");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.13", "Boolean");
        }
    }

    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "Boolean";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.7";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "Boolean";
    }

    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return null;
    }

    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return null;
    }

    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return null;
    }

    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        boolean bl;
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        String string = byteString.stringValue().toUpperCase();
        boolean bl2 = bl = string.equals("TRUE") || string.equals("YES") || string.equals("ON") || string.equals("1") || string.equals("FALSE") || string.equals("NO") || string.equals("OFF") || string.equals("0");
        if (!bl) {
            stringBuilder.append(MessageHandler.getMessage(6422533, byteString.stringValue()));
        }
        return bl;
    }

    public static AttributeValue createBooleanValue(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "createBooleanValue", String.valueOf(bl)));
        if (bl) {
            return new AttributeValue(new ASN1OctetString("TRUE"), (ByteString)new ASN1OctetString("TRUE"));
        }
        return new AttributeValue(new ASN1OctetString("FALSE"), (ByteString)new ASN1OctetString("FALSE"));
    }

    public static boolean decodeBooleanValue(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "decodeBooleanValue", String.valueOf(byteString)));
        String string = byteString.stringValue();
        if (string.equals("TRUE")) {
            return true;
        }
        if (string.equals("FALSE")) {
            return false;
        }
        int n = 6422533;
        String string2 = MessageHandler.getMessage(n, string);
        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n);
    }
}

