/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Enumerated;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.util.ServerConstants;

public class LDAPModification {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.LDAPModification";
    private LDAPAttribute attribute;
    private ModificationType modificationType;

    public LDAPModification(ModificationType modificationType, LDAPAttribute lDAPAttribute) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf((Object)modificationType), String.valueOf(lDAPAttribute)));
        this.modificationType = modificationType;
        this.attribute = lDAPAttribute;
    }

    public ModificationType getModificationType() {
        assert (Debug.debugEnter(CLASS_NAME, "getModificationType", new String[0]));
        return this.modificationType;
    }

    public void setModificationType(ModificationType modificationType) {
        assert (Debug.debugEnter(CLASS_NAME, "setModificationType", String.valueOf((Object)modificationType)));
        this.modificationType = modificationType;
    }

    public LDAPAttribute getAttribute() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttribute", new String[0]));
        return this.attribute;
    }

    public void setAttribute(LDAPAttribute lDAPAttribute) {
        assert (Debug.debugEnter(CLASS_NAME, "setAttribute", String.valueOf(lDAPAttribute)));
        this.attribute = lDAPAttribute;
    }

    public ASN1Element encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(2);
        arrayList.add(new ASN1Enumerated(this.modificationType.intValue()));
        arrayList.add(this.attribute.encode());
        return new ASN1Sequence(arrayList);
    }

    public static LDAPModification decode(ASN1Element aSN1Element) throws LDAPException {
        LDAPAttribute lDAPAttribute;
        ModificationType modificationType;
        ArrayList<ASN1Element> arrayList;
        assert (Debug.debugEnter(CLASS_NAME, "decode", String.valueOf(aSN1Element)));
        try {
            arrayList = aSN1Element.decodeAsSequence().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decode", exception));
            int n = 2293869;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string, exception);
        }
        int n = arrayList.size();
        if (n != 2) {
            int n2 = 2293870;
            String string = MessageHandler.getMessage(n2, n);
            throw new LDAPException(2, n2, string);
        }
        try {
            switch (arrayList.get(0).decodeAsEnumerated().intValue()) {
                case 0: {
                    modificationType = ModificationType.ADD;
                    break;
                }
                case 1: {
                    modificationType = ModificationType.DELETE;
                    break;
                }
                case 2: {
                    modificationType = ModificationType.REPLACE;
                    break;
                }
                case 3: {
                    modificationType = ModificationType.INCREMENT;
                    break;
                }
                default: {
                    int n3 = arrayList.get(0).decodeAsEnumerated().intValue();
                    int n4 = 2293871;
                    String string = MessageHandler.getMessage(n4, n3);
                    throw new LDAPException(2, n4, string);
                }
            }
        }
        catch (LDAPException lDAPException) {
            throw lDAPException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decode", exception));
            int n5 = 2293872;
            String string = MessageHandler.getMessage(n5, String.valueOf(exception));
            throw new LDAPException(2, n5, string, exception);
        }
        try {
            lDAPAttribute = LDAPAttribute.decode(arrayList.get(1));
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decode", exception));
            int n6 = 2293873;
            String string = MessageHandler.getMessage(n6, String.valueOf(exception));
            throw new LDAPException(2, n6, string, exception);
        }
        return new LDAPModification(modificationType, lDAPAttribute);
    }

    public Modification toModification() throws LDAPException {
        return new Modification(this.modificationType, this.attribute.toAttribute());
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("LDAPModification(type=");
        stringBuilder.append(String.valueOf((Object)this.modificationType));
        stringBuilder.append(", attr=");
        this.attribute.toString(stringBuilder);
        stringBuilder.append("})");
    }

    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("LDAP Modification");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Modification Type:  ");
        stringBuilder.append(String.valueOf((Object)this.modificationType));
        stringBuilder.append(" (");
        stringBuilder.append(this.modificationType.intValue());
        stringBuilder.append(")");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("  Attribute:");
        stringBuilder.append(ServerConstants.EOL);
        this.attribute.toString(stringBuilder, n + 4);
    }
}

