/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public class IntermediateResponseProtocolOp
extends ProtocolOp {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.IntermediateResponseProtocolOp";
    private ASN1OctetString value;
    private String oid;

    public IntermediateResponseProtocolOp(String string) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string)));
        this.oid = string;
        this.value = null;
    }

    public IntermediateResponseProtocolOp(String string, ASN1OctetString aSN1OctetString) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(aSN1OctetString)));
        this.oid = string;
        this.value = aSN1OctetString;
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return this.oid;
    }

    public void setOID(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setOID", String.valueOf(string)));
        this.oid = string;
    }

    public ASN1OctetString getValue() {
        assert (Debug.debugEnter(CLASS_NAME, "getValue", new String[0]));
        return this.value;
    }

    public void setValue(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", new String[0]));
        this.value = aSN1OctetString;
    }

    public byte getType() {
        assert (Debug.debugEnter(CLASS_NAME, "getType", new String[0]));
        return 121;
    }

    public String getProtocolOpName() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolOpName", new String[0]));
        return "Intermediate Response";
    }

    public ASN1Element encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(2);
        if (this.oid != null) {
            arrayList.add(new ASN1OctetString(-128, this.oid));
        }
        if (this.value != null) {
            this.value.setType((byte)-127);
            arrayList.add(this.value);
        }
        return new ASN1Sequence(121, arrayList);
    }

    public static IntermediateResponseProtocolOp decodeIntermediateResponse(ASN1Element aSN1Element) throws LDAPException {
        ArrayList<ASN1Element> arrayList;
        assert (Debug.debugEnter(CLASS_NAME, "decodeIntermediateResponse", String.valueOf(aSN1Element)));
        try {
            arrayList = aSN1Element.decodeAsSequence().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeIntermediateResponse", exception));
            int n = 2294074;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string, exception);
        }
        int n = arrayList.size();
        if (n > 2) {
            int n2 = 2294075;
            String string = MessageHandler.getMessage(n2, n);
            throw new LDAPException(2, n2, string);
        }
        String string = null;
        ASN1OctetString aSN1OctetString = null;
        if (arrayList.size() == 1) {
            ASN1Element aSN1Element2 = arrayList.get(0);
            switch (aSN1Element2.getType()) {
                case -128: {
                    try {
                        string = aSN1Element2.decodeAsOctetString().stringValue();
                        break;
                    }
                    catch (ASN1Exception aSN1Exception) {
                        assert (Debug.debugException(CLASS_NAME, "decodeIntermediateResponse", aSN1Exception));
                        int n3 = 2294076;
                        String string2 = MessageHandler.getMessage(n3, aSN1Exception.getMessage());
                        throw new LDAPException(2, n3, string2);
                    }
                }
                case -127: {
                    try {
                        aSN1OctetString = aSN1Element2.decodeAsOctetString();
                        break;
                    }
                    catch (ASN1Exception aSN1Exception) {
                        assert (Debug.debugException(CLASS_NAME, "decodeIntermediateResponse", aSN1Exception));
                        int n4 = 2294077;
                        String string3 = MessageHandler.getMessage(n4, aSN1Exception.getMessage());
                        throw new LDAPException(2, n4, string3);
                    }
                }
                default: {
                    int n5 = 2294078;
                    String string4 = MessageHandler.getMessage(n5, StaticUtils.byteToHex(aSN1Element2.getType()));
                    throw new LDAPException(2, n5, string4);
                }
            }
        } else if (arrayList.size() == 2) {
            try {
                string = arrayList.get(0).decodeAsOctetString().stringValue();
            }
            catch (ASN1Exception aSN1Exception) {
                assert (Debug.debugException(CLASS_NAME, "decodeIntermediateResponse", aSN1Exception));
                int n6 = 2294076;
                String string5 = MessageHandler.getMessage(n6, aSN1Exception.getMessage());
                throw new LDAPException(2, n6, string5);
            }
            try {
                aSN1OctetString = arrayList.get(1).decodeAsOctetString();
            }
            catch (ASN1Exception aSN1Exception) {
                assert (Debug.debugException(CLASS_NAME, "decodeIntermediateResponse", aSN1Exception));
                int n7 = 2294076;
                String string6 = MessageHandler.getMessage(n7, aSN1Exception.getMessage());
                throw new LDAPException(2, n7, string6);
            }
        }
        return new IntermediateResponseProtocolOp(string, aSN1OctetString);
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("IntermediateResponse(oid=");
        stringBuilder.append(String.valueOf(this.oid));
        if (this.value != null) {
            stringBuilder.append(", value=");
            this.value.toString(stringBuilder);
        }
        stringBuilder.append(")");
    }

    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("Intermediate Response");
        stringBuilder.append(ServerConstants.EOL);
        if (this.oid != null) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("  OID:  ");
            stringBuilder.append(this.oid);
            stringBuilder.append(ServerConstants.EOL);
        }
        if (this.value != null) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("  Value:");
            stringBuilder.append(ServerConstants.EOL);
            this.value.toString(stringBuilder, n + 4);
        }
    }
}

