/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Enumerated;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.DN;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindResponseProtocolOp
extends ProtocolOp {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.BindResponseProtocolOp";
    private ASN1OctetString serverSASLCredentials;
    private DN matchedDN;
    private int resultCode;
    private List<String> referralURLs;
    private String errorMessage;

    public BindResponseProtocolOp(int n) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(n)));
        this.resultCode = n;
        this.errorMessage = null;
        this.matchedDN = null;
        this.referralURLs = null;
        this.serverSASLCredentials = null;
    }

    public BindResponseProtocolOp(int n, String string) {
        assert (Debug.debugEnter(CLASS_NAME, String.valueOf(n), String.valueOf(string)));
        this.resultCode = n;
        this.errorMessage = string;
        this.matchedDN = null;
        this.referralURLs = null;
        this.serverSASLCredentials = null;
    }

    public BindResponseProtocolOp(int n, String string, DN dN, List<String> list) {
        assert (Debug.debugEnter(CLASS_NAME, String.valueOf(n), String.valueOf(string), String.valueOf(dN), String.valueOf(list)));
        this.resultCode = n;
        this.errorMessage = string;
        this.matchedDN = dN;
        this.referralURLs = list;
        this.serverSASLCredentials = null;
    }

    public BindResponseProtocolOp(int n, String string, DN dN, List<String> list, ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, String.valueOf(n), String.valueOf(string), String.valueOf(dN), String.valueOf(list)));
        this.resultCode = n;
        this.errorMessage = string;
        this.matchedDN = dN;
        this.referralURLs = list;
        this.serverSASLCredentials = aSN1OctetString;
    }

    public int getResultCode() {
        assert (Debug.debugEnter(CLASS_NAME, "getResultCode", new String[0]));
        return this.resultCode;
    }

    public void setResultCode(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "setResultCode", String.valueOf(n)));
        this.resultCode = n;
    }

    public String getErrorMessage() {
        assert (Debug.debugEnter(CLASS_NAME, "getErrorMessage", new String[0]));
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setErrorMessage", String.valueOf(string)));
        this.errorMessage = string;
    }

    public DN getMatchedDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchedDN", new String[0]));
        return this.matchedDN;
    }

    public void setMatchedDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "setMatchedDN", String.valueOf(dN)));
        this.matchedDN = dN;
    }

    public List<String> getReferralURLs() {
        assert (Debug.debugEnter(CLASS_NAME, "getReferralURLs", new String[0]));
        return this.referralURLs;
    }

    public void setReferralURLs(List<String> list) {
        assert (Debug.debugEnter(CLASS_NAME, "setReferralURLs", String.valueOf(list)));
        this.referralURLs = list;
    }

    public ASN1OctetString getServerSASLCredentials() {
        assert (Debug.debugEnter(CLASS_NAME, "getServerSASLCredentials", new String[0]));
        return this.serverSASLCredentials;
    }

    public void setServerSASLCredentials(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setServerSASLCredentials", new String[0]));
        this.serverSASLCredentials = aSN1OctetString;
    }

    @Override
    public byte getType() {
        assert (Debug.debugEnter(CLASS_NAME, "getType", new String[0]));
        return 97;
    }

    @Override
    public String getProtocolOpName() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolOpName", new String[0]));
        return "Bind Response";
    }

    @Override
    public ASN1Element encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(5);
        arrayList.add(new ASN1Enumerated(this.resultCode));
        if (this.matchedDN == null) {
            arrayList.add(new ASN1OctetString());
        } else {
            arrayList.add(new ASN1OctetString(this.matchedDN.toString()));
        }
        arrayList.add(new ASN1OctetString(this.errorMessage));
        if (this.referralURLs != null && !this.referralURLs.isEmpty()) {
            ArrayList<ASN1Element> arrayList2 = new ArrayList<ASN1Element>(this.referralURLs.size());
            for (String string : this.referralURLs) {
                arrayList2.add(new ASN1OctetString(string));
            }
            arrayList.add(new ASN1Sequence(-93, arrayList2));
        }
        if (this.serverSASLCredentials != null) {
            this.serverSASLCredentials.setType((byte)-121);
            arrayList.add(this.serverSASLCredentials);
        }
        return new ASN1Sequence(97, arrayList);
    }

    public static BindResponseProtocolOp decodeBindResponse(ASN1Element aSN1Element) throws LDAPException {
        ArrayList<String> arrayList;
        ASN1OctetString aSN1OctetString;
        DN dN;
        String string;
        int n;
        ArrayList<ASN1Element> arrayList2;
        assert (Debug.debugEnter(CLASS_NAME, "decodeBindResponse", String.valueOf(aSN1Element)));
        try {
            arrayList2 = aSN1Element.decodeAsSequence().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeBindResponse", exception));
            int n2 = 2293820;
            String string2 = MessageHandler.getMessage(n2, String.valueOf(exception));
            throw new LDAPException(2, n2, string2, exception);
        }
        int n3 = arrayList2.size();
        if (n3 < 3 || n3 > 5) {
            int n4 = 2293826;
            String string3 = MessageHandler.getMessage(n4, n3);
            throw new LDAPException(2, n4, string3);
        }
        try {
            n = arrayList2.get(0).decodeAsInteger().intValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeBindResponse", exception));
            int n5 = 2293822;
            String string4 = MessageHandler.getMessage(n5, String.valueOf(exception));
            throw new LDAPException(2, n5, string4, exception);
        }
        try {
            string = arrayList2.get(1).decodeAsOctetString().stringValue();
            dN = string.length() == 0 ? null : DN.decode(string);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeBindResponse", exception));
            int n6 = 2293823;
            String string5 = MessageHandler.getMessage(n6, String.valueOf(exception));
            throw new LDAPException(2, n6, string5, exception);
        }
        try {
            string = arrayList2.get(2).decodeAsOctetString().stringValue();
            if (string.length() == 0) {
                string = null;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeBindResponse", exception));
            int n7 = 2293824;
            String string6 = MessageHandler.getMessage(n7, String.valueOf(exception));
            throw new LDAPException(2, n7, string6, exception);
        }
        block8 : switch (n3) {
            case 4: {
                aSN1Element = arrayList2.get(3);
                switch (aSN1Element.getType()) {
                    case -93: {
                        aSN1OctetString = null;
                        try {
                            ArrayList<ASN1Element> arrayList3 = aSN1Element.decodeAsSequence().elements();
                            arrayList = new ArrayList(arrayList3.size());
                            for (ASN1Element aSN1Element2 : arrayList3) {
                                arrayList.add(aSN1Element2.decodeAsOctetString().stringValue());
                            }
                            break block8;
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "decodeBindResponse", exception));
                            int n8 = 2293825;
                            String string7 = MessageHandler.getMessage(n8, String.valueOf(exception));
                            throw new LDAPException(2, n8, string7, exception);
                        }
                    }
                    case -121: {
                        arrayList = null;
                        try {
                            aSN1OctetString = aSN1Element.decodeAsOctetString();
                            break block8;
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "decodeBindResponse", exception));
                            int n9 = 2293827;
                            String string8 = MessageHandler.getMessage(n9, String.valueOf(exception));
                            throw new LDAPException(2, n9, string8, exception);
                        }
                    }
                    default: {
                        int n10 = 2293828;
                        String string9 = MessageHandler.getMessage(n10, aSN1Element.getType());
                        throw new LDAPException(2, n10, string9);
                    }
                }
            }
            case 5: {
                try {
                    ArrayList<ASN1Element> arrayList4 = arrayList2.get(3).decodeAsSequence().elements();
                    arrayList = new ArrayList<String>(arrayList4.size());
                    for (ASN1Element object : arrayList4) {
                        arrayList.add(object.decodeAsOctetString().stringValue());
                    }
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "decodeBindResponse", exception));
                    int n11 = 2293825;
                    String string10 = MessageHandler.getMessage(n11, String.valueOf(exception));
                    throw new LDAPException(2, n11, string10, exception);
                }
                try {
                    aSN1OctetString = arrayList2.get(4).decodeAsOctetString();
                    break;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "decodeBindResponse", exception));
                    int n12 = 2293827;
                    String string2 = MessageHandler.getMessage(n12, String.valueOf(exception));
                    throw new LDAPException(2, n12, string2, exception);
                }
            }
            default: {
                arrayList = null;
                aSN1OctetString = null;
            }
        }
        return new BindResponseProtocolOp(n, string, dN, arrayList, aSN1OctetString);
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("BindResponse(resultCode=");
        stringBuilder.append(this.resultCode);
        if (this.errorMessage != null && this.errorMessage.length() > 0) {
            stringBuilder.append(", errorMessage=");
            stringBuilder.append(this.errorMessage);
        }
        if (this.matchedDN != null) {
            stringBuilder.append(", matchedDN=");
            stringBuilder.append(this.matchedDN.toString());
        }
        if (this.referralURLs != null && !this.referralURLs.isEmpty()) {
            stringBuilder.append(", referralURLs={");
            Iterator<String> iterator = this.referralURLs.iterator();
            stringBuilder.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(", ");
                stringBuilder.append(iterator.next());
            }
            stringBuilder.append("}");
        }
        if (this.serverSASLCredentials != null) {
            stringBuilder.append(", serverSASLCredentials=");
            this.serverSASLCredentials.toString(stringBuilder);
        }
        stringBuilder.append(")");
    }

    @Override
    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("Bind Response");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Result Code:  ");
        stringBuilder.append(this.resultCode);
        stringBuilder.append(ServerConstants.EOL);
        if (this.errorMessage != null) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("  Error Message:  ");
            stringBuilder.append(this.errorMessage);
            stringBuilder.append(ServerConstants.EOL);
        }
        if (this.matchedDN != null) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("  Matched DN:  ");
            this.matchedDN.toString(stringBuilder);
            stringBuilder.append(ServerConstants.EOL);
        }
        if (this.referralURLs != null && !this.referralURLs.isEmpty()) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("  Referral URLs:  ");
            stringBuilder.append(ServerConstants.EOL);
            for (String string : this.referralURLs) {
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder.append("  ");
                stringBuilder.append(string);
                stringBuilder.append(ServerConstants.EOL);
            }
        }
        if (this.serverSASLCredentials != null) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("  Server SASL Credentials:");
            stringBuilder.append(ServerConstants.EOL);
            this.serverSASLCredentials.toString(stringBuilder, n + 4);
        }
    }
}

