/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.util.Base64;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddRequestProtocolOp
extends ProtocolOp {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.AddRequestProtocolOp";
    private List<LDAPAttribute> attributes;
    private ASN1OctetString dn;

    public AddRequestProtocolOp(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(aSN1OctetString)));
        this.dn = aSN1OctetString;
        this.attributes = new ArrayList<LDAPAttribute>();
    }

    public AddRequestProtocolOp(ASN1OctetString aSN1OctetString, ArrayList<LDAPAttribute> arrayList) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(aSN1OctetString), String.valueOf(arrayList)));
        this.dn = aSN1OctetString;
        this.attributes = arrayList == null ? new ArrayList<LDAPAttribute>() : arrayList;
    }

    public ASN1OctetString getDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getDN", new String[0]));
        return this.dn;
    }

    public void setDN(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setDN", String.valueOf(aSN1OctetString)));
        this.dn = aSN1OctetString;
    }

    public List<LDAPAttribute> getAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributes", new String[0]));
        return this.attributes;
    }

    @Override
    public byte getType() {
        assert (Debug.debugEnter(CLASS_NAME, "getType", new String[0]));
        return 104;
    }

    @Override
    public String getProtocolOpName() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolOpName", new String[0]));
        return "Add Request";
    }

    @Override
    public ASN1Element encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(2);
        arrayList.add(this.dn);
        ArrayList<ASN1Element> arrayList2 = new ArrayList<ASN1Element>(this.attributes.size());
        for (LDAPAttribute lDAPAttribute : this.attributes) {
            arrayList2.add(lDAPAttribute.encode());
        }
        arrayList.add(new ASN1Sequence(arrayList2));
        return new ASN1Sequence(104, arrayList);
    }

    public static AddRequestProtocolOp decodeAddRequest(ASN1Element aSN1Element) throws LDAPException {
        ArrayList<LDAPAttribute> arrayList;
        ASN1OctetString aSN1OctetString;
        ArrayList<ASN1Element> arrayList2;
        assert (Debug.debugEnter(CLASS_NAME, "decodeAddRequest", String.valueOf(aSN1Element)));
        try {
            arrayList2 = aSN1Element.decodeAsSequence().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeAddRequest", exception));
            int n = 2293865;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string, exception);
        }
        int n = arrayList2.size();
        if (n != 2) {
            int n2 = 2293866;
            String string = MessageHandler.getMessage(n2, n);
            throw new LDAPException(2, n2, string);
        }
        try {
            aSN1OctetString = arrayList2.get(0).decodeAsOctetString();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeAddRequest", exception));
            int n3 = 2293867;
            String string = MessageHandler.getMessage(n3, String.valueOf(exception));
            throw new LDAPException(2, n3, string, exception);
        }
        try {
            ArrayList<ASN1Element> arrayList3 = arrayList2.get(1).decodeAsSequence().elements();
            arrayList = new ArrayList<LDAPAttribute>(arrayList3.size());
            for (ASN1Element aSN1Element2 : arrayList3) {
                arrayList.add(LDAPAttribute.decode(aSN1Element2));
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeAddRequest", exception));
            int n4 = 2293868;
            String string = MessageHandler.getMessage(n4, String.valueOf(exception));
            throw new LDAPException(2, n4, string, exception);
        }
        return new AddRequestProtocolOp(aSN1OctetString, arrayList);
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("AddRequest(dn=");
        this.dn.toString(stringBuilder);
        stringBuilder.append(", attrs={");
        if (!this.attributes.isEmpty()) {
            Iterator<LDAPAttribute> iterator = this.attributes.iterator();
            iterator.next().toString(stringBuilder);
            while (iterator.hasNext()) {
                stringBuilder.append(", ");
                iterator.next().toString(stringBuilder);
            }
        }
        stringBuilder.append("})");
    }

    @Override
    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("Add Request");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  DN:  ");
        this.dn.toString(stringBuilder);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("  Attributes:");
        stringBuilder.append(ServerConstants.EOL);
        for (LDAPAttribute lDAPAttribute : this.attributes) {
            lDAPAttribute.toString(stringBuilder, n + 4);
        }
    }

    public void toLDIF(StringBuilder stringBuilder, int n) {
        int n2;
        String string;
        assert (Debug.debugEnter(CLASS_NAME, "toLDIF", "java.lang.StringBuilder", String.valueOf(n)));
        if (StaticUtils.needsBase64Encoding(this.dn.value())) {
            string = Base64.encode(this.dn.value());
            stringBuilder.append("dn:: ");
            n2 = n - 5;
        } else {
            string = this.dn.stringValue();
            stringBuilder.append("dn: ");
            n2 = n - 4;
        }
        int n3 = string.length();
        if (n3 <= n2 || n2 <= 0) {
            stringBuilder.append(string);
            stringBuilder.append(ServerConstants.EOL);
        } else {
            stringBuilder.append(string.substring(0, n2));
            stringBuilder.append(ServerConstants.EOL);
            int n4 = n2;
            while (n3 - n4 > n - 1) {
                stringBuilder.append(" ");
                stringBuilder.append(string.substring(n4, n4 + n - 1));
                stringBuilder.append(ServerConstants.EOL);
                n4 += n - 1;
            }
            if (n4 < n3) {
                stringBuilder.append(" ");
                stringBuilder.append(string.substring(n4));
                stringBuilder.append(ServerConstants.EOL);
            }
        }
        for (LDAPAttribute lDAPAttribute : this.attributes) {
            String string2 = lDAPAttribute.getAttributeType();
            int n5 = string2.length();
            for (ASN1OctetString aSN1OctetString : lDAPAttribute.getValues()) {
                String string3;
                if (StaticUtils.needsBase64Encoding(aSN1OctetString.value())) {
                    string3 = Base64.encode(aSN1OctetString.value());
                    stringBuilder.append(string2);
                    stringBuilder.append(":: ");
                    n2 = n - n5 - 3;
                } else {
                    string3 = aSN1OctetString.stringValue();
                    stringBuilder.append(string2);
                    stringBuilder.append(": ");
                    n2 = n - n5 - 2;
                }
                int n6 = string3.length();
                if (n6 <= n2 || n2 <= 0) {
                    stringBuilder.append(string3);
                    stringBuilder.append(ServerConstants.EOL);
                    continue;
                }
                stringBuilder.append(string3.substring(0, n2));
                stringBuilder.append(ServerConstants.EOL);
                int n7 = n2;
                while (n6 - n7 > n - 1) {
                    stringBuilder.append(" ");
                    stringBuilder.append(string3.substring(n7, n7 + n - 1));
                    stringBuilder.append(ServerConstants.EOL);
                    n7 += n - 1;
                }
                if (n7 >= n6) continue;
                stringBuilder.append(" ");
                stringBuilder.append(string3.substring(n7));
                stringBuilder.append(ServerConstants.EOL);
            }
        }
        stringBuilder.append(ServerConstants.EOL);
    }
}

