/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.jmx;

import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.ConnectionSecurityProvider;
import org.opends.server.core.AddOperation;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.Operation;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.UnbindOperation;
import org.opends.server.extensions.NullConnectionSecurityProvider;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalSearchListener;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.jmx.JmxConnectionHandler;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.Control;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.IntermediateResponse;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.SearchScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxClientConnection
extends ClientConnection
implements NotificationListener {
    private static final String CLASS_NAME = "org.opends.server.protocols.jmx.JmxClientConnection";
    private AtomicInteger nextMessageID;
    private AtomicLong nextOperationID;
    private ConnectionSecurityProvider securityProvider;
    private LinkedList<Operation> operationList;
    private long connectionID;
    protected String jmxConnectionID;
    private JmxConnectionHandler jmxConnectionHandler;
    private Boolean disconnectStarted;

    public JmxClientConnection(JmxConnectionHandler jmxConnectionHandler, AuthenticationInfo authenticationInfo) {
        block4: {
            this.jmxConnectionID = null;
            this.disconnectStarted = new Boolean(false);
            assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
            this.nextMessageID = new AtomicInteger(1);
            this.nextOperationID = new AtomicLong(0L);
            this.jmxConnectionHandler = jmxConnectionHandler;
            jmxConnectionHandler.connectionList.add(this);
            this.setAuthenticationInfo(authenticationInfo);
            this.connectionID = DirectoryServer.newConnectionAccepted(this);
            if (this.connectionID < 0L) {
                this.disconnect(DisconnectReason.ADMIN_LIMIT_EXCEEDED, true, 2293974, new Object[0]);
            }
            this.operationList = new LinkedList();
            try {
                this.securityProvider = new NullConnectionSecurityProvider();
                this.securityProvider.initializeConnectionSecurityProvider(null);
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "<init>", exception)) break block4;
                throw new AssertionError();
            }
        }
        jmxConnectionHandler.rmiConnector.jmxRmiConnectorNoClientCertificate.addNotificationListener(this, null, null);
    }

    @Override
    public void handleNotification(Notification notification, Object object) {
        if (!(notification instanceof JMXConnectionNotification)) {
            return;
        }
        JMXConnectionNotification jMXConnectionNotification = (JMXConnectionNotification)notification;
        if (!jMXConnectionNotification.getType().equals("jmx.remote.connection.closed") && !jMXConnectionNotification.getType().equals("jmx.remote.connection.failed")) {
            return;
        }
        if (!jMXConnectionNotification.getConnectionId().equals(this.jmxConnectionID)) {
            return;
        }
        this.disconnect(DisconnectReason.CLIENT_DISCONNECT, false, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long nextOperationID() {
        assert (Debug.debugEnter(CLASS_NAME, "nextOperationID", new String[0]));
        long l = this.nextOperationID.getAndIncrement();
        if (l < 0L) {
            AtomicLong atomicLong = this.nextOperationID;
            synchronized (atomicLong) {
                if (this.nextOperationID.get() < 0L) {
                    this.nextOperationID.set(1L);
                    return 0L;
                }
                return this.nextOperationID.getAndIncrement();
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int nextMessageID() {
        assert (Debug.debugEnter(CLASS_NAME, "nextMessageID", new String[0]));
        int n = this.nextMessageID.getAndIncrement();
        if (n < 0) {
            AtomicInteger atomicInteger = this.nextMessageID;
            synchronized (atomicInteger) {
                if (this.nextMessageID.get() < 0) {
                    this.nextMessageID.set(2);
                    return 1;
                }
                return this.nextMessageID.getAndIncrement();
            }
        }
        return n;
    }

    @Override
    public long getConnectionID() {
        assert (Debug.debugEnter(CLASS_NAME, "getConnectionID", new String[0]));
        return this.connectionID;
    }

    @Override
    public ConnectionHandler getConnectionHandler() {
        assert (Debug.debugEnter(CLASS_NAME, "getConnectionHandler", new String[0]));
        return this.jmxConnectionHandler;
    }

    @Override
    public String getProtocol() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocol", new String[0]));
        return "jmx";
    }

    @Override
    public String getClientAddress() {
        assert (Debug.debugEnter(CLASS_NAME, "getClientAddress", new String[0]));
        return "jmx";
    }

    @Override
    public String getServerAddress() {
        assert (Debug.debugEnter(CLASS_NAME, "getServerAddress", new String[0]));
        return "jmx";
    }

    @Override
    public InetAddress getRemoteAddress() {
        assert (Debug.debugEnter(CLASS_NAME, "getRemoteAddress", new String[0]));
        return null;
    }

    @Override
    public InetAddress getLocalAddress() {
        assert (Debug.debugEnter(CLASS_NAME, "getLocalAddress", new String[0]));
        return null;
    }

    @Override
    public boolean isSecure() {
        assert (Debug.debugEnter(CLASS_NAME, "isSecure", new String[0]));
        return this.securityProvider.isSecure();
    }

    @Override
    public ConnectionSecurityProvider getConnectionSecurityProvider() {
        assert (Debug.debugEnter(CLASS_NAME, "getConnectionSecurityProvider", new String[0]));
        return this.securityProvider;
    }

    @Override
    public void setConnectionSecurityProvider(ConnectionSecurityProvider connectionSecurityProvider) {
        assert (Debug.debugEnter(CLASS_NAME, "setConnectionSecurityProvider", String.valueOf(connectionSecurityProvider)));
        this.securityProvider = connectionSecurityProvider;
    }

    @Override
    public String getSecurityMechanism() {
        assert (Debug.debugEnter(CLASS_NAME, "getSecurityMechanism", new String[0]));
        return this.securityProvider.getSecurityMechanismName();
    }

    @Override
    public boolean processDataRead(ByteBuffer byteBuffer) {
        assert (Debug.debugEnter(CLASS_NAME, "processDataRead", new String[0]));
        return false;
    }

    @Override
    public void sendResponse(Operation operation) {
        assert (Debug.debugEnter(CLASS_NAME, "sendResponse", String.valueOf(operation)));
    }

    public AddOperation processAdd(ASN1OctetString aSN1OctetString, ArrayList<LDAPAttribute> arrayList) {
        assert (Debug.debugEnter(CLASS_NAME, "processAdd", String.valueOf(aSN1OctetString), String.valueOf(arrayList)));
        AddOperation addOperation = new AddOperation(this, this.nextOperationID(), this.nextMessageID(), new ArrayList<Control>(0), aSN1OctetString, arrayList);
        addOperation.run();
        return addOperation;
    }

    public CompareOperation processCompare(ASN1OctetString aSN1OctetString, String string, ASN1OctetString aSN1OctetString2) {
        assert (Debug.debugEnter(CLASS_NAME, "processCompare", String.valueOf(aSN1OctetString), String.valueOf(string), String.valueOf(aSN1OctetString2)));
        CompareOperation compareOperation = new CompareOperation((ClientConnection)this, this.nextOperationID(), this.nextMessageID(), new ArrayList<Control>(0), aSN1OctetString, string, (ByteString)aSN1OctetString2);
        compareOperation.run();
        return compareOperation;
    }

    public DeleteOperation processDelete(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "processDelete", String.valueOf(aSN1OctetString)));
        DeleteOperation deleteOperation = new DeleteOperation((ClientConnection)this, this.nextOperationID(), this.nextMessageID(), new ArrayList<Control>(0), aSN1OctetString);
        deleteOperation.run();
        return deleteOperation;
    }

    public ExtendedOperation processExtendedOperation(String string, ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "processExtendedOperation", String.valueOf(string), String.valueOf(aSN1OctetString)));
        ExtendedOperation extendedOperation = new ExtendedOperation(this, this.nextOperationID(), this.nextMessageID(), new ArrayList<Control>(0), string, aSN1OctetString);
        extendedOperation.run();
        return extendedOperation;
    }

    public ModifyOperation processModify(ASN1OctetString aSN1OctetString, ArrayList<LDAPModification> arrayList) {
        assert (Debug.debugEnter(CLASS_NAME, "processModify", String.valueOf(aSN1OctetString), String.valueOf(arrayList)));
        ModifyOperation modifyOperation = new ModifyOperation((ClientConnection)this, this.nextOperationID(), this.nextMessageID(), new ArrayList<Control>(0), aSN1OctetString, arrayList);
        modifyOperation.run();
        return modifyOperation;
    }

    public ModifyDNOperation processModifyDN(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "processModifyDN", String.valueOf(aSN1OctetString), String.valueOf(aSN1OctetString2), String.valueOf(bl)));
        return this.processModifyDN(aSN1OctetString, aSN1OctetString2, bl, null);
    }

    public ModifyDNOperation processModifyDN(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, boolean bl, ASN1OctetString aSN1OctetString3) {
        assert (Debug.debugEnter(CLASS_NAME, "processModifyDN", String.valueOf(aSN1OctetString), String.valueOf(aSN1OctetString2), String.valueOf(bl), String.valueOf(aSN1OctetString3)));
        ModifyDNOperation modifyDNOperation = new ModifyDNOperation((ClientConnection)this, this.nextOperationID(), this.nextMessageID(), new ArrayList<Control>(0), aSN1OctetString, aSN1OctetString2, bl, aSN1OctetString3);
        modifyDNOperation.run();
        return modifyDNOperation;
    }

    public InternalSearchOperation processSearch(ASN1OctetString aSN1OctetString, SearchScope searchScope, LDAPFilter lDAPFilter) {
        assert (Debug.debugEnter(CLASS_NAME, "processSearch", String.valueOf(aSN1OctetString), String.valueOf((Object)searchScope), String.valueOf(lDAPFilter)));
        return this.processSearch(aSN1OctetString, searchScope, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, lDAPFilter, new LinkedHashSet<String>(0));
    }

    public InternalSearchOperation processSearch(ASN1OctetString aSN1OctetString, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, int n2, boolean bl, LDAPFilter lDAPFilter, LinkedHashSet<String> linkedHashSet) {
        assert (Debug.debugEnter(CLASS_NAME, "processSearch", String.valueOf(aSN1OctetString), String.valueOf((Object)searchScope), String.valueOf((Object)dereferencePolicy), String.valueOf(n), String.valueOf(n2), String.valueOf(bl), String.valueOf(lDAPFilter), String.valueOf(linkedHashSet)));
        InternalSearchOperation internalSearchOperation = new InternalSearchOperation((ClientConnection)this, this.nextOperationID(), this.nextMessageID(), new ArrayList<Control>(0), aSN1OctetString, searchScope, dereferencePolicy, n, n2, bl, lDAPFilter, linkedHashSet, null);
        internalSearchOperation.run();
        return internalSearchOperation;
    }

    public InternalSearchOperation processSearch(ASN1OctetString aSN1OctetString, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n, int n2, boolean bl, LDAPFilter lDAPFilter, LinkedHashSet<String> linkedHashSet, InternalSearchListener internalSearchListener) {
        assert (Debug.debugEnter(CLASS_NAME, "processSearch", String.valueOf(aSN1OctetString), String.valueOf((Object)searchScope), String.valueOf((Object)dereferencePolicy), String.valueOf(n), String.valueOf(n2), String.valueOf(bl), String.valueOf(lDAPFilter), String.valueOf(linkedHashSet), String.valueOf(internalSearchListener)));
        InternalSearchOperation internalSearchOperation = new InternalSearchOperation((ClientConnection)this, this.nextOperationID(), this.nextMessageID(), new ArrayList<Control>(0), aSN1OctetString, searchScope, dereferencePolicy, n, n2, bl, lDAPFilter, linkedHashSet, internalSearchListener);
        internalSearchOperation.run();
        return internalSearchOperation;
    }

    @Override
    public void sendSearchEntry(SearchOperation searchOperation, SearchResultEntry searchResultEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "sendSearchEntry", String.valueOf(searchOperation), String.valueOf(searchResultEntry)));
        ((InternalSearchOperation)searchOperation).addSearchEntry(searchResultEntry);
    }

    @Override
    public boolean sendSearchReference(SearchOperation searchOperation, SearchResultReference searchResultReference) {
        assert (Debug.debugEnter(CLASS_NAME, "sendSearchReference", String.valueOf(searchOperation), String.valueOf(searchResultReference)));
        ((InternalSearchOperation)searchOperation).addSearchReference(searchResultReference);
        return true;
    }

    @Override
    protected boolean sendIntermediateResponseMessage(IntermediateResponse intermediateResponse) {
        assert (Debug.debugEnter(CLASS_NAME, "sendIntermediateResponseMessage", String.valueOf(intermediateResponse)));
        return false;
    }

    @Override
    public void disconnect(DisconnectReason disconnectReason, boolean bl, String string, int n) {
        block7: {
            Object object;
            block6: {
                assert (Debug.debugEnter(CLASS_NAME, "disconnect", String.valueOf((Object)disconnectReason), String.valueOf(bl), String.valueOf(string), String.valueOf(n)));
                if (this.disconnectStarted.booleanValue()) {
                    return;
                }
                this.disconnectStarted = true;
                try {
                    object = new UnbindOperation((ClientConnection)this, this.nextOperationID(), this.nextMessageID(), null);
                    ((UnbindOperation)object).run();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "disconnect", exception)) break block6;
                    throw new AssertionError();
                }
            }
            try {
                object = DirectoryServer.getPluginConfigManager();
                ((PluginConfigManager)object).invokePostDisconnectPlugins(this, disconnectReason, n, string);
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "disconnect", exception)) break block7;
                throw new AssertionError();
            }
        }
    }

    @Override
    public boolean bindInProgress() {
        assert (Debug.debugEnter(CLASS_NAME, "bindInProgress", new String[0]));
        return false;
    }

    @Override
    public void setBindInProgress(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setBindInProgress", String.valueOf(bl)));
    }

    @Override
    public Collection<Operation> getOperationsInProgress() {
        assert (Debug.debugEnter(CLASS_NAME, "getOperationsInProgress", new String[0]));
        return this.operationList;
    }

    @Override
    public Operation getOperationInProgress(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "getOperationInProgress", String.valueOf(n)));
        return null;
    }

    @Override
    public boolean removeOperationInProgress(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "removeOperationInProgress", String.valueOf(n)));
        return false;
    }

    @Override
    public CancelResult cancelOperation(int n, CancelRequest cancelRequest) {
        assert (Debug.debugEnter(CLASS_NAME, "cancelOperation", String.valueOf(n), String.valueOf(cancelRequest)));
        return CancelResult.CANNOT_CANCEL;
    }

    @Override
    public void cancelAllOperations(CancelRequest cancelRequest) {
        assert (Debug.debugEnter(CLASS_NAME, "cancelAllOperations", String.valueOf(cancelRequest)));
    }

    @Override
    public void cancelAllOperationsExcept(CancelRequest cancelRequest, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "cancelAllOperationsExcept", String.valueOf(cancelRequest), String.valueOf(n)));
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        stringBuilder.append("JmxClientConnection(connID=");
        stringBuilder.append(this.connectionID);
        stringBuilder.append(", authDN=\"");
        stringBuilder.append(this.getAuthenticationInfo().getAuthenticationDN());
        stringBuilder.append("\")");
    }

    protected void finalize() {
        this.disconnect(DisconnectReason.OTHER, false, null, -1);
    }
}

