/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.jmx;

import java.io.IOException;
import java.io.Serializable;
import java.net.Socket;
import java.rmi.server.RMIClientSocketFactory;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import org.opends.server.loggers.Debug;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;

public class DirectoryRMIClientSocketFactory
implements RMIClientSocketFactory,
Serializable {
    private static final String CLASS_NAME = "org.opends.server.protocols.jmx.DirectoryRMIClientSocketFactory";
    private static final long serialVersionUID = -6701450600497520362L;
    private static InheritableThreadLocal<Map> tlMapConnectionEnv = new InheritableThreadLocal();
    private static InheritableThreadLocal<String> tlStrServerHostname = new InheritableThreadLocal();
    private final boolean needClientCertificate;
    private transient SSLSocketFactory sslSocketFactory = null;
    private transient String serverHostname = null;

    public DirectoryRMIClientSocketFactory(boolean bl) {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.needClientCertificate = bl;
    }

    public static void setConnectionEnv(Map map) {
        tlMapConnectionEnv.set(map);
    }

    public static Map getConnectionEnv() {
        return (Map)tlMapConnectionEnv.get();
    }

    public static void setServerHostname(String string) {
        tlStrServerHostname.set(string);
    }

    public static String getServerHostname() {
        return (String)tlStrServerHostname.get();
    }

    public boolean getNeedClientCertificate() {
        return this.needClientCertificate;
    }

    public Socket createSocket(String string, int n) throws IOException {
        SSLSocketFactory sSLSocketFactory = this.getSSLSocketFactory();
        String string2 = this.getRealServerHostname(string);
        SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string2, n);
        return sSLSocket;
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private synchronized String getRealServerHostname(String string) throws IOException {
        if (this.serverHostname == null) {
            this.serverHostname = DirectoryRMIClientSocketFactory.getServerHostname();
            if (this.serverHostname == null) {
                this.serverHostname = "";
            }
        }
        if (this.serverHostname.length() > 0) {
            return this.serverHostname;
        }
        return string;
    }

    private synchronized SSLSocketFactory getSSLSocketFactory() throws IOException {
        assert (Debug.debugEnter(CLASS_NAME, "getSSLSocketFactory", new String[0]));
        if (this.sslSocketFactory == null) {
            assert (Debug.debugMessage(DebugLogCategory.CONNECTION_HANDLING, DebugLogSeverity.VERBOSE, CLASS_NAME, "getSSLSocketFactory", "sslSocketFactory is null, get a new one"));
            Map map = DirectoryRMIClientSocketFactory.getConnectionEnv();
            TrustManager[] trustManagerArray = null;
            if (map != null && map.containsKey("org.opends.server.protocol.jmx.ssl.trust.manager.array")) {
                try {
                    trustManagerArray = (TrustManager[])map.get("org.opends.server.protocol.jmx.ssl.trust.manager.array");
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "getSSLSocketFactory", exception));
                    trustManagerArray = null;
                }
                if (trustManagerArray == null) {
                    throw new IOException("invalid type or null value for key [org.opends.server.protocol.jmx.ssl.trust.manager.array] in connection environment : " + map.get("org.opends.server.protocol.jmx.ssl.trust.manager.array"));
                }
            }
            SSLContext sSLContext = null;
            try {
                sSLContext = SSLContext.getInstance("TLSv1");
                sSLContext.init(null, trustManagerArray, null);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "getSSLSocketFactory", exception));
                throw new IOException("Unable to initialize SSL context : " + exception.getMessage());
            }
            this.sslSocketFactory = sSLContext.getSocketFactory();
        }
        return this.sslSocketFactory;
    }
}

