/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.asn1;

import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

public class ASN1Boolean
extends ASN1Element {
    private static final String CLASS_NAME = "org.opends.server.protocols.asn1.ASN1Boolean";
    private static final long serialVersionUID = -3352160557662933000L;
    private boolean booleanValue;

    public ASN1Boolean(boolean bl) {
        super((byte)1, ASN1Boolean.encodeValue(bl));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(bl)));
        this.booleanValue = bl;
    }

    public ASN1Boolean(byte by, boolean bl) {
        super(by, ASN1Boolean.encodeValue(bl));
        assert (Debug.debugConstructor(CLASS_NAME, StaticUtils.byteToHex(by), String.valueOf(bl)));
        this.booleanValue = bl;
    }

    private ASN1Boolean(byte by, byte[] byArray, boolean bl) {
        super(by, byArray);
        assert (Debug.debugConstructor(CLASS_NAME, StaticUtils.byteToHex(by), StaticUtils.bytesToHex(byArray), String.valueOf(bl)));
        this.booleanValue = bl;
    }

    public boolean booleanValue() {
        assert (Debug.debugEnter(CLASS_NAME, "booleanValue", new String[0]));
        return this.booleanValue;
    }

    public void setValue(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", String.valueOf(bl)));
        this.booleanValue = bl;
        this.setValueInternal(ASN1Boolean.encodeValue(bl));
    }

    public void setValue(byte[] byArray) throws ASN1Exception {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", StaticUtils.bytesToHex(byArray)));
        if (byArray == null) {
            int n = 2293771;
            String string = MessageHandler.getMessage(n);
            throw new ASN1Exception(n, string);
        }
        if (byArray.length != 1) {
            int n = 2293772;
            String string = MessageHandler.getMessage(n, byArray.length);
            throw new ASN1Exception(n, string);
        }
        this.booleanValue = byArray[0] != 0;
        this.setValueInternal(byArray);
    }

    public static ASN1Boolean decodeAsBoolean(ASN1Element aSN1Element) throws ASN1Exception {
        assert (Debug.debugEnter(CLASS_NAME, "decodeAsBoolean", String.valueOf(aSN1Element)));
        if (aSN1Element == null) {
            int n = 2293773;
            String string = MessageHandler.getMessage(n);
            throw new ASN1Exception(n, string);
        }
        byte[] byArray = aSN1Element.value();
        if (byArray.length != 1) {
            int n = 2293774;
            String string = MessageHandler.getMessage(n, byArray.length);
            throw new ASN1Exception(n, string);
        }
        boolean bl = byArray[0] != 0;
        return new ASN1Boolean(aSN1Element.getType(), byArray, bl);
    }

    public static ASN1Boolean decodeAsBoolean(byte[] byArray) throws ASN1Exception {
        int n;
        int n2;
        assert (Debug.debugEnter(CLASS_NAME, "decodeAsBoolean", StaticUtils.bytesToHex(byArray)));
        if (byArray == null) {
            int n3 = 2293775;
            String string = MessageHandler.getMessage(n3);
            throw new ASN1Exception(n3, string);
        }
        if (byArray.length < 3) {
            int n4 = 2293776;
            String string = MessageHandler.getMessage(n4, byArray.length);
            throw new ASN1Exception(n4, string);
        }
        byte by = byArray[0];
        int n5 = byArray[1] & 0x7F;
        int n6 = 2;
        if (n5 != byArray[1]) {
            n2 = n5;
            if (n2 > 4) {
                int n7 = 0x230003;
                String string = MessageHandler.getMessage(n7, n2);
                throw new ASN1Exception(n7, string);
            }
            if (byArray.length < 2 + n2) {
                int n8 = 2293764;
                String string = MessageHandler.getMessage(n8, n2);
                throw new ASN1Exception(n8, string);
            }
            n5 = 0;
            n6 = 2 + n2;
            for (n = 0; n < n2; ++n) {
                n5 = n5 << 8 | byArray[n + 2] & 0xFF;
            }
        }
        if (byArray.length - n6 != n5) {
            n2 = 2293765;
            String string = MessageHandler.getMessage(n2, n5, byArray.length - n6);
            throw new ASN1Exception(n2, string);
        }
        if (n5 != 1) {
            n2 = 2293777;
            String string = MessageHandler.getMessage(n2, n5);
            throw new ASN1Exception(n2, string);
        }
        byte[] byArray2 = new byte[]{byArray[n6]};
        n = byArray2[0] != 0 ? 1 : 0;
        return new ASN1Boolean(by, byArray2, n != 0);
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("ASN1Boolean(type=");
        stringBuilder.append(StaticUtils.byteToHex(this.getType()));
        stringBuilder.append(", value=");
        stringBuilder.append(this.booleanValue);
        stringBuilder.append(")");
    }

    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("ASN.1 Boolean");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  BER Type:  ");
        stringBuilder.append(StaticUtils.byteToHex(this.getType()));
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Value:  ");
        stringBuilder.append(this.booleanValue);
        stringBuilder.append(" (");
        stringBuilder.append(StaticUtils.byteToHex(this.value()[0]));
        stringBuilder.append(")");
        stringBuilder.append(ServerConstants.EOL);
    }
}

