/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins.profiler;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opends.server.api.DirectoryThread;
import org.opends.server.loggers.Debug;
import org.opends.server.plugins.profiler.ProfileStack;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Long;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.asn1.ASN1Writer;

public class ProfilerThread
extends DirectoryThread {
    private static final String CLASS_NAME = "org.opends.server.plugins.profiler.ProfilerThread";
    private boolean stopProfiling;
    private long captureStartTime;
    private long captureStopTime;
    private long numIntervals;
    private long sampleInterval;
    private HashMap<ProfileStack, Long> stackTraces;
    private Thread captureThread;

    public ProfilerThread(long l) {
        super("Directory Server Profiler Thread");
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(l)));
        this.sampleInterval = l;
        this.stackTraces = new HashMap();
        this.numIntervals = 0L;
        this.stopProfiling = false;
        this.captureStartTime = -1L;
        this.captureStopTime = -1L;
        this.captureThread = null;
    }

    public void run() {
        assert (Debug.debugEnter(CLASS_NAME, "run", new String[0]));
        this.captureThread = ProfilerThread.currentThread();
        this.captureStartTime = System.currentTimeMillis();
        while (!this.stopProfiling) {
            long l;
            long l2 = System.currentTimeMillis();
            Map<Thread, StackTraceElement[]> map = ProfilerThread.getAllStackTraces();
            ++this.numIntervals;
            for (Thread thread : map.keySet()) {
                StackTraceElement[] stackTraceElementArray;
                if (thread == ProfilerThread.currentThread() || (stackTraceElementArray = map.get(thread)) == null || stackTraceElementArray.length == 0) continue;
                ProfileStack profileStack = new ProfileStack(stackTraceElementArray);
                Long l3 = this.stackTraces.get(profileStack);
                if (l3 == null) {
                    this.stackTraces.put(profileStack, 1L);
                    continue;
                }
                this.stackTraces.put(profileStack, 1L + (long)l3.intValue());
            }
            if (this.stopProfiling || (l = this.sampleInterval - (System.currentTimeMillis() - l2)) <= 0L) continue;
            try {
                Thread.sleep(l);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "run", exception));
            }
        }
        this.captureStopTime = System.currentTimeMillis();
        this.captureThread = null;
    }

    public void stopProfiling() {
        block4: {
            assert (Debug.debugEnter(CLASS_NAME, "stopProfiling", new String[0]));
            this.stopProfiling = true;
            try {
                if (this.captureThread != null) {
                    this.captureThread.join();
                }
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "stopProfiling", exception)) break block4;
                throw new AssertionError();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeCaptureData(String string) throws IOException {
        assert (Debug.debugEnter(CLASS_NAME, "writeCaptureData", String.valueOf(string)));
        ASN1Writer aSN1Writer = new ASN1Writer(new FileOutputStream(string));
        try {
            if (this.captureStartTime < 0L) {
                this.captureStopTime = this.captureStartTime = System.currentTimeMillis();
            } else if (this.captureStopTime < 0L) {
                this.captureStopTime = System.currentTimeMillis();
            }
            ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(3);
            arrayList.add(new ASN1Long(this.numIntervals));
            arrayList.add(new ASN1Long(this.captureStartTime));
            arrayList.add(new ASN1Long(this.captureStopTime));
            aSN1Writer.writeElement(new ASN1Sequence(arrayList));
            for (ProfileStack profileStack : this.stackTraces.keySet()) {
                aSN1Writer.writeElement(profileStack.encode());
                aSN1Writer.writeElement(new ASN1Long(this.stackTraces.get(profileStack)));
            }
        }
        finally {
            aSN1Writer.close();
        }
    }
}

