/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins.profiler;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.api.plugin.StartupPluginResult;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.IntegerWithUnitConfigAttribute;
import org.opends.server.config.MultiChoiceConfigAttribute;
import org.opends.server.config.ReadOnlyConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.plugins.profiler.ProfilerThread;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProfilerPlugin
extends DirectoryServerPlugin
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.plugins.profiler.ProfilerPlugin";
    public static final String PROFILE_ACTION_NONE = "none";
    public static final String PROFILE_ACTION_START = "start";
    public static final String PROFILE_ACTION_STOP = "stop";
    public static final String PROFILE_ACTION_CANCEL = "cancel";
    private static final LinkedHashMap<String, Double> timeUnits = new LinkedHashMap();
    private boolean autoStart;
    private DN configEntryDN;
    private LinkedHashSet<String> profilerActions;
    private long sampleInterval;
    private ProfilerThread profilerThread;
    private String profileDirectory;

    public ProfilerPlugin() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public final void initializePlugin(Set<PluginType> set, ConfigEntry configEntry) throws ConfigException {
        Object object;
        Object object2;
        ConfigAttribute configAttribute;
        Object object32;
        assert (Debug.debugEnter(CLASS_NAME, "initializePlugin", String.valueOf(set), String.valueOf(configEntry)));
        this.profilerActions = new LinkedHashSet(4);
        this.profilerActions.add(PROFILE_ACTION_NONE);
        this.profilerActions.add(PROFILE_ACTION_START);
        this.profilerActions.add(PROFILE_ACTION_STOP);
        this.profilerActions.add(PROFILE_ACTION_CANCEL);
        this.configEntryDN = configEntry.getDN();
        if (set.isEmpty()) {
            int n = 7602181;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
            throw new ConfigException(n, string);
        }
        for (Object object32 : set) {
            if (object32 == PluginType.STARTUP) continue;
            int n = 7602182;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), String.valueOf(object32));
            throw new ConfigException(n, string);
        }
        this.profileDirectory = System.getProperty("user.dir");
        int n = 0x700007;
        object32 = new StringConfigAttribute("ds-cfg-profile-directory", MessageHandler.getMessage(n), true, false, false);
        try {
            configAttribute = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object32);
            if (configAttribute != null) {
                this.profileDirectory = StaticUtils.getFileForPath(configAttribute.activeValue()).getAbsolutePath();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializePlugin", exception));
            n = 7471112;
            object2 = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception), this.profileDirectory);
            Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_WARNING, (String)object2, n);
        }
        this.autoStart = false;
        n = 0x70000A;
        configAttribute = new BooleanConfigAttribute("ds-cfg-enable-profiling-on-startup", MessageHandler.getMessage(n), false);
        try {
            object2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(configAttribute);
            if (object2 != null) {
                this.autoStart = ((BooleanConfigAttribute)object2).activeValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializePlugin", exception));
            n = 7471115;
            object = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_WARNING, (String)object, n);
        }
        this.sampleInterval = 10L;
        n = 0x70000C;
        object2 = new IntegerWithUnitConfigAttribute("ds-cfg-profile-sample-interval", MessageHandler.getMessage(n), false, timeUnits, true, 1L, false, 0L);
        try {
            object = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object2);
            if (object != null) {
                this.sampleInterval = ((IntegerWithUnitConfigAttribute)object).activeCalculatedValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializePlugin", exception));
            n = 7471117;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception), this.sampleInterval);
            Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_WARNING, string, n);
        }
        DirectoryConfig.registerConfigurableComponent(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void finalizePlugin() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizePlugin", new String[0]));
        ProfilerPlugin profilerPlugin = this;
        synchronized (profilerPlugin) {
            if (this.profilerThread != null) {
                this.profilerThread.stopProfiling();
                String string = this.profileDirectory + File.separator + "profile." + TimeThread.getUTCTime();
                try {
                    this.profilerThread.writeCaptureData(string);
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "finalizePlugin", exception));
                    int n = 7602185;
                    String string2 = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), string, StaticUtils.stackTraceToSingleLineString(exception));
                    Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string2, n);
                }
            }
        }
        DirectoryConfig.deregisterConfigurableComponent(this);
    }

    @Override
    public final StartupPluginResult doStartup() {
        assert (Debug.debugEnter(CLASS_NAME, "doStartup", new String[0]));
        if (this.autoStart) {
            this.profilerThread = new ProfilerThread(this.sampleInterval);
            this.profilerThread.start();
        }
        return StartupPluginResult.SUCCESS;
    }

    @Override
    public final DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public final List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        int n = 0x70000C;
        IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute = new IntegerWithUnitConfigAttribute("ds-cfg-profile-sample-interval", MessageHandler.getMessage(n), false, timeUnits, true, 1L, false, 0L, this.sampleInterval, "milliseconds");
        linkedList.add(integerWithUnitConfigAttribute);
        n = 0x700007;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-profile-directory", MessageHandler.getMessage(n), true, false, false, this.profileDirectory);
        linkedList.add(stringConfigAttribute);
        n = 0x70000A;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-enable-profiling-on-startup", MessageHandler.getMessage(n), false, this.autoStart);
        linkedList.add(booleanConfigAttribute);
        n = 0x70000E;
        String string = this.profilerThread == null ? "disabled" : "enabled";
        ReadOnlyConfigAttribute readOnlyConfigAttribute = new ReadOnlyConfigAttribute("ds-cfg-profiler-state", MessageHandler.getMessage(n), string);
        linkedList.add(readOnlyConfigAttribute);
        n = 0x70000F;
        MultiChoiceConfigAttribute multiChoiceConfigAttribute = new MultiChoiceConfigAttribute("ds-cfg-profile-action", MessageHandler.getMessage(n), true, false, false, this.profilerActions, PROFILE_ACTION_NONE);
        linkedList.add(multiChoiceConfigAttribute);
        return linkedList;
    }

    @Override
    public final boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        Object object;
        ConfigAttribute configAttribute;
        ConfigAttribute configAttribute2;
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.lang.List<String>"));
        int n = 0x70000C;
        IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute = new IntegerWithUnitConfigAttribute("ds-cfg-profile-sample-interval", MessageHandler.getMessage(n), false, timeUnits, true, 1L, false, 0L);
        try {
            configAttribute2 = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(integerWithUnitConfigAttribute);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 7471117;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception), this.sampleInterval));
            return false;
        }
        n = 0x700007;
        configAttribute2 = new StringConfigAttribute("ds-cfg-profile-directory", MessageHandler.getMessage(n), true, false, false);
        try {
            configAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(configAttribute2);
            if (!(configAttribute == null || ((File)(object = StaticUtils.getFileForPath(((StringConfigAttribute)configAttribute).activeValue()))).exists() && ((File)object).isDirectory())) {
                n = 7471120;
                list.add(MessageHandler.getMessage(n, ((StringConfigAttribute)configAttribute).activeValue(), String.valueOf(this.configEntryDN)));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 7471112;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception), this.sampleInterval));
            return false;
        }
        n = 0x70000A;
        configAttribute = new BooleanConfigAttribute("ds-cfg-enable-profiling-on-startup", MessageHandler.getMessage(n), false);
        try {
            object = (BooleanConfigAttribute)configEntry.getConfigAttribute(configAttribute);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 7471115;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        n = 0x70000F;
        object = new MultiChoiceConfigAttribute("ds-cfg-profile-action", MessageHandler.getMessage(n), false, false, false, (Set<String>)this.profilerActions);
        try {
            MultiChoiceConfigAttribute multiChoiceConfigAttribute = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 7471121;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        ArrayList<String> arrayList;
        boolean bl2;
        ResultCode resultCode;
        block45: {
            Object object;
            Object object2;
            ConfigAttribute configAttribute;
            ConfigAttribute configAttribute2;
            assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
            resultCode = ResultCode.SUCCESS;
            bl2 = false;
            arrayList = new ArrayList<String>();
            int n = 0x70000C;
            IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute = new IntegerWithUnitConfigAttribute("ds-cfg-profile-sample-interval", MessageHandler.getMessage(n), false, timeUnits, true, 1L, false, 0L);
            try {
                long l;
                configAttribute2 = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(integerWithUnitConfigAttribute);
                if (configAttribute2 != null && (l = configAttribute2.pendingCalculatedValue()) != this.sampleInterval) {
                    this.sampleInterval = l;
                    if (bl) {
                        n = 7340050;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), this.sampleInterval));
                    }
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                n = 7602195;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                resultCode = DirectoryConfig.getServerErrorResultCode();
            }
            n = 0x700007;
            configAttribute2 = new StringConfigAttribute("ds-cfg-profile-directory", MessageHandler.getMessage(n), true, false, false);
            try {
                configAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(configAttribute2);
                if (configAttribute != null && !((String)(object2 = configAttribute.pendingValue())).equals(this.profileDirectory)) {
                    object = StaticUtils.getFileForPath((String)object2);
                    if (!((File)object).exists() || !((File)object).isDirectory()) {
                        n = 7471120;
                        arrayList.add(MessageHandler.getMessage(n, object2, String.valueOf(this.configEntryDN)));
                        resultCode = DirectoryConfig.getServerErrorResultCode();
                    } else {
                        this.profileDirectory = ((File)object).getAbsolutePath();
                        if (bl) {
                            n = 7340052;
                            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), this.profileDirectory));
                        }
                    }
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                n = 7602197;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                resultCode = DirectoryConfig.getServerErrorResultCode();
            }
            n = 0x70000F;
            configAttribute = new MultiChoiceConfigAttribute("ds-cfg-profile-action", MessageHandler.getMessage(n), false, false, false, (Set<String>)this.profilerActions);
            try {
                object2 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(configAttribute);
                if (object2 == null) break block45;
                if (resultCode == ResultCode.SUCCESS) {
                    object = ((MultiChoiceConfigAttribute)object2).pendingValue().toLowerCase();
                    if (!((String)object).equals(PROFILE_ACTION_NONE)) {
                        if (((String)object).equals(PROFILE_ACTION_START)) {
                            ProfilerPlugin profilerPlugin = this;
                            synchronized (profilerPlugin) {
                                if (this.profilerThread == null) {
                                    this.profilerThread = new ProfilerThread(this.sampleInterval);
                                    this.profilerThread.start();
                                    if (bl) {
                                        n = 7340054;
                                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                                    }
                                } else {
                                    n = 0x700017;
                                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                                }
                            }
                        }
                        if (((String)object).equals(PROFILE_ACTION_STOP)) {
                            ProfilerPlugin profilerPlugin = this;
                            synchronized (profilerPlugin) {
                                if (this.profilerThread == null) {
                                    n = 7340056;
                                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                                } else {
                                    this.profilerThread.stopProfiling();
                                    if (bl) {
                                        n = 7340057;
                                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                                    }
                                    String string = this.profileDirectory + File.separator + "profile." + TimeThread.getUTCTime();
                                    try {
                                        this.profilerThread.writeCaptureData(string);
                                        if (bl) {
                                            n = 7340058;
                                            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), string));
                                        }
                                    }
                                    catch (Exception exception) {
                                        assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                                        n = 7602185;
                                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), string, StaticUtils.stackTraceToSingleLineString(exception)));
                                        resultCode = DirectoryConfig.getServerErrorResultCode();
                                    }
                                    this.profilerThread = null;
                                }
                            }
                        }
                        if (((String)object).equals(PROFILE_ACTION_CANCEL)) {
                            ProfilerPlugin profilerPlugin = this;
                            synchronized (profilerPlugin) {
                                if (this.profilerThread == null) {
                                    n = 7340056;
                                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                                } else {
                                    this.profilerThread.stopProfiling();
                                    if (bl) {
                                        n = 7340057;
                                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN)));
                                    }
                                    this.profilerThread = null;
                                }
                            }
                        } else {
                            n = 7536667;
                            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), object));
                            resultCode = DirectoryConfig.getServerErrorResultCode();
                        }
                    }
                } else {
                    n = 7340060;
                    arrayList.add(MessageHandler.getMessage(n, ((MultiChoiceConfigAttribute)object2).pendingValue(), String.valueOf(this.configEntryDN)));
                }
                configEntry.removeConfigAttribute("ds-cfg-profile-action".toLowerCase());
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePlugin", exception));
                n = 7602205;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                resultCode = DirectoryConfig.getServerErrorResultCode();
            }
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }

    static {
        timeUnits.put("ms", 1.0);
        timeUnits.put("milliseconds", 1.0);
        timeUnits.put("s", 1000.0);
        timeUnits.put("seconds", 1000.0);
    }
}

