/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.api.plugin.PreOperationPluginResult;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Modification;
import org.opends.server.types.ModificationType;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.types.operation.PreOperationModifyDNOperation;
import org.opends.server.types.operation.PreOperationModifyOperation;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LastModPlugin
extends DirectoryServerPlugin {
    private static final String CLASS_NAME = "org.opends.server.plugins.LastModPlugin";
    private final AttributeType createTimestampType;
    private final AttributeType creatorsNameType;
    private final AttributeType modifiersNameType;
    private final AttributeType modifyTimestampType;

    public LastModPlugin() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.createTimestampType = DirectoryConfig.getAttributeType("createtimestamp", true);
        this.creatorsNameType = DirectoryConfig.getAttributeType("creatorsname", true);
        this.modifiersNameType = DirectoryConfig.getAttributeType("modifiersname", true);
        this.modifyTimestampType = DirectoryConfig.getAttributeType("modifytimestamp", true);
    }

    @Override
    public final void initializePlugin(Set<PluginType> set, ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializePlugin", String.valueOf(set), String.valueOf(configEntry)));
        block3: for (PluginType pluginType : set) {
            switch (pluginType) {
                case PRE_OPERATION_ADD: 
                case PRE_OPERATION_MODIFY: 
                case PRE_OPERATION_MODIFY_DN: {
                    continue block3;
                }
            }
            int n = 7602227;
            String string = MessageHandler.getMessage(n, pluginType.toString());
            throw new ConfigException(n, string);
        }
    }

    @Override
    public final PreOperationPluginResult doPreOperation(PreOperationAddOperation preOperationAddOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "doPreOperation", String.valueOf(preOperationAddOperation)));
        DN dN = preOperationAddOperation.getAuthorizationDN();
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        if (dN == null) {
            linkedHashSet.add(new AttributeValue(this.creatorsNameType, ByteStringFactory.create()));
        } else {
            linkedHashSet.add(new AttributeValue(this.creatorsNameType, ByteStringFactory.create(dN.toString())));
        }
        Attribute attribute = new Attribute(this.creatorsNameType, "creatorsName", linkedHashSet);
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(1);
        arrayList.add(attribute);
        preOperationAddOperation.setAttribute(this.creatorsNameType, arrayList);
        LinkedHashSet<AttributeValue> linkedHashSet2 = new LinkedHashSet<AttributeValue>(1);
        linkedHashSet2.add(new AttributeValue(this.createTimestampType, ByteStringFactory.create(TimeThread.getUTCTime())));
        Attribute attribute2 = new Attribute(this.createTimestampType, "createTimestamp", linkedHashSet2);
        ArrayList<Attribute> arrayList2 = new ArrayList<Attribute>(1);
        arrayList2.add(attribute2);
        preOperationAddOperation.setAttribute(this.createTimestampType, arrayList2);
        return PreOperationPluginResult.SUCCESS;
    }

    @Override
    public final PreOperationPluginResult doPreOperation(PreOperationModifyOperation preOperationModifyOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "doPreOperation", String.valueOf(preOperationModifyOperation)));
        DN dN = preOperationModifyOperation.getAuthorizationDN();
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        if (dN == null) {
            linkedHashSet.add(new AttributeValue(this.modifiersNameType, ByteStringFactory.create()));
        } else {
            linkedHashSet.add(new AttributeValue(this.modifiersNameType, ByteStringFactory.create(dN.toString())));
        }
        Attribute attribute = new Attribute(this.modifiersNameType, "modifiersName", linkedHashSet);
        try {
            preOperationModifyOperation.addModification(new Modification(ModificationType.REPLACE, attribute));
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "doPreOperation", directoryException));
            preOperationModifyOperation.setResultCode(DirectoryConfig.getServerErrorResultCode());
            preOperationModifyOperation.appendErrorMessage(directoryException.getErrorMessage());
            return new PreOperationPluginResult(false, false, true);
        }
        LinkedHashSet<AttributeValue> linkedHashSet2 = new LinkedHashSet<AttributeValue>(1);
        linkedHashSet2.add(new AttributeValue(this.modifyTimestampType, ByteStringFactory.create(TimeThread.getUTCTime())));
        Attribute attribute2 = new Attribute(this.modifyTimestampType, "modifyTimestamp", linkedHashSet2);
        try {
            preOperationModifyOperation.addModification(new Modification(ModificationType.REPLACE, attribute2));
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "doPreOperation", directoryException));
            preOperationModifyOperation.setResultCode(DirectoryConfig.getServerErrorResultCode());
            preOperationModifyOperation.appendErrorMessage(directoryException.getErrorMessage());
            return new PreOperationPluginResult(false, false, true);
        }
        return PreOperationPluginResult.SUCCESS;
    }

    @Override
    public final PreOperationPluginResult doPreOperation(PreOperationModifyDNOperation preOperationModifyDNOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "doPreOperation", String.valueOf(preOperationModifyDNOperation)));
        DN dN = preOperationModifyDNOperation.getAuthorizationDN();
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        if (dN == null) {
            linkedHashSet.add(new AttributeValue(this.modifiersNameType, ByteStringFactory.create()));
        } else {
            linkedHashSet.add(new AttributeValue(this.modifiersNameType, ByteStringFactory.create(dN.toString())));
        }
        Attribute attribute = new Attribute(this.modifiersNameType, "modifiersName", linkedHashSet);
        preOperationModifyDNOperation.addModification(new Modification(ModificationType.REPLACE, attribute));
        LinkedHashSet<AttributeValue> linkedHashSet2 = new LinkedHashSet<AttributeValue>(1);
        linkedHashSet2.add(new AttributeValue(this.modifyTimestampType, ByteStringFactory.create(TimeThread.getUTCTime())));
        Attribute attribute2 = new Attribute(this.modifyTimestampType, "modifyTimestamp", linkedHashSet2);
        preOperationModifyDNOperation.addModification(new Modification(ModificationType.REPLACE, attribute2));
        return PreOperationPluginResult.SUCCESS;
    }
}

