/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins;

import java.util.LinkedHashSet;
import java.util.Set;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.api.plugin.PreParsePluginResult;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.operation.PreParseSearchOperation;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDAPADListPlugin
extends DirectoryServerPlugin {
    private static final String CLASS_NAME = "org.opends.server.plugins.LDAPADListPlugin";

    public LDAPADListPlugin() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public final void initializePlugin(Set<PluginType> set, ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializePlugin", String.valueOf(set), String.valueOf(configEntry)));
        if (set.isEmpty()) {
            int n = 7602179;
            String string = MessageHandler.getMessage(n, String.valueOf(configEntry.getDN()));
            throw new ConfigException(n, string);
        }
        for (PluginType pluginType : set) {
            if (pluginType == PluginType.PRE_PARSE_SEARCH) continue;
            int n = 0x740004;
            String string = MessageHandler.getMessage(n, String.valueOf(configEntry.getDN()), String.valueOf((Object)pluginType));
            throw new ConfigException(n, string);
        }
        DirectoryConfig.registerSupportedFeature("1.3.6.1.4.1.4203.1.5.2");
    }

    @Override
    public final PreParsePluginResult doPreParse(PreParseSearchOperation preParseSearchOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "doPreParseSearch", String.valueOf(preParseSearchOperation)));
        LinkedHashSet<String> linkedHashSet = preParseSearchOperation.getAttributes();
        boolean bl = false;
        for (String object : linkedHashSet) {
            if (!object.startsWith("@")) continue;
            bl = true;
            break;
        }
        if (bl) {
            LinkedHashSet linkedHashSet2 = new LinkedHashSet();
            for (String string : linkedHashSet) {
                if (string.startsWith("@")) {
                    String string2 = StaticUtils.toLowerCase(string.substring(1));
                    ObjectClass objectClass = DirectoryConfig.getObjectClass(string2, false);
                    if (objectClass == null) {
                        Debug.debugMessage(DebugLogCategory.PLUGIN, DebugLogSeverity.WARNING, CLASS_NAME, "doPreParse", "Cannot replace unknown objectclass " + string2);
                        continue;
                    }
                    Debug.debugMessage(DebugLogCategory.PLUGIN, DebugLogSeverity.INFO, CLASS_NAME, "doPreParse", "Replacing objectclass " + string2);
                    for (AttributeType attributeType : objectClass.getRequiredAttributeChain()) {
                        linkedHashSet2.add(attributeType.getNameOrOID());
                    }
                    for (AttributeType attributeType : objectClass.getOptionalAttributeChain()) {
                        linkedHashSet2.add(attributeType.getNameOrOID());
                    }
                    continue;
                }
                linkedHashSet2.add(string);
            }
            preParseSearchOperation.setAttributes(linkedHashSet2);
        }
        return PreParsePluginResult.SUCCESS;
    }
}

