/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.LDIFPluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.api.plugin.PreOperationPluginResult;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeUsage;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.DirectoryConfig;
import org.opends.server.types.Entry;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.operation.PreOperationAddOperation;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntryUUIDPlugin
extends DirectoryServerPlugin {
    private static final String CLASS_NAME = "org.opends.server.plugins.EntryUUIDPlugin";
    private static final String ENTRYUUID = "entryuuid";
    private final AttributeType entryUUIDType;

    public EntryUUIDPlugin() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        AttributeType attributeType = DirectoryConfig.getAttributeType(ENTRYUUID, false);
        if (attributeType == null) {
            attributeType = new AttributeType(ENTRYUUID, Collections.singleton(ENTRYUUID), ENTRYUUID, null, null, DirectoryConfig.getDefaultAttributeSyntax(), AttributeUsage.DIRECTORY_OPERATION, false, true, false, true);
        }
        this.entryUUIDType = attributeType;
    }

    @Override
    public final void initializePlugin(Set<PluginType> set, ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializePlugin", String.valueOf(set), String.valueOf(configEntry)));
        block3: for (PluginType pluginType : set) {
            switch (pluginType) {
                case LDIF_IMPORT: 
                case PRE_OPERATION_ADD: {
                    continue block3;
                }
            }
            int n = 7602238;
            String string = MessageHandler.getMessage(n, pluginType.toString());
            throw new ConfigException(n, string);
        }
    }

    @Override
    public final LDIFPluginResult doLDIFImport(LDIFImportConfig lDIFImportConfig, Entry entry) {
        assert (Debug.debugEnter(CLASS_NAME, "doLDIFImport", String.valueOf(lDIFImportConfig), String.valueOf(entry)));
        List<Attribute> list = entry.getAttribute(this.entryUUIDType);
        if (list != null) {
            return LDIFPluginResult.SUCCESS;
        }
        byte[] byArray = StaticUtils.getBytes(entry.getDN().toNormalizedString());
        UUID uUID = UUID.nameUUIDFromBytes(byArray);
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        linkedHashSet.add(new AttributeValue(this.entryUUIDType, ByteStringFactory.create(uUID.toString())));
        list = new ArrayList<Attribute>(1);
        Attribute attribute = new Attribute(this.entryUUIDType, "entryUUID", linkedHashSet);
        list.add(attribute);
        entry.putAttribute(this.entryUUIDType, list);
        return LDIFPluginResult.SUCCESS;
    }

    @Override
    public final PreOperationPluginResult doPreOperation(PreOperationAddOperation preOperationAddOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "doPreOperation", String.valueOf(preOperationAddOperation)));
        Map<AttributeType, List<Attribute>> map = preOperationAddOperation.getOperationalAttributes();
        List<Attribute> list = map.get(this.entryUUIDType);
        if (list != null) {
            return PreOperationPluginResult.SUCCESS;
        }
        UUID uUID = UUID.randomUUID();
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        linkedHashSet.add(new AttributeValue(this.entryUUIDType, ByteStringFactory.create(uUID.toString())));
        list = new ArrayList<Attribute>(1);
        Attribute attribute = new Attribute(this.entryUUIDType, "entryUUID", linkedHashSet);
        list.add(attribute);
        preOperationAddOperation.setAttribute(this.entryUUIDType, list);
        return PreOperationPluginResult.SUCCESS;
    }
}

