/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.monitors;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionMonitorProvider
extends MonitorProvider {
    private static final String CLASS_NAME = "org.opends.server.monitors.VersionMonitorProvider";

    public VersionMonitorProvider() {
        super("Version Monitor Provider");
    }

    @Override
    public void initializeMonitorProvider(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMonitorProvider", String.valueOf(configEntry)));
    }

    @Override
    public String getMonitorInstanceName() {
        assert (Debug.debugEnter(CLASS_NAME, "getMonitorInstanceName", new String[0]));
        return "Version";
    }

    @Override
    public long getUpdateInterval() {
        assert (Debug.debugEnter(CLASS_NAME, "getUpdateInterval", new String[0]));
        return 0L;
    }

    @Override
    public void updateMonitorData() {
        assert (Debug.debugEnter(CLASS_NAME, "updateMonitorData", new String[0]));
    }

    public ArrayList<Attribute> getMonitorData() {
        assert (Debug.debugEnter(CLASS_NAME, "getMonitorData", new String[0]));
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>(8);
        arrayList.add(this.createAttribute("productName", "OpenDS Directory Server"));
        arrayList.add(this.createAttribute("buildID", "20061110175103"));
        arrayList.add(this.createAttribute("majorVersion", String.valueOf(0)));
        arrayList.add(this.createAttribute("minorVersion", String.valueOf(1)));
        arrayList.add(this.createAttribute("pointVersion", String.valueOf(0)));
        arrayList.add(this.createAttribute("versionQualifier", "-build016"));
        arrayList.add(this.createAttribute("debugBuild", String.valueOf(false)));
        arrayList.add(this.createAttribute("fixIDs", ""));
        return arrayList;
    }

    private Attribute createAttribute(String string, String string2) {
        assert (Debug.debugEnter(CLASS_NAME, "createAttribute", String.valueOf(string), String.valueOf(string2)));
        AttributeType attributeType = DirectoryServer.getDefaultAttributeType(string);
        ASN1OctetString aSN1OctetString = new ASN1OctetString(string2);
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        try {
            linkedHashSet.add(new AttributeValue(aSN1OctetString, attributeType.normalize(aSN1OctetString)));
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createAttribute", exception));
            linkedHashSet.add(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString));
        }
        return new Attribute(attributeType, string, linkedHashSet);
    }
}

