/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.monitors;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.TraditionalWorkQueue;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraditionalWorkQueueMonitor
extends MonitorProvider {
    private static final String CLASS_NAME = "org.opends.server.monitors.WorkQueueMonitor";
    public static final String ATTR_CURRENT_BACKLOG = "currentRequestBacklog";
    public static final String ATTR_AVERAGE_BACKLOG = "averageRequestBacklog";
    public static final String ATTR_MAX_BACKLOG = "maxRequestBacklog";
    public static final String ATTR_OPS_SUBMITTED = "requestsSubmitted";
    public static final String ATTR_OPS_REJECTED_QUEUE_FULL = "requestsRejectedDueToQueueFull";
    private int maxBacklog;
    private long numPolls;
    private long totalBacklog;
    private TraditionalWorkQueue workQueue;

    public TraditionalWorkQueueMonitor(TraditionalWorkQueue traditionalWorkQueue) {
        super("Work Queue Monitor Provider");
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.workQueue = traditionalWorkQueue;
    }

    @Override
    public void initializeMonitorProvider(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMonitorProvider", String.valueOf(configEntry)));
        this.maxBacklog = 0;
        this.totalBacklog = 0L;
        this.numPolls = 0L;
    }

    @Override
    public String getMonitorInstanceName() {
        assert (Debug.debugEnter(CLASS_NAME, "getMonitorInstanceName", new String[0]));
        return "Work Queue";
    }

    @Override
    public long getUpdateInterval() {
        assert (Debug.debugEnter(CLASS_NAME, "getUpdateInterval", new String[0]));
        return 10000L;
    }

    @Override
    public void updateMonitorData() {
        assert (Debug.debugEnter(CLASS_NAME, "updateMonitorData", new String[0]));
        int n = this.workQueue.size();
        this.totalBacklog += (long)n;
        ++this.numPolls;
        if (n > this.maxBacklog) {
            this.maxBacklog = n;
        }
    }

    public ArrayList<Attribute> getMonitorData() {
        assert (Debug.debugEnter(CLASS_NAME, "getMonitorData", new String[0]));
        int n = this.workQueue.size();
        this.totalBacklog += (long)n;
        ++this.numPolls;
        if (n > this.maxBacklog) {
            this.maxBacklog = n;
        }
        long l = (long)(1.0 * (double)this.totalBacklog / (double)this.numPolls);
        long l2 = this.workQueue.getOpsSubmitted();
        long l3 = this.workQueue.getOpsRejectedDueToQueueFull();
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        AttributeSyntax attributeSyntax = DirectoryServer.getDefaultIntegerSyntax();
        AttributeType attributeType = DirectoryServer.getDefaultAttributeType(ATTR_CURRENT_BACKLOG, attributeSyntax);
        ASN1OctetString aSN1OctetString = new ASN1OctetString(String.valueOf(n));
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>();
        linkedHashSet.add(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString));
        arrayList.add(new Attribute(attributeType, ATTR_CURRENT_BACKLOG, linkedHashSet));
        attributeType = DirectoryServer.getDefaultAttributeType(ATTR_AVERAGE_BACKLOG, attributeSyntax);
        aSN1OctetString = new ASN1OctetString(String.valueOf(l));
        linkedHashSet = new LinkedHashSet();
        linkedHashSet.add(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString));
        arrayList.add(new Attribute(attributeType, ATTR_AVERAGE_BACKLOG, linkedHashSet));
        attributeType = DirectoryServer.getDefaultAttributeType(ATTR_MAX_BACKLOG, attributeSyntax);
        aSN1OctetString = new ASN1OctetString(String.valueOf(this.maxBacklog));
        linkedHashSet = new LinkedHashSet();
        linkedHashSet.add(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString));
        arrayList.add(new Attribute(attributeType, ATTR_MAX_BACKLOG, linkedHashSet));
        attributeType = DirectoryServer.getDefaultAttributeType(ATTR_OPS_SUBMITTED, attributeSyntax);
        aSN1OctetString = new ASN1OctetString(String.valueOf(l2));
        linkedHashSet = new LinkedHashSet();
        linkedHashSet.add(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString));
        arrayList.add(new Attribute(attributeType, ATTR_OPS_SUBMITTED, linkedHashSet));
        attributeType = DirectoryServer.getDefaultAttributeType(ATTR_OPS_REJECTED_QUEUE_FULL, attributeSyntax);
        aSN1OctetString = new ASN1OctetString(String.valueOf(l3));
        linkedHashSet = new LinkedHashSet();
        linkedHashSet.add(new AttributeValue(aSN1OctetString, (ByteString)aSN1OctetString));
        arrayList.add(new Attribute(attributeType, ATTR_OPS_REJECTED_QUEUE_FULL, linkedHashSet));
        return arrayList;
    }
}

