/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.RandomAccessFile;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.X509Certificate;
import javax.net.ssl.KeyManager;
import javax.net.ssl.X509KeyManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.PostRotationAction;

public class SignatureAction
implements PostRotationAction {
    private static final String CLASS_NAME = "org.opends.server.loggers.SignatureAction";
    private static final String delimiter = "---------";
    private File originalFile;
    private String signatureAlgorithm = "SHA1withRSA";
    private String digestAlgorithm = "SHA";
    private String alias = null;

    public SignatureAction(String string, String string2) {
        this.originalFile = new File(string);
        this.alias = string2;
    }

    public SignatureAction(String string, String string2, String string3, String string4) {
        this.originalFile = new File(string);
        this.signatureAlgorithm = string2;
        this.digestAlgorithm = string3;
        this.alias = string4;
    }

    public boolean execute() {
        FileInputStream fileInputStream = null;
        boolean bl = false;
        try {
            KeyManager[] keyManagerArray = DirectoryServer.getKeyManagerProvider().getKeyManagers();
            if (keyManagerArray.length == 0) {
                System.err.println("No private key available to sign with.");
                return false;
            }
            X509KeyManager x509KeyManager = (X509KeyManager)keyManagerArray[0];
            PrivateKey privateKey = x509KeyManager.getPrivateKey(this.alias);
            Signature signature = Signature.getInstance(this.signatureAlgorithm);
            signature.initSign(privateKey);
            MessageDigest messageDigest = MessageDigest.getInstance(this.digestAlgorithm);
            messageDigest.reset();
            fileInputStream = new FileInputStream(this.originalFile);
            bl = true;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            byte[] byArray = new byte[1024];
            while (bufferedInputStream.available() != 0) {
                int n = bufferedInputStream.read(byArray);
                messageDigest.update(byArray, 0, n);
            }
            bufferedInputStream.close();
            byte[] byArray2 = messageDigest.digest();
            signature.update(byArray2);
            byte[] byArray3 = signature.sign();
            RandomAccessFile randomAccessFile = new RandomAccessFile(this.originalFile, "rw");
            randomAccessFile.seek(randomAccessFile.length());
            randomAccessFile.write(delimiter.getBytes());
            randomAccessFile.write("\n".getBytes());
            randomAccessFile.write(byArray3);
            return true;
        }
        catch (Exception exception) {
            block8: {
                assert (Debug.debugException(CLASS_NAME, "execute", exception));
                if (bl) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception2) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "execute", exception2)) break block8;
                        throw new AssertionError();
                    }
                }
            }
            return false;
        }
    }

    public boolean verify() {
        RandomAccessFile randomAccessFile = null;
        boolean bl = false;
        try {
            byte[] byArray;
            KeyManager[] keyManagerArray = DirectoryServer.getKeyManagerProvider().getKeyManagers();
            if (keyManagerArray.length == 0) {
                System.err.println("No public key available to verify signature with.");
                return false;
            }
            X509KeyManager x509KeyManager = (X509KeyManager)keyManagerArray[0];
            X509Certificate[] x509CertificateArray = x509KeyManager.getCertificateChain(this.alias);
            if (x509CertificateArray == null || x509CertificateArray.length == 0) {
                System.err.println("Cannot find the public key for the signature.");
                return false;
            }
            PublicKey publicKey = x509CertificateArray[0].getPublicKey();
            Signature signature = Signature.getInstance(this.signatureAlgorithm);
            signature.initVerify(publicKey);
            MessageDigest messageDigest = MessageDigest.getInstance(this.digestAlgorithm);
            messageDigest.reset();
            randomAccessFile = new RandomAccessFile(this.originalFile, "r");
            bl = true;
            String string = null;
            while ((string = randomAccessFile.readLine()) != null && !string.equals(delimiter)) {
                byArray = (string + "\n").getBytes();
                messageDigest.update(byArray);
            }
            byArray = new byte[128];
            int n = randomAccessFile.read(byArray, 0, 128);
            byte[] byArray2 = messageDigest.digest();
            signature.update(byArray2);
            boolean bl2 = signature.verify(byArray);
            return bl2;
        }
        catch (Exception exception) {
            block9: {
                assert (Debug.debugException(CLASS_NAME, "execute", exception));
                if (bl) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (Exception exception2) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "execute", exception2)) break block9;
                        throw new AssertionError();
                    }
                }
            }
            return false;
        }
    }

    private void printBytes(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            System.out.print(Integer.toHexString(byArray[i]));
        }
        System.out.println("");
    }
}

