/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.logging.ErrorManager;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.opends.server.api.InvokableComponent;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.loggers.ActionType;
import org.opends.server.loggers.InitializationErrorManager;
import org.opends.server.loggers.LoggerAlarmHandler;
import org.opends.server.loggers.MeteredStream;
import org.opends.server.loggers.RotationActionThread;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InvokableMethod;
import org.opends.server.types.ResultCode;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryFileHandler
extends Handler
implements LoggerAlarmHandler,
InvokableComponent {
    private Writer writer;
    private MeteredStream meter;
    private boolean append;
    private String filename;
    private int bufferSize = 65536;
    private long limit = 0L;
    private File file;
    private ArrayList<ActionType> actions;
    private ConfigEntry configEntry;

    public DirectoryFileHandler(ConfigEntry configEntry, String string, int n) throws IOException, SecurityException {
        this.configEntry = configEntry;
        this.bufferSize = n;
        this.configure();
        this.filename = string;
        this.openFile();
    }

    public DirectoryFileHandler(ConfigEntry configEntry, String string, boolean bl, int n) throws IOException, SecurityException {
        this.configEntry = configEntry;
        this.bufferSize = n;
        this.configure();
        this.filename = string;
        this.append = bl;
        this.openFile();
    }

    public void setFileSize(long l) {
        this.limit = l;
    }

    private void openFile() throws IOException, SecurityException {
        InitializationErrorManager initializationErrorManager = new InitializationErrorManager();
        this.setErrorManager(initializationErrorManager);
        this.file = new File(this.filename);
        if (this.append) {
            this.open(this.file, true);
        } else {
            this.open(this.file, false);
        }
        Exception exception = initializationErrorManager.lastException;
        if (exception != null) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof SecurityException) {
                throw (SecurityException)exception;
            }
            throw new IOException("Exception: " + exception);
        }
        this.setErrorManager(new ErrorManager());
    }

    public void rotate(String string) {
        this.close();
        File file = this.file;
        File file2 = new File(string);
        if (file.exists()) {
            if (file2.exists()) {
                System.err.println("File:" + file2 + " already exists. Renaming...");
                File file3 = new File(string + ".sav");
                file2.renameTo(file3);
            }
            file.renameTo(file2);
        }
        try {
            this.open(this.file, false);
        }
        catch (IOException iOException) {
            this.reportError(null, iOException, 4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord logRecord) {
        String string;
        try {
            string = this.getFormatter().format(logRecord);
        }
        catch (Exception exception) {
            this.reportError(null, exception, 1);
            return;
        }
        DirectoryFileHandler directoryFileHandler = this;
        synchronized (directoryFileHandler) {
            try {
                this.writer.write(string);
            }
            catch (Exception exception) {
                this.reportError(null, exception, 1);
                return;
            }
            if (this.limit > 0L && this.meter.written >= this.limit) {
                this.rollover();
            }
        }
    }

    public long getFileSize() {
        return this.meter.written;
    }

    @Override
    public void rollover() {
        String string = this.filename + "." + this.getFileExtension();
        this.rotate(string);
        RotationActionThread rotationActionThread = new RotationActionThread(string, this.actions, this.configEntry);
        rotationActionThread.start();
    }

    @Override
    public void setPostRotationActions(ArrayList<ActionType> arrayList) {
        this.actions = arrayList;
    }

    @Override
    public DN getInvokableComponentEntryDN() {
        return this.configEntry.getDN();
    }

    @Override
    public InvokableMethod[] getOperationSignatures() {
        InvokableMethod[] invokableMethodArray = new InvokableMethod[]{new InvokableMethod("rotateNow", "Rotate the log file immediately", null, "void", true, true)};
        return invokableMethodArray;
    }

    @Override
    public Object invokeMethod(String string, ConfigAttribute[] configAttributeArray) throws DirectoryException {
        if (!string.equals("rotateNow")) {
            int n = 3342414;
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, MessageHandler.getMessage(n), n);
        }
        this.rollover();
        return null;
    }

    @Override
    public void close() {
        this.flushAndClose();
    }

    private String getFileExtension() {
        return TimeThread.getUTCTime();
    }

    private void open(File file, boolean bl) throws IOException {
        long l = 0L;
        if (bl) {
            l = file.length();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file, bl);
        BufferedOutputStream bufferedOutputStream = null;
        bufferedOutputStream = this.bufferSize <= 0 ? new BufferedOutputStream(fileOutputStream) : new BufferedOutputStream(fileOutputStream, this.bufferSize);
        this.meter = new MeteredStream(bufferedOutputStream, l);
        this.writer = new BufferedWriter(new OutputStreamWriter(this.meter));
    }

    private void configure() {
        this.setLevel(Level.ALL);
        this.append = true;
    }

    private void flushAndClose() {
        if (this.writer != null) {
            try {
                this.writer.flush();
                this.writer.close();
            }
            catch (Exception exception) {
                this.reportError(null, exception, 3);
            }
            this.writer = null;
        }
    }

    @Override
    public void flush() {
        if (this.writer != null) {
            try {
                this.writer.flush();
            }
            catch (Exception exception) {
                this.reportError(null, exception, 2);
            }
        }
    }
}

