/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.loggers;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opends.server.api.AccessLogger;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.AbandonOperation;
import org.opends.server.core.AddOperation;
import org.opends.server.core.BindOperation;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.UnbindOperation;
import org.opends.server.loggers.ActionType;
import org.opends.server.loggers.DirectoryFileFormatter;
import org.opends.server.loggers.DirectoryFileHandler;
import org.opends.server.loggers.DirectoryLogLevel;
import org.opends.server.loggers.LoggerThread;
import org.opends.server.loggers.RetentionPolicy;
import org.opends.server.loggers.RotationConfigUtil;
import org.opends.server.loggers.RotationPolicy;
import org.opends.server.loggers.SizeBasedRotationPolicy;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.util.Base64;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryAuditLogger
extends AccessLogger
implements ConfigurableComponent {
    private static final int DEFAULT_TIME_INTERVAL = 30000;
    private static final int DEFAULT_BUFFER_SIZE = 0;
    private boolean suppressInternalOps = true;
    private Logger auditLogger = null;
    private String changedLogFileName = null;
    private DirectoryFileHandler fileHandler = null;
    private DN configDN;

    @Override
    public void initializeAccessLogger(ConfigEntry configEntry) throws ConfigException {
        this.configDN = configEntry.getDN();
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-log-file", MessageHandler.getMessage(0x300033), true, false, true);
        StringConfigAttribute stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
        if (stringConfigAttribute2 == null) {
            int n = 3407954;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
            throw new ConfigException(n, string);
        }
        this.initializeAccessLogger(stringConfigAttribute2.activeValue(), configEntry);
    }

    @Override
    public void closeAccessLogger() {
        this.fileHandler.close();
    }

    @Override
    public void logConnect(ClientConnection clientConnection) {
    }

    @Override
    public void logDisconnect(ClientConnection clientConnection, DisconnectReason disconnectReason, String string) {
    }

    @Override
    public void logAbandonRequest(AbandonOperation abandonOperation) {
    }

    @Override
    public void logAbandonResult(AbandonOperation abandonOperation) {
    }

    @Override
    public void logAddRequest(AddOperation addOperation) {
    }

    @Override
    public void logAddResponse(AddOperation addOperation) {
        long l = addOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        ResultCode resultCode = addOperation.getResultCode();
        if (resultCode == ResultCode.SUCCESS) {
            StringBuilder stringBuilder = new StringBuilder(50);
            stringBuilder.append("dn:");
            ByteString byteString = addOperation.getRawEntryDN();
            this.encodeValue(byteString, stringBuilder);
            stringBuilder.append("\n");
            stringBuilder.append("changetype: add\n");
            List<LDAPAttribute> list = addOperation.getRawAttributes();
            for (LDAPAttribute lDAPAttribute : list) {
                stringBuilder.append(lDAPAttribute.getAttributeType());
                stringBuilder.append(":");
                ArrayList<ASN1OctetString> arrayList = lDAPAttribute.getValues();
                if (!arrayList.isEmpty()) {
                    Iterator iterator = arrayList.iterator();
                    ASN1OctetString aSN1OctetString = (ASN1OctetString)iterator.next();
                    this.encodeValue(aSN1OctetString, stringBuilder);
                    while (iterator.hasNext()) {
                        stringBuilder.append("\n");
                        stringBuilder.append(lDAPAttribute.getAttributeType());
                        stringBuilder.append(":");
                        aSN1OctetString = (ASN1OctetString)iterator.next();
                        this.encodeValue(aSN1OctetString, stringBuilder);
                    }
                }
                stringBuilder.append("\n");
            }
            this.auditLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
        }
    }

    @Override
    public void logBindRequest(BindOperation bindOperation) {
    }

    @Override
    public void logBindResponse(BindOperation bindOperation) {
    }

    @Override
    public void logCompareRequest(CompareOperation compareOperation) {
    }

    @Override
    public void logCompareResponse(CompareOperation compareOperation) {
    }

    @Override
    public void logDeleteRequest(DeleteOperation deleteOperation) {
    }

    @Override
    public void logDeleteResponse(DeleteOperation deleteOperation) {
        long l = deleteOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        ResultCode resultCode = deleteOperation.getResultCode();
        if (resultCode == ResultCode.SUCCESS) {
            StringBuilder stringBuilder = new StringBuilder(50);
            stringBuilder.append("dn:");
            ByteString byteString = deleteOperation.getRawEntryDN();
            this.encodeValue(byteString, stringBuilder);
            stringBuilder.append("\n");
            stringBuilder.append("changetype: delete\n");
            stringBuilder.append("\n");
            this.auditLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
        }
    }

    @Override
    public void logExtendedRequest(ExtendedOperation extendedOperation) {
    }

    @Override
    public void logExtendedResponse(ExtendedOperation extendedOperation) {
    }

    @Override
    public void logModifyRequest(ModifyOperation modifyOperation) {
    }

    @Override
    public void logModifyResponse(ModifyOperation modifyOperation) {
        long l = modifyOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        ResultCode resultCode = modifyOperation.getResultCode();
        if (resultCode == ResultCode.SUCCESS) {
            StringBuilder stringBuilder = new StringBuilder(50);
            stringBuilder.append("dn:");
            ByteString byteString = modifyOperation.getRawEntryDN();
            this.encodeValue(byteString, stringBuilder);
            stringBuilder.append("\n");
            stringBuilder.append("changetype: modify\n");
            List<LDAPModification> list = modifyOperation.getRawModifications();
            for (LDAPModification lDAPModification : list) {
                ModificationType modificationType = lDAPModification.getModificationType();
                LDAPAttribute lDAPAttribute = lDAPModification.getAttribute();
                switch (modificationType) {
                    case ADD: {
                        stringBuilder.append("add: ");
                        break;
                    }
                    case DELETE: {
                        stringBuilder.append("delete: ");
                        break;
                    }
                    case REPLACE: {
                        stringBuilder.append("replace: ");
                        break;
                    }
                }
                stringBuilder.append(lDAPAttribute.getAttributeType());
            }
            stringBuilder.append("\n");
            this.auditLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
        }
    }

    @Override
    public void logModifyDNRequest(ModifyDNOperation modifyDNOperation) {
    }

    @Override
    public void logModifyDNResponse(ModifyDNOperation modifyDNOperation) {
        long l = modifyDNOperation.getConnectionID();
        if (l < 0L && this.suppressInternalOps) {
            return;
        }
        ResultCode resultCode = modifyDNOperation.getResultCode();
        if (resultCode == ResultCode.SUCCESS) {
            StringBuilder stringBuilder = new StringBuilder(50);
            stringBuilder.append("dn:");
            ByteString byteString = modifyDNOperation.getRawEntryDN();
            this.encodeValue(byteString, stringBuilder);
            stringBuilder.append("\n");
            stringBuilder.append("changetype: modrdn\n");
            stringBuilder.append("newrdn: ");
            ByteString byteString2 = modifyDNOperation.getRawNewRDN();
            this.encodeValue(byteString2, stringBuilder);
            stringBuilder.append("\n");
            stringBuilder.append("deleteoldrdn: ");
            if (modifyDNOperation.deleteOldRDN()) {
                stringBuilder.append("1\n");
            } else {
                stringBuilder.append("0\n");
            }
            if (modifyDNOperation.getRawNewSuperior() != null) {
                stringBuilder.append("newsuperior: ");
                ByteString byteString3 = modifyDNOperation.getRawNewSuperior();
                this.encodeValue(byteString3, stringBuilder);
                stringBuilder.append("\n");
            }
            stringBuilder.append("\n");
            this.auditLogger.log(DirectoryLogLevel.INFORMATIONAL, stringBuilder.toString());
        }
    }

    @Override
    public void logSearchRequest(SearchOperation searchOperation) {
    }

    @Override
    public void logSearchResultEntry(SearchOperation searchOperation, SearchResultEntry searchResultEntry) {
    }

    @Override
    public void logSearchResultReference(SearchOperation searchOperation, SearchResultReference searchResultReference) {
    }

    @Override
    public void logSearchResultDone(SearchOperation searchOperation) {
    }

    @Override
    public void logUnbind(UnbindOperation unbindOperation) {
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != this.getClass()) {
            return false;
        }
        return this.auditLogger.equals(object);
    }

    @Override
    public int hashCode() {
        return this.auditLogger.hashCode();
    }

    private void encodeValue(ByteString byteString, StringBuilder stringBuilder) {
        byte[] byArray = byteString.value();
        if (StaticUtils.needsBase64Encoding(byArray)) {
            stringBuilder.append(": ");
            stringBuilder.append(Base64.encode(byArray));
        } else {
            stringBuilder.append(" ");
            byteString.toString(stringBuilder);
        }
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        return this.configDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        return null;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        try {
            StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-log-file", MessageHandler.getMessage(0x300033), true, false, true);
            StringConfigAttribute stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (stringConfigAttribute2 == null) {
                int n = 3407954;
                String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
                list.add(string);
                return false;
            }
            this.changedLogFileName = stringConfigAttribute2.pendingValue();
        }
        catch (ConfigException configException) {
            int n = 3407926;
            String string = MessageHandler.getMessage(n, this.getClass().getName(), configEntry.getDN().toString(), String.valueOf(configException));
            list.add(string);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        this.fileHandler.close();
        try {
            this.initializeAccessLogger(this.changedLogFileName, configEntry);
        }
        catch (ConfigException configException) {
            return new ConfigChangeResult(DirectoryServer.getServerErrorResultCode(), false);
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    private void initializeAccessLogger(String string, ConfigEntry configEntry) throws ConfigException {
        this.auditLogger = Logger.getLogger("org.opends.server.loggers.DirectoryAuditLogger");
        this.auditLogger.setLevel(Level.ALL);
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(DirectoryServer.getServerRoot() + File.separator + string);
        }
        try {
            BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-suppress-internal-operations", MessageHandler.getMessage(3146031), false);
            BooleanConfigAttribute booleanConfigAttribute2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (booleanConfigAttribute2 != null) {
                this.suppressInternalOps = booleanConfigAttribute2.pendingValue();
            }
        }
        catch (Exception exception) {
            int n = 3408176;
            String string2 = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            throw new ConfigException(n, string2);
        }
        try {
            List<Object> list;
            int n = RotationConfigUtil.getIntegerAttribute(configEntry, "ds-cfg-buffer-size", 0x40000A);
            if (n == -1) {
                n = 0;
            }
            CopyOnWriteArrayList<RotationPolicy> copyOnWriteArrayList = RotationConfigUtil.getRotationPolicies(configEntry);
            this.fileHandler = new DirectoryFileHandler(configEntry, file.getAbsolutePath(), n);
            this.fileHandler.setFormatter(new DirectoryFileFormatter(true));
            this.auditLogger.addHandler(this.fileHandler);
            if (copyOnWriteArrayList != null) {
                list = RotationConfigUtil.getPostRotationActions(configEntry);
                this.fileHandler.setPostRotationActions((ArrayList<ActionType>)list);
                for (RotationPolicy object2 : copyOnWriteArrayList) {
                    if (!(object2 instanceof SizeBasedRotationPolicy)) continue;
                    long l = ((SizeBasedRotationPolicy)object2).getMaxFileSize();
                    this.fileHandler.setFileSize(l);
                    copyOnWriteArrayList.remove(object2);
                }
            }
            list = RotationConfigUtil.getRetentionPolicies(configEntry);
            int n2 = RotationConfigUtil.getIntegerAttribute(configEntry, "ds-cfg-thread-time-interval", 0x400009);
            if (n2 == -1) {
                n2 = 30000;
            }
            LoggerThread loggerThread = new LoggerThread("AuditLogger Thread", n2, this.fileHandler, copyOnWriteArrayList, (CopyOnWriteArrayList<RetentionPolicy>)list);
            loggerThread.start();
        }
        catch (IOException iOException) {
            int n = 0x440001;
            String string3 = MessageHandler.getMessage(n, String.valueOf(iOException));
            throw new ConfigException(n, string3, iOException);
        }
    }
}

