/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import org.opends.server.api.ClientConnection;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

public class WhoAmIExtendedOperation
extends ExtendedOperationHandler {
    private static final String CLASS_NAME = "org.opends.server.extensions.WhoAmIExtendedOperation";

    public WhoAmIExtendedOperation() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeExtendedOperationHandler(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeExtendedOperationHandler", String.valueOf(configEntry)));
        DirectoryServer.registerSupportedExtension("1.3.6.1.4.1.4203.1.11.3", this);
    }

    public void finalizeExtendedOperationHandler() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeExtendedOperationHandler", new String[0]));
        DirectoryServer.deregisterSupportedExtension("1.3.6.1.4.1.4203.1.11.3");
    }

    public void processExtendedOperation(ExtendedOperation extendedOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "processExtendedOperation", String.valueOf(extendedOperation)));
        ClientConnection clientConnection = extendedOperation.getClientConnection();
        if (clientConnection == null) {
            extendedOperation.setResultCode(ResultCode.UNWILLING_TO_PERFORM);
            int n = 1310997;
            extendedOperation.appendErrorMessage(MessageHandler.getMessage(n));
            return;
        }
        AuthenticationInfo authenticationInfo = clientConnection.getAuthenticationInfo();
        if (authenticationInfo == null || authenticationInfo.getAuthenticationDN() == null) {
            extendedOperation.setResultCode(ResultCode.SUCCESS);
            extendedOperation.setResponseValue(new ASN1OctetString());
            return;
        }
        extendedOperation.setResultCode(ResultCode.SUCCESS);
        extendedOperation.setResponseValue(new ASN1OctetString("dn:" + authenticationInfo.getAuthenticationDN().toString()));
    }
}

