/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import org.opends.server.api.ClientConnection;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.extensions.TLSCapableConnection;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class StartTLSExtendedOperation
extends ExtendedOperationHandler {
    private static final String CLASS_NAME = "org.opends.server.extensions.StartTLSExtendedOperation";

    public StartTLSExtendedOperation() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeExtendedOperationHandler(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeExtendedOperationHandler", String.valueOf(configEntry)));
        DirectoryServer.registerSupportedExtension("1.3.6.1.4.1.1466.20037", this);
    }

    public void finalizeExtendedOperationHandler() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeExtendedOperationHandler", new String[0]));
        DirectoryServer.deregisterSupportedExtension("1.3.6.1.4.1.1466.20037");
    }

    public void processExtendedOperation(ExtendedOperation extendedOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "processExtendedOperation", String.valueOf(extendedOperation)));
        extendedOperation.setResponseOID("1.3.6.1.4.1.1466.20037");
        ClientConnection clientConnection = extendedOperation.getClientConnection();
        if (clientConnection == null) {
            extendedOperation.setResultCode(ResultCode.UNAVAILABLE);
            int n = 1245312;
            extendedOperation.appendErrorMessage(MessageHandler.getMessage(n));
            return;
        }
        if (!(clientConnection instanceof TLSCapableConnection)) {
            extendedOperation.setResultCode(ResultCode.UNAVAILABLE);
            int n = 1245313;
            extendedOperation.appendErrorMessage(MessageHandler.getMessage(n));
            return;
        }
        TLSCapableConnection tLSCapableConnection = (TLSCapableConnection)((Object)clientConnection);
        StringBuilder stringBuilder = new StringBuilder();
        if (!tLSCapableConnection.tlsProtectionAvailable(stringBuilder)) {
            extendedOperation.setResultCode(ResultCode.UNAVAILABLE);
            extendedOperation.setErrorMessage(stringBuilder);
            return;
        }
        try {
            tLSCapableConnection.enableTLSConnectionSecurityProvider();
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "processExtendedOperation", directoryException));
            Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.MILD_ERROR, 1245314, StaticUtils.stackTraceToSingleLineString(directoryException));
        }
        extendedOperation.setResultCode(ResultCode.SUCCESS);
        try {
            tLSCapableConnection.sendClearResponse(extendedOperation);
            extendedOperation.setResponseSent();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "processExtendedOperation", exception));
            Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.MILD_ERROR, 1245563, StaticUtils.stackTraceToSingleLineString(exception));
            clientConnection.disconnect(DisconnectReason.SECURITY_PROBLEM, false, 1245563, StaticUtils.stackTraceToSingleLineString(exception));
        }
    }
}

