/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.PasswordValidator;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.IntegerConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.Operation;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LengthBasedPasswordValidator
extends PasswordValidator
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.extensions.LengthBasedPasswordValidator";
    private DN configEntryDN;
    private int maxLength;
    private int minLength;

    public LengthBasedPasswordValidator() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializePasswordValidator(ConfigEntry configEntry) throws ConfigException, InitializationException {
        Object object;
        IntegerConfigAttribute integerConfigAttribute;
        assert (Debug.debugEnter(CLASS_NAME, "initializePasswordValidator", String.valueOf(configEntry)));
        this.configEntryDN = configEntry.getDN();
        this.minLength = 0;
        int n = 1048907;
        IntegerConfigAttribute integerConfigAttribute2 = new IntegerConfigAttribute("ds-cfg-minimum-password-length", MessageHandler.getMessage(n), false, false, false, true, 0L, false, 0L);
        try {
            integerConfigAttribute = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute2);
            if (integerConfigAttribute != null) {
                this.minLength = integerConfigAttribute.activeIntValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializePasswordValidator", exception));
            n = 1245516;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        this.maxLength = 0;
        n = 1048909;
        integerConfigAttribute = new IntegerConfigAttribute("ds-cfg-maximum-password-length", MessageHandler.getMessage(n), false, false, false, true, 0L, false, 0L);
        try {
            object = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute);
            if (object != null) {
                this.maxLength = ((IntegerConfigAttribute)object).activeIntValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializePasswordValidator", exception));
            n = 1245518;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        if (this.minLength > 0 && this.maxLength > 0 && this.minLength > this.maxLength) {
            n = 1245519;
            object = MessageHandler.getMessage(n, this.minLength, this.maxLength);
            throw new ConfigException(n, (String)object);
        }
        DirectoryServer.registerConfigurableComponent(this);
    }

    @Override
    public void finalizePasswordValidator() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizePasswordValidator", new String[0]));
        DirectoryServer.deregisterConfigurableComponent(this);
    }

    @Override
    public boolean passwordIsAcceptable(ByteString byteString, Set<ByteString> set, Operation operation, Entry entry, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "passwordIsAcceptable", "ByteString", "Set<ByteString>", String.valueOf(operation), String.valueOf(entry), "java.lang.StringBuilder"));
        int n = byteString.stringValue().length();
        if (this.minLength > 0 && n < this.minLength) {
            stringBuilder.append(MessageHandler.getMessage(1245520, this.minLength));
            return false;
        }
        if (this.maxLength > 0 && n > this.maxLength) {
            stringBuilder.append(MessageHandler.getMessage(1245521, this.minLength));
            return false;
        }
        return true;
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        int n = 1048907;
        linkedList.add(new IntegerConfigAttribute("ds-cfg-minimum-password-length", MessageHandler.getMessage(n), false, false, false, true, 0L, false, 0L, this.minLength));
        n = 1048909;
        linkedList.add(new IntegerConfigAttribute("ds-cfg-maximum-password-length", MessageHandler.getMessage(n), false, false, false, true, 0L, false, 0L, this.maxLength));
        return linkedList;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
        int n = 0;
        int n2 = 1048907;
        IntegerConfigAttribute integerConfigAttribute = new IntegerConfigAttribute("ds-cfg-minimum-password-length", MessageHandler.getMessage(n2), false, false, false, true, 0L, false, 0L);
        try {
            IntegerConfigAttribute integerConfigAttribute2 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute);
            if (integerConfigAttribute2 != null) {
                n = integerConfigAttribute2.activeIntValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n2 = 1245516;
            list.add(MessageHandler.getMessage(n2, StaticUtils.stackTraceToSingleLineString(exception)));
        }
        int n3 = 0;
        n2 = 1048909;
        IntegerConfigAttribute integerConfigAttribute3 = new IntegerConfigAttribute("ds-cfg-maximum-password-length", MessageHandler.getMessage(n2), false, false, false, true, 0L, false, 0L);
        try {
            IntegerConfigAttribute integerConfigAttribute4 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute3);
            if (integerConfigAttribute4 != null) {
                n3 = integerConfigAttribute4.activeIntValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n2 = 1245518;
            list.add(MessageHandler.getMessage(n2, StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        if (n > 0 && n3 > 0 && n > n3) {
            n2 = 1245519;
            list.add(MessageHandler.getMessage(n2, n, n3));
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        int n2 = 1048907;
        IntegerConfigAttribute integerConfigAttribute = new IntegerConfigAttribute("ds-cfg-minimum-password-length", MessageHandler.getMessage(n2), false, false, false, true, 0L, false, 0L);
        try {
            IntegerConfigAttribute integerConfigAttribute2 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute);
            if (integerConfigAttribute2 != null) {
                n = integerConfigAttribute2.activeIntValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
            }
            n2 = 1245516;
            arrayList.add(MessageHandler.getMessage(n2, StaticUtils.stackTraceToSingleLineString(exception)));
        }
        int n3 = 0;
        n2 = 1048909;
        IntegerConfigAttribute integerConfigAttribute3 = new IntegerConfigAttribute("ds-cfg-maximum-password-length", MessageHandler.getMessage(n2), false, false, false, true, 0L, false, 0L);
        try {
            IntegerConfigAttribute integerConfigAttribute4 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute3);
            if (integerConfigAttribute4 != null) {
                n3 = integerConfigAttribute4.activeIntValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
            }
            n2 = 1245518;
            arrayList.add(MessageHandler.getMessage(n2, StaticUtils.stackTraceToSingleLineString(exception)));
        }
        if (n > 0 && n3 > 0 && n > n3) {
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
            }
            n2 = 1245519;
            arrayList.add(MessageHandler.getMessage(n2, n, n3));
        }
        if (resultCode == ResultCode.SUCCESS) {
            if (n != this.minLength) {
                this.minLength = n;
                if (bl) {
                    n2 = 1048914;
                    arrayList.add(MessageHandler.getMessage(n2, this.minLength));
                }
            }
            if (n3 != this.maxLength) {
                this.maxLength = n3;
                if (bl) {
                    n2 = 1048915;
                    arrayList.add(MessageHandler.getMessage(n2, this.maxLength));
                }
            }
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }
}

