/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.TrustManagerProvider;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBasedTrustManagerProvider
extends TrustManagerProvider
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.extensions.FileBasedTrustManagerProvider";
    private DN configEntryDN;
    private char[] trustStorePIN;
    private String trustStoreFile;
    private String trustStorePINEnVar;
    private String trustStorePINFile;
    private String trustStorePINProperty;
    private String trustStoreType;

    public FileBasedTrustManagerProvider() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeTrustManagerProvider(ConfigEntry configEntry) throws ConfigException, InitializationException {
        block45: {
            StringConfigAttribute stringConfigAttribute;
            int n;
            block47: {
                StringConfigAttribute stringConfigAttribute2;
                block46: {
                    Object object;
                    block44: {
                        Object object2;
                        block43: {
                            StringConfigAttribute stringConfigAttribute3;
                            assert (Debug.debugEnter(CLASS_NAME, "initializeTrustManagerProvider", String.valueOf(configEntry)));
                            this.configEntryDN = configEntry.getDN();
                            n = 0x100055;
                            StringConfigAttribute stringConfigAttribute4 = new StringConfigAttribute("ds-cfg-trust-store-file", MessageHandler.getMessage(n), true, false, false);
                            try {
                                stringConfigAttribute3 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute4);
                                if (stringConfigAttribute3 == null || (this.trustStoreFile = stringConfigAttribute3.activeValue()) == null) {
                                    n = 1310806;
                                    String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
                                    throw new ConfigException(n, string);
                                }
                                object2 = StaticUtils.getFileForPath(this.trustStoreFile);
                                if (!((File)object2).exists() || !((File)object2).isFile()) {
                                    n = 1310807;
                                    String string = MessageHandler.getMessage(n, String.valueOf(this.trustStoreFile), String.valueOf(this.configEntryDN));
                                    throw new InitializationException(n, string);
                                }
                            }
                            catch (ConfigException configException) {
                                assert (Debug.debugException(CLASS_NAME, "initializeTrustManagerProvider", configException));
                                throw configException;
                            }
                            catch (InitializationException initializationException) {
                                assert (Debug.debugException(CLASS_NAME, "initializeTrustManagerProvider", initializationException));
                                throw initializationException;
                            }
                            catch (Exception exception) {
                                assert (Debug.debugException(CLASS_NAME, "initializeTrustManagerProvider", exception));
                                n = 1310808;
                                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                                throw new InitializationException(n, string, exception);
                            }
                            this.trustStoreType = KeyStore.getDefaultType();
                            n = 1048665;
                            stringConfigAttribute3 = new StringConfigAttribute("ds-cfg-trust-store-type", MessageHandler.getMessage(n), false, false, false);
                            try {
                                object2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute3);
                                if (object2 == null) break block43;
                                object = ((StringConfigAttribute)object2).activeValue();
                                try {
                                    KeyStore.getInstance((String)object);
                                    this.trustStoreType = object;
                                }
                                catch (KeyStoreException keyStoreException) {
                                    assert (Debug.debugException(CLASS_NAME, "initializeTrustManagerProvider", keyStoreException));
                                    n = 1310826;
                                    String string = MessageHandler.getMessage(n, String.valueOf(object), String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(keyStoreException));
                                    throw new InitializationException(n, string);
                                }
                            }
                            catch (InitializationException initializationException) {
                                assert (Debug.debugException(CLASS_NAME, "initializeTrustManagerProvider", initializationException));
                                throw initializationException;
                            }
                            catch (Exception exception) {
                                assert (Debug.debugException(CLASS_NAME, "initializeTrustManagerProvider", exception));
                                n = 1310810;
                                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                                throw new InitializationException(n, string, exception);
                            }
                        }
                        this.trustStorePIN = null;
                        this.trustStorePINEnVar = null;
                        this.trustStorePINFile = null;
                        this.trustStorePINProperty = null;
                        n = 1048667;
                        object2 = new StringConfigAttribute("ds-cfg-trust-store-pin-property", MessageHandler.getMessage(n), false, false, false);
                        try {
                            object = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object2);
                            if (object == null) break block44;
                            String string = ((StringConfigAttribute)object).activeValue();
                            String string2 = System.getProperty(string);
                            if (string2 == null) {
                                n = 1310812;
                                String string3 = MessageHandler.getMessage(n, String.valueOf(string), String.valueOf(this.configEntryDN));
                                throw new InitializationException(n, string3);
                            }
                            this.trustStorePIN = string2.toCharArray();
                            this.trustStorePINProperty = string;
                            break block45;
                        }
                        catch (InitializationException initializationException) {
                            assert (Debug.debugException(CLASS_NAME, "initializeTrustManagerProvider", initializationException));
                            throw initializationException;
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "initializeTrustManagerProvider", exception));
                            n = 1310813;
                            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                            throw new InitializationException(n, string, exception);
                        }
                    }
                    n = 1048670;
                    object = new StringConfigAttribute("ds-cfg-trust-store-pin-environment-variable", MessageHandler.getMessage(n), false, false, false);
                    try {
                        stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object);
                        if (stringConfigAttribute2 == null) break block46;
                        String string = stringConfigAttribute2.activeValue();
                        String string4 = System.getenv(string);
                        if (string4 == null) {
                            n = 1310815;
                            String string5 = MessageHandler.getMessage(n, String.valueOf(string), String.valueOf(this.configEntryDN));
                            throw new InitializationException(n, string5);
                        }
                        this.trustStorePIN = string4.toCharArray();
                        this.trustStorePINEnVar = string;
                        break block45;
                    }
                    catch (InitializationException initializationException) {
                        assert (Debug.debugException(CLASS_NAME, "initializeTrustManagerProvider", initializationException));
                        throw initializationException;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "initializeTrustManagerProvider", exception));
                        n = 1310816;
                        String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                        throw new InitializationException(n, string, exception);
                    }
                }
                n = 0x100061;
                stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-trust-store-pin-file", MessageHandler.getMessage(n), false, false, false);
                try {
                    String string;
                    Object object;
                    stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute2);
                    if (stringConfigAttribute == null) break block47;
                    String string6 = stringConfigAttribute.activeValue();
                    File file = StaticUtils.getFileForPath(string6);
                    if (!file.exists()) {
                        n = 1310818;
                        String string7 = MessageHandler.getMessage(n, String.valueOf(string6), String.valueOf(this.configEntryDN));
                        throw new InitializationException(n, string7);
                    }
                    try {
                        object = new BufferedReader(new FileReader(file));
                        string = ((BufferedReader)object).readLine();
                        ((BufferedReader)object).close();
                    }
                    catch (IOException iOException) {
                        n = 1310819;
                        String string8 = MessageHandler.getMessage(n, String.valueOf(string6), String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(iOException));
                        throw new InitializationException(n, string8, iOException);
                    }
                    if (string == null) {
                        n = 1310820;
                        object = MessageHandler.getMessage(n, String.valueOf(string6), String.valueOf(this.configEntryDN));
                        throw new InitializationException(n, (String)object);
                    }
                    this.trustStorePIN = string.toCharArray();
                    this.trustStorePINFile = string6;
                    break block45;
                }
                catch (InitializationException initializationException) {
                    assert (Debug.debugException(CLASS_NAME, "initializeTrustManagerProvider", initializationException));
                    throw initializationException;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "initializeTrustManagerProvider", exception));
                    n = 1310821;
                    String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                    throw new InitializationException(n, string, exception);
                }
            }
            n = 0x100066;
            stringConfigAttribute = new StringConfigAttribute("ds-cfg-trust-store-pin", MessageHandler.getMessage(n), false, false, false);
            try {
                StringConfigAttribute stringConfigAttribute5 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
                if (stringConfigAttribute5 != null) {
                    this.trustStorePIN = stringConfigAttribute5.activeValue().toCharArray();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeTrustManagerProvider", exception));
                n = 1310823;
                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                throw new InitializationException(n, string, exception);
            }
        }
        DirectoryServer.registerConfigurableComponent(this);
    }

    @Override
    public void finalizeTrustManagerProvider() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeTrustManagerProvider", new String[0]));
        DirectoryServer.deregisterConfigurableComponent(this);
    }

    @Override
    public TrustManager[] getTrustManagers() throws DirectoryException {
        Object object;
        KeyStore keyStore;
        assert (Debug.debugEnter(CLASS_NAME, "getTrustManagers", new String[0]));
        try {
            keyStore = KeyStore.getInstance(this.trustStoreType);
            object = new FileInputStream(StaticUtils.getFileForPath(this.trustStoreFile));
            keyStore.load((InputStream)object, this.trustStorePIN);
            ((FileInputStream)object).close();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getTrustManagers", exception));
            int n = 1310824;
            String string = MessageHandler.getMessage(n, this.trustStoreFile, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n, exception);
        }
        try {
            object = TrustManagerFactory.getDefaultAlgorithm();
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance((String)object);
            trustManagerFactory.init(keyStore);
            return trustManagerFactory.getTrustManagers();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getTrustManagers", exception));
            int n = 1310825;
            String string = MessageHandler.getMessage(n, this.trustStoreFile, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n, exception);
        }
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        int n = 0x100055;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-trust-store-file", MessageHandler.getMessage(n), true, false, false, this.trustStoreFile);
        linkedList.add(stringConfigAttribute);
        n = 1048665;
        StringConfigAttribute stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-trust-store-type", MessageHandler.getMessage(n), true, false, false, this.trustStoreType);
        linkedList.add(stringConfigAttribute2);
        n = 1048667;
        StringConfigAttribute stringConfigAttribute3 = new StringConfigAttribute("ds-cfg-trust-store-pin-property", MessageHandler.getMessage(n), false, false, false, this.trustStorePINProperty);
        linkedList.add(stringConfigAttribute3);
        n = 1048670;
        StringConfigAttribute stringConfigAttribute4 = new StringConfigAttribute("ds-cfg-trust-store-pin-environment-variable", MessageHandler.getMessage(n), false, false, false, this.trustStorePINEnVar);
        linkedList.add(stringConfigAttribute4);
        n = 0x100061;
        StringConfigAttribute stringConfigAttribute5 = new StringConfigAttribute("ds-cfg-trust-store-pin-file", MessageHandler.getMessage(n), false, false, false, this.trustStorePINFile);
        linkedList.add(stringConfigAttribute5);
        String string = this.trustStorePINProperty == null && this.trustStorePINEnVar == null && this.trustStorePINFile == null ? new String(this.trustStorePIN) : null;
        n = 0x100066;
        StringConfigAttribute stringConfigAttribute6 = new StringConfigAttribute("ds-cfg-trust-store-pin", MessageHandler.getMessage(n), false, false, false, string);
        linkedList.add(stringConfigAttribute6);
        return linkedList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        StringConfigAttribute stringConfigAttribute;
        int n;
        block32: {
            StringConfigAttribute stringConfigAttribute2;
            Object object;
            StringConfigAttribute stringConfigAttribute3;
            block31: {
                Object object2;
                assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
                n = 0x100055;
                StringConfigAttribute stringConfigAttribute4 = new StringConfigAttribute("ds-cfg-trust-store-file", MessageHandler.getMessage(n), true, false, false);
                try {
                    object2 = null;
                    stringConfigAttribute3 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute4);
                    if (stringConfigAttribute3 == null || (object2 = stringConfigAttribute3.activeValue()) == null) {
                        n = 1310806;
                        String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
                        throw new ConfigException(n, string);
                    }
                    object = StaticUtils.getFileForPath((String)object2);
                    if (!((File)object).exists() || !((File)object).isFile()) {
                        n = 1310807;
                        String string = MessageHandler.getMessage(n, String.valueOf(object2), String.valueOf(this.configEntryDN));
                        list.add(string);
                        return false;
                    }
                }
                catch (ConfigException configException) {
                    assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", configException));
                    list.add(configException.getMessage());
                    return false;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
                    n = 1310808;
                    String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                    list.add(string);
                    return false;
                }
                n = 1048665;
                object2 = new StringConfigAttribute("ds-cfg-trust-store-type", MessageHandler.getMessage(n), false, false, false);
                try {
                    stringConfigAttribute3 = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object2);
                    if (stringConfigAttribute3 == null) break block31;
                    object = stringConfigAttribute3.activeValue();
                    try {
                        KeyStore.getInstance((String)object);
                    }
                    catch (KeyStoreException keyStoreException) {
                        assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", keyStoreException));
                        n = 1310826;
                        String string = MessageHandler.getMessage(n, String.valueOf(object), String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(keyStoreException));
                        list.add(string);
                        return false;
                    }
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
                    n = 1310810;
                    object = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                    list.add((String)object);
                    return false;
                }
            }
            n = 1048667;
            stringConfigAttribute3 = new StringConfigAttribute("ds-cfg-trust-store-pin-property", MessageHandler.getMessage(n), false, false, false);
            try {
                object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute3);
                if (object != null) {
                    String string = ((StringConfigAttribute)object).activeValue();
                    String string2 = System.getProperty(string);
                    if (string2 != null) return true;
                    n = 1310812;
                    String string3 = MessageHandler.getMessage(n, String.valueOf(string), String.valueOf(this.configEntryDN));
                    list.add(string3);
                    return false;
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
                n = 1310813;
                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                list.add(string);
                return false;
            }
            n = 1048670;
            object = new StringConfigAttribute("ds-cfg-trust-store-pin-environment-variable", MessageHandler.getMessage(n), false, false, false);
            try {
                stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object);
                if (stringConfigAttribute2 != null) {
                    String string = stringConfigAttribute2.activeValue();
                    String string4 = System.getenv(string);
                    if (string4 != null) return true;
                    n = 1310815;
                    String string5 = MessageHandler.getMessage(n, String.valueOf(string), String.valueOf(this.configEntryDN));
                    list.add(string5);
                    return false;
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
                n = 1310816;
                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                list.add(string);
                return false;
            }
            n = 0x100061;
            stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-trust-store-pin-file", MessageHandler.getMessage(n), false, false, false);
            try {
                String string;
                Object object3;
                stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute2);
                if (stringConfigAttribute == null) break block32;
                String string6 = stringConfigAttribute.activeValue();
                File file = StaticUtils.getFileForPath(string6);
                if (!file.exists()) {
                    n = 1310818;
                    String string7 = MessageHandler.getMessage(n, String.valueOf(string6), String.valueOf(this.configEntryDN));
                    list.add(string7);
                    return false;
                }
                try {
                    object3 = new BufferedReader(new FileReader(file));
                    string = ((BufferedReader)object3).readLine();
                    ((BufferedReader)object3).close();
                }
                catch (IOException iOException) {
                    n = 1310819;
                    String string8 = MessageHandler.getMessage(n, String.valueOf(string6), String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(iOException));
                    list.add(string8);
                    return false;
                }
                if (string != null) return true;
                n = 1310820;
                object3 = MessageHandler.getMessage(n, String.valueOf(string6), String.valueOf(this.configEntryDN));
                list.add((String)object3);
                return false;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
                n = 1310821;
                String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
                list.add(string);
                return false;
            }
        }
        n = 0x100066;
        stringConfigAttribute = new StringConfigAttribute("ds-cfg-trust-store-pin", MessageHandler.getMessage(n), false, false, false);
        try {
            StringConfigAttribute stringConfigAttribute5 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (stringConfigAttribute5 == null) return true;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 1310823;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            list.add(string);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        String string;
        String string2;
        String string3;
        Object object;
        Object object2;
        int n;
        String string4;
        ArrayList<String> arrayList;
        boolean bl2;
        ResultCode resultCode;
        block55: {
            StringConfigAttribute stringConfigAttribute;
            block57: {
                StringConfigAttribute stringConfigAttribute2;
                block56: {
                    StringConfigAttribute stringConfigAttribute3;
                    block54: {
                        block53: {
                            Object object3;
                            block52: {
                                assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
                                resultCode = ResultCode.SUCCESS;
                                bl2 = false;
                                arrayList = new ArrayList<String>();
                                string4 = null;
                                n = 0x100055;
                                StringConfigAttribute stringConfigAttribute4 = new StringConfigAttribute("ds-cfg-trust-store-file", MessageHandler.getMessage(n), true, false, false);
                                try {
                                    object2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute4);
                                    if (object2 == null || (string4 = ((StringConfigAttribute)object2).activeValue()) == null) {
                                        n = 1310806;
                                        String string5 = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN));
                                        throw new ConfigException(n, string5);
                                    }
                                    object3 = StaticUtils.getFileForPath(string4);
                                    if (!((File)object3).exists() || !((File)object3).isFile()) {
                                        n = 1310807;
                                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(string4), String.valueOf(this.configEntryDN)));
                                        if (resultCode == ResultCode.SUCCESS) {
                                            resultCode = ResultCode.CONSTRAINT_VIOLATION;
                                        }
                                    }
                                }
                                catch (ConfigException configException) {
                                    assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", configException));
                                    if (resultCode == ResultCode.SUCCESS) {
                                        resultCode = ResultCode.CONSTRAINT_VIOLATION;
                                    }
                                }
                                catch (Exception exception) {
                                    assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                                    n = 1310808;
                                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                                    if (resultCode != ResultCode.SUCCESS) break block52;
                                    resultCode = DirectoryServer.getServerErrorResultCode();
                                }
                            }
                            object2 = KeyStore.getDefaultType();
                            n = 1048665;
                            object3 = new StringConfigAttribute("ds-cfg-trust-store-type", MessageHandler.getMessage(n), false, false, false);
                            try {
                                object = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object3);
                                if (object != null) {
                                    object2 = ((StringConfigAttribute)object).activeValue();
                                    try {
                                        KeyStore.getInstance((String)object2);
                                    }
                                    catch (KeyStoreException keyStoreException) {
                                        assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", keyStoreException));
                                        n = 1310826;
                                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(object2), String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(keyStoreException)));
                                        if (resultCode == ResultCode.SUCCESS) {
                                            resultCode = ResultCode.CONSTRAINT_VIOLATION;
                                        }
                                    }
                                }
                            }
                            catch (Exception exception) {
                                assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                                n = 1310810;
                                arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                                if (resultCode != ResultCode.SUCCESS) break block53;
                                resultCode = DirectoryServer.getServerErrorResultCode();
                            }
                        }
                        object = null;
                        string3 = null;
                        string2 = null;
                        string = null;
                        n = 1048667;
                        StringConfigAttribute stringConfigAttribute5 = new StringConfigAttribute("ds-cfg-trust-store-pin-property", MessageHandler.getMessage(n), false, false, false);
                        try {
                            stringConfigAttribute3 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute5);
                            if (stringConfigAttribute3 == null) break block54;
                            String string6 = stringConfigAttribute3.activeValue();
                            String string7 = System.getProperty(string6);
                            if (string7 == null) {
                                n = 1310812;
                                arrayList.add(MessageHandler.getMessage(n, String.valueOf(string6), String.valueOf(this.configEntryDN)));
                                if (resultCode == ResultCode.SUCCESS) {
                                    resultCode = ResultCode.CONSTRAINT_VIOLATION;
                                }
                                break block55;
                            }
                            object = string7.toCharArray();
                            string = string6;
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                            n = 1310813;
                            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                            if (resultCode == ResultCode.SUCCESS) {
                                resultCode = DirectoryServer.getServerErrorResultCode();
                            }
                            break block55;
                        }
                    }
                    n = 1048670;
                    stringConfigAttribute3 = new StringConfigAttribute("ds-cfg-trust-store-pin-environment-variable", MessageHandler.getMessage(n), false, false, false);
                    try {
                        stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute3);
                        if (stringConfigAttribute2 == null) break block56;
                        String string8 = stringConfigAttribute2.activeValue();
                        String string9 = System.getenv(string8);
                        if (string9 == null) {
                            n = 1310815;
                            arrayList.add(MessageHandler.getMessage(n, String.valueOf(string8), String.valueOf(this.configEntryDN)));
                            if (resultCode == ResultCode.SUCCESS) {
                                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                            }
                            break block55;
                        }
                        object = string9.toCharArray();
                        string3 = string8;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                        n = 1310816;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = DirectoryServer.getServerErrorResultCode();
                        }
                        break block55;
                    }
                }
                n = 0x100061;
                stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-trust-store-pin-file", MessageHandler.getMessage(n), false, false, false);
                try {
                    String string10;
                    stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute2);
                    if (stringConfigAttribute == null) break block57;
                    String string11 = stringConfigAttribute.activeValue();
                    File file = StaticUtils.getFileForPath(string11);
                    if (!file.exists()) {
                        n = 1310818;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(string11), String.valueOf(this.configEntryDN)));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = ResultCode.CONSTRAINT_VIOLATION;
                        }
                        break block55;
                    }
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                        string10 = bufferedReader.readLine();
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        n = 1310819;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(string11), String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(iOException)));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = DirectoryServer.getServerErrorResultCode();
                        }
                        break block55;
                    }
                    if (string10 == null) {
                        n = 1310820;
                        arrayList.add(MessageHandler.getMessage(n, String.valueOf(string11), String.valueOf(this.configEntryDN)));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = ResultCode.CONSTRAINT_VIOLATION;
                        }
                        break block55;
                    }
                    object = string10.toCharArray();
                    string2 = string11;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                    n = 1310821;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                    if (resultCode == ResultCode.SUCCESS) {
                        resultCode = DirectoryServer.getServerErrorResultCode();
                    }
                    break block55;
                }
            }
            n = 0x100066;
            stringConfigAttribute = new StringConfigAttribute("ds-cfg-trust-store-pin", MessageHandler.getMessage(n), false, false, false);
            try {
                StringConfigAttribute stringConfigAttribute6 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
                if (stringConfigAttribute6 != null) {
                    object = stringConfigAttribute6.activeValue().toCharArray();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                n = 1310823;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
                if (resultCode != ResultCode.SUCCESS) break block55;
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            if (!this.trustStoreFile.equals(string4)) {
                this.trustStoreFile = string4;
                if (bl) {
                    n = 1048683;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), String.valueOf(string4)));
                }
            }
            if (!this.trustStoreType.equals(object2)) {
                this.trustStoreType = object2;
                if (bl) {
                    n = 1048684;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), String.valueOf(object2)));
                }
            }
            if (!(this.trustStorePIN == null && object == null || Arrays.equals(this.trustStorePIN, (char[])object))) {
                this.trustStorePIN = (char[])object;
                this.trustStorePINProperty = string;
                this.trustStorePINEnVar = string3;
                this.trustStorePINFile = string2;
                if (bl) {
                    n = 1048685;
                    arrayList.add(MessageHandler.getMessage(n));
                }
            }
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }
}

