/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.api.Backend;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.EntryCache;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.IntegerConfigAttribute;
import org.opends.server.config.IntegerWithUnitConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.CacheEntry;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LockManager;
import org.opends.server.types.LockType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FIFOEntryCache
extends EntryCache
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.extensions.FIFOEntryCache";
    private static final LinkedHashMap<String, Double> timeUnits = new LinkedHashMap();
    private DN configEntryDN;
    private HashMap<Backend, HashMap<Long, CacheEntry>> idMap;
    private HashSet<SearchFilter> excludeFilters;
    private HashSet<SearchFilter> includeFilters;
    private int maxMemoryPercent;
    private LinkedHashMap<DN, CacheEntry> dnMap;
    private Lock cacheLock;
    private long lockTimeout;
    private long maxAllowedMemory;
    private long maxEntries;
    private Runtime runtime;

    public FIFOEntryCache() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeEntryCache(ConfigEntry configEntry) throws ConfigException, InitializationException {
        Object object;
        Object object2;
        Object object3;
        StringConfigAttribute stringConfigAttribute;
        ConfigAttribute configAttribute;
        ConfigAttribute configAttribute2;
        IntegerConfigAttribute integerConfigAttribute;
        assert (Debug.debugEnter(CLASS_NAME, "initializeEntryCache", String.valueOf(configEntry)));
        this.configEntryDN = configEntry.getDN();
        this.idMap = new HashMap();
        this.dnMap = new LinkedHashMap();
        this.cacheLock = new ReentrantLock();
        this.runtime = Runtime.getRuntime();
        this.maxMemoryPercent = 90;
        int n = 0x100006;
        IntegerConfigAttribute integerConfigAttribute2 = new IntegerConfigAttribute("ds-cfg-max-memory-percent", MessageHandler.getMessage(n), true, false, false, true, 1L, true, 100L);
        try {
            integerConfigAttribute = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute2);
            if (integerConfigAttribute != null) {
                this.maxMemoryPercent = integerConfigAttribute.activeIntValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 1310727, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception), this.maxMemoryPercent);
        }
        this.maxAllowedMemory = this.runtime.maxMemory() / 100L * (long)this.maxMemoryPercent;
        this.maxEntries = Long.MAX_VALUE;
        n = 0x100008;
        integerConfigAttribute = new IntegerConfigAttribute("ds-cfg-max-entries", MessageHandler.getMessage(n), true, false, false, true, 0L, false, 0L);
        try {
            configAttribute2 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute);
            if (configAttribute2 != null) {
                this.maxEntries = configAttribute2.activeValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 1310729, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
        }
        this.lockTimeout = 2000L;
        n = 0x10000A;
        configAttribute2 = new IntegerWithUnitConfigAttribute("ds-cfg-lock-timeout", MessageHandler.getMessage(n), false, timeUnits, true, 0L, false, 0L);
        try {
            configAttribute = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(configAttribute2);
            if (configAttribute != null) {
                this.lockTimeout = configAttribute.activeCalculatedValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 1310731, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception), this.lockTimeout);
        }
        this.includeFilters = new HashSet();
        n = 0x10000C;
        configAttribute = new StringConfigAttribute("ds-cfg-include-filter", MessageHandler.getMessage(n), false, true, false);
        try {
            stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(configAttribute);
            if (stringConfigAttribute != null && (object3 = stringConfigAttribute.activeValues()) != null && !object3.isEmpty()) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    try {
                        this.includeFilters.add(SearchFilter.createFilterFromString((String)object));
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
                        Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 1179661, String.valueOf(this.configEntryDN), object, StaticUtils.stackTraceToSingleLineString(exception));
                    }
                }
                if (this.includeFilters.isEmpty()) {
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 1179662, String.valueOf(this.configEntryDN));
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 1310735, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
        }
        this.excludeFilters = new HashSet();
        n = 0x100010;
        stringConfigAttribute = new StringConfigAttribute("ds-cfg-exclude-filter", MessageHandler.getMessage(n), false, true, false);
        try {
            object3 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object3 != null && (object2 = ((StringConfigAttribute)object3).activeValues()) != null && !object2.isEmpty()) {
                object = object2.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    try {
                        this.excludeFilters.add(SearchFilter.createFilterFromString(string));
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
                        Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 0x120011, String.valueOf(this.configEntryDN), string, StaticUtils.stackTraceToSingleLineString(exception));
                    }
                }
                if (this.excludeFilters.isEmpty()) {
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 0x120012, String.valueOf(this.configEntryDN));
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 1310739, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finalizeEntryCache() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeEntryCache", new String[0]));
        this.cacheLock.lock();
        try {
            this.idMap.clear();
            this.dnMap.clear();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "finalizeEntryCache", exception));
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    @Override
    public boolean containsEntry(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "containsEntry", String.valueOf(dN)));
        return this.dnMap.containsKey(dN);
    }

    @Override
    public Entry getEntry(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "getEntry", String.valueOf(dN)));
        CacheEntry cacheEntry = this.dnMap.get(dN);
        if (cacheEntry == null) {
            return null;
        }
        return cacheEntry.getEntry();
    }

    @Override
    public long getEntryID(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "getEntryID", String.valueOf(dN)));
        CacheEntry cacheEntry = this.dnMap.get(dN);
        if (cacheEntry == null) {
            return -1L;
        }
        return cacheEntry.getEntryID();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Entry getEntry(DN dN, LockType lockType, List<Lock> list) {
        assert (Debug.debugEnter(CLASS_NAME, "getEntry", String.valueOf(dN), String.valueOf((Object)lockType), "java.util.List<Lock>"));
        CacheEntry cacheEntry = this.dnMap.get(dN);
        if (cacheEntry == null) {
            return null;
        }
        switch (lockType) {
            case READ: {
                Lock lock = LockManager.lockRead(dN, this.lockTimeout);
                if (lock == null) {
                    return null;
                }
                try {
                    list.add(lock);
                    return cacheEntry.getEntry();
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "getEntry", exception));
                    try {
                        LockManager.unlock(dN, lock);
                        return null;
                    }
                    catch (Exception exception2) {
                        assert (Debug.debugException(CLASS_NAME, "getEntry", exception2));
                        return null;
                    }
                }
            }
            case WRITE: {
                Lock lock = LockManager.lockWrite(dN, this.lockTimeout);
                if (lock == null) {
                    return null;
                }
                try {
                    list.add(lock);
                    return cacheEntry.getEntry();
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "getEntry", exception));
                    try {
                        LockManager.unlock(dN, lock);
                        return null;
                    }
                    catch (Exception exception3) {
                        assert (Debug.debugException(CLASS_NAME, "getEntry", exception3));
                        return null;
                    }
                }
            }
            case NONE: {
                return cacheEntry.getEntry();
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Entry getEntry(Backend backend, long l, LockType lockType, List<Lock> list) {
        assert (Debug.debugEnter(CLASS_NAME, "getEntry", String.valueOf(backend), String.valueOf(l), String.valueOf((Object)lockType), "java.util.List<Lock>"));
        HashMap<Long, CacheEntry> hashMap = this.idMap.get(backend);
        if (hashMap == null) {
            return null;
        }
        CacheEntry cacheEntry = hashMap.get(l);
        if (cacheEntry == null) {
            return null;
        }
        Entry entry = cacheEntry.getEntry();
        switch (lockType) {
            case READ: {
                Lock lock = LockManager.lockRead(entry.getDN(), this.lockTimeout);
                if (lock == null) {
                    return null;
                }
                try {
                    list.add(lock);
                    return entry;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "getEntry", exception));
                    try {
                        LockManager.unlock(entry.getDN(), lock);
                        return null;
                    }
                    catch (Exception exception2) {
                        assert (Debug.debugException(CLASS_NAME, "getEntry", exception2));
                        return null;
                    }
                }
            }
            case WRITE: {
                Lock lock = LockManager.lockWrite(entry.getDN(), this.lockTimeout);
                if (lock == null) {
                    return null;
                }
                try {
                    list.add(lock);
                    return entry;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "getEntry", exception));
                    try {
                        LockManager.unlock(entry.getDN(), lock);
                        return null;
                    }
                    catch (Exception exception3) {
                        assert (Debug.debugException(CLASS_NAME, "getEntry", exception3));
                        return null;
                    }
                }
            }
            case NONE: {
                return entry;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putEntry(Entry entry, Backend backend, long l) {
        assert (Debug.debugEnter(CLASS_NAME, "putEntry", String.valueOf(entry), String.valueOf(backend), String.valueOf(l)));
        if (!this.excludeFilters.isEmpty()) {
            for (SearchFilter object : this.excludeFilters) {
                try {
                    if (!object.matchesEntry(entry)) continue;
                    return;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "putEntry", exception));
                    return;
                }
            }
        }
        if (!this.includeFilters.isEmpty()) {
            boolean bl = false;
            for (SearchFilter searchFilter : this.includeFilters) {
                try {
                    if (!searchFilter.matchesEntry(entry)) continue;
                    bl = true;
                    break;
                }
                catch (Exception hashMap) {
                    assert (Debug.debugException(CLASS_NAME, "putEntry", hashMap));
                }
            }
            if (!bl) {
                return;
            }
        }
        CacheEntry cacheEntry = new CacheEntry(entry, backend, l);
        try {
            if (!this.cacheLock.tryLock(this.lockTimeout, TimeUnit.MILLISECONDS)) {
                return;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "putEntry", exception));
            return;
        }
        try {
            long l2 = this.runtime.totalMemory() - this.runtime.freeMemory();
            if (l2 > this.maxAllowedMemory) {
                Iterator<CacheEntry> iterator = this.dnMap.values().iterator();
                if (iterator.hasNext()) {
                    CacheEntry cacheEntry2 = iterator.next();
                    iterator.remove();
                    HashMap<Long, CacheEntry> hashMap = this.idMap.get(cacheEntry2.getBackend());
                    if (hashMap != null) {
                        hashMap.remove(cacheEntry2.getEntryID());
                    }
                }
            } else {
                this.dnMap.put(entry.getDN(), cacheEntry);
                HashMap<Long, CacheEntry> hashMap = this.idMap.get(backend);
                if (hashMap == null) {
                    hashMap = new HashMap();
                    hashMap.put(l, cacheEntry);
                    this.idMap.put(backend, hashMap);
                } else {
                    hashMap.put(l, cacheEntry);
                }
                int n = this.dnMap.size();
                if (this.maxEntries > 0L && (long)n > this.maxEntries) {
                    Iterator<CacheEntry> iterator = this.dnMap.values().iterator();
                    while (iterator.hasNext() && (long)n > this.maxEntries) {
                        CacheEntry cacheEntry3 = iterator.next();
                        iterator.remove();
                        HashMap<Long, CacheEntry> hashMap2 = this.idMap.get(cacheEntry3.getBackend());
                        if (hashMap2 != null) {
                            hashMap2.remove(cacheEntry3.getEntryID());
                        }
                        --n;
                    }
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "putEntry", exception));
            return;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean putEntryIfAbsent(Entry entry, Backend backend, long l) {
        assert (Debug.debugEnter(CLASS_NAME, "putEntryIfAbsent", String.valueOf(entry), String.valueOf(backend), String.valueOf(l)));
        if (!this.excludeFilters.isEmpty()) {
            for (SearchFilter object : this.excludeFilters) {
                try {
                    if (!object.matchesEntry(entry)) continue;
                    return true;
                }
                catch (Exception bl) {
                    assert (Debug.debugException(CLASS_NAME, "putEntry", bl));
                    return false;
                }
            }
        }
        if (!this.includeFilters.isEmpty()) {
            boolean bl = false;
            for (SearchFilter searchFilter : this.includeFilters) {
                try {
                    if (!searchFilter.matchesEntry(entry)) continue;
                    bl = true;
                    break;
                }
                catch (Exception bl2) {
                    assert (Debug.debugException(CLASS_NAME, "putEntry", bl2));
                }
            }
            if (!bl) {
                return true;
            }
        }
        CacheEntry cacheEntry = new CacheEntry(entry, backend, l);
        try {
            if (!this.cacheLock.tryLock(this.lockTimeout, TimeUnit.MILLISECONDS)) {
                return false;
            }
        }
        catch (Exception l2) {
            assert (Debug.debugException(CLASS_NAME, "putEntry", l2));
            return false;
        }
        try {
            block30: {
                Object object;
                block29: {
                    if (this.dnMap.containsKey(entry.getDN())) {
                        boolean exception = false;
                        return exception;
                    }
                    long l2 = this.runtime.totalMemory() - this.runtime.freeMemory();
                    if (l2 <= this.maxAllowedMemory) break block29;
                    object = this.dnMap.values().iterator();
                    if (!object.hasNext()) break block30;
                    CacheEntry cacheEntry2 = object.next();
                    object.remove();
                    HashMap<Long, CacheEntry> hashMap = this.idMap.get(cacheEntry2.getBackend());
                    if (hashMap == null) break block30;
                    hashMap.remove(cacheEntry2.getEntryID());
                    break block30;
                }
                this.dnMap.put(entry.getDN(), cacheEntry);
                object = this.idMap.get(backend);
                if (object == null) {
                    object = new HashMap<Long, Object>();
                    ((HashMap)object).put(l, cacheEntry);
                    this.idMap.put(backend, (HashMap<Long, CacheEntry>)object);
                } else {
                    ((HashMap)object).put(l, cacheEntry);
                }
                int n = this.dnMap.size();
                if (this.maxEntries > 0L && (long)n > this.maxEntries) {
                    Iterator<CacheEntry> iterator = this.dnMap.values().iterator();
                    while (iterator.hasNext() && (long)n > this.maxEntries) {
                        CacheEntry cacheEntry3 = iterator.next();
                        iterator.remove();
                        HashMap<Long, CacheEntry> hashMap = this.idMap.get(cacheEntry3.getBackend());
                        if (hashMap != null) {
                            hashMap.remove(cacheEntry3.getEntryID());
                        }
                        --n;
                    }
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "putEntry", exception));
            boolean bl = false;
            return bl;
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeEntry(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "removeEntry", String.valueOf(dN)));
        this.cacheLock.lock();
        try {
            CacheEntry cacheEntry = (CacheEntry)this.dnMap.remove(dN);
            if (cacheEntry == null) {
                return;
            }
            Map map = this.idMap.get(cacheEntry.getBackend());
            if (map == null) {
                return;
            }
            map.remove(cacheEntry.getEntryID());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "removeEntry", exception));
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        assert (Debug.debugEnter(CLASS_NAME, "clear", new String[0]));
        this.cacheLock.lock();
        try {
            this.dnMap.clear();
            this.idMap.clear();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "clear", exception));
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearBackend(Backend backend) {
        assert (Debug.debugEnter(CLASS_NAME, "clearBackend", String.valueOf(backend)));
        this.cacheLock.lock();
        try {
            HashMap<Long, CacheEntry> hashMap = this.idMap.remove(backend);
            if (hashMap == null) {
                return;
            }
            int n = 0;
            for (CacheEntry cacheEntry : hashMap.values()) {
                this.dnMap.remove(cacheEntry.getEntry().getDN());
                if (++n % 1000 != 0) continue;
                this.cacheLock.unlock();
                Thread.currentThread();
                Thread.yield();
                this.cacheLock.lock();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "clearBackend", exception));
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearSubtree(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "clearSubtree", String.valueOf(dN)));
        Backend backend = DirectoryServer.getBackend(dN);
        if (backend == null) {
            return;
        }
        this.cacheLock.lock();
        try {
            this.clearSubtree(dN, backend);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "clearBackend", exception));
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    private void clearSubtree(DN dN, Backend backend) {
        assert (Debug.debugEnter(CLASS_NAME, "clearSubtree", String.valueOf(dN), String.valueOf(backend)));
        HashMap<Long, CacheEntry> hashMap = this.idMap.get(backend);
        if (hashMap == null) {
            return;
        }
        int n = 0;
        Iterator<CacheEntry> iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            CacheEntry cacheEntry = iterator.next();
            DN dN2 = cacheEntry.getEntry().getDN();
            if (dN2.isDescendantOf(dN)) {
                iterator.remove();
                this.dnMap.remove(dN2);
            }
            if (++n % 1000 != 0) continue;
            this.cacheLock.unlock();
            Thread.currentThread();
            Thread.yield();
            this.cacheLock.lock();
        }
        for (Backend backend2 : backend.getSubordinateBackends()) {
            boolean bl = false;
            for (DN dN3 : backend2.getBaseDNs()) {
                if (!dN3.isDescendantOf(dN)) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            this.clearSubtree(dN, backend2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleLowMemory() {
        assert (Debug.debugEnter(CLASS_NAME, "handleLowMemory", new String[0]));
        this.cacheLock.lock();
        try {
            int n = this.dnMap.size();
            if (n < 1000) {
                this.dnMap.clear();
                this.idMap.clear();
            } else {
                Iterator<CacheEntry> iterator = this.dnMap.values().iterator();
                for (int i = n / 10; iterator.hasNext() && i > 0; --i) {
                    CacheEntry cacheEntry = iterator.next();
                    iterator.remove();
                    HashMap<Long, CacheEntry> hashMap = this.idMap.get(cacheEntry.getBackend());
                    if (hashMap == null) continue;
                    hashMap.remove(cacheEntry.getEntryID());
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "handleLowMemory", exception));
        }
        finally {
            this.cacheLock.unlock();
        }
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        int n = 0x100006;
        IntegerConfigAttribute integerConfigAttribute = new IntegerConfigAttribute("ds-cfg-max-memory-percent", MessageHandler.getMessage(n), true, false, false, true, 1L, true, 100L, this.maxMemoryPercent);
        linkedList.add(integerConfigAttribute);
        n = 0x100008;
        IntegerConfigAttribute integerConfigAttribute2 = new IntegerConfigAttribute("ds-cfg-max-entries", MessageHandler.getMessage(n), true, false, false, true, 0L, false, 0L, this.maxEntries);
        linkedList.add(integerConfigAttribute2);
        n = 0x10000A;
        IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute = new IntegerWithUnitConfigAttribute("ds-cfg-lock-timeout", MessageHandler.getMessage(n), false, timeUnits, true, 0L, false, 0L, this.lockTimeout, "milliseconds");
        linkedList.add(integerWithUnitConfigAttribute);
        n = 0x10000C;
        ArrayList<String> arrayList = new ArrayList<String>(this.includeFilters.size());
        for (SearchFilter object2 : this.includeFilters) {
            arrayList.add(object2.toString());
        }
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-include-filter", MessageHandler.getMessage(n), false, true, false, arrayList);
        linkedList.add(stringConfigAttribute);
        n = 0x100010;
        ArrayList<String> arrayList2 = new ArrayList<String>(this.excludeFilters.size());
        for (SearchFilter searchFilter : this.excludeFilters) {
            arrayList2.add(searchFilter.toString());
        }
        StringConfigAttribute stringConfigAttribute2 = new StringConfigAttribute("ds-cfg-exclude-filter", MessageHandler.getMessage(n), false, true, false, arrayList2);
        linkedList.add(stringConfigAttribute2);
        return linkedList;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        Object object;
        Object object2;
        Object object3;
        StringConfigAttribute stringConfigAttribute;
        ConfigAttribute configAttribute;
        ConfigAttribute configAttribute2;
        IntegerConfigAttribute integerConfigAttribute;
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
        boolean bl = true;
        int n = 0x100006;
        IntegerConfigAttribute integerConfigAttribute2 = new IntegerConfigAttribute("ds-cfg-max-memory-percent", MessageHandler.getMessage(n), true, false, false, true, 1L, true, 100L);
        try {
            integerConfigAttribute = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 0x140014;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl = false;
        }
        n = 0x100008;
        integerConfigAttribute = new IntegerConfigAttribute("ds-cfg-max-entries", MessageHandler.getMessage(n), true, false, false, true, 0L, false, 0L);
        try {
            configAttribute2 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            n = 1310741;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl = false;
        }
        n = 0x10000A;
        configAttribute2 = new IntegerWithUnitConfigAttribute("ds-cfg-lock-timeout", MessageHandler.getMessage(n), false, timeUnits, true, 0L, false, 0L);
        try {
            configAttribute = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(configAttribute2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            n = 1310742;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl = false;
        }
        n = 0x10000C;
        configAttribute = new StringConfigAttribute("ds-cfg-include-filter", MessageHandler.getMessage(n), false, true, false);
        try {
            stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(configAttribute);
            if (stringConfigAttribute != null && (object3 = stringConfigAttribute.activeValues()) != null && !object3.isEmpty()) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    try {
                        SearchFilter.createFilterFromString((String)object);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
                        n = 1310743;
                        list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), object, StaticUtils.stackTraceToSingleLineString(exception)));
                        bl = false;
                    }
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            n = 1310744;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl = false;
        }
        n = 0x100010;
        stringConfigAttribute = new StringConfigAttribute("ds-cfg-exclude-filter", MessageHandler.getMessage(n), false, true, false);
        try {
            object3 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object3 != null && (object2 = ((StringConfigAttribute)object3).activeValues()) != null && !object2.isEmpty()) {
                object = object2.iterator();
                while (object.hasNext()) {
                    String string = (String)object.next();
                    try {
                        SearchFilter.createFilterFromString(string);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
                        n = 1310745;
                        list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), string, StaticUtils.stackTraceToSingleLineString(exception)));
                        bl = false;
                    }
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeEntryCache", exception));
            n = 1310746;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            bl = false;
        }
        return bl;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl3 = true;
        int n = 90;
        int n2 = 0x100006;
        IntegerConfigAttribute integerConfigAttribute = new IntegerConfigAttribute("ds-cfg-max-memory-percent", MessageHandler.getMessage(n2), true, false, false, true, 1L, true, 100L);
        try {
            IntegerConfigAttribute integerConfigAttribute2 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute);
            if (integerConfigAttribute2 != null) {
                n = integerConfigAttribute2.pendingIntValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n2 = 0x140014;
            arrayList.add(MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = ResultCode.CONSTRAINT_VIOLATION;
            bl3 = false;
        }
        long l = Long.MAX_VALUE;
        n2 = 0x100008;
        IntegerConfigAttribute integerConfigAttribute3 = new IntegerConfigAttribute("ds-cfg-max-entries", MessageHandler.getMessage(n2), true, false, false, true, 0L, false, 0L);
        try {
            IntegerConfigAttribute integerConfigAttribute4 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute3);
            if (integerConfigAttribute4 != null) {
                l = integerConfigAttribute4.pendingValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n2 = 1310741;
            arrayList.add(MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
            }
            bl3 = false;
        }
        long l2 = 2000L;
        n2 = 0x10000A;
        IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute = new IntegerWithUnitConfigAttribute("ds-cfg-lock-timeout", MessageHandler.getMessage(n2), false, timeUnits, true, 0L, false, 0L);
        try {
            object5 = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(integerWithUnitConfigAttribute);
            if (object5 != null) {
                l2 = ((IntegerWithUnitConfigAttribute)object5).pendingCalculatedValue();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n2 = 1310742;
            arrayList.add(MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
            }
            bl3 = false;
        }
        object5 = new HashSet();
        n2 = 0x10000C;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-include-filter", MessageHandler.getMessage(n2), false, true, false);
        try {
            object4 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object4 != null && (object3 = ((StringConfigAttribute)object4).activeValues()) != null && !object3.isEmpty()) {
                object2 = object3.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    try {
                        ((HashSet)object5).add(SearchFilter.createFilterFromString((String)object));
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                        n2 = 1310743;
                        arrayList.add(MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), object, StaticUtils.stackTraceToSingleLineString(exception)));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                        }
                        bl3 = false;
                    }
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n2 = 1310744;
            arrayList.add(MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
            }
            bl3 = false;
        }
        object4 = new HashSet();
        n2 = 0x100010;
        object3 = new StringConfigAttribute("ds-cfg-exclude-filter", MessageHandler.getMessage(n2), false, true, false);
        try {
            object2 = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object3);
            if (object2 != null && (object = ((StringConfigAttribute)object2).activeValues()) != null && !object.isEmpty()) {
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    try {
                        ((HashSet)object4).add(SearchFilter.createFilterFromString(string));
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                        n2 = 1310745;
                        arrayList.add(MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), string, StaticUtils.stackTraceToSingleLineString(exception)));
                        if (resultCode == ResultCode.SUCCESS) {
                            resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                        }
                        bl3 = false;
                    }
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n2 = 1310746;
            arrayList.add(MessageHandler.getMessage(n2, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
            }
            bl3 = false;
        }
        if (bl3) {
            if (this.maxMemoryPercent != n) {
                this.maxMemoryPercent = n;
                this.maxAllowedMemory = this.runtime.maxMemory() / 100L * (long)this.maxMemoryPercent;
                if (bl) {
                    arrayList.add(MessageHandler.getMessage(0x10001B, this.maxMemoryPercent, this.maxAllowedMemory));
                }
            }
            if (this.maxEntries != l) {
                this.maxEntries = l;
                if (bl) {
                    arrayList.add(MessageHandler.getMessage(0x10001C, this.maxEntries));
                }
            }
            if (this.lockTimeout != l2) {
                this.lockTimeout = l2;
                if (bl) {
                    arrayList.add(MessageHandler.getMessage(0x10001D, this.lockTimeout));
                }
            }
            if (!this.includeFilters.equals(object5)) {
                this.includeFilters = object5;
                if (bl) {
                    arrayList.add(MessageHandler.getMessage(0x10001E));
                }
            }
            if (!this.excludeFilters.equals(object4)) {
                this.excludeFilters = object4;
                if (bl) {
                    arrayList.add(MessageHandler.getMessage(0x10001F));
                }
            }
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }

    static {
        timeUnits.put("ms", 1.0);
        timeUnits.put("milliseconds", 1.0);
        timeUnits.put("s", 1000.0);
        timeUnits.put("seconds", 1000.0);
    }
}

