/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.ConnectionSecurityProvider;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.MultiChoiceConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.BindOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.CertificateValidationPolicy;
import org.opends.server.extensions.TLSConnectionSecurityProvider;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExternalSASLMechanismHandler
extends SASLMechanismHandler
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.extensions.ExternalSASLMechanismHandler";
    private static final HashSet<String> validationValueStrings = new HashSet(3);
    private AttributeType certificateAttributeType;
    private CertificateValidationPolicy validationPolicy;
    private DN configEntryDN;

    public ExternalSASLMechanismHandler() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeSASLMechanismHandler(ConfigEntry configEntry) throws ConfigException, InitializationException {
        Object object;
        Object object2;
        assert (Debug.debugEnter(CLASS_NAME, "initializeSASLMechanismHandler", String.valueOf(configEntry)));
        this.configEntryDN = configEntry.getDN();
        this.validationPolicy = CertificateValidationPolicy.NEVER;
        int n = 1048707;
        MultiChoiceConfigAttribute multiChoiceConfigAttribute = new MultiChoiceConfigAttribute("ds-cfg-client-certificate-validation-policy", MessageHandler.getMessage(n), false, false, false, validationValueStrings);
        try {
            object2 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute);
            if (object2 != null) {
                this.validationPolicy = CertificateValidationPolicy.policyForName(((MultiChoiceConfigAttribute)object2).activeValue());
                if (this.validationPolicy == null) {
                    n = 1310852;
                    String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), ((MultiChoiceConfigAttribute)object2).activeValue());
                    throw new ConfigException(n, string);
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeSASLMechanismHandler", exception));
            n = 1310853;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        object2 = "usercertificate";
        n = 1048710;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-certificate-attribute", MessageHandler.getMessage(n), false, false, false);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object != null) {
                object2 = StaticUtils.toLowerCase(((StringConfigAttribute)object).activeValue());
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeSASLMechanismHandler", exception));
            n = 1310855;
            String string = MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        this.certificateAttributeType = DirectoryServer.getAttributeType((String)object2);
        if (this.certificateAttributeType == null) {
            n = 1310856;
            object = MessageHandler.getMessage(n, String.valueOf(object2), String.valueOf(this.configEntryDN));
            throw new ConfigException(n, (String)object);
        }
        DirectoryServer.registerSASLMechanismHandler("EXTERNAL", this);
        DirectoryServer.registerConfigurableComponent(this);
    }

    @Override
    public void finalizeSASLMechanismHandler() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeSASLMechanismHandler", new String[0]));
        DirectoryServer.deregisterConfigurableComponent(this);
        DirectoryServer.deregisterSASLMechanismHandler("EXTERNAL");
    }

    @Override
    public void processSASLBind(BindOperation bindOperation) {
        Object object;
        Entry entry;
        assert (Debug.debugEnter(CLASS_NAME, "processSASLBind", String.valueOf(bindOperation)));
        ClientConnection clientConnection = bindOperation.getClientConnection();
        if (clientConnection == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n = 1245307;
            String string = MessageHandler.getMessage(n);
            bindOperation.setAuthFailureReason(n, string);
            return;
        }
        ConnectionSecurityProvider connectionSecurityProvider = clientConnection.getConnectionSecurityProvider();
        if (connectionSecurityProvider == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n = 1245308;
            String string = MessageHandler.getMessage(n);
            bindOperation.setAuthFailureReason(n, string);
            return;
        }
        if (!(connectionSecurityProvider instanceof TLSConnectionSecurityProvider)) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n = 1245309;
            String string = MessageHandler.getMessage(n, connectionSecurityProvider.getSecurityMechanismName());
            bindOperation.setAuthFailureReason(n, string);
            return;
        }
        TLSConnectionSecurityProvider tLSConnectionSecurityProvider = (TLSConnectionSecurityProvider)connectionSecurityProvider;
        Certificate[] certificateArray = tLSConnectionSecurityProvider.getClientCertificateChain();
        if (certificateArray == null || certificateArray.length == 0) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n = 1245310;
            String string = MessageHandler.getMessage(n);
            bindOperation.setAuthFailureReason(n, string);
            return;
        }
        try {
            entry = DirectoryServer.getCertificateMapper().mapCertificateToUser(certificateArray);
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "processSASLBind", directoryException));
            bindOperation.setResponseData(directoryException);
            return;
        }
        if (entry == null) {
            bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
            int n = 1245311;
            String string = MessageHandler.getMessage(n);
            bindOperation.setAuthFailureReason(n, string);
            return;
        }
        bindOperation.setSASLAuthUserEntry(entry);
        List<Attribute> list = entry.getAttribute(this.certificateAttributeType);
        switch (this.validationPolicy) {
            case ALWAYS: {
                if (list == null) {
                    if (this.validationPolicy != CertificateValidationPolicy.ALWAYS) break;
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int n = 1245321;
                    String string = MessageHandler.getMessage(n, String.valueOf(entry.getDN()));
                    bindOperation.setAuthFailureReason(n, string);
                    return;
                }
                try {
                    object = certificateArray[0].getEncoded();
                    AttributeValue attributeValue = new AttributeValue(this.certificateAttributeType, (ByteString)new ASN1OctetString((byte[])object));
                    boolean bl = false;
                    for (Attribute object2 : list) {
                        if (!object2.hasValue(attributeValue)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        int n = 1245322;
                        String object3 = MessageHandler.getMessage(n, String.valueOf(entry.getDN()));
                        bindOperation.setAuthFailureReason(n, object3);
                        return;
                    }
                    break;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "processSASLBind", exception));
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int n = 1245323;
                    String string = MessageHandler.getMessage(n, String.valueOf(entry.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                    bindOperation.setAuthFailureReason(n, string);
                    return;
                }
            }
            case IFPRESENT: {
                if (list == null) break;
                try {
                    object = certificateArray[0].getEncoded();
                    AttributeValue attributeValue = new AttributeValue(this.certificateAttributeType, (ByteString)new ASN1OctetString((byte[])object));
                    boolean bl = false;
                    for (Attribute attribute : list) {
                        if (!attribute.hasValue(attributeValue)) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        int n = 1245322;
                        String string = MessageHandler.getMessage(n, String.valueOf(entry.getDN()));
                        bindOperation.setAuthFailureReason(n, string);
                        return;
                    }
                    break;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "processSASLBind", exception));
                    bindOperation.setResultCode(ResultCode.INVALID_CREDENTIALS);
                    int n = 1245323;
                    String string = MessageHandler.getMessage(n, String.valueOf(entry.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                    bindOperation.setAuthFailureReason(n, string);
                    return;
                }
            }
        }
        object = new AuthenticationInfo(entry.getDN(), "EXTERNAL", DirectoryServer.isRootDN(entry.getDN()));
        clientConnection.setAuthenticationInfo((AuthenticationInfo)object);
        bindOperation.setResultCode(ResultCode.SUCCESS);
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        int n = 1048707;
        linkedList.add(new MultiChoiceConfigAttribute("ds-cfg-client-certificate-validation-policy", MessageHandler.getMessage(n), false, false, false, validationValueStrings, this.validationPolicy.toString()));
        n = 1048710;
        String string = this.certificateAttributeType.getNameOrOID();
        linkedList.add(new StringConfigAttribute("ds-cfg-certificate-attribute", MessageHandler.getMessage(n), false, false, false, string));
        return linkedList;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        Object object;
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
        int n = 1048707;
        MultiChoiceConfigAttribute multiChoiceConfigAttribute = new MultiChoiceConfigAttribute("ds-cfg-client-certificate-validation-policy", MessageHandler.getMessage(n), false, false, false, validationValueStrings);
        try {
            object = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute);
            if (object != null && CertificateValidationPolicy.policyForName(((MultiChoiceConfigAttribute)object).activeValue()) == null) {
                n = 1310852;
                list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), ((MultiChoiceConfigAttribute)object).activeValue()));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 1310853;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        object = "usercertificate";
        n = 1048710;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-certificate-attribute", MessageHandler.getMessage(n), false, false, false);
        try {
            StringConfigAttribute stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (stringConfigAttribute2 != null) {
                object = StaticUtils.toLowerCase(stringConfigAttribute2.activeValue());
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 1310855;
            list.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        if (DirectoryServer.getAttributeType((String)object) == null) {
            n = 1310856;
            list.add(MessageHandler.getMessage(n, String.valueOf(object), String.valueOf(this.configEntryDN)));
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        Object object;
        Object object2;
        assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl2 = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        CertificateValidationPolicy certificateValidationPolicy = CertificateValidationPolicy.NEVER;
        int n = 1048707;
        MultiChoiceConfigAttribute multiChoiceConfigAttribute = new MultiChoiceConfigAttribute("ds-cfg-client-certificate-validation-policy", MessageHandler.getMessage(n), false, false, false, validationValueStrings);
        try {
            object2 = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute);
            if (object2 != null && (certificateValidationPolicy = CertificateValidationPolicy.policyForName(((MultiChoiceConfigAttribute)object2).activeValue())) == null) {
                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                n = 1310852;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), ((MultiChoiceConfigAttribute)object2).activeValue()));
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
            n = 1310853;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
        }
        object2 = "usercertificate";
        n = 1048710;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-certificate-attribute", MessageHandler.getMessage(n), false, false, false);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object != null) {
                object2 = StaticUtils.toLowerCase(((StringConfigAttribute)object).activeValue());
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
            n = 1310855;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        object = DirectoryServer.getAttributeType((String)object2);
        if (object == null) {
            n = 1310856;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(object2), String.valueOf(this.configEntryDN)));
            if (resultCode == ResultCode.SUCCESS) {
                resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            if (certificateValidationPolicy != this.validationPolicy) {
                this.validationPolicy = certificateValidationPolicy;
                if (bl) {
                    n = 1048716;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), String.valueOf((Object)this.validationPolicy)));
                }
            }
            if (!this.certificateAttributeType.equals(object)) {
                this.certificateAttributeType = object;
                if (bl) {
                    n = 1048717;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(this.configEntryDN), this.certificateAttributeType.getNameOrOID()));
                }
            }
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }

    @Override
    public boolean isPasswordBased(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "isPasswordBased", String.valueOf(string)));
        return false;
    }

    @Override
    public boolean isSecure(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "isSecure", String.valueOf(string)));
        return true;
    }

    static {
        validationValueStrings.add(CertificateValidationPolicy.ALWAYS.toString());
        validationValueStrings.add(CertificateValidationPolicy.NEVER.toString());
        validationValueStrings.add(CertificateValidationPolicy.IFPRESENT.toString());
    }
}

