/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import org.opends.server.api.ClientConnection;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class CancelExtendedOperation
extends ExtendedOperationHandler {
    private static final String CLASS_NAME = "org.opends.server.extensions.CancelExtendedOperation";

    public CancelExtendedOperation() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeExtendedOperationHandler(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeExtendedOperationHandler", String.valueOf(configEntry)));
        DirectoryServer.registerSupportedExtension("1.3.6.1.1.8", this);
    }

    public void finalizeExtendedOperationHandler() {
        assert (Debug.debugEnter(CLASS_NAME, "finalizeExtendedOperationHandler", new String[0]));
        DirectoryServer.deregisterSupportedExtension("1.3.6.1.1.8");
    }

    public void processExtendedOperation(ExtendedOperation extendedOperation) {
        int n;
        Object object;
        assert (Debug.debugEnter(CLASS_NAME, "processExtendedOperation", String.valueOf(extendedOperation)));
        ASN1OctetString aSN1OctetString = extendedOperation.getRequestValue();
        if (aSN1OctetString == null) {
            extendedOperation.setResultCode(ResultCode.PROTOCOL_ERROR);
            int n2 = 1245511;
            extendedOperation.appendErrorMessage(MessageHandler.getMessage(n2));
            return;
        }
        try {
            object = ASN1Sequence.decodeAsSequence(aSN1OctetString.value());
            n = ((ASN1Sequence)object).elements().get(0).decodeAsInteger().intValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "processExtendedOperation", exception));
            extendedOperation.setResultCode(ResultCode.PROTOCOL_ERROR);
            int n3 = 1245512;
            String string = MessageHandler.getMessage(n3, StaticUtils.stackTraceToSingleLineString(exception));
            extendedOperation.appendErrorMessage(string);
            return;
        }
        object = MessageHandler.getMessage(1048905, extendedOperation.getMessageID());
        StringBuilder stringBuilder = new StringBuilder();
        CancelRequest cancelRequest = new CancelRequest(true, (String)object, stringBuilder);
        ClientConnection clientConnection = extendedOperation.getClientConnection();
        CancelResult cancelResult = clientConnection.cancelOperation(n, cancelRequest);
        extendedOperation.setResultCode(cancelResult.getResultCode());
        extendedOperation.setErrorMessage(stringBuilder);
    }
}

