/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.extensions;

import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.ByteStringFactory;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.Base64;

public class Base64PasswordStorageScheme
extends PasswordStorageScheme {
    private static final String CLASS_NAME = "org.opends.server.extensions.Base64PasswordStorageScheme";

    public Base64PasswordStorageScheme() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializePasswordStorageScheme(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializePasswordStorageScheme", String.valueOf(configEntry)));
    }

    public String getStorageSchemeName() {
        assert (Debug.debugEnter(CLASS_NAME, "getStorageSchemeName", new String[0]));
        return "BASE64";
    }

    public ByteString encodePassword(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "encodePassword", "ByteString"));
        return ByteStringFactory.create(Base64.encode(byteString.value()));
    }

    public ByteString encodePasswordWithScheme(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "encodePasswordWithScheme", "ByteString"));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        stringBuilder.append("BASE64");
        stringBuilder.append('}');
        stringBuilder.append(Base64.encode(byteString.value()));
        return ByteStringFactory.create(stringBuilder.toString());
    }

    public boolean passwordMatches(ByteString byteString, ByteString byteString2) {
        assert (Debug.debugEnter(CLASS_NAME, "passwordMatches", String.valueOf(byteString), String.valueOf(byteString2)));
        String string = Base64.encode(byteString.value());
        String string2 = byteString2.stringValue();
        return string.equals(string2);
    }

    public boolean isReversible() {
        assert (Debug.debugEnter(CLASS_NAME, "isReversible", new String[0]));
        return true;
    }

    public ByteString getPlaintextValue(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getPlaintextValue", String.valueOf(byteString)));
        try {
            return ByteStringFactory.create(Base64.decode(byteString.stringValue()));
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "getPlaintextValue", exception));
            int n = 1245186;
            String string = MessageHandler.getMessage(n, byteString.stringValue(), String.valueOf(exception));
            throw new DirectoryException(ResultCode.INVALID_CREDENTIALS, string, n, exception);
        }
    }

    public boolean supportsAuthPasswordSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsAuthPasswordSyntax", new String[0]));
        return false;
    }

    public ByteString encodeAuthPassword(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "encodeAuthPassword", String.valueOf(byteString)));
        int n = 1245514;
        String string = MessageHandler.getMessage(n, this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    public boolean authPasswordMatches(ByteString byteString, String string, String string2) {
        assert (Debug.debugEnter(CLASS_NAME, "authPasswordMatches", String.valueOf(byteString), String.valueOf(string), String.valueOf(string2)));
        return false;
    }

    public ByteString getAuthPasswordPlaintextValue(String string, String string2) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthPasswordPlaintextValue", String.valueOf(string), String.valueOf(string2)));
        int n = 1245514;
        String string3 = MessageHandler.getMessage(n, this.getStorageSchemeName());
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string3, n);
    }

    public boolean isStorageSchemeSecure() {
        assert (Debug.debugEnter(CLASS_NAME, "isStorageSchemeSecure", new String[0]));
        return false;
    }
}

