/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.List;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.Operation;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.loggers.Access;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.Control;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.OperationType;
import org.opends.server.types.operation.PostOperationUnbindOperation;
import org.opends.server.types.operation.PreParseUnbindOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnbindOperation
extends Operation
implements PreParseUnbindOperation,
PostOperationUnbindOperation {
    private static final String CLASS_NAME = "org.opends.server.core.UnbindOperation";
    private long processingStartTime;
    private long processingStopTime;

    public UnbindOperation(ClientConnection clientConnection, long l, int n, ArrayList<Control> arrayList) {
        super(clientConnection, l, n, arrayList);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(l), String.valueOf(n), String.valueOf(arrayList)));
    }

    @Override
    public final OperationType getOperationType() {
        return OperationType.UNBIND;
    }

    @Override
    public final void disconnectClient(DisconnectReason disconnectReason, boolean bl, String string, int n) {
        this.clientConnection.disconnect(disconnectReason, bl, string, n);
    }

    @Override
    public final String[][] getRequestLogElements() {
        return new String[0][];
    }

    @Override
    public final String[][] getResponseLogElements() {
        return new String[0][];
    }

    @Override
    public final List<Control> getResponseControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getResponseControls", new String[0]));
        return NO_RESPONSE_CONTROLS;
    }

    @Override
    public final void addResponseControl(Control control) {
    }

    @Override
    public final void removeResponseControl(Control control) {
    }

    @Override
    public long getProcessingStartTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingStartTime", new String[0]));
        return this.processingStartTime;
    }

    @Override
    public long getProcessingStopTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingStopTime", new String[0]));
        return this.processingStopTime;
    }

    @Override
    public long getProcessingTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingTime", new String[0]));
        return this.processingStopTime - this.processingStartTime;
    }

    @Override
    public final void run() {
        assert (Debug.debugEnter(CLASS_NAME, "run", new String[0]));
        PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
        boolean bl = false;
        this.processingStartTime = System.currentTimeMillis();
        pluginConfigManager.invokePreParseUnbindPlugins(this);
        Access.logUnbind(this);
        this.getClientConnection().disconnect(DisconnectReason.UNBIND, false, null, -1);
        pluginConfigManager.invokePostOperationUnbindPlugins(this);
        this.processingStopTime = System.currentTimeMillis();
    }

    @Override
    public final CancelResult cancel(CancelRequest cancelRequest) {
        assert (Debug.debugEnter(CLASS_NAME, "cancel", String.valueOf(cancelRequest)));
        cancelRequest.addResponseMessage(MessageHandler.getMessage(196611));
        return CancelResult.CANNOT_CANCEL;
    }

    @Override
    public final CancelRequest getCancelRequest() {
        assert (Debug.debugEnter(CLASS_NAME, "getCancelRequest", new String[0]));
        return null;
    }

    @Override
    boolean setCancelRequest(CancelRequest cancelRequest) {
        assert (Debug.debugEnter(CLASS_NAME, "setCancelRequest", String.valueOf(cancelRequest)));
        return false;
    }

    @Override
    public final void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("UnbindOperation(connID=");
        stringBuilder.append(this.clientConnection.getConnectionID());
        stringBuilder.append(", opID=");
        stringBuilder.append(this.operationID);
        stringBuilder.append(")");
    }
}

