/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.HashSet;
import java.util.InputMismatchException;
import java.util.NoSuchElementException;
import org.opends.server.core.SimpleSubtreeSpecification;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RelativeSubtreeSpecification
extends SimpleSubtreeSpecification {
    private static final String CLASS_NAME = RelativeSubtreeSpecification.class.getName();
    private DN rootDN;
    private DN relativeBaseDN;
    private SearchFilter filter;

    public static RelativeSubtreeSpecification valueOf(DN dN, String string) throws DirectoryException {
        String string2;
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "valueOf", new String[0]));
        DN dN2 = null;
        int n2 = -1;
        int n3 = -1;
        HashSet<DN> hashSet = new HashSet<DN>();
        HashSet<DN> hashSet2 = new HashSet<DN>();
        SearchFilter searchFilter = null;
        SimpleSubtreeSpecification.Parser parser = new SimpleSubtreeSpecification.Parser(string);
        boolean bl = true;
        try {
            block21: {
                parser.skipLeftBrace();
                n = 1;
                while (true) {
                    if (parser.hasNextRightBrace()) {
                        parser.skipRightBrace();
                        if (parser.hasNext()) {
                            throw new InputMismatchException();
                        }
                        break block21;
                    }
                    if (n == 0) {
                        parser.skipSeparator();
                    } else {
                        n = 0;
                    }
                    string2 = parser.nextKey();
                    if (string2.equals("relativebase")) {
                        if (dN2 != null) {
                            throw new InputMismatchException();
                        }
                        dN2 = DN.decode(parser.nextStringValue());
                        continue;
                    }
                    if (string2.equals("minimum")) {
                        if (n2 != -1) {
                            throw new InputMismatchException();
                        }
                        n2 = parser.nextInt();
                        continue;
                    }
                    if (string2.equals("maximum")) {
                        if (n3 != -1) {
                            throw new InputMismatchException();
                        }
                        n3 = parser.nextInt();
                        continue;
                    }
                    if (string2.equals("specificationfilter")) {
                        if (searchFilter != null) {
                            throw new InputMismatchException();
                        }
                        searchFilter = SearchFilter.createFilterFromString(parser.nextStringValue());
                        continue;
                    }
                    if (!string2.equals("specificexclusions")) break;
                    if (!hashSet.isEmpty() || !hashSet2.isEmpty()) {
                        throw new InputMismatchException();
                    }
                    parser.nextSpecificExclusions(hashSet, hashSet2);
                }
                throw new InputMismatchException();
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n3 >= 0 && n3 < n2) {
                bl = false;
            }
        }
        catch (InputMismatchException inputMismatchException) {
            bl = false;
        }
        catch (NoSuchElementException noSuchElementException) {
            bl = false;
        }
        if (bl) {
            return new RelativeSubtreeSpecification(dN, dN2, n2, n3, hashSet, hashSet2, searchFilter);
        }
        n = 6488323;
        string2 = MessageHandler.getMessage(n, string);
        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n);
    }

    public RelativeSubtreeSpecification(DN dN, DN dN2, int n, int n2, Iterable<DN> iterable, Iterable<DN> iterable2, SearchFilter searchFilter) {
        super(dN2 == null ? dN : dN.concat(dN2), n, n2, iterable, iterable2);
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.rootDN = dN;
        this.relativeBaseDN = dN2;
        this.filter = searchFilter;
    }

    public DN getRootDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getRootDN", new String[0]));
        return this.rootDN;
    }

    public DN getRelativeBaseDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getRelativeBaseDN", new String[0]));
        return this.relativeBaseDN;
    }

    public SearchFilter getFilter() {
        assert (Debug.debugEnter(CLASS_NAME, "getFilter", new String[0]));
        return this.filter;
    }

    @Override
    public boolean isWithinScope(Entry entry) {
        assert (Debug.debugEnter(CLASS_NAME, "isWithinScope", new String[0]));
        if (this.isDNWithinScope(entry.getDN())) {
            try {
                return this.filter.matchesEntry(entry);
            }
            catch (DirectoryException directoryException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public StringBuilder toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        boolean bl = true;
        stringBuilder.append("{");
        if (this.relativeBaseDN != null && !this.relativeBaseDN.isNullDN()) {
            stringBuilder.append(" relativeBase ");
            StaticUtils.toRFC3641StringValue(stringBuilder, this.relativeBaseDN.toString());
            bl = false;
        }
        Iterable<DN> iterable = this.getChopBefore();
        Iterable<DN> iterable2 = this.getChopAfter();
        if (iterable != null && iterable.iterator().hasNext() || iterable2 != null && iterable2.iterator().hasNext()) {
            if (!bl) {
                stringBuilder.append(",");
            } else {
                bl = false;
            }
            stringBuilder.append(" specificExclusions { ");
            boolean bl2 = true;
            if (iterable != null) {
                for (DN dN : iterable) {
                    if (!bl2) {
                        stringBuilder.append(", chopBefore:");
                    } else {
                        stringBuilder.append("chopBefore:");
                        bl2 = false;
                    }
                    StaticUtils.toRFC3641StringValue(stringBuilder, dN.toString());
                }
            }
            if (iterable2 != null) {
                for (DN dN : iterable2) {
                    if (!bl2) {
                        stringBuilder.append(", chopAfter:");
                    } else {
                        stringBuilder.append("chopAfter:");
                        bl2 = false;
                    }
                    StaticUtils.toRFC3641StringValue(stringBuilder, dN.toString());
                }
            }
            stringBuilder.append(" }");
        }
        if (this.getMinimumDepth() > 0) {
            if (!bl) {
                stringBuilder.append(",");
            } else {
                bl = false;
            }
            stringBuilder.append(" minimum ");
            stringBuilder.append(this.getMinimumDepth());
        }
        if (this.getMaximumDepth() >= 0) {
            if (!bl) {
                stringBuilder.append(",");
            } else {
                bl = false;
            }
            stringBuilder.append(" maximum ");
            stringBuilder.append(this.getMaximumDepth());
        }
        if (this.filter != null) {
            if (!bl) {
                stringBuilder.append(",");
            } else {
                bl = false;
            }
            stringBuilder.append(" specificationFilter ");
            StaticUtils.toRFC3641StringValue(stringBuilder, this.filter.toString());
        }
        stringBuilder.append(" }");
        return stringBuilder;
    }

    @Override
    public boolean equals(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "equals", new String[0]));
        if (this == object) {
            return true;
        }
        if (object instanceof RelativeSubtreeSpecification) {
            RelativeSubtreeSpecification relativeSubtreeSpecification = (RelativeSubtreeSpecification)object;
            if (!this.commonComponentsEquals(relativeSubtreeSpecification)) {
                return false;
            }
            if (!this.getBaseDN().equals(relativeSubtreeSpecification.getBaseDN())) {
                return false;
            }
            if (this.filter != null) {
                return this.filter.equals(relativeSubtreeSpecification.filter);
            }
            return this.filter == relativeSubtreeSpecification.filter;
        }
        return false;
    }

    @Override
    public int hashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
        int n = this.commonComponentsHashCode();
        n = n * 31 + this.getBaseDN().hashCode();
        if (this.filter != null) {
            n = n * 31 + this.filter.hashCode();
        }
        return n;
    }
}

