/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.IntermediateResponsePluginResult;
import org.opends.server.api.plugin.LDIFPluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.api.plugin.PostConnectPluginResult;
import org.opends.server.api.plugin.PostDisconnectPluginResult;
import org.opends.server.api.plugin.PostOperationPluginResult;
import org.opends.server.api.plugin.PostResponsePluginResult;
import org.opends.server.api.plugin.PreOperationPluginResult;
import org.opends.server.api.plugin.PreParsePluginResult;
import org.opends.server.api.plugin.SearchEntryPluginResult;
import org.opends.server.api.plugin.SearchReferencePluginResult;
import org.opends.server.api.plugin.StartupPluginResult;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.MultiChoiceConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.AbandonOperation;
import org.opends.server.core.AddOperation;
import org.opends.server.core.BindOperation;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.Operation;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.UnbindOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.IntermediateResponse;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginConfigManager
implements ConfigChangeListener,
ConfigAddListener,
ConfigDeleteListener {
    private static final String CLASS_NAME = "org.opends.server.core.PluginConfigManager";
    private DirectoryServerPlugin[] startupPlugins;
    private DirectoryServerPlugin[] shutdownPlugins;
    private DirectoryServerPlugin[] postConnectPlugins;
    private DirectoryServerPlugin[] postDisconnectPlugins;
    private DirectoryServerPlugin[] ldifImportPlugins;
    private DirectoryServerPlugin[] ldifExportPlugins;
    private DirectoryServerPlugin[] preParseAbandonPlugins;
    private DirectoryServerPlugin[] preParseAddPlugins;
    private DirectoryServerPlugin[] preParseBindPlugins;
    private DirectoryServerPlugin[] preParseComparePlugins;
    private DirectoryServerPlugin[] preParseDeletePlugins;
    private DirectoryServerPlugin[] preParseExtendedPlugins;
    private DirectoryServerPlugin[] preParseModifyPlugins;
    private DirectoryServerPlugin[] preParseModifyDNPlugins;
    private DirectoryServerPlugin[] preParseSearchPlugins;
    private DirectoryServerPlugin[] preParseUnbindPlugins;
    private DirectoryServerPlugin[] preOperationAddPlugins;
    private DirectoryServerPlugin[] preOperationBindPlugins;
    private DirectoryServerPlugin[] preOperationComparePlugins;
    private DirectoryServerPlugin[] preOperationDeletePlugins;
    private DirectoryServerPlugin[] preOperationExtendedPlugins;
    private DirectoryServerPlugin[] preOperationModifyPlugins;
    private DirectoryServerPlugin[] preOperationModifyDNPlugins;
    private DirectoryServerPlugin[] preOperationSearchPlugins;
    private DirectoryServerPlugin[] postOperationAbandonPlugins;
    private DirectoryServerPlugin[] postOperationAddPlugins;
    private DirectoryServerPlugin[] postOperationBindPlugins;
    private DirectoryServerPlugin[] postOperationComparePlugins;
    private DirectoryServerPlugin[] postOperationDeletePlugins;
    private DirectoryServerPlugin[] postOperationExtendedPlugins;
    private DirectoryServerPlugin[] postOperationModifyPlugins;
    private DirectoryServerPlugin[] postOperationModifyDNPlugins;
    private DirectoryServerPlugin[] postOperationSearchPlugins;
    private DirectoryServerPlugin[] postOperationUnbindPlugins;
    private DirectoryServerPlugin[] postResponseAddPlugins;
    private DirectoryServerPlugin[] postResponseBindPlugins;
    private DirectoryServerPlugin[] postResponseComparePlugins;
    private DirectoryServerPlugin[] postResponseDeletePlugins;
    private DirectoryServerPlugin[] postResponseExtendedPlugins;
    private DirectoryServerPlugin[] postResponseModifyPlugins;
    private DirectoryServerPlugin[] postResponseModifyDNPlugins;
    private DirectoryServerPlugin[] postResponseSearchPlugins;
    private DirectoryServerPlugin[] searchResultEntryPlugins;
    private DirectoryServerPlugin[] searchResultReferencePlugins;
    private DirectoryServerPlugin[] intermediateResponsePlugins;
    private ConcurrentHashMap<DN, DirectoryServerPlugin> registeredPlugins;
    private ReentrantLock pluginLock;

    public PluginConfigManager() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.pluginLock = new ReentrantLock();
        this.startupPlugins = new DirectoryServerPlugin[0];
        this.shutdownPlugins = new DirectoryServerPlugin[0];
        this.postConnectPlugins = new DirectoryServerPlugin[0];
        this.postDisconnectPlugins = new DirectoryServerPlugin[0];
        this.ldifImportPlugins = new DirectoryServerPlugin[0];
        this.ldifExportPlugins = new DirectoryServerPlugin[0];
        this.preParseAbandonPlugins = new DirectoryServerPlugin[0];
        this.preParseAddPlugins = new DirectoryServerPlugin[0];
        this.preParseBindPlugins = new DirectoryServerPlugin[0];
        this.preParseComparePlugins = new DirectoryServerPlugin[0];
        this.preParseDeletePlugins = new DirectoryServerPlugin[0];
        this.preParseExtendedPlugins = new DirectoryServerPlugin[0];
        this.preParseModifyPlugins = new DirectoryServerPlugin[0];
        this.preParseModifyDNPlugins = new DirectoryServerPlugin[0];
        this.preParseSearchPlugins = new DirectoryServerPlugin[0];
        this.preParseUnbindPlugins = new DirectoryServerPlugin[0];
        this.preOperationAddPlugins = new DirectoryServerPlugin[0];
        this.preOperationBindPlugins = new DirectoryServerPlugin[0];
        this.preOperationComparePlugins = new DirectoryServerPlugin[0];
        this.preOperationDeletePlugins = new DirectoryServerPlugin[0];
        this.preOperationExtendedPlugins = new DirectoryServerPlugin[0];
        this.preOperationModifyPlugins = new DirectoryServerPlugin[0];
        this.preOperationModifyDNPlugins = new DirectoryServerPlugin[0];
        this.preOperationSearchPlugins = new DirectoryServerPlugin[0];
        this.postOperationAbandonPlugins = new DirectoryServerPlugin[0];
        this.postOperationAddPlugins = new DirectoryServerPlugin[0];
        this.postOperationBindPlugins = new DirectoryServerPlugin[0];
        this.postOperationComparePlugins = new DirectoryServerPlugin[0];
        this.postOperationDeletePlugins = new DirectoryServerPlugin[0];
        this.postOperationExtendedPlugins = new DirectoryServerPlugin[0];
        this.postOperationModifyPlugins = new DirectoryServerPlugin[0];
        this.postOperationModifyDNPlugins = new DirectoryServerPlugin[0];
        this.postOperationSearchPlugins = new DirectoryServerPlugin[0];
        this.postOperationUnbindPlugins = new DirectoryServerPlugin[0];
        this.postResponseAddPlugins = new DirectoryServerPlugin[0];
        this.postResponseBindPlugins = new DirectoryServerPlugin[0];
        this.postResponseComparePlugins = new DirectoryServerPlugin[0];
        this.postResponseDeletePlugins = new DirectoryServerPlugin[0];
        this.postResponseExtendedPlugins = new DirectoryServerPlugin[0];
        this.postResponseModifyPlugins = new DirectoryServerPlugin[0];
        this.postResponseModifyDNPlugins = new DirectoryServerPlugin[0];
        this.postResponseSearchPlugins = new DirectoryServerPlugin[0];
        this.searchResultEntryPlugins = new DirectoryServerPlugin[0];
        this.searchResultReferencePlugins = new DirectoryServerPlugin[0];
        this.intermediateResponsePlugins = new DirectoryServerPlugin[0];
    }

    public void initializePluginConfig(Set<PluginType> set) throws ConfigException, InitializationException {
        ConfigEntry configEntry;
        assert (Debug.debugEnter(CLASS_NAME, "initializePluginConfig", new String[0]));
        this.registeredPlugins = new ConcurrentHashMap();
        try {
            DN dN = DN.decode("cn=Plugins,cn=config");
            configEntry = DirectoryServer.getConfigEntry(dN);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializePluginConfig", exception));
            int n = 3408101;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new ConfigException(n, string, exception);
        }
        if (configEntry == null) {
            int n = 3408102;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        configEntry.registerAddListener(this);
        configEntry.registerDeleteListener(this);
        block14: for (ConfigEntry configEntry2 : configEntry.getChildren().values()) {
            DirectoryServerPlugin directoryServerPlugin;
            String string;
            Object object;
            Object object3;
            Object object4;
            int n;
            HashSet<PluginType> hashSet;
            DN dN;
            block34: {
                Object object5;
                block33: {
                    block32: {
                        int n2;
                        dN = configEntry2.getDN();
                        configEntry2.registerChangeListener(this);
                        try {
                            SearchFilter searchFilter = SearchFilter.createFilterFromString("(objectClass=ds-cfg-plugin)");
                            if (!searchFilter.matchesEntry(configEntry2.getEntry())) {
                                n2 = 3277031;
                                hashSet = MessageHandler.getMessage(n2, String.valueOf(dN));
                                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, (String)((Object)hashSet), n2);
                            }
                            break block32;
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "initializePluginConfig", exception));
                            n2 = 3408104;
                            hashSet = MessageHandler.getMessage(n2, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, (String)((Object)hashSet), n2);
                        }
                        continue;
                    }
                    n = 3145961;
                    BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-plugin-enabled", MessageHandler.getMessage(n), false);
                    try {
                        hashSet = (BooleanConfigAttribute)configEntry2.getConfigAttribute(booleanConfigAttribute);
                        if (hashSet == null) {
                            n = 3277034;
                            object5 = MessageHandler.getMessage(n, String.valueOf(dN));
                            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, (String)object5, n);
                            continue;
                        }
                        if (!((BooleanConfigAttribute)((Object)hashSet)).activeValue()) {
                            n = 3145963;
                            object5 = MessageHandler.getMessage(n, String.valueOf(dN));
                            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.INFORMATIONAL, (String)object5, n);
                        }
                        break block33;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "initializePluginConfig", exception));
                        n = 3408108;
                        object5 = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                        Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object5, n);
                    }
                    continue;
                }
                hashSet = new HashSet<PluginType>();
                n = 3145965;
                object5 = new MultiChoiceConfigAttribute("ds-cfg-plugin-type", MessageHandler.getMessage(n), true, true, true, PluginType.getPluginTypeNames());
                try {
                    object4 = (MultiChoiceConfigAttribute)configEntry2.getConfigAttribute((ConfigAttribute)object5);
                    if (object4 == null || ((MultiChoiceConfigAttribute)object4).activeValues().isEmpty()) {
                        n = 3408111;
                        object3 = MessageHandler.getMessage(n, String.valueOf(dN));
                        Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object3, n);
                        continue;
                    }
                    for (String exception : ((MultiChoiceConfigAttribute)object4).activeValues()) {
                        object = PluginType.forName(exception.toLowerCase());
                        if (object == null) {
                            n = 3408112;
                            string = MessageHandler.getMessage(n, String.valueOf(dN), exception);
                            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
                            continue block14;
                        }
                        if (set != null && !set.contains(object)) continue;
                        hashSet.add((PluginType)((Object)object));
                    }
                    if (hashSet.isEmpty()) {
                    }
                    break block34;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "initializePluginConfig", exception));
                    n = 3408113;
                    object3 = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object3, n);
                }
                continue;
            }
            n = 0x3000EE;
            object3 = new StringConfigAttribute("ds-cfg-plugin-class", MessageHandler.getMessage(n), true, false, true);
            try {
                StringConfigAttribute stringConfigAttribute = (StringConfigAttribute)configEntry2.getConfigAttribute((ConfigAttribute)object3);
                if (stringConfigAttribute == null) {
                    n = 3408114;
                    object = MessageHandler.getMessage(n, String.valueOf(dN));
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object, n);
                    continue;
                }
                object4 = stringConfigAttribute.activeValue();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePluginConfig", exception));
                n = 3408115;
                object = MessageHandler.getMessage(n, String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, (String)object, n);
                continue;
            }
            try {
                object = Class.forName((String)object4);
                directoryServerPlugin = (DirectoryServerPlugin)((Class)object).newInstance();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePluginConfig", exception));
                n = 3408116;
                string = MessageHandler.getMessage(n, String.valueOf(object4), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
                continue;
            }
            try {
                directoryServerPlugin.initializeInternal(dN, hashSet);
                directoryServerPlugin.initializePlugin(hashSet, configEntry2);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializePluginConfig", exception));
                n = 3408117;
                string = MessageHandler.getMessage(n, String.valueOf(object4), String.valueOf(dN), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
                continue;
            }
            this.registerPlugin(directoryServerPlugin, dN, hashSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalizePlugins() {
        this.pluginLock.lock();
        try {
            Iterator<DirectoryServerPlugin> iterator = this.registeredPlugins.values().iterator();
            while (iterator.hasNext()) {
                try {
                    iterator.next().finalizePlugin();
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "finalizePlugins", exception));
                }
            }
            this.registeredPlugins.clear();
        }
        finally {
            this.pluginLock.unlock();
        }
    }

    public ConcurrentHashMap<DN, DirectoryServerPlugin> getRegisteredPlugins() {
        assert (Debug.debugEnter(CLASS_NAME, "getRegisteredPlugins", new String[0]));
        return this.registeredPlugins;
    }

    public DirectoryServerPlugin getRegisteredPlugin(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "getRegisteredPlugin", String.valueOf(dN)));
        return this.registeredPlugins.get(dN);
    }

    @Override
    public boolean configChangeIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        ConfigAttribute configAttribute;
        Object object;
        StringConfigAttribute stringConfigAttribute;
        Object object2;
        assert (Debug.debugEnter(CLASS_NAME, "configChangeIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        if (!configEntry.hasObjectClass("ds-cfg-plugin")) {
            int n = 3277031;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
            stringBuilder.append(string);
            return false;
        }
        try {
            object2 = new StringConfigAttribute("ds-cfg-plugin-class", MessageHandler.getMessage(0x3000EE), true, false, true);
            stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object2);
            if (stringConfigAttribute == null) {
                int n = 3408114;
                String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
                stringBuilder.append(string);
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            int n = 3408115;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        try {
            object2 = Class.forName(stringConfigAttribute.pendingValue());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            int n = 3408115;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        try {
            object = (DirectoryServerPlugin)((Class)object2).newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            int n = 3408116;
            String string = MessageHandler.getMessage(n, ((Class)object2).getName(), String.valueOf(configEntry.getDN()), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        try {
            configAttribute = new BooleanConfigAttribute("ds-cfg-plugin-enabled", MessageHandler.getMessage(3145961), false);
            object = (BooleanConfigAttribute)configEntry.getConfigAttribute(configAttribute);
            if (object == null) {
                int n = 3277034;
                String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
                stringBuilder.append(string);
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            int n = 3408108;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        try {
            MultiChoiceConfigAttribute multiChoiceConfigAttribute = new MultiChoiceConfigAttribute("ds-cfg-plugin-type", MessageHandler.getMessage(3145965), true, true, true, PluginType.getPluginTypeNames());
            configAttribute = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute(multiChoiceConfigAttribute);
            if (configAttribute == null) {
                int n = 3408111;
                String string = MessageHandler.getMessage(n, String.valueOf(configEntry.getDN()));
                stringBuilder.append(string);
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            int n = 3408113;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        return true;
    }

    @Override
    public ConfigChangeResult applyConfigurationChange(ConfigEntry configEntry) {
        Object object;
        ConfigAttribute configAttribute;
        Object object2;
        Object object3;
        boolean bl;
        DirectoryServerPlugin directoryServerPlugin;
        ArrayList<String> arrayList;
        boolean bl2;
        ResultCode resultCode;
        DN dN;
        block28: {
            assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationChange", String.valueOf(configEntry)));
            dN = configEntry.getDN();
            resultCode = ResultCode.SUCCESS;
            bl2 = false;
            arrayList = new ArrayList<String>();
            if (!configEntry.hasObjectClass("ds-cfg-plugin")) {
                int n = 3277031;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.UNWILLING_TO_PERFORM;
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            directoryServerPlugin = this.registeredPlugins.get(dN);
            bl = false;
            try {
                object3 = new BooleanConfigAttribute("ds-cfg-plugin-enabled", MessageHandler.getMessage(3145961), false);
                BooleanConfigAttribute booleanConfigAttribute = (BooleanConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object3);
                if (booleanConfigAttribute == null) {
                    int n = 3277034;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                    resultCode = ResultCode.UNWILLING_TO_PERFORM;
                    return new ConfigChangeResult(resultCode, bl2, arrayList);
                }
                if (booleanConfigAttribute.activeValue()) {
                    if (directoryServerPlugin == null) {
                        bl = true;
                    }
                    break block28;
                }
                if (directoryServerPlugin == null) {
                    return new ConfigChangeResult(resultCode, bl2, arrayList);
                }
                this.deregisterPlugin(dN);
                directoryServerPlugin.finalizePlugin();
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                int n = 3408108;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
        }
        object3 = new HashSet();
        try {
            object2 = new MultiChoiceConfigAttribute("ds-cfg-plugin-type", MessageHandler.getMessage(3145965), true, true, true, PluginType.getPluginTypeNames());
            configAttribute = (MultiChoiceConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object2);
            if (configAttribute == null) {
                int n = 3408111;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            for (String object4 : configAttribute.activeValues()) {
                PluginType n = PluginType.forName(object4.toLowerCase());
                if (n == null) {
                    int n2 = 3408112;
                    arrayList.add(MessageHandler.getMessage(n2, String.valueOf(dN), object4));
                    resultCode = ResultCode.INVALID_ATTRIBUTE_SYNTAX;
                    return new ConfigChangeResult(resultCode, bl2, arrayList);
                }
                ((HashSet)object3).add(n);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
            int n = 3408113;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl2, arrayList);
        }
        try {
            configAttribute = new StringConfigAttribute("ds-cfg-plugin-class", MessageHandler.getMessage(0x3000EE), true, false, true);
            object = (StringConfigAttribute)configEntry.getConfigAttribute(configAttribute);
            if (object == null) {
                int n = 3408114;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            object2 = ((StringConfigAttribute)object).pendingValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
            int n = 3408115;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl2, arrayList);
        }
        boolean bl3 = false;
        object = null;
        if (directoryServerPlugin != null) {
            object = directoryServerPlugin.getClass().getName();
            boolean bl4 = bl3 = !((String)object2).equals(object);
        }
        if (bl3) {
            bl2 = true;
            arrayList.add(MessageHandler.getMessage(3146107, String.valueOf(object), String.valueOf(object2), String.valueOf(dN)));
            return new ConfigChangeResult(resultCode, bl2, arrayList);
        }
        if (bl) {
            try {
                Class<?> exception = Class.forName((String)object2);
                directoryServerPlugin = (DirectoryServerPlugin)exception.newInstance();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                int n = 3408116;
                arrayList.add(MessageHandler.getMessage(n, object2, String.valueOf(dN), String.valueOf(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            try {
                directoryServerPlugin.initializeInternal(dN, (Set<PluginType>)object3);
                directoryServerPlugin.initializePlugin((Set<PluginType>)object3, configEntry);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                int n = 3408117;
                arrayList.add(MessageHandler.getMessage(n, object2, String.valueOf(dN), String.valueOf(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            this.registerPlugin(directoryServerPlugin, dN, (HashSet<PluginType>)object3);
            return new ConfigChangeResult(resultCode, bl2, arrayList);
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }

    @Override
    public boolean configAddIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "configAddIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        return false;
    }

    @Override
    public ConfigChangeResult applyConfigurationAdd(ConfigEntry configEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationAdd", String.valueOf(configEntry)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        return new ConfigChangeResult(resultCode, bl, arrayList);
    }

    @Override
    public boolean configDeleteIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "configDeleteIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        return false;
    }

    @Override
    public ConfigChangeResult applyConfigurationDelete(ConfigEntry configEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationDelete", String.valueOf(configEntry)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        return new ConfigChangeResult(resultCode, bl, arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerPlugin(DirectoryServerPlugin directoryServerPlugin, DN dN, HashSet<PluginType> hashSet) {
        assert (Debug.debugEnter(CLASS_NAME, "registerPlugin", String.valueOf(directoryServerPlugin), String.valueOf(hashSet)));
        this.pluginLock.lock();
        try {
            this.registeredPlugins.put(dN, directoryServerPlugin);
            for (PluginType pluginType : hashSet) {
                switch (pluginType) {
                    case STARTUP: {
                        this.startupPlugins = this.addPlugin(this.startupPlugins, directoryServerPlugin);
                        break;
                    }
                    case SHUTDOWN: {
                        this.shutdownPlugins = this.addPlugin(this.shutdownPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_CONNECT: {
                        this.postConnectPlugins = this.addPlugin(this.postConnectPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_DISCONNECT: {
                        this.postDisconnectPlugins = this.addPlugin(this.postDisconnectPlugins, directoryServerPlugin);
                        break;
                    }
                    case LDIF_IMPORT: {
                        this.ldifImportPlugins = this.addPlugin(this.ldifImportPlugins, directoryServerPlugin);
                        break;
                    }
                    case LDIF_EXPORT: {
                        this.ldifExportPlugins = this.addPlugin(this.ldifExportPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_PARSE_ABANDON: {
                        this.preParseAbandonPlugins = this.addPlugin(this.preParseAbandonPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_PARSE_ADD: {
                        this.preParseAddPlugins = this.addPlugin(this.preParseAddPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_PARSE_BIND: {
                        this.preParseBindPlugins = this.addPlugin(this.preParseBindPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_PARSE_COMPARE: {
                        this.preParseComparePlugins = this.addPlugin(this.preParseComparePlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_PARSE_DELETE: {
                        this.preParseDeletePlugins = this.addPlugin(this.preParseDeletePlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_PARSE_EXTENDED: {
                        this.preParseExtendedPlugins = this.addPlugin(this.preParseExtendedPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_PARSE_MODIFY: {
                        this.preParseModifyPlugins = this.addPlugin(this.preParseModifyPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_PARSE_MODIFY_DN: {
                        this.preParseModifyDNPlugins = this.addPlugin(this.preParseModifyDNPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_PARSE_SEARCH: {
                        this.preParseSearchPlugins = this.addPlugin(this.preParseSearchPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_PARSE_UNBIND: {
                        this.preParseUnbindPlugins = this.addPlugin(this.preParseUnbindPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_OPERATION_ADD: {
                        this.preOperationAddPlugins = this.addPlugin(this.preOperationAddPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_OPERATION_BIND: {
                        this.preOperationBindPlugins = this.addPlugin(this.preOperationBindPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_OPERATION_COMPARE: {
                        this.preOperationComparePlugins = this.addPlugin(this.preOperationComparePlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_OPERATION_DELETE: {
                        this.preOperationDeletePlugins = this.addPlugin(this.preOperationDeletePlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_OPERATION_EXTENDED: {
                        this.preOperationExtendedPlugins = this.addPlugin(this.preOperationExtendedPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_OPERATION_MODIFY: {
                        this.preOperationModifyPlugins = this.addPlugin(this.preOperationModifyPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_OPERATION_MODIFY_DN: {
                        this.preOperationModifyDNPlugins = this.addPlugin(this.preOperationModifyDNPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_OPERATION_SEARCH: {
                        this.preOperationSearchPlugins = this.addPlugin(this.preOperationSearchPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_OPERATION_ABANDON: {
                        this.postOperationAbandonPlugins = this.addPlugin(this.postOperationAbandonPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_OPERATION_ADD: {
                        this.postOperationAddPlugins = this.addPlugin(this.postOperationAddPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_OPERATION_BIND: {
                        this.postOperationBindPlugins = this.addPlugin(this.postOperationBindPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_OPERATION_COMPARE: {
                        this.postOperationComparePlugins = this.addPlugin(this.postOperationComparePlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_OPERATION_DELETE: {
                        this.postOperationDeletePlugins = this.addPlugin(this.postOperationDeletePlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_OPERATION_EXTENDED: {
                        this.postOperationExtendedPlugins = this.addPlugin(this.postOperationExtendedPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_OPERATION_MODIFY: {
                        this.postOperationModifyPlugins = this.addPlugin(this.postOperationModifyPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_OPERATION_MODIFY_DN: {
                        this.postOperationModifyDNPlugins = this.addPlugin(this.postOperationModifyDNPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_OPERATION_SEARCH: {
                        this.postOperationSearchPlugins = this.addPlugin(this.postOperationSearchPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_OPERATION_UNBIND: {
                        this.postOperationUnbindPlugins = this.addPlugin(this.postOperationUnbindPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_RESPONSE_ADD: {
                        this.postResponseAddPlugins = this.addPlugin(this.postResponseAddPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_RESPONSE_BIND: {
                        this.postResponseBindPlugins = this.addPlugin(this.postResponseBindPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_RESPONSE_COMPARE: {
                        this.postResponseComparePlugins = this.addPlugin(this.postResponseComparePlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_RESPONSE_DELETE: {
                        this.postResponseDeletePlugins = this.addPlugin(this.postResponseDeletePlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_RESPONSE_EXTENDED: {
                        this.postResponseExtendedPlugins = this.addPlugin(this.postResponseExtendedPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_RESPONSE_MODIFY: {
                        this.postResponseModifyPlugins = this.addPlugin(this.postResponseModifyPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_RESPONSE_MODIFY_DN: {
                        this.postResponseModifyDNPlugins = this.addPlugin(this.postResponseModifyDNPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_RESPONSE_SEARCH: {
                        this.postResponseSearchPlugins = this.addPlugin(this.postResponseSearchPlugins, directoryServerPlugin);
                        break;
                    }
                    case SEARCH_RESULT_ENTRY: {
                        this.searchResultEntryPlugins = this.addPlugin(this.searchResultEntryPlugins, directoryServerPlugin);
                        break;
                    }
                    case SEARCH_RESULT_REFERENCE: {
                        this.searchResultReferencePlugins = this.addPlugin(this.searchResultReferencePlugins, directoryServerPlugin);
                        break;
                    }
                    case INTERMEDIATE_RESPONSE: {
                        this.intermediateResponsePlugins = this.addPlugin(this.intermediateResponsePlugins, directoryServerPlugin);
                        break;
                    }
                }
            }
        }
        finally {
            this.pluginLock.unlock();
        }
    }

    private DirectoryServerPlugin[] addPlugin(DirectoryServerPlugin[] directoryServerPluginArray, DirectoryServerPlugin directoryServerPlugin) {
        assert (Debug.debugEnter(CLASS_NAME, "addPlugin", String.valueOf(directoryServerPluginArray), String.valueOf(directoryServerPlugin)));
        DirectoryServerPlugin[] directoryServerPluginArray2 = new DirectoryServerPlugin[directoryServerPluginArray.length + 1];
        System.arraycopy(directoryServerPluginArray, 0, directoryServerPluginArray2, 0, directoryServerPluginArray.length);
        directoryServerPluginArray2[directoryServerPluginArray.length] = directoryServerPlugin;
        return directoryServerPluginArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deregisterPlugin(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterPlugin", String.valueOf(dN)));
        this.pluginLock.lock();
        try {
            DirectoryServerPlugin directoryServerPlugin = this.registeredPlugins.remove(dN);
            if (directoryServerPlugin == null) {
                return;
            }
            for (PluginType pluginType : directoryServerPlugin.getPluginTypes()) {
                switch (pluginType) {
                    case STARTUP: {
                        this.startupPlugins = this.removePlugin(this.startupPlugins, directoryServerPlugin);
                        break;
                    }
                    case SHUTDOWN: {
                        this.shutdownPlugins = this.removePlugin(this.shutdownPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_CONNECT: {
                        this.postConnectPlugins = this.removePlugin(this.postConnectPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_DISCONNECT: {
                        this.postDisconnectPlugins = this.removePlugin(this.postDisconnectPlugins, directoryServerPlugin);
                        break;
                    }
                    case LDIF_IMPORT: {
                        this.ldifImportPlugins = this.removePlugin(this.ldifImportPlugins, directoryServerPlugin);
                        break;
                    }
                    case LDIF_EXPORT: {
                        this.ldifExportPlugins = this.removePlugin(this.ldifExportPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_PARSE_ABANDON: {
                        this.preParseAbandonPlugins = this.removePlugin(this.preParseAbandonPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_PARSE_ADD: {
                        this.preParseAddPlugins = this.removePlugin(this.preParseAddPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_PARSE_BIND: {
                        this.preParseBindPlugins = this.removePlugin(this.preParseBindPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_PARSE_COMPARE: {
                        this.preParseComparePlugins = this.removePlugin(this.preParseComparePlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_PARSE_DELETE: {
                        this.preParseDeletePlugins = this.removePlugin(this.preParseDeletePlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_PARSE_EXTENDED: {
                        this.preParseExtendedPlugins = this.removePlugin(this.preParseExtendedPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_PARSE_MODIFY: {
                        this.preParseModifyPlugins = this.removePlugin(this.preParseModifyPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_PARSE_MODIFY_DN: {
                        this.preParseModifyDNPlugins = this.removePlugin(this.preParseModifyDNPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_PARSE_SEARCH: {
                        this.preParseSearchPlugins = this.removePlugin(this.preParseSearchPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_PARSE_UNBIND: {
                        this.preParseUnbindPlugins = this.removePlugin(this.preParseUnbindPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_OPERATION_ADD: {
                        this.preOperationAddPlugins = this.removePlugin(this.preOperationAddPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_OPERATION_BIND: {
                        this.preOperationBindPlugins = this.removePlugin(this.preOperationBindPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_OPERATION_COMPARE: {
                        this.preOperationComparePlugins = this.removePlugin(this.preOperationComparePlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_OPERATION_DELETE: {
                        this.preOperationDeletePlugins = this.removePlugin(this.preOperationDeletePlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_OPERATION_EXTENDED: {
                        this.preOperationExtendedPlugins = this.removePlugin(this.preOperationExtendedPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_OPERATION_MODIFY: {
                        this.preOperationModifyPlugins = this.removePlugin(this.preOperationModifyPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_OPERATION_MODIFY_DN: {
                        this.preOperationModifyDNPlugins = this.removePlugin(this.preOperationModifyDNPlugins, directoryServerPlugin);
                        break;
                    }
                    case PRE_OPERATION_SEARCH: {
                        this.preOperationSearchPlugins = this.removePlugin(this.preOperationSearchPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_OPERATION_ABANDON: {
                        this.postOperationAbandonPlugins = this.removePlugin(this.postOperationAbandonPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_OPERATION_ADD: {
                        this.postOperationAddPlugins = this.removePlugin(this.postOperationAddPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_OPERATION_BIND: {
                        this.postOperationBindPlugins = this.removePlugin(this.postOperationBindPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_OPERATION_COMPARE: {
                        this.postOperationComparePlugins = this.removePlugin(this.postOperationComparePlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_OPERATION_DELETE: {
                        this.postOperationDeletePlugins = this.removePlugin(this.postOperationDeletePlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_OPERATION_EXTENDED: {
                        this.postOperationExtendedPlugins = this.removePlugin(this.postOperationExtendedPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_OPERATION_MODIFY: {
                        this.postOperationModifyPlugins = this.removePlugin(this.postOperationModifyPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_OPERATION_MODIFY_DN: {
                        this.postOperationModifyDNPlugins = this.removePlugin(this.postOperationModifyDNPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_OPERATION_SEARCH: {
                        this.postOperationSearchPlugins = this.removePlugin(this.postOperationSearchPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_OPERATION_UNBIND: {
                        this.postOperationUnbindPlugins = this.removePlugin(this.postOperationUnbindPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_RESPONSE_ADD: {
                        this.postResponseAddPlugins = this.removePlugin(this.postResponseAddPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_RESPONSE_BIND: {
                        this.postResponseBindPlugins = this.removePlugin(this.postResponseBindPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_RESPONSE_COMPARE: {
                        this.postResponseComparePlugins = this.removePlugin(this.postResponseComparePlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_RESPONSE_DELETE: {
                        this.postResponseDeletePlugins = this.removePlugin(this.postResponseDeletePlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_RESPONSE_EXTENDED: {
                        this.postResponseExtendedPlugins = this.removePlugin(this.postResponseExtendedPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_RESPONSE_MODIFY: {
                        this.postResponseModifyPlugins = this.removePlugin(this.postResponseModifyPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_RESPONSE_MODIFY_DN: {
                        this.postResponseModifyDNPlugins = this.removePlugin(this.postResponseModifyDNPlugins, directoryServerPlugin);
                        break;
                    }
                    case POST_RESPONSE_SEARCH: {
                        this.postResponseSearchPlugins = this.removePlugin(this.postResponseSearchPlugins, directoryServerPlugin);
                        break;
                    }
                    case SEARCH_RESULT_ENTRY: {
                        this.searchResultEntryPlugins = this.removePlugin(this.searchResultEntryPlugins, directoryServerPlugin);
                        break;
                    }
                    case SEARCH_RESULT_REFERENCE: {
                        this.searchResultReferencePlugins = this.removePlugin(this.searchResultReferencePlugins, directoryServerPlugin);
                        break;
                    }
                    case INTERMEDIATE_RESPONSE: {
                        this.intermediateResponsePlugins = this.removePlugin(this.intermediateResponsePlugins, directoryServerPlugin);
                        break;
                    }
                }
            }
        }
        finally {
            this.pluginLock.unlock();
        }
    }

    private DirectoryServerPlugin[] removePlugin(DirectoryServerPlugin[] directoryServerPluginArray, DirectoryServerPlugin directoryServerPlugin) {
        assert (Debug.debugEnter(CLASS_NAME, "addPlugin", String.valueOf(directoryServerPluginArray), String.valueOf(directoryServerPlugin)));
        int n = -1;
        int n2 = directoryServerPluginArray.length;
        for (int i = 0; i < n2; ++i) {
            if (!directoryServerPluginArray[i].getPluginEntryDN().equals(directoryServerPlugin.getPluginEntryDN())) continue;
            n = i;
            break;
        }
        if (n < 0) {
            return directoryServerPluginArray;
        }
        if (n2 == 0) {
            return new DirectoryServerPlugin[0];
        }
        DirectoryServerPlugin[] directoryServerPluginArray2 = new DirectoryServerPlugin[n2 - 1];
        if (n > 0) {
            System.arraycopy(directoryServerPluginArray, 0, directoryServerPluginArray2, 0, n);
        }
        if (n < n2 - 1) {
            System.arraycopy(directoryServerPluginArray, n + 1, directoryServerPluginArray2, n, n2 - n - 1);
        }
        return directoryServerPluginArray2;
    }

    public StartupPluginResult invokeStartupPlugins() {
        assert (Debug.debugEnter(CLASS_NAME, "invokeStartupPlugins", new String[0]));
        StartupPluginResult startupPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.startupPlugins) {
            String string;
            int n;
            try {
                startupPluginResult = directoryServerPlugin.doStartup();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokeStartupPlugins", exception));
                int n2 = 7667742;
                String string2 = MessageHandler.getMessage(n2, String.valueOf(directoryServerPlugin.getPluginEntryDN()), StaticUtils.stackTraceToSingleLineString(exception));
                startupPluginResult = new StartupPluginResult(false, false, n2, string2);
                break;
            }
            if (startupPluginResult == null) {
                n = 7667743;
                string = MessageHandler.getMessage(n, String.valueOf(directoryServerPlugin.getPluginEntryDN()));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.FATAL_ERROR, string, n);
                return new StartupPluginResult(false, false, n, string);
            }
            if (startupPluginResult.completedSuccessfully()) continue;
            if (startupPluginResult.continueStartup()) {
                n = 7602208;
                string = MessageHandler.getMessage(n, String.valueOf(directoryServerPlugin.getPluginEntryDN()), startupPluginResult.getErrorMessage(), startupPluginResult.getErrorID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                continue;
            }
            n = 7667745;
            string = MessageHandler.getMessage(n, String.valueOf(directoryServerPlugin.getPluginEntryDN()), startupPluginResult.getErrorMessage(), startupPluginResult.getErrorID());
            Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.FATAL_ERROR, string, n);
            return startupPluginResult;
        }
        if (startupPluginResult == null) {
            startupPluginResult = StartupPluginResult.SUCCESS;
        }
        return startupPluginResult;
    }

    public void invokeShutdownPlugins() {
        assert (Debug.debugEnter(CLASS_NAME, "invokeShutdownPlugins", new String[0]));
        for (DirectoryServerPlugin directoryServerPlugin : this.shutdownPlugins) {
            try {
                directoryServerPlugin.doShutdown();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokeShutdownPlugins", exception));
                int n = 7602210;
                String string = MessageHandler.getMessage(n, String.valueOf(directoryServerPlugin.getPluginEntryDN()), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
            }
        }
    }

    public PostConnectPluginResult invokePostConnectPlugins(ClientConnection clientConnection) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePostConnectPlugins", String.valueOf(clientConnection)));
        PostConnectPluginResult postConnectPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.postConnectPlugins) {
            try {
                postConnectPluginResult = directoryServerPlugin.doPostConnect(clientConnection);
            }
            catch (Exception exception) {
                block11: {
                    assert (Debug.debugException(CLASS_NAME, "invokePostConnectPlugins", exception));
                    int n = 7602211;
                    String string = MessageHandler.getMessage(n, String.valueOf(directoryServerPlugin.getPluginEntryDN()), clientConnection.getConnectionID(), clientConnection.getClientAddress(), StaticUtils.stackTraceToSingleLineString(exception));
                    Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                    try {
                        clientConnection.disconnect(DisconnectReason.SERVER_ERROR, true, string, n);
                    }
                    catch (Exception exception2) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "invokePostConnectPlugins", exception2)) break block11;
                        throw new AssertionError();
                    }
                }
                return new PostConnectPluginResult(true, false);
            }
            if (postConnectPluginResult == null) {
                block12: {
                    int n = 7602212;
                    String string = MessageHandler.getMessage(n, String.valueOf(directoryServerPlugin.getPluginEntryDN()), clientConnection.getConnectionID(), clientConnection.getClientAddress());
                    Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                    try {
                        clientConnection.disconnect(DisconnectReason.SERVER_ERROR, true, string, n);
                    }
                    catch (Exception exception) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "invokePostConnectPlugins", exception)) break block12;
                        throw new AssertionError();
                    }
                }
                return new PostConnectPluginResult(true, false);
            }
            if (!postConnectPluginResult.connectionTerminated() && postConnectPluginResult.continuePluginProcessing()) continue;
            return postConnectPluginResult;
        }
        if (postConnectPluginResult == null) {
            postConnectPluginResult = PostConnectPluginResult.SUCCESS;
        }
        return postConnectPluginResult;
    }

    public PostDisconnectPluginResult invokePostDisconnectPlugins(ClientConnection clientConnection, DisconnectReason disconnectReason, int n, String string) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePostConnectPlugins", String.valueOf(clientConnection)));
        PostDisconnectPluginResult postDisconnectPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.postDisconnectPlugins) {
            try {
                postDisconnectPluginResult = directoryServerPlugin.doPostDisconnect(clientConnection, disconnectReason, n, string);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePostDisconnectPlugins", exception));
                int n2 = 7602213;
                String string2 = MessageHandler.getMessage(n2, String.valueOf(directoryServerPlugin.getPluginEntryDN()), clientConnection.getConnectionID(), clientConnection.getClientAddress(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string2, n2);
                return new PostDisconnectPluginResult(false);
            }
            if (postDisconnectPluginResult == null) {
                int n3 = 7602214;
                String string3 = MessageHandler.getMessage(n3, String.valueOf(directoryServerPlugin.getPluginEntryDN()), clientConnection.getConnectionID(), clientConnection.getClientAddress());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string3, n3);
                return new PostDisconnectPluginResult(false);
            }
            if (postDisconnectPluginResult.continuePluginProcessing()) continue;
            return postDisconnectPluginResult;
        }
        if (postDisconnectPluginResult == null) {
            postDisconnectPluginResult = PostDisconnectPluginResult.SUCCESS;
        }
        return postDisconnectPluginResult;
    }

    public LDIFPluginResult invokeLDIFImportPlugins(LDIFImportConfig lDIFImportConfig, Entry entry) {
        assert (Debug.debugEnter(CLASS_NAME, "invokeLDIFImportPlugins", String.valueOf(lDIFImportConfig), String.valueOf(entry)));
        LDIFPluginResult lDIFPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.ldifImportPlugins) {
            try {
                lDIFPluginResult = directoryServerPlugin.doLDIFImport(lDIFImportConfig, entry);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokeLDIFImportPlugins", exception));
                int n = 7602234;
                String string = MessageHandler.getMessage(n, String.valueOf(directoryServerPlugin.getPluginEntryDN()), String.valueOf(entry.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new LDIFPluginResult(false, false);
            }
            if (lDIFPluginResult == null) {
                int n = 7602235;
                String string = MessageHandler.getMessage(n, String.valueOf(directoryServerPlugin.getPluginEntryDN()), String.valueOf(entry.getDN()));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new LDIFPluginResult(false, false);
            }
            if (lDIFPluginResult.continuePluginProcessing()) continue;
            return lDIFPluginResult;
        }
        if (lDIFPluginResult == null) {
            lDIFPluginResult = LDIFPluginResult.SUCCESS;
        }
        return lDIFPluginResult;
    }

    public LDIFPluginResult invokeLDIFExportPlugins(LDIFExportConfig lDIFExportConfig, Entry entry) {
        assert (Debug.debugEnter(CLASS_NAME, "invokeLDIFExportPlugins", String.valueOf(lDIFExportConfig), String.valueOf(entry)));
        LDIFPluginResult lDIFPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.ldifExportPlugins) {
            try {
                lDIFPluginResult = directoryServerPlugin.doLDIFExport(lDIFExportConfig, entry);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokeLDIFExportPlugins", exception));
                int n = 7602236;
                String string = MessageHandler.getMessage(n, String.valueOf(directoryServerPlugin.getPluginEntryDN()), String.valueOf(entry.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new LDIFPluginResult(false, false);
            }
            if (lDIFPluginResult == null) {
                int n = 7602237;
                String string = MessageHandler.getMessage(n, String.valueOf(directoryServerPlugin.getPluginEntryDN()), String.valueOf(entry.getDN()));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new LDIFPluginResult(false, false);
            }
            if (lDIFPluginResult.continuePluginProcessing()) continue;
            return lDIFPluginResult;
        }
        if (lDIFPluginResult == null) {
            lDIFPluginResult = LDIFPluginResult.SUCCESS;
        }
        return lDIFPluginResult;
    }

    public PreParsePluginResult invokePreParseAbandonPlugins(AbandonOperation abandonOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePreParseAbandonPlugins", String.valueOf(abandonOperation)));
        PreParsePluginResult preParsePluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.preParseAbandonPlugins) {
            try {
                preParsePluginResult = directoryServerPlugin.doPreParse(abandonOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePreParseAbandonPlugins", exception));
                int n = 7602215;
                String string = MessageHandler.getMessage(n, abandonOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), abandonOperation.getConnectionID(), abandonOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                abandonOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                abandonOperation.appendErrorMessage(string);
                return new PreParsePluginResult(false, false, true);
            }
            if (preParsePluginResult == null) {
                int n = 7602216;
                String string = MessageHandler.getMessage(n, abandonOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), abandonOperation.getConnectionID(), abandonOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                abandonOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                abandonOperation.appendErrorMessage(string);
                return new PreParsePluginResult(false, false, true);
            }
            if (!preParsePluginResult.connectionTerminated() && preParsePluginResult.continuePluginProcessing()) continue;
            return preParsePluginResult;
        }
        if (preParsePluginResult == null) {
            preParsePluginResult = PreParsePluginResult.SUCCESS;
        }
        return preParsePluginResult;
    }

    public PreParsePluginResult invokePreParseAddPlugins(AddOperation addOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePreParseAddPlugins", String.valueOf(addOperation)));
        PreParsePluginResult preParsePluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.preParseAddPlugins) {
            try {
                preParsePluginResult = directoryServerPlugin.doPreParse(addOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePreParseAddPlugins", exception));
                int n = 7602215;
                String string = MessageHandler.getMessage(n, addOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), addOperation.getConnectionID(), addOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                addOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                addOperation.appendErrorMessage(string);
                return new PreParsePluginResult(false, false, true);
            }
            if (preParsePluginResult == null) {
                int n = 7602216;
                String string = MessageHandler.getMessage(n, addOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), addOperation.getConnectionID(), addOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                addOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                addOperation.appendErrorMessage(string);
                return new PreParsePluginResult(false, false, true);
            }
            if (!preParsePluginResult.connectionTerminated() && preParsePluginResult.continuePluginProcessing()) continue;
            return preParsePluginResult;
        }
        if (preParsePluginResult == null) {
            preParsePluginResult = PreParsePluginResult.SUCCESS;
        }
        return preParsePluginResult;
    }

    public PreParsePluginResult invokePreParseBindPlugins(BindOperation bindOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePreParseBindPlugins", String.valueOf(bindOperation)));
        PreParsePluginResult preParsePluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.preParseBindPlugins) {
            try {
                preParsePluginResult = directoryServerPlugin.doPreParse(bindOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePreParseBindPlugins", exception));
                int n = 7602215;
                String string = MessageHandler.getMessage(n, bindOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), bindOperation.getConnectionID(), bindOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                bindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                bindOperation.appendErrorMessage(string);
                return new PreParsePluginResult(false, false, true);
            }
            if (preParsePluginResult == null) {
                int n = 7602216;
                String string = MessageHandler.getMessage(n, bindOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), bindOperation.getConnectionID(), bindOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                bindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                bindOperation.appendErrorMessage(string);
                return new PreParsePluginResult(false, false, true);
            }
            if (!preParsePluginResult.connectionTerminated() && preParsePluginResult.continuePluginProcessing()) continue;
            return preParsePluginResult;
        }
        if (preParsePluginResult == null) {
            preParsePluginResult = PreParsePluginResult.SUCCESS;
        }
        return preParsePluginResult;
    }

    public PreParsePluginResult invokePreParseComparePlugins(CompareOperation compareOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePreParseComparePlugins", String.valueOf(compareOperation)));
        PreParsePluginResult preParsePluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.preParseComparePlugins) {
            try {
                preParsePluginResult = directoryServerPlugin.doPreParse(compareOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePreParseComparePlugins", exception));
                int n = 7602215;
                String string = MessageHandler.getMessage(n, compareOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), compareOperation.getConnectionID(), compareOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                compareOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                compareOperation.appendErrorMessage(string);
                return new PreParsePluginResult(false, false, true);
            }
            if (preParsePluginResult == null) {
                int n = 7602216;
                String string = MessageHandler.getMessage(n, compareOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), compareOperation.getConnectionID(), compareOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                compareOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                compareOperation.appendErrorMessage(string);
                return new PreParsePluginResult(false, false, true);
            }
            if (!preParsePluginResult.connectionTerminated() && preParsePluginResult.continuePluginProcessing()) continue;
            return preParsePluginResult;
        }
        if (preParsePluginResult == null) {
            preParsePluginResult = PreParsePluginResult.SUCCESS;
        }
        return preParsePluginResult;
    }

    public PreParsePluginResult invokePreParseDeletePlugins(DeleteOperation deleteOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePreParseDeletePlugins", String.valueOf(deleteOperation)));
        PreParsePluginResult preParsePluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.preParseDeletePlugins) {
            try {
                preParsePluginResult = directoryServerPlugin.doPreParse(deleteOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePreParseDeletePlugins", exception));
                int n = 7602215;
                String string = MessageHandler.getMessage(n, deleteOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), deleteOperation.getConnectionID(), deleteOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                deleteOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                deleteOperation.appendErrorMessage(string);
                return new PreParsePluginResult(false, false, true);
            }
            if (preParsePluginResult == null) {
                int n = 7602216;
                String string = MessageHandler.getMessage(n, deleteOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), deleteOperation.getConnectionID(), deleteOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                deleteOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                deleteOperation.appendErrorMessage(string);
                return new PreParsePluginResult(false, false, true);
            }
            if (!preParsePluginResult.connectionTerminated() && preParsePluginResult.continuePluginProcessing()) continue;
            return preParsePluginResult;
        }
        if (preParsePluginResult == null) {
            preParsePluginResult = PreParsePluginResult.SUCCESS;
        }
        return preParsePluginResult;
    }

    public PreParsePluginResult invokePreParseExtendedPlugins(ExtendedOperation extendedOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePreParseExtendedPlugins", String.valueOf(extendedOperation)));
        PreParsePluginResult preParsePluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.preParseExtendedPlugins) {
            try {
                preParsePluginResult = directoryServerPlugin.doPreParse(extendedOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePreParseExtendedPlugins", exception));
                int n = 7602215;
                String string = MessageHandler.getMessage(n, extendedOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), extendedOperation.getConnectionID(), extendedOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                extendedOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                extendedOperation.appendErrorMessage(string);
                return new PreParsePluginResult(false, false, true);
            }
            if (preParsePluginResult == null) {
                int n = 7602216;
                String string = MessageHandler.getMessage(n, extendedOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), extendedOperation.getConnectionID(), extendedOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                extendedOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                extendedOperation.appendErrorMessage(string);
                return new PreParsePluginResult(false, false, true);
            }
            if (!preParsePluginResult.connectionTerminated() && preParsePluginResult.continuePluginProcessing()) continue;
            return preParsePluginResult;
        }
        if (preParsePluginResult == null) {
            preParsePluginResult = PreParsePluginResult.SUCCESS;
        }
        return preParsePluginResult;
    }

    public PreParsePluginResult invokePreParseModifyPlugins(ModifyOperation modifyOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePreParseModifyPlugins", String.valueOf(modifyOperation)));
        PreParsePluginResult preParsePluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.preParseModifyPlugins) {
            try {
                preParsePluginResult = directoryServerPlugin.doPreParse(modifyOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePreParseModifyPlugins", exception));
                int n = 7602215;
                String string = MessageHandler.getMessage(n, modifyOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), modifyOperation.getConnectionID(), modifyOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                modifyOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                modifyOperation.appendErrorMessage(string);
                return new PreParsePluginResult(false, false, true);
            }
            if (preParsePluginResult == null) {
                int n = 7602216;
                String string = MessageHandler.getMessage(n, modifyOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), modifyOperation.getConnectionID(), modifyOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                modifyOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                modifyOperation.appendErrorMessage(string);
                return new PreParsePluginResult(false, false, true);
            }
            if (!preParsePluginResult.connectionTerminated() && preParsePluginResult.continuePluginProcessing()) continue;
            return preParsePluginResult;
        }
        if (preParsePluginResult == null) {
            preParsePluginResult = PreParsePluginResult.SUCCESS;
        }
        return preParsePluginResult;
    }

    public PreParsePluginResult invokePreParseModifyDNPlugins(ModifyDNOperation modifyDNOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePreParseModifyDNPlugins", String.valueOf(modifyDNOperation)));
        PreParsePluginResult preParsePluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.preParseModifyDNPlugins) {
            try {
                preParsePluginResult = directoryServerPlugin.doPreParse(modifyDNOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePreParseModifyDNPlugins", exception));
                int n = 7602215;
                String string = MessageHandler.getMessage(n, modifyDNOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), modifyDNOperation.getConnectionID(), modifyDNOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                modifyDNOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                modifyDNOperation.appendErrorMessage(string);
                return new PreParsePluginResult(false, false, true);
            }
            if (preParsePluginResult == null) {
                int n = 7602216;
                String string = MessageHandler.getMessage(n, modifyDNOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), modifyDNOperation.getConnectionID(), modifyDNOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                modifyDNOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                modifyDNOperation.appendErrorMessage(string);
                return new PreParsePluginResult(false, false, true);
            }
            if (!preParsePluginResult.connectionTerminated() && preParsePluginResult.continuePluginProcessing()) continue;
            return preParsePluginResult;
        }
        if (preParsePluginResult == null) {
            preParsePluginResult = PreParsePluginResult.SUCCESS;
        }
        return preParsePluginResult;
    }

    public PreParsePluginResult invokePreParseSearchPlugins(SearchOperation searchOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePreParseSearchPlugins", String.valueOf(searchOperation)));
        PreParsePluginResult preParsePluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.preParseSearchPlugins) {
            try {
                preParsePluginResult = directoryServerPlugin.doPreParse(searchOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePreParseSearchPlugins", exception));
                int n = 7602215;
                String string = MessageHandler.getMessage(n, searchOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                searchOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                searchOperation.appendErrorMessage(string);
                return new PreParsePluginResult(false, false, true);
            }
            if (preParsePluginResult == null) {
                int n = 7602216;
                String string = MessageHandler.getMessage(n, searchOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                searchOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                searchOperation.appendErrorMessage(string);
                return new PreParsePluginResult(false, false, true);
            }
            if (!preParsePluginResult.connectionTerminated() && preParsePluginResult.continuePluginProcessing()) continue;
            return preParsePluginResult;
        }
        if (preParsePluginResult == null) {
            preParsePluginResult = PreParsePluginResult.SUCCESS;
        }
        return preParsePluginResult;
    }

    public PreParsePluginResult invokePreParseUnbindPlugins(UnbindOperation unbindOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePreParseUnbindPlugins", String.valueOf(unbindOperation)));
        PreParsePluginResult preParsePluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.preParseUnbindPlugins) {
            try {
                preParsePluginResult = directoryServerPlugin.doPreParse(unbindOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePreParseUnbindPlugins", exception));
                int n = 7602215;
                String string = MessageHandler.getMessage(n, unbindOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), unbindOperation.getConnectionID(), unbindOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                unbindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                unbindOperation.appendErrorMessage(string);
                return new PreParsePluginResult(false, false, true);
            }
            if (preParsePluginResult == null) {
                int n = 7602216;
                String string = MessageHandler.getMessage(n, unbindOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), unbindOperation.getConnectionID(), unbindOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                unbindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                unbindOperation.appendErrorMessage(string);
                return new PreParsePluginResult(false, false, true);
            }
            if (!preParsePluginResult.connectionTerminated() && preParsePluginResult.continuePluginProcessing()) continue;
            return preParsePluginResult;
        }
        if (preParsePluginResult == null) {
            preParsePluginResult = PreParsePluginResult.SUCCESS;
        }
        return preParsePluginResult;
    }

    public PreOperationPluginResult invokePreOperationAddPlugins(AddOperation addOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePreOperationAddPlugins", String.valueOf(addOperation)));
        PreOperationPluginResult preOperationPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.preOperationAddPlugins) {
            try {
                preOperationPluginResult = directoryServerPlugin.doPreOperation(addOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePreOperationAddPlugins", exception));
                int n = 7602217;
                String string = MessageHandler.getMessage(n, addOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), addOperation.getConnectionID(), addOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                addOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                addOperation.appendErrorMessage(string);
                return new PreOperationPluginResult(false, false, true);
            }
            if (preOperationPluginResult == null) {
                int n = 7602218;
                String string = MessageHandler.getMessage(n, addOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), addOperation.getConnectionID(), addOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                addOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                addOperation.appendErrorMessage(string);
                return new PreOperationPluginResult(false, false, true);
            }
            if (!preOperationPluginResult.connectionTerminated() && preOperationPluginResult.continuePluginProcessing()) continue;
            return preOperationPluginResult;
        }
        if (preOperationPluginResult == null) {
            preOperationPluginResult = PreOperationPluginResult.SUCCESS;
        }
        return preOperationPluginResult;
    }

    public PreOperationPluginResult invokePreOperationBindPlugins(BindOperation bindOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePreOperationBindPlugins", String.valueOf(bindOperation)));
        PreOperationPluginResult preOperationPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.preOperationBindPlugins) {
            try {
                preOperationPluginResult = directoryServerPlugin.doPreOperation(bindOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePreOperationBindPlugins", exception));
                int n = 7602217;
                String string = MessageHandler.getMessage(n, bindOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), bindOperation.getConnectionID(), bindOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                bindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                bindOperation.appendErrorMessage(string);
                return new PreOperationPluginResult(false, false, true);
            }
            if (preOperationPluginResult == null) {
                int n = 7602218;
                String string = MessageHandler.getMessage(n, bindOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), bindOperation.getConnectionID(), bindOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                bindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                bindOperation.appendErrorMessage(string);
                return new PreOperationPluginResult(false, false, true);
            }
            if (!preOperationPluginResult.connectionTerminated() && preOperationPluginResult.continuePluginProcessing()) continue;
            return preOperationPluginResult;
        }
        if (preOperationPluginResult == null) {
            preOperationPluginResult = PreOperationPluginResult.SUCCESS;
        }
        return preOperationPluginResult;
    }

    public PreOperationPluginResult invokePreOperationComparePlugins(CompareOperation compareOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePreOperationComparePlugins", String.valueOf(compareOperation)));
        PreOperationPluginResult preOperationPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.preOperationComparePlugins) {
            try {
                preOperationPluginResult = directoryServerPlugin.doPreOperation(compareOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePreOperationComparePlugins", exception));
                int n = 7602217;
                String string = MessageHandler.getMessage(n, compareOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), compareOperation.getConnectionID(), compareOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                compareOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                compareOperation.appendErrorMessage(string);
                return new PreOperationPluginResult(false, false, true);
            }
            if (preOperationPluginResult == null) {
                int n = 7602218;
                String string = MessageHandler.getMessage(n, compareOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), compareOperation.getConnectionID(), compareOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                compareOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                compareOperation.appendErrorMessage(string);
                return new PreOperationPluginResult(false, false, true);
            }
            if (!preOperationPluginResult.connectionTerminated() && preOperationPluginResult.continuePluginProcessing()) continue;
            return preOperationPluginResult;
        }
        if (preOperationPluginResult == null) {
            preOperationPluginResult = PreOperationPluginResult.SUCCESS;
        }
        return preOperationPluginResult;
    }

    public PreOperationPluginResult invokePreOperationDeletePlugins(DeleteOperation deleteOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePreOperationDeletePlugins", String.valueOf(deleteOperation)));
        PreOperationPluginResult preOperationPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.preOperationDeletePlugins) {
            try {
                preOperationPluginResult = directoryServerPlugin.doPreOperation(deleteOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePreOperationDeletePlugins", exception));
                int n = 7602217;
                String string = MessageHandler.getMessage(n, deleteOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), deleteOperation.getConnectionID(), deleteOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                deleteOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                deleteOperation.appendErrorMessage(string);
                return new PreOperationPluginResult(false, false, true);
            }
            if (preOperationPluginResult == null) {
                int n = 7602218;
                String string = MessageHandler.getMessage(n, deleteOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), deleteOperation.getConnectionID(), deleteOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                deleteOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                deleteOperation.appendErrorMessage(string);
                return new PreOperationPluginResult(false, false, true);
            }
            if (!preOperationPluginResult.connectionTerminated() && preOperationPluginResult.continuePluginProcessing()) continue;
            return preOperationPluginResult;
        }
        if (preOperationPluginResult == null) {
            preOperationPluginResult = PreOperationPluginResult.SUCCESS;
        }
        return preOperationPluginResult;
    }

    public PreOperationPluginResult invokePreOperationExtendedPlugins(ExtendedOperation extendedOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePreOperationExtendedPlugins", String.valueOf(extendedOperation)));
        PreOperationPluginResult preOperationPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.preOperationExtendedPlugins) {
            try {
                preOperationPluginResult = directoryServerPlugin.doPreOperation(extendedOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePreOperationExtendedPlugins", exception));
                int n = 7602217;
                String string = MessageHandler.getMessage(n, extendedOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), extendedOperation.getConnectionID(), extendedOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                extendedOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                extendedOperation.appendErrorMessage(string);
                return new PreOperationPluginResult(false, false, true);
            }
            if (preOperationPluginResult == null) {
                int n = 7602218;
                String string = MessageHandler.getMessage(n, extendedOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), extendedOperation.getConnectionID(), extendedOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                extendedOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                extendedOperation.appendErrorMessage(string);
                return new PreOperationPluginResult(false, false, true);
            }
            if (!preOperationPluginResult.connectionTerminated() && preOperationPluginResult.continuePluginProcessing()) continue;
            return preOperationPluginResult;
        }
        if (preOperationPluginResult == null) {
            preOperationPluginResult = PreOperationPluginResult.SUCCESS;
        }
        return preOperationPluginResult;
    }

    public PreOperationPluginResult invokePreOperationModifyPlugins(ModifyOperation modifyOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePreOperationModifyPlugins", String.valueOf(modifyOperation)));
        PreOperationPluginResult preOperationPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.preOperationModifyPlugins) {
            try {
                preOperationPluginResult = directoryServerPlugin.doPreOperation(modifyOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePreOperationModifyPlugins", exception));
                int n = 7602217;
                String string = MessageHandler.getMessage(n, modifyOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), modifyOperation.getConnectionID(), modifyOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                modifyOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                modifyOperation.appendErrorMessage(string);
                return new PreOperationPluginResult(false, false, true);
            }
            if (preOperationPluginResult == null) {
                int n = 7602218;
                String string = MessageHandler.getMessage(n, modifyOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), modifyOperation.getConnectionID(), modifyOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                modifyOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                modifyOperation.appendErrorMessage(string);
                return new PreOperationPluginResult(false, false, true);
            }
            if (!preOperationPluginResult.connectionTerminated() && preOperationPluginResult.continuePluginProcessing()) continue;
            return preOperationPluginResult;
        }
        if (preOperationPluginResult == null) {
            preOperationPluginResult = PreOperationPluginResult.SUCCESS;
        }
        return preOperationPluginResult;
    }

    public PreOperationPluginResult invokePreOperationModifyDNPlugins(ModifyDNOperation modifyDNOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePreOperationModifyDNPlugins", String.valueOf(modifyDNOperation)));
        PreOperationPluginResult preOperationPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.preOperationModifyDNPlugins) {
            try {
                preOperationPluginResult = directoryServerPlugin.doPreOperation(modifyDNOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePreOperationModifyDNPlugins", exception));
                int n = 7602217;
                String string = MessageHandler.getMessage(n, modifyDNOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), modifyDNOperation.getConnectionID(), modifyDNOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                modifyDNOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                modifyDNOperation.appendErrorMessage(string);
                return new PreOperationPluginResult(false, false, true);
            }
            if (preOperationPluginResult == null) {
                int n = 7602218;
                String string = MessageHandler.getMessage(n, modifyDNOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), modifyDNOperation.getConnectionID(), modifyDNOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                modifyDNOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                modifyDNOperation.appendErrorMessage(string);
                return new PreOperationPluginResult(false, false, true);
            }
            if (!preOperationPluginResult.connectionTerminated() && preOperationPluginResult.continuePluginProcessing()) continue;
            return preOperationPluginResult;
        }
        if (preOperationPluginResult == null) {
            preOperationPluginResult = PreOperationPluginResult.SUCCESS;
        }
        return preOperationPluginResult;
    }

    public PreOperationPluginResult invokePreOperationSearchPlugins(SearchOperation searchOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePreOperationSearchPlugins", String.valueOf(searchOperation)));
        PreOperationPluginResult preOperationPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.preOperationSearchPlugins) {
            try {
                preOperationPluginResult = directoryServerPlugin.doPreOperation(searchOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePreOperationSearchPlugins", exception));
                int n = 7602217;
                String string = MessageHandler.getMessage(n, searchOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                searchOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                searchOperation.appendErrorMessage(string);
                return new PreOperationPluginResult(false, false, true);
            }
            if (preOperationPluginResult == null) {
                int n = 7602218;
                String string = MessageHandler.getMessage(n, searchOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                searchOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                searchOperation.appendErrorMessage(string);
                return new PreOperationPluginResult(false, false, true);
            }
            if (!preOperationPluginResult.connectionTerminated() && preOperationPluginResult.continuePluginProcessing()) continue;
            return preOperationPluginResult;
        }
        if (preOperationPluginResult == null) {
            preOperationPluginResult = PreOperationPluginResult.SUCCESS;
        }
        return preOperationPluginResult;
    }

    public PostOperationPluginResult invokePostOperationAbandonPlugins(AbandonOperation abandonOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePostOperationAbandonPlugins", String.valueOf(abandonOperation)));
        PostOperationPluginResult postOperationPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.postOperationAbandonPlugins) {
            try {
                postOperationPluginResult = directoryServerPlugin.doPostOperation(abandonOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePostOperationAbandonPlugins", exception));
                int n = 7602219;
                String string = MessageHandler.getMessage(n, abandonOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), abandonOperation.getConnectionID(), abandonOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                abandonOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                abandonOperation.appendErrorMessage(string);
                return new PostOperationPluginResult(false, false);
            }
            if (postOperationPluginResult == null) {
                int n = 7602220;
                String string = MessageHandler.getMessage(n, abandonOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), abandonOperation.getConnectionID(), abandonOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                abandonOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                abandonOperation.appendErrorMessage(string);
                return new PostOperationPluginResult(false, false);
            }
            if (!postOperationPluginResult.connectionTerminated() && postOperationPluginResult.continuePluginProcessing()) continue;
            return postOperationPluginResult;
        }
        if (postOperationPluginResult == null) {
            postOperationPluginResult = PostOperationPluginResult.SUCCESS;
        }
        return postOperationPluginResult;
    }

    public PostOperationPluginResult invokePostOperationAddPlugins(AddOperation addOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePostOperationAddPlugins", String.valueOf(addOperation)));
        PostOperationPluginResult postOperationPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.postOperationAddPlugins) {
            try {
                postOperationPluginResult = directoryServerPlugin.doPostOperation(addOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePostOperationAddPlugins", exception));
                int n = 7602219;
                String string = MessageHandler.getMessage(n, addOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), addOperation.getConnectionID(), addOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                addOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                addOperation.appendErrorMessage(string);
                return new PostOperationPluginResult(false, false);
            }
            if (postOperationPluginResult == null) {
                int n = 7602220;
                String string = MessageHandler.getMessage(n, addOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), addOperation.getConnectionID(), addOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                addOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                addOperation.appendErrorMessage(string);
                return new PostOperationPluginResult(false, false);
            }
            if (!postOperationPluginResult.connectionTerminated() && postOperationPluginResult.continuePluginProcessing()) continue;
            return postOperationPluginResult;
        }
        if (postOperationPluginResult == null) {
            postOperationPluginResult = PostOperationPluginResult.SUCCESS;
        }
        return postOperationPluginResult;
    }

    public PostOperationPluginResult invokePostOperationBindPlugins(BindOperation bindOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePostOperationBindPlugins", String.valueOf(bindOperation)));
        PostOperationPluginResult postOperationPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.postOperationBindPlugins) {
            try {
                postOperationPluginResult = directoryServerPlugin.doPostOperation(bindOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePostOperationBindPlugins", exception));
                int n = 7602219;
                String string = MessageHandler.getMessage(n, bindOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), bindOperation.getConnectionID(), bindOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                bindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                bindOperation.appendErrorMessage(string);
                return new PostOperationPluginResult(false, false);
            }
            if (postOperationPluginResult == null) {
                int n = 7602220;
                String string = MessageHandler.getMessage(n, bindOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), bindOperation.getConnectionID(), bindOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                bindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                bindOperation.appendErrorMessage(string);
                return new PostOperationPluginResult(false, false);
            }
            if (!postOperationPluginResult.connectionTerminated() && postOperationPluginResult.continuePluginProcessing()) continue;
            return postOperationPluginResult;
        }
        if (postOperationPluginResult == null) {
            postOperationPluginResult = PostOperationPluginResult.SUCCESS;
        }
        return postOperationPluginResult;
    }

    public PostOperationPluginResult invokePostOperationComparePlugins(CompareOperation compareOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePostOperationComparePlugins", String.valueOf(compareOperation)));
        PostOperationPluginResult postOperationPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.postOperationComparePlugins) {
            try {
                postOperationPluginResult = directoryServerPlugin.doPostOperation(compareOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePostOperationComparePlugins", exception));
                int n = 7602219;
                String string = MessageHandler.getMessage(n, compareOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), compareOperation.getConnectionID(), compareOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                compareOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                compareOperation.appendErrorMessage(string);
                return new PostOperationPluginResult(false, false);
            }
            if (postOperationPluginResult == null) {
                int n = 7602220;
                String string = MessageHandler.getMessage(n, compareOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), compareOperation.getConnectionID(), compareOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                compareOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                compareOperation.appendErrorMessage(string);
                return new PostOperationPluginResult(false, false);
            }
            if (!postOperationPluginResult.connectionTerminated() && postOperationPluginResult.continuePluginProcessing()) continue;
            return postOperationPluginResult;
        }
        if (postOperationPluginResult == null) {
            postOperationPluginResult = PostOperationPluginResult.SUCCESS;
        }
        return postOperationPluginResult;
    }

    public PostOperationPluginResult invokePostOperationDeletePlugins(DeleteOperation deleteOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePostOperationDeletePlugins", String.valueOf(deleteOperation)));
        PostOperationPluginResult postOperationPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.postOperationDeletePlugins) {
            try {
                postOperationPluginResult = directoryServerPlugin.doPostOperation(deleteOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePostOperationDeletePlugins", exception));
                int n = 7602219;
                String string = MessageHandler.getMessage(n, deleteOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), deleteOperation.getConnectionID(), deleteOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                deleteOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                deleteOperation.appendErrorMessage(string);
                return new PostOperationPluginResult(false, false);
            }
            if (postOperationPluginResult == null) {
                int n = 7602220;
                String string = MessageHandler.getMessage(n, deleteOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), deleteOperation.getConnectionID(), deleteOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                deleteOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                deleteOperation.appendErrorMessage(string);
                return new PostOperationPluginResult(false, false);
            }
            if (!postOperationPluginResult.connectionTerminated() && postOperationPluginResult.continuePluginProcessing()) continue;
            return postOperationPluginResult;
        }
        if (postOperationPluginResult == null) {
            postOperationPluginResult = PostOperationPluginResult.SUCCESS;
        }
        return postOperationPluginResult;
    }

    public PostOperationPluginResult invokePostOperationExtendedPlugins(ExtendedOperation extendedOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePostOperationExtendedPlugins", String.valueOf(extendedOperation)));
        PostOperationPluginResult postOperationPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.postOperationExtendedPlugins) {
            try {
                postOperationPluginResult = directoryServerPlugin.doPostOperation(extendedOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePostOperationExtendedPlugins", exception));
                int n = 7602219;
                String string = MessageHandler.getMessage(n, extendedOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), extendedOperation.getConnectionID(), extendedOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                extendedOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                extendedOperation.appendErrorMessage(string);
                return new PostOperationPluginResult(false, false);
            }
            if (postOperationPluginResult == null) {
                int n = 7602220;
                String string = MessageHandler.getMessage(n, extendedOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), extendedOperation.getConnectionID(), extendedOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                extendedOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                extendedOperation.appendErrorMessage(string);
                return new PostOperationPluginResult(false, false);
            }
            if (!postOperationPluginResult.connectionTerminated() && postOperationPluginResult.continuePluginProcessing()) continue;
            return postOperationPluginResult;
        }
        if (postOperationPluginResult == null) {
            postOperationPluginResult = PostOperationPluginResult.SUCCESS;
        }
        return postOperationPluginResult;
    }

    public PostOperationPluginResult invokePostOperationModifyPlugins(ModifyOperation modifyOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePostOperationModifyPlugins", String.valueOf(modifyOperation)));
        PostOperationPluginResult postOperationPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.postOperationModifyPlugins) {
            try {
                postOperationPluginResult = directoryServerPlugin.doPostOperation(modifyOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePostOperationModifyPlugins", exception));
                int n = 7602219;
                String string = MessageHandler.getMessage(n, modifyOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), modifyOperation.getConnectionID(), modifyOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                modifyOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                modifyOperation.appendErrorMessage(string);
                return new PostOperationPluginResult(false, false);
            }
            if (postOperationPluginResult == null) {
                int n = 7602220;
                String string = MessageHandler.getMessage(n, modifyOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), modifyOperation.getConnectionID(), modifyOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                modifyOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                modifyOperation.appendErrorMessage(string);
                return new PostOperationPluginResult(false, false);
            }
            if (!postOperationPluginResult.connectionTerminated() && postOperationPluginResult.continuePluginProcessing()) continue;
            return postOperationPluginResult;
        }
        if (postOperationPluginResult == null) {
            postOperationPluginResult = PostOperationPluginResult.SUCCESS;
        }
        return postOperationPluginResult;
    }

    public PostOperationPluginResult invokePostOperationModifyDNPlugins(ModifyDNOperation modifyDNOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePostOperationModifyDNPlugins", String.valueOf(modifyDNOperation)));
        PostOperationPluginResult postOperationPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.postOperationModifyDNPlugins) {
            try {
                postOperationPluginResult = directoryServerPlugin.doPostOperation(modifyDNOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePostOperationModifyDNPlugins", exception));
                int n = 7602219;
                String string = MessageHandler.getMessage(n, modifyDNOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), modifyDNOperation.getConnectionID(), modifyDNOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                modifyDNOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                modifyDNOperation.appendErrorMessage(string);
                return new PostOperationPluginResult(false, false);
            }
            if (postOperationPluginResult == null) {
                int n = 7602220;
                String string = MessageHandler.getMessage(n, modifyDNOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), modifyDNOperation.getConnectionID(), modifyDNOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                modifyDNOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                modifyDNOperation.appendErrorMessage(string);
                return new PostOperationPluginResult(false, false);
            }
            if (!postOperationPluginResult.connectionTerminated() && postOperationPluginResult.continuePluginProcessing()) continue;
            return postOperationPluginResult;
        }
        if (postOperationPluginResult == null) {
            postOperationPluginResult = PostOperationPluginResult.SUCCESS;
        }
        return postOperationPluginResult;
    }

    public PostOperationPluginResult invokePostOperationSearchPlugins(SearchOperation searchOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePostOperationSearchPlugins", String.valueOf(searchOperation)));
        PostOperationPluginResult postOperationPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.postOperationSearchPlugins) {
            try {
                postOperationPluginResult = directoryServerPlugin.doPostOperation(searchOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePostOperationSearchPlugins", exception));
                int n = 7602219;
                String string = MessageHandler.getMessage(n, searchOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                searchOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                searchOperation.appendErrorMessage(string);
                return new PostOperationPluginResult(false, false);
            }
            if (postOperationPluginResult == null) {
                int n = 7602220;
                String string = MessageHandler.getMessage(n, searchOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                searchOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                searchOperation.appendErrorMessage(string);
                return new PostOperationPluginResult(false, false);
            }
            if (!postOperationPluginResult.connectionTerminated() && postOperationPluginResult.continuePluginProcessing()) continue;
            return postOperationPluginResult;
        }
        if (postOperationPluginResult == null) {
            postOperationPluginResult = PostOperationPluginResult.SUCCESS;
        }
        return postOperationPluginResult;
    }

    public PostOperationPluginResult invokePostOperationUnbindPlugins(UnbindOperation unbindOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePostOperationUnbindPlugins", String.valueOf(unbindOperation)));
        PostOperationPluginResult postOperationPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.postOperationUnbindPlugins) {
            try {
                postOperationPluginResult = directoryServerPlugin.doPostOperation(unbindOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePostOperationUnbindPlugins", exception));
                int n = 7602219;
                String string = MessageHandler.getMessage(n, unbindOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), unbindOperation.getConnectionID(), unbindOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                unbindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                unbindOperation.appendErrorMessage(string);
                return new PostOperationPluginResult(false, false);
            }
            if (postOperationPluginResult == null) {
                int n = 7602220;
                String string = MessageHandler.getMessage(n, unbindOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), unbindOperation.getConnectionID(), unbindOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                unbindOperation.setResultCode(DirectoryServer.getServerErrorResultCode());
                unbindOperation.appendErrorMessage(string);
                return new PostOperationPluginResult(false, false);
            }
            if (!postOperationPluginResult.connectionTerminated() && postOperationPluginResult.continuePluginProcessing()) continue;
            return postOperationPluginResult;
        }
        if (postOperationPluginResult == null) {
            postOperationPluginResult = PostOperationPluginResult.SUCCESS;
        }
        return postOperationPluginResult;
    }

    public PostResponsePluginResult invokePostResponseAddPlugins(AddOperation addOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePostResponseAddPlugins", String.valueOf(addOperation)));
        PostResponsePluginResult postResponsePluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.postResponseAddPlugins) {
            try {
                postResponsePluginResult = directoryServerPlugin.doPostResponse(addOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePostResponseAddPlugins", exception));
                int n = 7602221;
                String string = MessageHandler.getMessage(n, addOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), addOperation.getConnectionID(), addOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new PostResponsePluginResult(false, false);
            }
            if (postResponsePluginResult == null) {
                int n = 7602222;
                String string = MessageHandler.getMessage(n, addOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), addOperation.getConnectionID(), addOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new PostResponsePluginResult(false, false);
            }
            if (!postResponsePluginResult.connectionTerminated() && postResponsePluginResult.continuePluginProcessing()) continue;
            return postResponsePluginResult;
        }
        if (postResponsePluginResult == null) {
            postResponsePluginResult = PostResponsePluginResult.SUCCESS;
        }
        return postResponsePluginResult;
    }

    public PostResponsePluginResult invokePostResponseBindPlugins(BindOperation bindOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePostResponseBindPlugins", String.valueOf(bindOperation)));
        PostResponsePluginResult postResponsePluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.postResponseBindPlugins) {
            try {
                postResponsePluginResult = directoryServerPlugin.doPostResponse(bindOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePostResponseBindPlugins", exception));
                int n = 7602221;
                String string = MessageHandler.getMessage(n, bindOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), bindOperation.getConnectionID(), bindOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new PostResponsePluginResult(false, false);
            }
            if (postResponsePluginResult == null) {
                int n = 7602222;
                String string = MessageHandler.getMessage(n, bindOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), bindOperation.getConnectionID(), bindOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new PostResponsePluginResult(false, false);
            }
            if (!postResponsePluginResult.connectionTerminated() && postResponsePluginResult.continuePluginProcessing()) continue;
            return postResponsePluginResult;
        }
        if (postResponsePluginResult == null) {
            postResponsePluginResult = PostResponsePluginResult.SUCCESS;
        }
        return postResponsePluginResult;
    }

    public PostResponsePluginResult invokePostResponseComparePlugins(CompareOperation compareOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePostResponseComparePlugins", String.valueOf(compareOperation)));
        PostResponsePluginResult postResponsePluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.postResponseComparePlugins) {
            try {
                postResponsePluginResult = directoryServerPlugin.doPostResponse(compareOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePostResponseComparePlugins", exception));
                int n = 7602221;
                String string = MessageHandler.getMessage(n, compareOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), compareOperation.getConnectionID(), compareOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new PostResponsePluginResult(false, false);
            }
            if (postResponsePluginResult == null) {
                int n = 7602222;
                String string = MessageHandler.getMessage(n, compareOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), compareOperation.getConnectionID(), compareOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new PostResponsePluginResult(false, false);
            }
            if (!postResponsePluginResult.connectionTerminated() && postResponsePluginResult.continuePluginProcessing()) continue;
            return postResponsePluginResult;
        }
        if (postResponsePluginResult == null) {
            postResponsePluginResult = PostResponsePluginResult.SUCCESS;
        }
        return postResponsePluginResult;
    }

    public PostResponsePluginResult invokePostResponseDeletePlugins(DeleteOperation deleteOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePostResponseDeletePlugins", String.valueOf(deleteOperation)));
        PostResponsePluginResult postResponsePluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.postResponseDeletePlugins) {
            try {
                postResponsePluginResult = directoryServerPlugin.doPostResponse(deleteOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePostResponseDeletePlugins", exception));
                int n = 7602221;
                String string = MessageHandler.getMessage(n, deleteOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), deleteOperation.getConnectionID(), deleteOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new PostResponsePluginResult(false, false);
            }
            if (postResponsePluginResult == null) {
                int n = 7602222;
                String string = MessageHandler.getMessage(n, deleteOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), deleteOperation.getConnectionID(), deleteOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new PostResponsePluginResult(false, false);
            }
            if (!postResponsePluginResult.connectionTerminated() && postResponsePluginResult.continuePluginProcessing()) continue;
            return postResponsePluginResult;
        }
        if (postResponsePluginResult == null) {
            postResponsePluginResult = PostResponsePluginResult.SUCCESS;
        }
        return postResponsePluginResult;
    }

    public PostResponsePluginResult invokePostResponseExtendedPlugins(ExtendedOperation extendedOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePostResponseExtendedPlugins", String.valueOf(extendedOperation)));
        PostResponsePluginResult postResponsePluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.postResponseExtendedPlugins) {
            try {
                postResponsePluginResult = directoryServerPlugin.doPostResponse(extendedOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePostResponseExtendedPlugins", exception));
                int n = 7602221;
                String string = MessageHandler.getMessage(n, extendedOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), extendedOperation.getConnectionID(), extendedOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new PostResponsePluginResult(false, false);
            }
            if (postResponsePluginResult == null) {
                int n = 7602222;
                String string = MessageHandler.getMessage(n, extendedOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), extendedOperation.getConnectionID(), extendedOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new PostResponsePluginResult(false, false);
            }
            if (!postResponsePluginResult.connectionTerminated() && postResponsePluginResult.continuePluginProcessing()) continue;
            return postResponsePluginResult;
        }
        if (postResponsePluginResult == null) {
            postResponsePluginResult = PostResponsePluginResult.SUCCESS;
        }
        return postResponsePluginResult;
    }

    public PostResponsePluginResult invokePostResponseModifyPlugins(ModifyOperation modifyOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePostResponseModifyPlugins", String.valueOf(modifyOperation)));
        PostResponsePluginResult postResponsePluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.postResponseModifyPlugins) {
            try {
                postResponsePluginResult = directoryServerPlugin.doPostResponse(modifyOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePostResponseModifyPlugins", exception));
                int n = 7602221;
                String string = MessageHandler.getMessage(n, modifyOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), modifyOperation.getConnectionID(), modifyOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new PostResponsePluginResult(false, false);
            }
            if (postResponsePluginResult == null) {
                int n = 7602222;
                String string = MessageHandler.getMessage(n, modifyOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), modifyOperation.getConnectionID(), modifyOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new PostResponsePluginResult(false, false);
            }
            if (!postResponsePluginResult.connectionTerminated() && postResponsePluginResult.continuePluginProcessing()) continue;
            return postResponsePluginResult;
        }
        if (postResponsePluginResult == null) {
            postResponsePluginResult = PostResponsePluginResult.SUCCESS;
        }
        return postResponsePluginResult;
    }

    public PostResponsePluginResult invokePostResponseModifyDNPlugins(ModifyDNOperation modifyDNOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePostResponseModifyDNPlugins", String.valueOf(modifyDNOperation)));
        PostResponsePluginResult postResponsePluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.postResponseModifyDNPlugins) {
            try {
                postResponsePluginResult = directoryServerPlugin.doPostResponse(modifyDNOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePostResponseModifyDNPlugins", exception));
                int n = 7602221;
                String string = MessageHandler.getMessage(n, modifyDNOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), modifyDNOperation.getConnectionID(), modifyDNOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new PostResponsePluginResult(false, false);
            }
            if (postResponsePluginResult == null) {
                int n = 7602222;
                String string = MessageHandler.getMessage(n, modifyDNOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), modifyDNOperation.getConnectionID(), modifyDNOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new PostResponsePluginResult(false, false);
            }
            if (!postResponsePluginResult.connectionTerminated() && postResponsePluginResult.continuePluginProcessing()) continue;
            return postResponsePluginResult;
        }
        if (postResponsePluginResult == null) {
            postResponsePluginResult = PostResponsePluginResult.SUCCESS;
        }
        return postResponsePluginResult;
    }

    public PostResponsePluginResult invokePostResponseSearchPlugins(SearchOperation searchOperation) {
        assert (Debug.debugEnter(CLASS_NAME, "invokePostResponseSearchPlugins", String.valueOf(searchOperation)));
        PostResponsePluginResult postResponsePluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.postResponseSearchPlugins) {
            try {
                postResponsePluginResult = directoryServerPlugin.doPostResponse(searchOperation);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokePostResponseSearchPlugins", exception));
                int n = 7602221;
                String string = MessageHandler.getMessage(n, searchOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new PostResponsePluginResult(false, false);
            }
            if (postResponsePluginResult == null) {
                int n = 7602222;
                String string = MessageHandler.getMessage(n, searchOperation.getOperationType().getOperationName(), String.valueOf(directoryServerPlugin.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new PostResponsePluginResult(false, false);
            }
            if (!postResponsePluginResult.connectionTerminated() && postResponsePluginResult.continuePluginProcessing()) continue;
            return postResponsePluginResult;
        }
        if (postResponsePluginResult == null) {
            postResponsePluginResult = PostResponsePluginResult.SUCCESS;
        }
        return postResponsePluginResult;
    }

    public SearchEntryPluginResult invokeSearchResultEntryPlugins(SearchOperation searchOperation, SearchResultEntry searchResultEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "invokeSearchResultEntryPlugins", String.valueOf(searchOperation), String.valueOf(searchResultEntry)));
        SearchEntryPluginResult searchEntryPluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.searchResultEntryPlugins) {
            try {
                searchEntryPluginResult = directoryServerPlugin.processSearchEntry(searchOperation, searchResultEntry);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokeSearchResultEntryPlugins", exception));
                int n = 7602223;
                String string = MessageHandler.getMessage(n, String.valueOf(directoryServerPlugin.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID(), String.valueOf(searchResultEntry.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new SearchEntryPluginResult(false, false, false, false);
            }
            if (searchEntryPluginResult == null) {
                int n = 7602224;
                String string = MessageHandler.getMessage(n, String.valueOf(directoryServerPlugin.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID(), String.valueOf(searchResultEntry.getDN()));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new SearchEntryPluginResult(false, false, false, false);
            }
            if (!searchEntryPluginResult.connectionTerminated() && searchEntryPluginResult.continuePluginProcessing()) continue;
            return searchEntryPluginResult;
        }
        if (searchEntryPluginResult == null) {
            searchEntryPluginResult = SearchEntryPluginResult.SUCCESS;
        }
        return searchEntryPluginResult;
    }

    public SearchReferencePluginResult invokeSearchResultReferencePlugins(SearchOperation searchOperation, SearchResultReference searchResultReference) {
        assert (Debug.debugEnter(CLASS_NAME, "invokeSearchResultReferencePlugins", String.valueOf(searchOperation), String.valueOf(searchResultReference)));
        SearchReferencePluginResult searchReferencePluginResult = null;
        for (DirectoryServerPlugin directoryServerPlugin : this.searchResultReferencePlugins) {
            try {
                searchReferencePluginResult = directoryServerPlugin.processSearchReference(searchOperation, searchResultReference);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokeSearchResultReferencePlugins", exception));
                int n = 7602225;
                String string = MessageHandler.getMessage(n, String.valueOf(directoryServerPlugin.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID(), searchResultReference.getReferralURLString(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new SearchReferencePluginResult(false, false, false, false);
            }
            if (searchReferencePluginResult == null) {
                int n = 7602226;
                String string = MessageHandler.getMessage(n, String.valueOf(directoryServerPlugin.getPluginEntryDN()), searchOperation.getConnectionID(), searchOperation.getOperationID(), searchResultReference.getReferralURLString());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new SearchReferencePluginResult(false, false, false, false);
            }
            if (!searchReferencePluginResult.connectionTerminated() && searchReferencePluginResult.continuePluginProcessing()) continue;
            return searchReferencePluginResult;
        }
        if (searchReferencePluginResult == null) {
            searchReferencePluginResult = SearchReferencePluginResult.SUCCESS;
        }
        return searchReferencePluginResult;
    }

    public IntermediateResponsePluginResult invokeIntermediateResponsePlugins(IntermediateResponse intermediateResponse) {
        assert (Debug.debugEnter(CLASS_NAME, "invokeIntermediateResponsePlugins", String.valueOf(intermediateResponse)));
        IntermediateResponsePluginResult intermediateResponsePluginResult = null;
        Operation operation = intermediateResponse.getOperation();
        for (DirectoryServerPlugin directoryServerPlugin : this.intermediateResponsePlugins) {
            try {
                intermediateResponsePluginResult = directoryServerPlugin.processIntermediateResponse(intermediateResponse);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "invokeIntermediateResponsePlugins", exception));
                int n = 7602239;
                String string = MessageHandler.getMessage(n, String.valueOf(directoryServerPlugin.getPluginEntryDN()), operation.getConnectionID(), operation.getOperationID(), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new IntermediateResponsePluginResult(false, false, false, false);
            }
            if (intermediateResponsePluginResult == null) {
                int n = 0x740040;
                String string = MessageHandler.getMessage(n, String.valueOf(directoryServerPlugin.getPluginEntryDN()), operation.getConnectionID(), operation.getOperationID());
                Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return new IntermediateResponsePluginResult(false, false, false, false);
            }
            if (!intermediateResponsePluginResult.connectionTerminated() && intermediateResponsePluginResult.continuePluginProcessing()) continue;
            return intermediateResponsePluginResult;
        }
        if (intermediateResponsePluginResult == null) {
            intermediateResponsePluginResult = IntermediateResponsePluginResult.SUCCESS;
        }
        return intermediateResponsePluginResult;
    }
}

