/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.AbstractCollection;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.api.ConfigHandler;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.PasswordGenerator;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.ServerConstants;

public class PasswordGeneratorConfigManager
implements ConfigChangeListener,
ConfigAddListener,
ConfigDeleteListener {
    private static final String CLASS_NAME = "org.opends.server.core.PasswordGeneratorConfigManager";
    private ConcurrentHashMap<DN, PasswordGenerator> passwordGenerators;
    private ConfigHandler configHandler;

    public PasswordGeneratorConfigManager() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.configHandler = DirectoryServer.getConfigHandler();
        this.passwordGenerators = new ConcurrentHashMap();
    }

    public void initializePasswordGenerators() throws ConfigException, InitializationException {
        ConfigEntry configEntry;
        assert (Debug.debugEnter(CLASS_NAME, "initializePasswordGenerators", new String[0]));
        try {
            DN dN = DN.decode("cn=Password Generators,cn=config");
            configEntry = this.configHandler.getConfigEntry(dN);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializePasswordGenerators", exception));
            int n = 3473900;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new ConfigException(n, string, exception);
        }
        if (configEntry == null) {
            int n = 3277293;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        configEntry.registerAddListener(this);
        configEntry.registerDeleteListener(this);
        if (!configEntry.hasChildren()) {
            return;
        }
        for (ConfigEntry configEntry2 : configEntry.getChildren().values()) {
            configEntry2.registerChangeListener(this);
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.configAddIsAcceptable(configEntry2, stringBuilder)) {
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408366, configEntry2.getDN().toString(), stringBuilder.toString());
                continue;
            }
            try {
                ConfigChangeResult configChangeResult = this.applyConfigurationAdd(configEntry2);
                if (configChangeResult.getResultCode() == ResultCode.SUCCESS) continue;
                StringBuilder stringBuilder2 = new StringBuilder();
                List<String> list = configChangeResult.getMessages();
                if (list == null || list.isEmpty()) {
                    stringBuilder2.append(MessageHandler.getMessage(0x300030));
                } else {
                    Iterator<String> iterator = list.iterator();
                    stringBuilder2.append(iterator.next());
                    while (iterator.hasNext()) {
                        stringBuilder2.append(ServerConstants.EOL);
                        stringBuilder2.append(iterator.next());
                    }
                }
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408367, configEntry2.getDN().toString(), stringBuilder2.toString());
            }
            catch (Exception exception) {
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408367, configEntry2.getDN().toString(), String.valueOf(exception));
            }
        }
    }

    public boolean configChangeIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        Object object;
        StringConfigAttribute stringConfigAttribute;
        Object object2;
        assert (Debug.debugEnter(CLASS_NAME, "configChangeIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        if (!configEntry.hasObjectClass("ds-cfg-password-generator")) {
            int n = 3408368;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
            stringBuilder.append(string);
            return false;
        }
        try {
            object2 = new StringConfigAttribute("ds-cfg-password-generator-class", MessageHandler.getMessage(3146225), true, false, true);
            stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object2);
            if (stringConfigAttribute == null) {
                int n = 3408370;
                String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
                stringBuilder.append(string);
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            int n = 3408371;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        try {
            object2 = Class.forName(stringConfigAttribute.pendingValue());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            int n = 3408371;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        try {
            object = (PasswordGenerator)((Class)object2).newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            int n = 3408372;
            String string = MessageHandler.getMessage(n, ((Class)object2).getName(), String.valueOf(configEntry.getDN()), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        try {
            BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-password-generator-enabled", MessageHandler.getMessage(3146229), false);
            object = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (object == null) {
                int n = 3408374;
                String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
                stringBuilder.append(string);
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            int n = 3408375;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationChange(ConfigEntry configEntry) {
        Object object;
        Object object2;
        boolean bl;
        PasswordGenerator passwordGenerator;
        ArrayList<String> arrayList;
        boolean bl2;
        ResultCode resultCode;
        DN dN;
        block22: {
            assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationChange", String.valueOf(configEntry)));
            dN = configEntry.getDN();
            resultCode = ResultCode.SUCCESS;
            bl2 = false;
            arrayList = new ArrayList<String>();
            if (!configEntry.hasObjectClass("ds-cfg-password-generator")) {
                int n = 3408368;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.UNWILLING_TO_PERFORM;
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            passwordGenerator = this.passwordGenerators.get(dN);
            bl = false;
            try {
                object2 = new BooleanConfigAttribute("ds-cfg-password-generator-enabled", MessageHandler.getMessage(3146229), false);
                BooleanConfigAttribute booleanConfigAttribute = (BooleanConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object2);
                if (booleanConfigAttribute == null) {
                    int n = 3408374;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                    resultCode = ResultCode.UNWILLING_TO_PERFORM;
                    return new ConfigChangeResult(resultCode, bl2, arrayList);
                }
                if (booleanConfigAttribute.activeValue()) {
                    if (passwordGenerator == null) {
                        bl = true;
                    }
                    break block22;
                }
                if (passwordGenerator == null) {
                    return new ConfigChangeResult(resultCode, bl2, arrayList);
                }
                this.passwordGenerators.remove(dN);
                passwordGenerator.finalizePasswordGenerator();
                DirectoryServer.deregisterPasswordGenerator(dN);
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
                int n = 3408375;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
        }
        try {
            StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-password-generator-class", MessageHandler.getMessage(3146225), true, false, true);
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object == null) {
                int n = 3408370;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            object2 = ((StringConfigAttribute)object).pendingValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            int n = 3408371;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl2, arrayList);
        }
        boolean bl3 = false;
        object = null;
        if (passwordGenerator != null) {
            object = passwordGenerator.getClass().getName();
            boolean bl4 = bl3 = !((String)object2).equals(object);
        }
        if (bl3) {
            bl2 = true;
            arrayList.add(MessageHandler.getMessage(3146232, String.valueOf(object), String.valueOf(object2), String.valueOf(dN)));
            return new ConfigChangeResult(resultCode, bl2, arrayList);
        }
        if (bl) {
            try {
                Class<?> clazz = Class.forName((String)object2);
                passwordGenerator = (PasswordGenerator)clazz.newInstance();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                int n = 3408372;
                arrayList.add(MessageHandler.getMessage(n, object2, String.valueOf(dN), String.valueOf(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            try {
                passwordGenerator.initializePasswordGenerator(configEntry);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                int n = 3342841;
                arrayList.add(MessageHandler.getMessage(n, object2, String.valueOf(dN), String.valueOf(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            this.passwordGenerators.put(dN, passwordGenerator);
            DirectoryServer.registerPasswordGenerator(dN, passwordGenerator);
            return new ConfigChangeResult(resultCode, bl2, arrayList);
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }

    public boolean configAddIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        Object object;
        Object object2;
        PasswordGenerator passwordGenerator;
        StringConfigAttribute stringConfigAttribute;
        Object object3;
        assert (Debug.debugEnter(CLASS_NAME, "configAddIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        DN dN = configEntry.getDN();
        if (this.passwordGenerators.containsKey(dN)) {
            int n = 3342842;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            stringBuilder.append(string);
            return false;
        }
        if (!configEntry.hasObjectClass("ds-cfg-password-generator")) {
            int n = 3408368;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
            stringBuilder.append(string);
            return false;
        }
        try {
            object3 = new StringConfigAttribute("ds-cfg-password-generator-class", MessageHandler.getMessage(3146225), true, false, true);
            stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object3);
            if (stringConfigAttribute == null) {
                int n = 3408370;
                String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
                stringBuilder.append(string);
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            int n = 3408371;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        try {
            object3 = Class.forName(stringConfigAttribute.pendingValue());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            int n = 3408371;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        try {
            passwordGenerator = (PasswordGenerator)((Class)object3).newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            int n = 3408372;
            String string = MessageHandler.getMessage(n, ((Class)object3).getName(), String.valueOf(dN), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        if (passwordGenerator instanceof ConfigurableComponent && !(object2 = (ConfigurableComponent)((Object)passwordGenerator)).hasAcceptableConfiguration(configEntry, (List<String>)(object = new LinkedList()))) {
            if (((AbstractCollection)object).isEmpty()) {
                int n = 3408379;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN)));
            } else {
                Iterator iterator = ((AbstractSequentialList)object).iterator();
                stringBuilder.append((String)iterator.next());
                while (iterator.hasNext()) {
                    stringBuilder.append("  ");
                    stringBuilder.append((String)iterator.next());
                }
            }
            return false;
        }
        try {
            object = new BooleanConfigAttribute("ds-cfg-password-generator-enabled", MessageHandler.getMessage(3146229), false);
            object2 = (BooleanConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object);
            if (object2 == null) {
                int n = 3408374;
                String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
                stringBuilder.append(string);
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            int n = 3408375;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationAdd(ConfigEntry configEntry) {
        Object object;
        Object object2;
        Object object3;
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationAdd", String.valueOf(configEntry)));
        DN dN = configEntry.getDN();
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!configEntry.hasObjectClass("ds-cfg-password-generator")) {
            int n = 3408368;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
            resultCode = ResultCode.UNWILLING_TO_PERFORM;
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            object3 = new BooleanConfigAttribute("ds-cfg-password-generator-enabled", MessageHandler.getMessage(3146229), false);
            BooleanConfigAttribute booleanConfigAttribute = (BooleanConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object3);
            if (booleanConfigAttribute == null) {
                int n = 3408374;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.SUCCESS;
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            if (!booleanConfigAttribute.activeValue()) {
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            int n = 3408375;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            object2 = new StringConfigAttribute("ds-cfg-password-generator-class", MessageHandler.getMessage(3146225), true, false, true);
            object = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object2);
            if (object == null) {
                int n = 3408370;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            object3 = ((StringConfigAttribute)object).pendingValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            int n = 3408371;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            object = Class.forName((String)object3);
            object2 = (PasswordGenerator)((Class)object).newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            int n = 3408372;
            arrayList.add(MessageHandler.getMessage(n, object3, String.valueOf(dN), String.valueOf(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            ((PasswordGenerator)object2).initializePasswordGenerator(configEntry);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            int n = 3342841;
            arrayList.add(MessageHandler.getMessage(n, object3, String.valueOf(dN), String.valueOf(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        this.passwordGenerators.put(dN, (PasswordGenerator)object2);
        DirectoryServer.registerPasswordGenerator(dN, (PasswordGenerator)object2);
        return new ConfigChangeResult(resultCode, bl, arrayList);
    }

    public boolean configDeleteIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "configDeleteIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        return true;
    }

    public ConfigChangeResult applyConfigurationDelete(ConfigEntry configEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationDelete", String.valueOf(configEntry)));
        DN dN = configEntry.getDN();
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        PasswordGenerator passwordGenerator = this.passwordGenerators.remove(dN);
        if (passwordGenerator != null) {
            DirectoryServer.deregisterPasswordGenerator(dN);
            passwordGenerator.finalizePasswordGenerator();
        }
        return new ConfigChangeResult(resultCode, bl);
    }
}

