/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.AbstractCollection;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.api.AccessLogger;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.api.ConfigHandler;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.DebugLogger;
import org.opends.server.api.ErrorLogger;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Access;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.loggers.StartupDebugLogger;
import org.opends.server.loggers.StartupErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.ServerConstants;

public class LoggerConfigManager
implements ConfigChangeListener,
ConfigAddListener,
ConfigDeleteListener {
    private static final String CLASS_NAME = "org.opends.server.core.LoggerConfigManager";
    private ConcurrentHashMap<DN, AccessLogger> activeAccessLoggers;
    private ConcurrentHashMap<DN, DebugLogger> activeDebugLoggers;
    private ConcurrentHashMap<DN, ErrorLogger> activeErrorLoggers;
    private ConfigHandler configHandler;

    public LoggerConfigManager() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.configHandler = DirectoryServer.getConfigHandler();
        this.activeAccessLoggers = new ConcurrentHashMap();
        this.activeDebugLoggers = new ConcurrentHashMap();
        this.activeErrorLoggers = new ConcurrentHashMap();
    }

    public void initializeLoggers() throws ConfigException, InitializationException {
        ConfigEntry configEntry;
        assert (Debug.debugEnter(CLASS_NAME, "initializeLoggers", new String[0]));
        try {
            DN dN = DN.decode("cn=Loggers,cn=config");
            configEntry = this.configHandler.getConfigEntry(dN);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeLoggers", exception));
            int n = 3473450;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new ConfigException(n, string, exception);
        }
        if (configEntry == null) {
            int n = 3276843;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        configEntry.registerAddListener(this);
        configEntry.registerDeleteListener(this);
        if (!configEntry.hasChildren()) {
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 3276844);
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 3276845);
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_WARNING, 3211310);
            return;
        }
        for (ConfigEntry configEntry2 : configEntry.getChildren().values()) {
            configEntry2.registerChangeListener(this);
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.configAddIsAcceptable(configEntry2, stringBuilder)) {
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3407919, configEntry2.getDN().toString(), stringBuilder.toString());
                continue;
            }
            try {
                ConfigChangeResult configChangeResult = this.applyConfigurationAdd(configEntry2);
                if (configChangeResult.getResultCode() == ResultCode.SUCCESS) continue;
                StringBuilder stringBuilder2 = new StringBuilder();
                List<String> list = configChangeResult.getMessages();
                if (list == null || list.isEmpty()) {
                    stringBuilder2.append(MessageHandler.getMessage(0x300030));
                } else {
                    Iterator<String> iterator = list.iterator();
                    stringBuilder2.append(iterator.next());
                    while (iterator.hasNext()) {
                        stringBuilder2.append(ServerConstants.EOL);
                        stringBuilder2.append(iterator.next());
                    }
                }
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3407921, configEntry2.getDN().toString(), stringBuilder2.toString());
            }
            catch (Exception exception) {
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3407921, configEntry2.getDN().toString(), String.valueOf(exception));
            }
        }
        if (this.activeAccessLoggers.isEmpty()) {
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 3276844);
        }
        if (this.activeErrorLoggers.isEmpty()) {
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 3276845);
        }
        if (this.activeDebugLoggers.isEmpty()) {
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_WARNING, 3211310);
        }
    }

    public void stopLoggers() {
        assert (Debug.debugEnter(CLASS_NAME, "stopLoggers", new String[0]));
        StartupErrorLogger startupErrorLogger = new StartupErrorLogger();
        startupErrorLogger.initializeErrorLogger(null);
        Error.removeAllErrorLoggers(true);
        Error.addErrorLogger(startupErrorLogger);
        StartupDebugLogger startupDebugLogger = new StartupDebugLogger();
        startupDebugLogger.initializeDebugLogger(null);
        Debug.removeAllDebugLoggers(true);
        Debug.addDebugLogger(startupDebugLogger);
    }

    public boolean configChangeIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        Object object;
        StringConfigAttribute stringConfigAttribute;
        Object object2;
        assert (Debug.debugEnter(CLASS_NAME, "configChangeIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (configEntry.hasObjectClass("ds-cfg-access-logger")) {
            bl = true;
        } else if (configEntry.hasObjectClass("ds-cfg-error-logger")) {
            bl2 = true;
        } else if (configEntry.hasObjectClass("ds-cfg-debug-logger")) {
            bl3 = true;
        } else {
            int n = 3407922;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
            stringBuilder.append(string);
            return false;
        }
        try {
            object2 = new StringConfigAttribute("ds-cfg-logger-class", MessageHandler.getMessage(0x300033), true, false, true);
            stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object2);
            if (stringConfigAttribute == null) {
                int n = 0x340034;
                String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
                stringBuilder.append(string);
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            int n = 3407925;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        try {
            object2 = Class.forName(stringConfigAttribute.pendingValue());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            int n = 3407925;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        if (bl) {
            try {
                object = (AccessLogger)((Class)object2).newInstance();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
                int n = 3407926;
                String string = MessageHandler.getMessage(n, ((Class)object2).getName(), configEntry.getDN().toString(), String.valueOf(exception));
                stringBuilder.append(string);
                return false;
            }
        }
        if (bl2) {
            try {
                object = (ErrorLogger)((Class)object2).newInstance();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
                int n = 3407927;
                String string = MessageHandler.getMessage(n, ((Class)object2).getName(), configEntry.getDN().toString(), String.valueOf(exception));
                stringBuilder.append(string);
                return false;
            }
        }
        if (bl3) {
            try {
                object = (DebugLogger)((Class)object2).newInstance();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
                int n = 3407928;
                String string = MessageHandler.getMessage(n, ((Class)object2).getName(), configEntry.getDN().toString(), String.valueOf(exception));
                stringBuilder.append(string);
                return false;
            }
        }
        try {
            BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-logger-enabled", MessageHandler.getMessage(0x300039), false);
            object = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (object == null) {
                int n = 3407930;
                String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
                stringBuilder.append(string);
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            int n = 3407931;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationChange(ConfigEntry configEntry) {
        Object object;
        Object object2;
        boolean bl;
        DebugLogger debugLogger;
        ErrorLogger errorLogger;
        AccessLogger accessLogger;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        ArrayList<String> arrayList;
        boolean bl5;
        ResultCode resultCode;
        DN dN;
        block56: {
            assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationChange", String.valueOf(configEntry)));
            dN = configEntry.getDN();
            resultCode = ResultCode.SUCCESS;
            bl5 = false;
            arrayList = new ArrayList<String>();
            bl4 = false;
            bl3 = false;
            bl2 = false;
            if (configEntry.hasObjectClass("ds-cfg-access-logger")) {
                bl4 = true;
            } else if (configEntry.hasObjectClass("ds-cfg-error-logger")) {
                bl3 = true;
            } else if (configEntry.hasObjectClass("ds-cfg-debug-logger")) {
                bl2 = true;
            } else {
                int n = 3407922;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.UNWILLING_TO_PERFORM;
                return new ConfigChangeResult(resultCode, bl5, arrayList);
            }
            boolean bl6 = false;
            accessLogger = null;
            errorLogger = null;
            debugLogger = null;
            if (bl4) {
                accessLogger = this.activeAccessLoggers.get(dN);
                bl6 = accessLogger != null;
            } else if (bl3) {
                errorLogger = this.activeErrorLoggers.get(dN);
                bl6 = errorLogger != null;
            } else if (bl2) {
                debugLogger = this.activeDebugLoggers.get(dN);
                bl6 = debugLogger != null;
            }
            bl = false;
            try {
                object2 = new BooleanConfigAttribute("ds-cfg-logger-enabled", MessageHandler.getMessage(0x300039), false);
                BooleanConfigAttribute booleanConfigAttribute = (BooleanConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object2);
                if (booleanConfigAttribute == null) {
                    int n = 3407930;
                    arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                    resultCode = ResultCode.UNWILLING_TO_PERFORM;
                    return new ConfigChangeResult(resultCode, bl5, arrayList);
                }
                if (booleanConfigAttribute.activeValue()) {
                    if (!bl6) {
                        bl = true;
                    }
                    break block56;
                }
                if (bl6) {
                    if (bl4) {
                        this.activeAccessLoggers.remove(dN);
                        accessLogger.closeAccessLogger();
                    } else if (bl3) {
                        this.activeErrorLoggers.remove(dN);
                        errorLogger.closeErrorLogger();
                    } else if (bl2) {
                        this.activeDebugLoggers.remove(dN);
                        debugLogger.closeDebugLogger();
                    }
                    return new ConfigChangeResult(resultCode, bl5, arrayList);
                }
                return new ConfigChangeResult(resultCode, bl5, arrayList);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
                int n = 3407931;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, bl5, arrayList);
            }
        }
        try {
            StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-logger-class", MessageHandler.getMessage(0x300033), true, false, true);
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object == null) {
                int n = 0x340034;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                return new ConfigChangeResult(resultCode, bl5, arrayList);
            }
            object2 = ((StringConfigAttribute)object).pendingValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            int n = 3407925;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl5, arrayList);
        }
        boolean bl7 = false;
        object = null;
        if (!(bl || accessLogger == null && errorLogger == null && debugLogger == null)) {
            if (bl4) {
                object = accessLogger.getClass().getName();
                bl7 = !((String)object2).equals(object);
            } else if (bl3) {
                object = errorLogger.getClass().getName();
                bl7 = !((String)object2).equals(object);
            } else if (bl2) {
                object = debugLogger.getClass().getName();
                boolean bl8 = bl7 = !((String)object2).equals(object);
            }
        }
        if (bl7) {
            bl5 = true;
            arrayList.add(MessageHandler.getMessage(3145850, String.valueOf(object), String.valueOf(object2), String.valueOf(dN)));
            return new ConfigChangeResult(resultCode, bl5, arrayList);
        }
        if (bl) {
            if (bl4) {
                try {
                    Class<?> clazz = Class.forName((String)object2);
                    accessLogger = (AccessLogger)clazz.newInstance();
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                    int n = 3407926;
                    arrayList.add(MessageHandler.getMessage(n, object2, String.valueOf(dN), String.valueOf(exception)));
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    return new ConfigChangeResult(resultCode, bl5, arrayList);
                }
                try {
                    accessLogger.initializeAccessLogger(configEntry);
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                    int n = 3342460;
                    arrayList.add(MessageHandler.getMessage(n, object2, String.valueOf(dN), String.valueOf(exception)));
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    return new ConfigChangeResult(resultCode, bl5, arrayList);
                }
                Access.addAccessLogger(accessLogger);
                this.activeAccessLoggers.put(dN, accessLogger);
                return new ConfigChangeResult(resultCode, bl5, arrayList);
            }
            if (bl3) {
                try {
                    Class<?> clazz = Class.forName((String)object2);
                    errorLogger = (ErrorLogger)clazz.newInstance();
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                    int n = 3407927;
                    arrayList.add(MessageHandler.getMessage(n, object2, String.valueOf(dN), String.valueOf(exception)));
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    return new ConfigChangeResult(resultCode, bl5, arrayList);
                }
                try {
                    errorLogger.initializeErrorLogger(configEntry);
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                    int n = 3342461;
                    arrayList.add(MessageHandler.getMessage(n, object2, String.valueOf(dN), String.valueOf(exception)));
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    return new ConfigChangeResult(resultCode, bl5, arrayList);
                }
                Error.addErrorLogger(errorLogger);
                this.activeErrorLoggers.put(dN, errorLogger);
                return new ConfigChangeResult(resultCode, bl5, arrayList);
            }
            try {
                Class<?> clazz = Class.forName((String)object2);
                debugLogger = (DebugLogger)clazz.newInstance();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                int n = 3407928;
                arrayList.add(MessageHandler.getMessage(n, object2, String.valueOf(dN), String.valueOf(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, bl5, arrayList);
            }
            try {
                debugLogger.initializeDebugLogger(configEntry);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                int n = 3342462;
                arrayList.add(MessageHandler.getMessage(n, object2, String.valueOf(dN), String.valueOf(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, bl5, arrayList);
            }
            Debug.addDebugLogger(debugLogger);
            this.activeDebugLoggers.put(dN, debugLogger);
            return new ConfigChangeResult(resultCode, bl5, arrayList);
        }
        return new ConfigChangeResult(resultCode, bl5, arrayList);
    }

    public boolean configAddIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        Object object;
        Object object2;
        StringConfigAttribute stringConfigAttribute;
        Object object3;
        assert (Debug.debugEnter(CLASS_NAME, "configAddIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        DN dN = configEntry.getDN();
        if (this.activeAccessLoggers.containsKey(dN) || this.activeErrorLoggers.containsKey(dN) || this.activeDebugLoggers.containsKey(dN)) {
            int n = 3342459;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            stringBuilder.append(string);
            return false;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (configEntry.hasObjectClass("ds-cfg-access-logger")) {
            bl = true;
        } else if (configEntry.hasObjectClass("ds-cfg-error-logger")) {
            bl2 = true;
        } else if (configEntry.hasObjectClass("ds-cfg-debug-logger")) {
            bl3 = true;
        } else {
            int n = 3407922;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
            stringBuilder.append(string);
            return false;
        }
        try {
            object3 = new StringConfigAttribute("ds-cfg-logger-class", MessageHandler.getMessage(0x300033), true, false, true);
            stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object3);
            if (stringConfigAttribute == null) {
                int n = 0x340034;
                String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
                stringBuilder.append(string);
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            int n = 3407925;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        try {
            object3 = Class.forName(stringConfigAttribute.pendingValue());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            int n = 3407925;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        Object object4 = null;
        if (bl) {
            try {
                object4 = (AccessLogger)((Class)object3).newInstance();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
                int n = 3407926;
                String string = MessageHandler.getMessage(n, ((Class)object3).getName(), configEntry.getDN().toString(), String.valueOf(exception));
                stringBuilder.append(string);
                return false;
            }
        }
        if (bl2) {
            try {
                object4 = (ErrorLogger)((Class)object3).newInstance();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
                int n = 3407927;
                String string = MessageHandler.getMessage(n, ((Class)object3).getName(), configEntry.getDN().toString(), String.valueOf(exception));
                stringBuilder.append(string);
                return false;
            }
        }
        if (bl3) {
            try {
                object4 = (DebugLogger)((Class)object3).newInstance();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
                int n = 3407928;
                String string = MessageHandler.getMessage(n, ((Class)object3).getName(), configEntry.getDN().toString(), String.valueOf(exception));
                stringBuilder.append(string);
                return false;
            }
        }
        if (object4 instanceof ConfigurableComponent && !(object2 = (ConfigurableComponent)object4).hasAcceptableConfiguration(configEntry, (List<String>)(object = new LinkedList()))) {
            if (((AbstractCollection)object).isEmpty()) {
                int n = 3408030;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN)));
            } else {
                Iterator iterator = ((AbstractSequentialList)object).iterator();
                stringBuilder.append((String)iterator.next());
                while (iterator.hasNext()) {
                    stringBuilder.append("  ");
                    stringBuilder.append((String)iterator.next());
                }
            }
            return false;
        }
        try {
            object = new BooleanConfigAttribute("ds-cfg-logger-enabled", MessageHandler.getMessage(0x300039), false);
            object2 = (BooleanConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object);
            if (object2 == null) {
                int n = 3407930;
                String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
                stringBuilder.append(string);
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            int n = 3407931;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationAdd(ConfigEntry configEntry) {
        Class<?> clazz;
        Object object;
        Object object2;
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationAdd", String.valueOf(configEntry)));
        DN dN = configEntry.getDN();
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if (configEntry.hasObjectClass("ds-cfg-access-logger")) {
            bl2 = true;
        } else if (configEntry.hasObjectClass("ds-cfg-error-logger")) {
            bl3 = true;
        } else if (configEntry.hasObjectClass("ds-cfg-debug-logger")) {
            bl4 = true;
        } else {
            int n = 3407922;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
            resultCode = ResultCode.UNWILLING_TO_PERFORM;
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            object2 = new BooleanConfigAttribute("ds-cfg-logger-enabled", MessageHandler.getMessage(0x300039), false);
            BooleanConfigAttribute booleanConfigAttribute = (BooleanConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object2);
            if (booleanConfigAttribute == null) {
                int n = 3407930;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.SUCCESS;
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            if (!booleanConfigAttribute.activeValue()) {
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            int n = 3407931;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            object = new StringConfigAttribute("ds-cfg-logger-class", MessageHandler.getMessage(0x300033), true, false, true);
            clazz = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object);
            if (clazz == null) {
                int n = 0x340034;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            object2 = ((StringConfigAttribute)((Object)clazz)).pendingValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            int n = 3407925;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        if (bl2) {
            try {
                clazz = Class.forName((String)object2);
                object = (AccessLogger)clazz.newInstance();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
                int n = 3407926;
                arrayList.add(MessageHandler.getMessage(n, object2, String.valueOf(dN), String.valueOf(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            try {
                ((AccessLogger)object).initializeAccessLogger(configEntry);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
                int n = 3342460;
                arrayList.add(MessageHandler.getMessage(n, object2, String.valueOf(dN), String.valueOf(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            Access.addAccessLogger((AccessLogger)object);
            this.activeAccessLoggers.put(dN, (AccessLogger)object);
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        if (bl3) {
            try {
                clazz = Class.forName((String)object2);
                object = (ErrorLogger)clazz.newInstance();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
                int n = 3407927;
                arrayList.add(MessageHandler.getMessage(n, object2, String.valueOf(dN), String.valueOf(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            try {
                ((ErrorLogger)object).initializeErrorLogger(configEntry);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
                int n = 3342461;
                arrayList.add(MessageHandler.getMessage(n, object2, String.valueOf(dN), String.valueOf(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            Error.addErrorLogger((ErrorLogger)object);
            this.activeErrorLoggers.put(dN, (ErrorLogger)object);
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            clazz = Class.forName((String)object2);
            object = (DebugLogger)clazz.newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            int n = 3407928;
            arrayList.add(MessageHandler.getMessage(n, object2, String.valueOf(dN), String.valueOf(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            ((DebugLogger)object).initializeDebugLogger(configEntry);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            int n = 3342462;
            arrayList.add(MessageHandler.getMessage(n, object2, String.valueOf(dN), String.valueOf(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        Debug.addDebugLogger((DebugLogger)object);
        this.activeDebugLoggers.put(dN, (DebugLogger)object);
        return new ConfigChangeResult(resultCode, bl, arrayList);
    }

    public boolean configDeleteIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "configDeleteIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        return true;
    }

    public ConfigChangeResult applyConfigurationDelete(ConfigEntry configEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationDelete", String.valueOf(configEntry)));
        DN dN = configEntry.getDN();
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        AccessLogger accessLogger = this.activeAccessLoggers.remove(dN);
        if (accessLogger != null) {
            Access.removeAccessLogger(accessLogger);
            accessLogger.closeAccessLogger();
            return new ConfigChangeResult(resultCode, bl);
        }
        ErrorLogger errorLogger = this.activeErrorLoggers.remove(dN);
        if (errorLogger != null) {
            Error.removeErrorLogger(errorLogger);
            errorLogger.closeErrorLogger();
            return new ConfigChangeResult(resultCode, bl);
        }
        DebugLogger debugLogger = this.activeDebugLoggers.remove(dN);
        if (debugLogger != null) {
            Debug.removeDebugLogger(debugLogger);
            debugLogger.closeDebugLogger();
            return new ConfigChangeResult(resultCode, bl);
        }
        return new ConfigChangeResult(resultCode, bl);
    }
}

