/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.api.KeyManagerProvider;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.extensions.NullKeyManagerProvider;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class KeyManagerProviderConfigManager
implements ConfigChangeListener,
ConfigAddListener,
ConfigDeleteListener {
    private static final String CLASS_NAME = "org.opends.server.core.KeyManagerProviderConfigManager";

    public KeyManagerProviderConfigManager() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeKeyManagerProvider() throws InitializationException {
        KeyManagerProvider keyManagerProvider;
        Object object;
        Object object2;
        Object object3;
        ConfigEntry configEntry;
        Object object4;
        assert (Debug.debugEnter(CLASS_NAME, "initializeKeyManagerProvider", new String[0]));
        try {
            object4 = new NullKeyManagerProvider();
            ((NullKeyManagerProvider)object4).initializeKeyManagerProvider(null);
            DirectoryServer.setKeyManagerProvider((KeyManagerProvider)object4);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
            int n = 3408180;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string, exception);
        }
        try {
            object4 = DN.decode("cn=Key Manager Provider,cn=SSL,cn=config");
            configEntry = DirectoryServer.getConfigEntry((DN)object4);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408181, StaticUtils.stackTraceToSingleLineString(exception));
            return;
        }
        if (configEntry == null) {
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 3408182);
            try {
                ConfigEntry configEntry2 = DirectoryServer.getConfigEntry(((DN)object4).getParentDNInSuffix());
                if (configEntry2 != null) {
                    configEntry2.registerAddListener(this);
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408183, StaticUtils.stackTraceToSingleLineString(exception));
            }
            return;
        }
        configEntry.registerChangeListener(this);
        try {
            DN dN = ((DN)object4).getParentDNInSuffix();
            object3 = DirectoryServer.getConfigEntry(dN);
            if (object3 != null) {
                ((ConfigEntry)object3).registerDeleteListener(this);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 3408184, StaticUtils.stackTraceToSingleLineString(exception));
        }
        int n = 3408185;
        object3 = new BooleanConfigAttribute("ds-cfg-key-manager-provider-enabled", MessageHandler.getMessage(n), false);
        try {
            object2 = (BooleanConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object3);
            if (object2 == null) {
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 3408186);
                return;
            }
            if (!((BooleanConfigAttribute)object2).activeValue()) {
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_WARNING, 3408187);
                return;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408188, StaticUtils.stackTraceToSingleLineString(exception));
            return;
        }
        n = 3408189;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-key-manager-provider-class", MessageHandler.getMessage(n), true, false, false);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object == null) {
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408190);
                return;
            }
            object2 = ((StringConfigAttribute)object).activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408191, StaticUtils.stackTraceToSingleLineString(exception));
            return;
        }
        try {
            object = Class.forName((String)object2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408192, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception));
            return;
        }
        try {
            keyManagerProvider = (KeyManagerProvider)((Class)object).newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408193, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception));
            return;
        }
        try {
            keyManagerProvider.initializeKeyManagerProvider(configEntry);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeKeyManagerProvider", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408194, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception));
            return;
        }
        DirectoryServer.setKeyManagerProvider(keyManagerProvider);
    }

    public boolean configChangeIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        Object object;
        Object object2;
        assert (Debug.debugEnter(CLASS_NAME, "configChangeIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        int n = 3408185;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-key-manager-provider-enabled", MessageHandler.getMessage(n), false);
        try {
            object2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (object2 == null) {
                n = 3408186;
                stringBuilder.append(MessageHandler.getMessage(n));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            n = 3408188;
            stringBuilder.append(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        n = 3408189;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-key-manager-provider-class", MessageHandler.getMessage(n), true, false, false);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object == null) {
                n = 3408190;
                stringBuilder.append(MessageHandler.getMessage(n));
                return false;
            }
            object2 = ((StringConfigAttribute)object).activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            n = 3408191;
            stringBuilder.append(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        try {
            object = Class.forName((String)object2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            n = 3408192;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        try {
            KeyManagerProvider keyManagerProvider = (KeyManagerProvider)((Class)object).newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            n = 3408193;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationChange(ConfigEntry configEntry) {
        KeyManagerProvider keyManagerProvider;
        Object object;
        Object object2;
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationChange", String.valueOf(configEntry)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl2 = false;
        String string = null;
        int n = 3408185;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-key-manager-provider-enabled", MessageHandler.getMessage(n), false);
        try {
            object2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (object2 == null) {
                n = 3408186;
                arrayList.add(MessageHandler.getMessage(n));
                resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            if (!((BooleanConfigAttribute)object2).pendingValue()) {
                DirectoryServer.getKeyManagerProvider().finalizeKeyManagerProvider();
                try {
                    NullKeyManagerProvider nullKeyManagerProvider = new NullKeyManagerProvider();
                    nullKeyManagerProvider.initializeKeyManagerProvider(null);
                    DirectoryServer.setKeyManagerProvider(nullKeyManagerProvider);
                    return new ConfigChangeResult(resultCode, bl, arrayList);
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                    n = 3408180;
                    arrayList.add(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
                    resultCode = DirectoryServer.getServerErrorResultCode();
                    return new ConfigChangeResult(resultCode, bl, arrayList);
                }
            }
            if (DirectoryServer.getKeyManagerProvider() instanceof NullKeyManagerProvider) {
                bl2 = true;
            } else {
                string = DirectoryServer.getKeyManagerProvider().getClass().getName();
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
            n = 3408188;
            arrayList.add(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        n = 3408189;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-key-manager-provider-class", MessageHandler.getMessage(n), true, false, false);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object == null) {
                n = 3408190;
                arrayList.add(MessageHandler.getMessage(n));
                resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            object2 = ((StringConfigAttribute)object).activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
            n = 3408191;
            arrayList.add(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        if (!bl2) {
            if (!((String)object2).equals(string)) {
                n = 3342674;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(string), String.valueOf(object2)));
                resultCode = ResultCode.UNWILLING_TO_PERFORM;
                bl = true;
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            object = Class.forName((String)object2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
            n = 3408192;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            keyManagerProvider = (KeyManagerProvider)((Class)object).newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
            n = 3408193;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            keyManagerProvider.initializeKeyManagerProvider(configEntry);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
            n = 3408194;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        DirectoryServer.setKeyManagerProvider(keyManagerProvider);
        return new ConfigChangeResult(resultCode, bl, arrayList);
    }

    public boolean configAddIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        Object object;
        Object object2;
        DN dN;
        assert (Debug.debugEnter(CLASS_NAME, "configAddIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        DN dN2 = configEntry.getDN();
        try {
            dN = DN.decode("cn=Key Manager Provider,cn=SSL,cn=config");
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", directoryException));
            stringBuilder.append(directoryException.getErrorMessage());
            return false;
        }
        if (!dN2.equals(dN)) {
            return true;
        }
        int n = 3408185;
        BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-key-manager-provider-enabled", MessageHandler.getMessage(n), false);
        try {
            object2 = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (object2 == null) {
                n = 3408186;
                stringBuilder.append(MessageHandler.getMessage(n));
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            n = 3408188;
            stringBuilder.append(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        n = 3408189;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-key-manager-provider-class", MessageHandler.getMessage(n), true, false, false);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object == null) {
                n = 3408190;
                stringBuilder.append(MessageHandler.getMessage(n));
                return false;
            }
            object2 = ((StringConfigAttribute)object).activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            n = 3408191;
            stringBuilder.append(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        try {
            object = Class.forName((String)object2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            n = 3408192;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        try {
            KeyManagerProvider keyManagerProvider = (KeyManagerProvider)((Class)object).newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            n = 3408193;
            stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationAdd(ConfigEntry configEntry) {
        KeyManagerProvider keyManagerProvider;
        Object object;
        Object object2;
        Object object3;
        DN dN;
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationAdd", String.valueOf(configEntry)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        DN dN2 = configEntry.getDN();
        try {
            dN = DN.decode("cn=Key Manager Provider,cn=SSL,cn=config");
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", directoryException));
            arrayList.add(directoryException.getErrorMessage());
            resultCode = directoryException.getResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        if (!dN2.equals(dN)) {
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        configEntry.registerChangeListener(this);
        try {
            DN dN3 = configEntry.getDN().getParentDNInSuffix();
            object3 = DirectoryServer.getConfigEntry(dN3);
            if (object3 != null) {
                ((ConfigEntry)object3).registerDeleteListener(this);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_WARNING, 3408184, StaticUtils.stackTraceToSingleLineString(exception));
        }
        int n = 3408185;
        object3 = new BooleanConfigAttribute("ds-cfg-key-manager-provider-enabled", MessageHandler.getMessage(n), false);
        try {
            object2 = (BooleanConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object3);
            if (object2 == null) {
                arrayList.add(MessageHandler.getMessage(3408186));
                resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            if (!((BooleanConfigAttribute)object2).activeValue()) {
                arrayList.add(MessageHandler.getMessage(3408187));
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            n = 3408188;
            arrayList.add(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        n = 3408189;
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-key-manager-provider-class", MessageHandler.getMessage(n), true, false, false);
        try {
            object = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (object == null) {
                arrayList.add(MessageHandler.getMessage(3408190));
                resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            object2 = ((StringConfigAttribute)object).activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            n = 3408191;
            arrayList.add(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            object = Class.forName((String)object2);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            n = 3408192;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            keyManagerProvider = (KeyManagerProvider)((Class)object).newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            n = 3408193;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            keyManagerProvider.initializeKeyManagerProvider(configEntry);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            n = 3408194;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(object2), StaticUtils.stackTraceToSingleLineString(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        DirectoryServer.setKeyManagerProvider(keyManagerProvider);
        return new ConfigChangeResult(resultCode, bl, arrayList);
    }

    public boolean configDeleteIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        DN dN;
        assert (Debug.debugEnter(CLASS_NAME, "configDeleteIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        DN dN2 = configEntry.getDN();
        try {
            dN = DN.decode("cn=Key Manager Provider,cn=SSL,cn=config");
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", directoryException));
            stringBuilder.append(directoryException.getErrorMessage());
            return false;
        }
        if (!dN2.equals(dN)) {
            return true;
        }
        KeyManagerProvider keyManagerProvider = DirectoryServer.getKeyManagerProvider();
        if (!(keyManagerProvider instanceof NullKeyManagerProvider)) {
            int n = 3342675;
            stringBuilder.append(MessageHandler.getMessage(n, keyManagerProvider.getClass().getName()));
            return false;
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationDelete(ConfigEntry configEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationDelete", String.valueOf(configEntry)));
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        return new ConfigChangeResult(resultCode, bl, arrayList);
    }
}

