/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import org.opends.server.api.ClientConnection;
import org.opends.server.controls.AuthorizationIdentityResponseControl;
import org.opends.server.controls.PasswordExpiredControl;
import org.opends.server.controls.PasswordExpiringControl;
import org.opends.server.controls.PasswordPolicyErrorType;
import org.opends.server.controls.PasswordPolicyResponseControl;
import org.opends.server.controls.PasswordPolicyWarningType;
import org.opends.server.core.AccessControlConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.Operation;
import org.opends.server.core.PasswordPolicyState;
import org.opends.server.loggers.Access;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AccountStatusNotificationType;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.AuthenticationInfo;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.LockManager;
import org.opends.server.types.OperationType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.operation.PostOperationBindOperation;
import org.opends.server.types.operation.PostResponseBindOperation;
import org.opends.server.types.operation.PreOperationBindOperation;
import org.opends.server.types.operation.PreParseBindOperation;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindOperation
extends Operation
implements PreParseBindOperation,
PreOperationBindOperation,
PostOperationBindOperation,
PostResponseBindOperation {
    private static final String CLASS_NAME = "org.opends.server.core.BindOperation";
    private ASN1OctetString saslCredentials;
    private ASN1OctetString serverSASLCredentials;
    private AuthenticationType authType;
    private boolean isFirstWarning;
    private boolean isGraceLogin;
    private boolean mustChangePassword;
    private boolean pwPolicyControlRequested;
    private ByteString rawBindDN;
    private ByteString simplePassword;
    private DN bindDN;
    private DN userEntryDN;
    private Entry saslAuthUserEntry;
    private int authFailureID;
    private int pwPolicyWarningValue;
    private List<Control> responseControls;
    private long processingStartTime;
    private long processingStopTime;
    PasswordPolicyErrorType pwPolicyErrorType;
    PasswordPolicyWarningType pwPolicyWarningType;
    private PasswordPolicyState pwPolicyState;
    private String authFailureReason;
    private String saslMechanism;

    public BindOperation(ClientConnection clientConnection, long l, int n, List<Control> list, ByteString byteString, ByteString byteString2) {
        super(clientConnection, l, n, list);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(n), String.valueOf(list), String.valueOf(byteString), String.valueOf(byteString2)));
        this.authType = AuthenticationType.SIMPLE;
        this.saslMechanism = null;
        this.saslCredentials = null;
        this.rawBindDN = byteString == null ? new ASN1OctetString() : byteString;
        this.simplePassword = byteString2 == null ? new ASN1OctetString() : byteString2;
        this.bindDN = null;
        this.userEntryDN = null;
        this.responseControls = new ArrayList<Control>(0);
        this.authFailureID = 0;
        this.authFailureReason = null;
        this.saslAuthUserEntry = null;
        this.isFirstWarning = false;
        this.isGraceLogin = false;
        this.mustChangePassword = false;
        this.pwPolicyControlRequested = false;
        this.pwPolicyErrorType = null;
        this.pwPolicyWarningType = null;
        this.pwPolicyWarningValue = -1;
    }

    public BindOperation(ClientConnection clientConnection, long l, int n, List<Control> list, ByteString byteString, String string, ASN1OctetString aSN1OctetString) {
        super(clientConnection, l, n, list);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(l), String.valueOf(n), String.valueOf(list), String.valueOf(byteString), String.valueOf(string), String.valueOf(aSN1OctetString)));
        this.authType = AuthenticationType.SASL;
        this.saslMechanism = string;
        this.saslCredentials = aSN1OctetString;
        this.simplePassword = null;
        this.rawBindDN = byteString == null ? new ASN1OctetString() : byteString;
        this.bindDN = null;
        this.userEntryDN = null;
        this.responseControls = new ArrayList<Control>(0);
        this.authFailureID = 0;
        this.authFailureReason = null;
        this.saslAuthUserEntry = null;
    }

    public BindOperation(ClientConnection clientConnection, long l, int n, List<Control> list, DN dN, ByteString byteString) {
        super(clientConnection, l, n, list);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(n), String.valueOf(list), String.valueOf(dN), String.valueOf(byteString)));
        this.authType = AuthenticationType.SIMPLE;
        this.bindDN = dN;
        this.saslMechanism = null;
        this.saslCredentials = null;
        this.rawBindDN = dN == null ? new ASN1OctetString() : new ASN1OctetString(dN.toString());
        this.simplePassword = byteString == null ? new ASN1OctetString() : byteString;
        this.responseControls = new ArrayList<Control>(0);
        this.authFailureID = 0;
        this.authFailureReason = null;
        this.saslAuthUserEntry = null;
        this.isFirstWarning = false;
        this.isGraceLogin = false;
        this.mustChangePassword = false;
        this.pwPolicyControlRequested = false;
        this.pwPolicyErrorType = null;
        this.pwPolicyWarningType = null;
        this.pwPolicyWarningValue = -1;
        this.userEntryDN = null;
    }

    public BindOperation(ClientConnection clientConnection, long l, int n, List<Control> list, DN dN, String string, ASN1OctetString aSN1OctetString) {
        super(clientConnection, l, n, list);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(l), String.valueOf(n), String.valueOf(list), String.valueOf(dN), String.valueOf(string), String.valueOf(aSN1OctetString)));
        this.authType = AuthenticationType.SASL;
        this.bindDN = dN;
        this.saslMechanism = string;
        this.saslCredentials = aSN1OctetString;
        this.simplePassword = null;
        this.rawBindDN = dN == null ? new ASN1OctetString() : new ASN1OctetString(dN.toString());
        this.responseControls = new ArrayList<Control>(0);
        this.authFailureID = 0;
        this.authFailureReason = null;
        this.saslAuthUserEntry = null;
        this.userEntryDN = null;
    }

    @Override
    public final AuthenticationType getAuthenticationType() {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthenticationType", new String[0]));
        return this.authType;
    }

    @Override
    public final ByteString getRawBindDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getRawBindDN", new String[0]));
        return this.rawBindDN;
    }

    @Override
    public final void setRawBindDN(ByteString byteString) {
        assert (Debug.debugEnter(CLASS_NAME, "setRawBindDN", String.valueOf(byteString)));
        this.rawBindDN = byteString == null ? new ASN1OctetString() : byteString;
        this.bindDN = null;
    }

    @Override
    public final DN getBindDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getBindDN", new String[0]));
        return this.bindDN;
    }

    @Override
    public final ByteString getSimplePassword() {
        assert (Debug.debugEnter(CLASS_NAME, "getSimplePassword", new String[0]));
        return this.simplePassword;
    }

    @Override
    public final void setSimplePassword(ByteString byteString) {
        assert (Debug.debugEnter(CLASS_NAME, "setSimplePassword", String.valueOf(byteString)));
        this.simplePassword = byteString == null ? new ASN1OctetString() : byteString;
        this.authType = AuthenticationType.SIMPLE;
        this.saslMechanism = null;
        this.saslCredentials = null;
    }

    @Override
    public final String getSASLMechanism() {
        assert (Debug.debugEnter(CLASS_NAME, "getSASLMechanism", new String[0]));
        return this.saslMechanism;
    }

    @Override
    public final ASN1OctetString getSASLCredentials() {
        assert (Debug.debugEnter(CLASS_NAME, "getSASLCredentials", new String[0]));
        return this.saslCredentials;
    }

    @Override
    public final void setSASLCredentials(String string, ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setSASLCredentials", String.valueOf(aSN1OctetString)));
        this.saslMechanism = string;
        this.saslCredentials = aSN1OctetString;
        this.authType = AuthenticationType.SASL;
        this.simplePassword = null;
    }

    @Override
    public final ASN1OctetString getServerSASLCredentials() {
        assert (Debug.debugEnter(CLASS_NAME, "getServerSASLCredentials", new String[0]));
        return this.serverSASLCredentials;
    }

    @Override
    public final void setServerSASLCredentials(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setServerSASLCredentials", String.valueOf(aSN1OctetString)));
        this.serverSASLCredentials = aSN1OctetString;
    }

    @Override
    public final Entry getSASLAuthUserEntry() {
        assert (Debug.debugEnter(CLASS_NAME, "getSASLAuthUserEntry", new String[0]));
        return this.saslAuthUserEntry;
    }

    public final void setSASLAuthUserEntry(Entry entry) {
        assert (Debug.debugEnter(CLASS_NAME, "setSASLAuthUserEntry", String.valueOf(entry)));
        this.saslAuthUserEntry = entry;
    }

    @Override
    public final String getAuthFailureReason() {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthFailureReason", new String[0]));
        return this.authFailureReason;
    }

    @Override
    public final int getAuthFailureID() {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthFailureID", new String[0]));
        return this.authFailureID;
    }

    @Override
    public final void setAuthFailureReason(int n, String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setAuthFailureReason", String.valueOf(n), String.valueOf(string)));
        this.authFailureID = n < 0 ? 0 : n;
        this.authFailureReason = string;
    }

    @Override
    public final DN getUserEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getUserEntryDN", new String[0]));
        return this.userEntryDN;
    }

    @Override
    public final long getProcessingStartTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingStartTime", new String[0]));
        return this.processingStartTime;
    }

    @Override
    public final long getProcessingStopTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingStopTime", new String[0]));
        return this.processingStopTime;
    }

    @Override
    public final long getProcessingTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getProcessingTime", new String[0]));
        return this.processingStopTime - this.processingStartTime;
    }

    @Override
    public final OperationType getOperationType() {
        return OperationType.BIND;
    }

    @Override
    public final void disconnectClient(DisconnectReason disconnectReason, boolean bl, String string, int n) {
        this.clientConnection.disconnect(disconnectReason, bl, string, n);
    }

    @Override
    public final String[][] getRequestLogElements() {
        if (this.authType == AuthenticationType.SASL) {
            return new String[][]{{"bindDN", String.valueOf(this.rawBindDN)}, {"authType", this.authType.toString()}, {"saslMechanism", this.saslMechanism}};
        }
        return new String[][]{{"bindDN", String.valueOf(this.rawBindDN)}, {"authType", this.authType.toString()}};
    }

    @Override
    public final String[][] getResponseLogElements() {
        CharSequence charSequence;
        String string;
        String string2 = String.valueOf(this.getResultCode().getIntValue());
        StringBuilder stringBuilder = this.getErrorMessage();
        String string3 = stringBuilder == null ? null : stringBuilder.toString();
        DN dN = this.getMatchedDN();
        String string4 = dN == null ? null : dN.toString();
        List<String> list = this.getReferralURLs();
        if (list == null || list.isEmpty()) {
            string = null;
        } else {
            charSequence = new StringBuilder();
            Iterator<String> iterator = list.iterator();
            ((StringBuilder)charSequence).append(iterator.next());
            while (iterator.hasNext()) {
                ((StringBuilder)charSequence).append(", ");
                ((StringBuilder)charSequence).append(iterator.next());
            }
            string = ((StringBuilder)charSequence).toString();
        }
        charSequence = String.valueOf(this.processingStopTime - this.processingStartTime);
        return new String[][]{{"resultCode", string2}, {"errorMessage", string3}, {"matchedDN", string4}, {"referralURLs", string}, {"processingTime", charSequence}};
    }

    @Override
    public final List<Control> getResponseControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getResponseControls", new String[0]));
        return this.responseControls;
    }

    @Override
    public final void addResponseControl(Control control) {
        this.responseControls.add(control);
    }

    @Override
    public final void removeResponseControl(Control control) {
        this.responseControls.remove(control);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public final void run() {
        block149: {
            block151: {
                block148: {
                    block150: {
                        if (!BindOperation.$assertionsDisabled && !Debug.debugEnter("org.opends.server.core.BindOperation", "run", new String[0])) {
                            throw new AssertionError();
                        }
                        this.processingStartTime = System.currentTimeMillis();
                        this.setResultCode(ResultCode.UNDEFINED);
                        var1_1 = false;
                        var2_2 = DirectoryServer.getSizeLimit();
                        var3_3 = DirectoryServer.getTimeLimit();
                        var4_4 = DirectoryServer.getLookthroughLimit();
                        this.clientConnection.setBindInProgress(true);
                        this.clientConnection.setUnauthenticated();
                        var5_5 = null;
                        var6_6 = MessageHandler.getMessage(217);
                        var7_7 = new CancelRequest(true, var6_6);
                        this.clientConnection.cancelAllOperationsExcept(var7_7, this.getMessageID());
                        var8_8 = DirectoryServer.getPluginConfigManager();
                        var9_9 = false;
                        var10_10 = var8_8.invokePreParseBindPlugins(this);
                        if (var10_10.connectionTerminated()) {
                            this.setResultCode(ResultCode.CANCELED);
                            var11_12 = 262368;
                            this.appendErrorMessage(MessageHandler.getMessage(var11_12));
                            this.processingStopTime = System.currentTimeMillis();
                            Access.logBindRequest(this);
                            Access.logBindResponse(this);
                            return;
                        }
                        if (!var10_10.sendResponseImmediately()) break block150;
                        var9_9 = true;
                        Access.logBindRequest(this);
                        break block149;
                    }
                    Access.logBindRequest(this);
                    try {
                        if (this.bindDN != null) break block148;
                        this.bindDN = DN.decode(this.rawBindDN);
                    }
                    catch (DirectoryException var11_13) {
                        if (!BindOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.core.BindOperation", "run", var11_13)) {
                            throw new AssertionError();
                        }
                        this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        this.setAuthFailureReason(var11_13.getErrorMessageID(), var11_13.getErrorMessage());
                        break block149;
                    }
                }
                if (AccessControlConfigManager.getInstance().getAccessControlHandler().isAllowed(this)) break block151;
                this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                var11_14 = 262653;
                var12_17 = MessageHandler.getMessage(var11_14, new Object[]{String.valueOf(this.bindDN)});
                this.setAuthFailureReason(var11_14, var12_17);
                var9_9 = true;
                break block149;
            }
            var11_15 = this.getRequestControls();
            if (var11_15 != null && !var11_15.isEmpty()) {
                for (var12_18 = 0; var12_18 < var11_15.size(); ++var12_18) {
                    var13_21 = var11_15.get(var12_18);
                    var14_23 = var13_21.getOID();
                    if (var14_23.equals("2.16.840.1.113730.3.4.16")) {
                        var1_1 = true;
                        continue;
                    }
                    if (var14_23.equals("1.3.6.1.4.1.42.2.27.8.5.1")) {
                        this.pwPolicyControlRequested = true;
                        continue;
                    }
                    if (!var13_21.isCritical()) continue;
                    this.setResultCode(ResultCode.UNAVAILABLE_CRITICAL_EXTENSION);
                    var15_28 = 262538;
                    this.appendErrorMessage(MessageHandler.getMessage(var15_28, new Object[]{String.valueOf(var14_23)}));
                    break block149;
                }
            }
            switch (1.$SwitchMap$org$opends$server$types$AuthenticationType[this.authType.ordinal()]) {
                case 1: {
                    if (this.simplePassword == null || this.simplePassword.value().length == 0) {
                        if (DirectoryServer.bindWithDNRequiresPassword() && this.bindDN != null && !this.bindDN.isNullDN()) {
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            var12_18 = 262565;
                            var13_21 = MessageHandler.getMessage(var12_18);
                            this.setAuthFailureReason(var12_18, (String)var13_21);
                            break;
                        }
                        var12_19 = var8_8.invokePreOperationBindPlugins(this);
                        if (var12_19.connectionTerminated()) {
                            this.setResultCode(ResultCode.CANCELED);
                            var13_22 = 262369;
                            this.appendErrorMessage(MessageHandler.getMessage(var13_22));
                            this.processingStopTime = System.currentTimeMillis();
                            Access.logBindResponse(this);
                            return;
                        }
                        if (var12_19.sendResponseImmediately()) {
                            var9_9 = true;
                            break;
                        }
                        this.setResultCode(ResultCode.SUCCESS);
                        var5_5 = new AuthenticationInfo();
                        break;
                    }
                    var12_20 = DirectoryServer.getActualRootBindDN(this.bindDN);
                    if (var12_20 != null) {
                        this.bindDN = var12_20;
                    }
                    var13_21 = null;
                    for (var14_24 = 0; var14_24 < 3 && (var13_21 = LockManager.lockRead(this.bindDN)) == null; ++var14_24) {
                    }
                    if (var13_21 == null) {
                        var14_24 = 262363;
                        var15_29 = MessageHandler.getMessage(var14_24, new Object[]{String.valueOf(this.bindDN)});
                        this.setResultCode(DirectoryServer.getServerErrorResultCode());
                        this.setAuthFailureReason(var14_24, var15_29);
                        break;
                    }
                    try {
                        try {
                            var14_25 = DirectoryServer.getEntry(this.bindDN);
                        }
                        catch (DirectoryException var15_30) {
                            if (!BindOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.core.BindOperation", "run", var15_30)) {
                                throw new AssertionError();
                            }
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(var15_30.getErrorMessageID(), var15_30.getErrorMessage());
                            var14_26 = null;
                            LockManager.unlock(this.bindDN, (Lock)var13_21);
                            break;
                        }
                        if (var14_25 == null) {
                            var15_31 = 196826;
                            var16_36 = MessageHandler.getMessage(var15_31, new Object[]{String.valueOf(this.bindDN)});
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(var15_31, var16_36);
                            break;
                        }
                        this.userEntryDN = var14_25.getDN();
                        this.pwPolicyState = new PasswordPolicyState(var14_25, false, false);
                        var15_32 = this.pwPolicyState.getPasswordAttribute();
                        var16_37 = var14_25.getAttribute(var15_32);
                        if (var16_37 == null || var16_37.isEmpty()) {
                            var17_41 = 196829;
                            var18_59 = MessageHandler.getMessage(var17_41, new Object[]{String.valueOf(this.bindDN)});
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(var17_41, var18_59);
                            break;
                        }
                        if (this.pwPolicyState.requireSecureAuthentication() && !this.clientConnection.isSecure()) {
                            var17_42 = 197124;
                            var18_60 = MessageHandler.getMessage(var17_42, new Object[]{String.valueOf(this.bindDN)});
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(var17_42, var18_60);
                            break;
                        }
                        if (this.pwPolicyState.isDisabled()) {
                            var17_43 = 197125;
                            var18_61 = MessageHandler.getMessage(var17_43, new Object[]{String.valueOf(this.bindDN)});
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(var17_43, var18_61);
                            break;
                        }
                        if (this.pwPolicyState.isAccountExpired()) {
                            var17_44 = 197139;
                            var18_62 = MessageHandler.getMessage(var17_44, new Object[]{String.valueOf(this.bindDN)});
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(var17_44, var18_62);
                            this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_EXPIRED, this.bindDN, var17_44, var18_62);
                            break;
                        }
                        if (this.pwPolicyState.lockedDueToFailures()) {
                            var17_45 = 197126;
                            var18_63 = MessageHandler.getMessage(var17_45, new Object[]{String.valueOf(this.bindDN)});
                            if (this.pwPolicyErrorType == null) {
                                this.pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                            }
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(var17_45, var18_63);
                            break;
                        }
                        if (this.pwPolicyState.lockedDueToMaximumResetAge()) {
                            var17_46 = 197127;
                            var18_64 = MessageHandler.getMessage(var17_46, new Object[]{String.valueOf(this.bindDN)});
                            if (this.pwPolicyErrorType == null) {
                                this.pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                            }
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(var17_46, var18_64);
                            this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_RESET_LOCKED, this.bindDN, var17_46, var18_64);
                            break;
                        }
                        if (this.pwPolicyState.lockedDueToIdleInterval()) {
                            var17_47 = 197128;
                            var18_65 = MessageHandler.getMessage(var17_47, new Object[]{String.valueOf(this.bindDN)});
                            if (this.pwPolicyErrorType == null) {
                                this.pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                            }
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(var17_47, var18_65);
                            this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_IDLE_LOCKED, this.bindDN, var17_47, var18_65);
                            break;
                        }
                        if (!this.pwPolicyState.isPasswordExpired()) ** GOTO lbl199
                        if (this.pwPolicyErrorType == null) {
                            this.pwPolicyErrorType = PasswordPolicyErrorType.PASSWORD_EXPIRED;
                        }
                        if ((var17_48 = this.pwPolicyState.getMaxAllowedGraceLogins()) <= 0 || !this.pwPolicyState.mayUseGraceLogin()) ** GOTO lbl193
                        var18_66 = this.pwPolicyState.getGraceLoginTimes();
                        if (var18_66 == null || var18_66.size() < var17_48) {
                            this.isGraceLogin = true;
                            this.mustChangePassword = true;
                            if (this.pwPolicyWarningType == null) {
                                this.pwPolicyWarningType = PasswordPolicyWarningType.GRACE_LOGINS_REMAINING;
                                this.pwPolicyWarningValue = var17_48 - (var18_66.size() + 1);
                            }
                        } else {
                            var19_82 = 197129;
                            var20_93 = MessageHandler.getMessage(var19_82, new Object[]{String.valueOf(this.bindDN)});
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(var19_82, var20_93);
                            this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRED, this.bindDN, var19_82, var20_93);
                            break;
lbl193:
                            // 1 sources

                            var18_67 = 197129;
                            var19_83 = MessageHandler.getMessage(var18_67, new Object[]{String.valueOf(this.bindDN)});
                            this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                            this.setAuthFailureReason(var18_67, var19_83);
                            this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRED, this.bindDN, var18_67, var19_83);
                            break;
lbl199:
                            // 1 sources

                            if (this.pwPolicyState.shouldWarn()) {
                                var17_48 = this.pwPolicyState.getSecondsUntilExpiration();
                                var18_66 = StaticUtils.secondsToTimeString(var17_48);
                                var19_84 = 66083;
                                var20_94 = MessageHandler.getMessage(var19_84, new Object[]{var18_66});
                                this.appendErrorMessage((String)var20_94);
                                if (this.pwPolicyWarningType == null) {
                                    this.pwPolicyWarningType = PasswordPolicyWarningType.TIME_BEFORE_EXPIRATION;
                                    this.pwPolicyWarningValue = var17_48;
                                }
                                this.isFirstWarning = this.pwPolicyState.isFirstWarning();
                            }
                        }
                        if (this.pwPolicyState.mustChangePassword()) {
                            this.mustChangePassword = true;
                            if (this.pwPolicyErrorType == null) {
                                this.pwPolicyErrorType = PasswordPolicyErrorType.CHANGE_AFTER_RESET;
                            }
                        }
                        if ((var17_49 = var8_8.invokePreOperationBindPlugins(this)).connectionTerminated()) {
                            this.setResultCode(ResultCode.CANCELED);
                            var18_68 = 262369;
                            this.appendErrorMessage(MessageHandler.getMessage(var18_68));
                            this.processingStopTime = System.currentTimeMillis();
                            Access.logBindResponse(this);
                            return;
                        }
                        if (var17_49.sendResponseImmediately()) {
                            var9_9 = true;
                            break;
                        }
                        if (this.pwPolicyState.passwordMatches(this.simplePassword)) {
                            this.setResultCode(ResultCode.SUCCESS);
                            var18_69 = DirectoryServer.isRootDN(var14_25.getDN());
                            var5_5 = new AuthenticationInfo(var14_25.getDN(), this.simplePassword, var18_69);
                            var19_85 = DirectoryServer.getAttributeType("ds-rlim-size-limit", true);
                            var20_94 = var14_25.getAttribute(var19_85);
                            if (var20_94 != null && var20_94.size() == 1 && (var23_112 = (var22_108 = (var21_103 = (Attribute)var20_94.get(0)).getValues()).iterator()).hasNext()) {
                                var24_115 = (AttributeValue)var23_112.next();
                                if (var23_112.hasNext()) {
                                    var25_122 = 131467;
                                    var26_133 = MessageHandler.getMessage(var25_122, new Object[]{String.valueOf(var14_25.getDN())});
                                    Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var26_133, var25_122);
                                } else {
                                    try {
                                        var2_2 = Integer.parseInt(var24_115.getStringValue());
                                    }
                                    catch (Exception var25_123) {
                                        if (!BindOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.core.BindOperation", "run", var25_123)) {
                                            throw new AssertionError();
                                        }
                                        var26_134 = 131468;
                                        var27_139 = MessageHandler.getMessage(var26_134, new Object[]{var24_115.getStringValue(), String.valueOf(var14_25.getDN())});
                                        Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var27_139, var26_134);
                                    }
                                }
                            }
                            if ((var20_94 = var14_25.getAttribute(var19_85 = DirectoryServer.getAttributeType("ds-rlim-time-limit", true))) != null && var20_94.size() == 1 && (var23_112 = (var22_108 = (var21_103 = var20_94.get(0)).getValues()).iterator()).hasNext()) {
                                var24_115 = (AttributeValue)var23_112.next();
                                if (var23_112.hasNext()) {
                                    var25_122 = 131469;
                                    var26_133 = MessageHandler.getMessage(var25_122, new Object[]{String.valueOf(var14_25.getDN())});
                                    Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var26_133, var25_122);
                                } else {
                                    try {
                                        var3_3 = Integer.parseInt(var24_115.getStringValue());
                                    }
                                    catch (Exception var25_124) {
                                        if (!BindOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.core.BindOperation", "run", var25_124)) {
                                            throw new AssertionError();
                                        }
                                        var26_135 = 131470;
                                        var27_139 = MessageHandler.getMessage(var26_135, new Object[]{var24_115.getStringValue(), String.valueOf(var14_25.getDN())});
                                        Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var27_139, var26_135);
                                    }
                                }
                            }
                            if ((var20_94 = var14_25.getAttribute(var19_85 = DirectoryServer.getAttributeType("ds-rlim-lookthrough-limit", true))) != null && var20_94.size() == 1 && (var23_112 = (var22_108 = (var21_103 = var20_94.get(0)).getValues()).iterator()).hasNext()) {
                                var24_115 = (AttributeValue)var23_112.next();
                                if (var23_112.hasNext()) {
                                    var25_125 = 131629;
                                    var26_136 = MessageHandler.getMessage(var25_125, new Object[]{String.valueOf(var14_25.getDN())});
                                    Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var26_136, var25_125);
                                } else {
                                    try {
                                        var4_4 = Integer.parseInt(var24_115.getStringValue());
                                    }
                                    catch (Exception var25_126) {
                                        if (!BindOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.core.BindOperation", "run", var25_126)) {
                                            throw new AssertionError();
                                        }
                                        var26_137 = 131630;
                                        var27_139 = MessageHandler.getMessage(var26_137, new Object[]{var24_115.getStringValue(), String.valueOf(var14_25.getDN())});
                                        Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var27_139, var26_137);
                                    }
                                }
                            }
                            this.pwPolicyState.handleDeprecatedStorageSchemes(this.simplePassword);
                            this.pwPolicyState.clearAuthFailureTimes();
                            if (this.isFirstWarning) {
                                this.pwPolicyState.setWarnedTime();
                                var21_104 = this.pwPolicyState.getSecondsUntilExpiration();
                                var22_108 = StaticUtils.secondsToTimeString(var21_104);
                                var23_113 = 66083;
                                var24_115 = MessageHandler.getMessage(var23_113, new Object[]{var22_108});
                                this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRING, this.bindDN, var23_113, (String)var24_115);
                            }
                            if (this.isGraceLogin) {
                                this.pwPolicyState.updateGraceLoginTimes();
                            }
                            this.pwPolicyState.setLastLoginTime();
                            break;
                        }
                        var18_70 = 196887;
                        var19_86 = MessageHandler.getMessage(var18_70);
                        this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        this.setAuthFailureReason(var18_70, var19_86);
                        var20_95 = this.pwPolicyState.getMaxAllowedFailures();
                        if (var20_95 <= 0) break;
                        this.pwPolicyState.updateAuthFailureTimes();
                        if (this.pwPolicyState.getAuthFailureTimes().size() < var20_95) break;
                        this.pwPolicyState.lockDueToFailures();
                        var22_109 = this.pwPolicyState.getLockoutDuration();
                        if (var22_109 > 0) {
                            var21_105 = AccountStatusNotificationType.ACCOUNT_TEMPORARILY_LOCKED;
                            var18_70 = 197156;
                            var19_86 = MessageHandler.getMessage(var18_70, new Object[]{StaticUtils.secondsToTimeString(var22_109)});
                        } else {
                            var21_105 = AccountStatusNotificationType.ACCOUNT_PERMANENTLY_LOCKED;
                            var18_70 = 197157;
                            var19_86 = MessageHandler.getMessage(var18_70);
                        }
                        this.pwPolicyState.generateAccountStatusNotification(var21_105, this.userEntryDN, var18_70, var19_86);
                        break;
                    }
                    catch (Exception var14_27) {
                        if (!BindOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.core.BindOperation", "run", var14_27)) {
                            throw new AssertionError();
                        }
                        var15_33 = 196888;
                        var16_37 = MessageHandler.getMessage(var15_33, new Object[]{StaticUtils.stackTraceToSingleLineString(var14_27)});
                        this.setResultCode(DirectoryServer.getServerErrorResultCode());
                        this.setAuthFailureReason(var15_33, (String)var16_37);
                        break;
                    }
                    finally {
                        LockManager.unlock(this.bindDN, (Lock)var13_21);
                    }
                }
                case 2: {
                    var14_23 = DirectoryServer.getSASLMechanismHandler(this.saslMechanism);
                    if (var14_23 == null) {
                        this.setResultCode(ResultCode.AUTH_METHOD_NOT_SUPPORTED);
                        var15_34 = 196830;
                        var16_38 = MessageHandler.getMessage(var15_34, new Object[]{this.saslMechanism});
                        this.appendErrorMessage(var16_38);
                        this.setAuthFailureReason(var15_34, var16_38);
                        break;
                    }
                    var15_35 = var8_8.invokePreOperationBindPlugins(this);
                    if (var15_35.connectionTerminated()) {
                        this.setResultCode(ResultCode.CANCELED);
                        var16_39 = 262369;
                        this.appendErrorMessage(MessageHandler.getMessage(var16_39));
                        this.processingStopTime = System.currentTimeMillis();
                        Access.logBindResponse(this);
                        return;
                    }
                    if (var15_35.sendResponseImmediately()) {
                        var9_9 = true;
                        break;
                    }
                    var14_23.processSASLBind(this);
                    if (this.saslAuthUserEntry == null) {
                        this.pwPolicyState = null;
                        var16_40 = null;
                    } else {
                        try {
                            this.pwPolicyState = new PasswordPolicyState(this.saslAuthUserEntry, false, false);
                            this.userEntryDN = this.saslAuthUserEntry.getDN();
                            var16_40 = String.valueOf(this.userEntryDN);
                        }
                        catch (DirectoryException var17_50) {
                            if (!BindOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.core.BindOperation", "run", var17_50)) {
                                throw new AssertionError();
                            }
                            this.setResponseData(var17_50);
                            break;
                        }
                    }
                    if (this.pwPolicyState == null) ** GOTO lbl437
                    if (this.pwPolicyState.isDisabled()) {
                        this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        var17_51 = 197125;
                        var18_71 = MessageHandler.getMessage(var17_51, new Object[]{var16_40});
                        this.setAuthFailureReason(var17_51, var18_71);
                        break;
                    }
                    if (this.pwPolicyState.isAccountExpired()) {
                        this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        var17_52 = 197139;
                        var18_72 = MessageHandler.getMessage(var17_52, new Object[]{var16_40});
                        this.setAuthFailureReason(var17_52, var18_72);
                        this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_EXPIRED, this.bindDN, var17_52, var18_72);
                        break;
                    }
                    if (this.pwPolicyState.requireSecureAuthentication() && !this.clientConnection.isSecure() && !var14_23.isSecure(this.saslMechanism)) {
                        this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        var17_53 = 197131;
                        var18_73 = MessageHandler.getMessage(var17_53, new Object[]{this.saslMechanism, var16_40});
                        this.setAuthFailureReason(var17_53, var18_73);
                        break;
                    }
                    if (this.pwPolicyState.lockedDueToFailures()) {
                        this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        if (this.pwPolicyErrorType == null) {
                            this.pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                        }
                        var17_54 = 197126;
                        var18_74 = MessageHandler.getMessage(var17_54, new Object[]{var16_40});
                        this.setAuthFailureReason(var17_54, var18_74);
                        break;
                    }
                    if (this.pwPolicyState.lockedDueToIdleInterval()) {
                        this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        if (this.pwPolicyErrorType == null) {
                            this.pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                        }
                        var17_55 = 197128;
                        var18_75 = MessageHandler.getMessage(var17_55, new Object[]{var16_40});
                        this.setAuthFailureReason(var17_55, var18_75);
                        this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_IDLE_LOCKED, this.bindDN, var17_55, var18_75);
                        break;
                    }
                    if (!var14_23.isPasswordBased(this.saslMechanism)) ** GOTO lbl437
                    if (this.pwPolicyState.lockedDueToMaximumResetAge()) {
                        this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        if (this.pwPolicyErrorType == null) {
                            this.pwPolicyErrorType = PasswordPolicyErrorType.ACCOUNT_LOCKED;
                        }
                        var17_56 = 197127;
                        var18_76 = MessageHandler.getMessage(var17_56, new Object[]{var16_40});
                        this.setAuthFailureReason(var17_56, var18_76);
                        this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.ACCOUNT_RESET_LOCKED, this.bindDN, var17_56, var18_76);
                        break;
                    }
                    if (!this.pwPolicyState.isPasswordExpired()) ** GOTO lbl427
                    if (this.pwPolicyErrorType == null) {
                        this.pwPolicyErrorType = PasswordPolicyErrorType.PASSWORD_EXPIRED;
                    }
                    if ((var17_57 = this.pwPolicyState.getMaxAllowedGraceLogins()) <= 0 || !this.pwPolicyState.mayUseGraceLogin()) ** GOTO lbl421
                    var18_77 = this.pwPolicyState.getGraceLoginTimes();
                    if (var18_77 == null || var18_77.size() < var17_57) {
                        this.isGraceLogin = true;
                        this.mustChangePassword = true;
                        if (this.pwPolicyWarningType == null) {
                            this.pwPolicyWarningType = PasswordPolicyWarningType.GRACE_LOGINS_REMAINING;
                            this.pwPolicyWarningValue = var17_57 - (var18_77.size() + 1);
                        }
                    } else {
                        var19_87 = 197129;
                        var20_96 = MessageHandler.getMessage(var19_87, new Object[]{String.valueOf(this.bindDN)});
                        this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        this.setAuthFailureReason(var19_87, var20_96);
                        this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRED, this.bindDN, var19_87, var20_96);
                        break;
lbl421:
                        // 1 sources

                        var18_78 = 197129;
                        var19_88 = MessageHandler.getMessage(var18_78, new Object[]{String.valueOf(this.bindDN)});
                        this.setResultCode(ResultCode.INVALID_CREDENTIALS);
                        this.setAuthFailureReason(var18_78, var19_88);
                        this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRED, this.bindDN, var18_78, var19_88);
                        break;
lbl427:
                        // 1 sources

                        if (this.pwPolicyState.shouldWarn()) {
                            var17_57 = this.pwPolicyState.getSecondsUntilExpiration();
                            var18_77 = StaticUtils.secondsToTimeString(var17_57);
                            var19_89 = 66083;
                            var20_97 = MessageHandler.getMessage(var19_89, new Object[]{var18_77});
                            this.appendErrorMessage(var20_97);
                            if (this.pwPolicyWarningType == null) {
                                this.pwPolicyWarningType = PasswordPolicyWarningType.TIME_BEFORE_EXPIRATION;
                                this.pwPolicyWarningValue = var17_57;
                            }
                            this.isFirstWarning = this.pwPolicyState.isFirstWarning();
                        }
                    }
lbl437:
                    // 6 sources

                    if ((var17_58 = this.getResultCode()) == ResultCode.SUCCESS) {
                        if (this.pwPolicyState == null) break;
                        if (var14_23.isPasswordBased(this.saslMechanism) && this.pwPolicyState.mustChangePassword()) {
                            this.mustChangePassword = true;
                        }
                        if (this.isFirstWarning) {
                            this.pwPolicyState.setWarnedTime();
                            var18_79 = this.pwPolicyState.getSecondsUntilExpiration();
                            var19_90 = StaticUtils.secondsToTimeString(var18_79);
                            var20_98 = 66083;
                            var21_106 = MessageHandler.getMessage(var20_98, new Object[]{var19_90});
                            this.pwPolicyState.generateAccountStatusNotification(AccountStatusNotificationType.PASSWORD_EXPIRING, this.bindDN, var20_98, (String)var21_106);
                        }
                        if (this.isGraceLogin) {
                            this.pwPolicyState.updateGraceLoginTimes();
                        }
                        this.pwPolicyState.setLastLoginTime();
                        var18_80 = DirectoryServer.getAttributeType("ds-rlim-size-limit", true);
                        var19_91 = this.saslAuthUserEntry.getAttribute(var18_80);
                        if (var19_91 != null && var19_91.size() == 1 && (var22_110 = (var21_106 = (var20_99 = var19_91.get(0)).getValues()).iterator()).hasNext()) {
                            var23_114 = (AttributeValue)var22_110.next();
                            if (var22_110.hasNext()) {
                                var24_116 = 131467;
                                var25_127 = MessageHandler.getMessage(var24_116, new Object[]{var16_40});
                                Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var25_127, var24_116);
                            } else {
                                try {
                                    var2_2 = Integer.parseInt(var23_114.getStringValue());
                                }
                                catch (Exception var24_117) {
                                    if (!BindOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.core.BindOperation", "run", var24_117)) {
                                        throw new AssertionError();
                                    }
                                    var25_128 = 131468;
                                    var26_138 = MessageHandler.getMessage(var25_128, new Object[]{var23_114.getStringValue(), var16_40});
                                    Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var26_138, var25_128);
                                }
                            }
                        }
                        if ((var19_91 = this.saslAuthUserEntry.getAttribute(var18_80 = DirectoryServer.getAttributeType("ds-rlim-time-limit", true))) != null && var19_91.size() == 1 && (var22_110 = (var21_106 = (var20_100 = var19_91.get(0)).getValues()).iterator()).hasNext()) {
                            var23_114 = (AttributeValue)var22_110.next();
                            if (var22_110.hasNext()) {
                                var24_118 = 131469;
                                var25_129 = MessageHandler.getMessage(var24_118, new Object[]{var16_40});
                                Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var25_129, var24_118);
                            } else {
                                try {
                                    var3_3 = Integer.parseInt(var23_114.getStringValue());
                                }
                                catch (Exception var24_119) {
                                    if (!BindOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.core.BindOperation", "run", var24_119)) {
                                        throw new AssertionError();
                                    }
                                    var25_130 = 131470;
                                    var26_138 = MessageHandler.getMessage(var25_130, new Object[]{var23_114.getStringValue(), var16_40});
                                    Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var26_138, var25_130);
                                }
                            }
                        }
                        if ((var19_91 = this.saslAuthUserEntry.getAttribute(var18_80 = DirectoryServer.getAttributeType("ds-rlim-lookthrough-limit", true))) == null || var19_91.size() != 1 || !(var22_110 = (var21_106 = (var20_101 = var19_91.get(0)).getValues()).iterator()).hasNext()) break;
                        var23_114 = (AttributeValue)var22_110.next();
                        if (var22_110.hasNext()) {
                            var24_120 = 131629;
                            var25_131 = MessageHandler.getMessage(var24_120, new Object[]{var16_40});
                            Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var25_131, var24_120);
                            break;
                        }
                        try {
                            var4_4 = Integer.parseInt(var23_114.getStringValue());
                        }
                        catch (Exception var24_121) {
                            if (!BindOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.core.BindOperation", "run", var24_121)) {
                                throw new AssertionError();
                            }
                            var25_132 = 131630;
                            var26_138 = MessageHandler.getMessage(var25_132, new Object[]{var23_114.getStringValue(), var16_40});
                            Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_WARNING, var26_138, var25_132);
                        }
                        break;
                    }
                    if (var17_58 == ResultCode.SASL_BIND_IN_PROGRESS || this.pwPolicyState == null || !var14_23.isPasswordBased(this.saslMechanism) || (var18_81 = this.pwPolicyState.getMaxAllowedFailures()) <= 0) break;
                    this.pwPolicyState.updateAuthFailureTimes();
                    if (this.pwPolicyState.getAuthFailureTimes().size() < var18_81) break;
                    this.pwPolicyState.lockDueToFailures();
                    var22_111 = this.pwPolicyState.getLockoutDuration();
                    if (var22_111 > 0) {
                        var19_92 = AccountStatusNotificationType.ACCOUNT_TEMPORARILY_LOCKED;
                        var20_102 = 197156;
                        var21_107 = MessageHandler.getMessage(var20_102, new Object[]{StaticUtils.secondsToTimeString(var22_111)});
                    } else {
                        var19_92 = AccountStatusNotificationType.ACCOUNT_PERMANENTLY_LOCKED;
                        var20_102 = 197157;
                        var21_107 = MessageHandler.getMessage(var20_102);
                    }
                    this.pwPolicyState.generateAccountStatusNotification(var19_92, this.userEntryDN, var20_102, var21_107);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        try {
            if (this.pwPolicyState != null) {
                this.pwPolicyState.updateUserEntry();
            }
        }
        catch (DirectoryException var10_11) {
            if (!BindOperation.$assertionsDisabled && !Debug.debugException("org.opends.server.core.BindOperation", "run", var10_11)) {
                throw new AssertionError();
            }
            this.setResponseData(var10_11);
        }
        if (!var9_9 && (var10_10 = var8_8.invokePostOperationBindPlugins(this)).connectionTerminated()) {
            this.setResultCode(ResultCode.CANCELED);
            var11_16 = 262369;
            this.appendErrorMessage(MessageHandler.getMessage(var11_16));
            this.processingStopTime = System.currentTimeMillis();
            Access.logBindResponse(this);
            return;
        }
        if (this.getResultCode() == ResultCode.SUCCESS && var5_5 != null) {
            this.clientConnection.setAuthenticationInfo(var5_5);
            this.clientConnection.setSizeLimit(var2_2);
            this.clientConnection.setTimeLimit(var3_3);
            this.clientConnection.setLookthroughLimit(var4_4);
            this.clientConnection.setMustChangePassword(this.mustChangePassword);
            if (var1_1) {
                this.responseControls.add(new AuthorizationIdentityResponseControl(var5_5.getAuthorizationDN()));
            }
        }
        if (this.getResultCode() == ResultCode.SUCCESS) {
            if (this.pwPolicyControlRequested) {
                var10_10 = new PasswordPolicyResponseControl(this.pwPolicyWarningType, this.pwPolicyWarningValue, this.pwPolicyErrorType);
                this.responseControls.add((Control)var10_10);
            } else if (this.pwPolicyErrorType == PasswordPolicyErrorType.PASSWORD_EXPIRED) {
                this.responseControls.add(new PasswordExpiredControl());
            } else if (this.pwPolicyWarningType == PasswordPolicyWarningType.TIME_BEFORE_EXPIRATION) {
                this.responseControls.add(new PasswordExpiringControl(this.pwPolicyWarningValue));
            }
        } else if (this.pwPolicyControlRequested) {
            var10_10 = new PasswordPolicyResponseControl(this.pwPolicyWarningType, this.pwPolicyWarningValue, this.pwPolicyErrorType);
            this.responseControls.add((Control)var10_10);
        } else if (this.pwPolicyErrorType == PasswordPolicyErrorType.PASSWORD_EXPIRED) {
            this.responseControls.add(new PasswordExpiredControl());
        }
        this.clientConnection.setBindInProgress(false);
        this.processingStopTime = System.currentTimeMillis();
        this.clientConnection.sendResponse(this);
        Access.logBindResponse(this);
        var8_8.invokePostResponseBindPlugins(this);
    }

    @Override
    public final CancelResult cancel(CancelRequest cancelRequest) {
        assert (Debug.debugEnter(CLASS_NAME, "cancel", String.valueOf(cancelRequest)));
        cancelRequest.addResponseMessage(MessageHandler.getMessage(196610));
        return CancelResult.CANNOT_CANCEL;
    }

    @Override
    public final CancelRequest getCancelRequest() {
        assert (Debug.debugEnter(CLASS_NAME, "getCancelRequest", new String[0]));
        return null;
    }

    @Override
    boolean setCancelRequest(CancelRequest cancelRequest) {
        assert (Debug.debugEnter(CLASS_NAME, "setCancelRequest", String.valueOf(cancelRequest)));
        return false;
    }

    @Override
    public final void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("BindOperation(connID=");
        stringBuilder.append(this.clientConnection.getConnectionID());
        stringBuilder.append(", opID=");
        stringBuilder.append(this.operationID);
        stringBuilder.append(", dn=");
        stringBuilder.append(this.rawBindDN);
        stringBuilder.append(", authType=");
        stringBuilder.append((Object)this.authType);
        stringBuilder.append(")");
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$opends$server$types$AuthenticationType;

        static {
            $SwitchMap$org$opends$server$types$AuthenticationType = new int[AuthenticationType.values().length];
            try {
                1.$SwitchMap$org$opends$server$types$AuthenticationType[AuthenticationType.SIMPLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$opends$server$types$AuthenticationType[AuthenticationType.SASL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

