/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.core;

import java.util.AbstractCollection;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.opends.server.api.AccountStatusNotificationHandler;
import org.opends.server.api.ConfigAddListener;
import org.opends.server.api.ConfigChangeListener;
import org.opends.server.api.ConfigDeleteListener;
import org.opends.server.api.ConfigHandler;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.ServerConstants;

public class AccountStatusNotificationHandlerConfigManager
implements ConfigChangeListener,
ConfigAddListener,
ConfigDeleteListener {
    private static final String CLASS_NAME = "org.opends.server.core.AccountStatusNotificationHandlerConfigManager";
    private ConcurrentHashMap<DN, AccountStatusNotificationHandler> notificationHandlers;
    private ConfigHandler configHandler;

    public AccountStatusNotificationHandlerConfigManager() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.configHandler = DirectoryServer.getConfigHandler();
        this.notificationHandlers = new ConcurrentHashMap();
    }

    public void initializeNotificationHandlers() throws ConfigException, InitializationException {
        ConfigEntry configEntry;
        assert (Debug.debugEnter(CLASS_NAME, "initializeNotificationHandlers", new String[0]));
        try {
            DN dN = DN.decode("cn=Account Status Notification Handlers,cn=config");
            configEntry = this.configHandler.getConfigEntry(dN);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeNotificationHandlers", exception));
            int n = 3473953;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new ConfigException(n, string, exception);
        }
        if (configEntry == null) {
            int n = 0x320222;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        configEntry.registerAddListener(this);
        configEntry.registerDeleteListener(this);
        if (!configEntry.hasChildren()) {
            return;
        }
        for (ConfigEntry configEntry2 : configEntry.getChildren().values()) {
            configEntry2.registerChangeListener(this);
            StringBuilder stringBuilder = new StringBuilder();
            if (!this.configAddIsAcceptable(configEntry2, stringBuilder)) {
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408419, configEntry2.getDN().toString(), stringBuilder.toString());
                continue;
            }
            try {
                ConfigChangeResult configChangeResult = this.applyConfigurationAdd(configEntry2);
                if (configChangeResult.getResultCode() == ResultCode.SUCCESS) continue;
                StringBuilder stringBuilder2 = new StringBuilder();
                List<String> list = configChangeResult.getMessages();
                if (list == null || list.isEmpty()) {
                    stringBuilder2.append(MessageHandler.getMessage(0x300030));
                } else {
                    Iterator<String> iterator = list.iterator();
                    stringBuilder2.append(iterator.next());
                    while (iterator.hasNext()) {
                        stringBuilder2.append(ServerConstants.EOL);
                        stringBuilder2.append(iterator.next());
                    }
                }
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408420, configEntry2.getDN().toString(), stringBuilder2.toString());
            }
            catch (Exception exception) {
                Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.SEVERE_ERROR, 3408420, configEntry2.getDN().toString(), String.valueOf(exception));
            }
        }
    }

    public boolean configChangeIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        Class<?> clazz;
        StringConfigAttribute stringConfigAttribute;
        Object object;
        assert (Debug.debugEnter(CLASS_NAME, "configChangeIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        if (!configEntry.hasObjectClass("ds-cfg-account-status-notification-handler")) {
            int n = 3408421;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
            stringBuilder.append(string);
            return false;
        }
        try {
            int n = 3146278;
            object = new StringConfigAttribute("ds-cfg-account-status-notification-handler-class", MessageHandler.getMessage(n), true, false, true);
            stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object);
            if (stringConfigAttribute == null) {
                n = 3408423;
                String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
                stringBuilder.append(string);
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            int n = 3408424;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        try {
            clazz = Class.forName(stringConfigAttribute.pendingValue());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            int n = 3408424;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        try {
            object = (AccountStatusNotificationHandler)clazz.newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            int n = 3408425;
            String string = MessageHandler.getMessage(n, clazz.getName(), String.valueOf(configEntry.getDN()), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        try {
            BooleanConfigAttribute booleanConfigAttribute = new BooleanConfigAttribute("ds-cfg-account-status-notification-handler-enabled", MessageHandler.getMessage(3146282), false);
            object = (BooleanConfigAttribute)configEntry.getConfigAttribute(booleanConfigAttribute);
            if (object == null) {
                int n = 3408427;
                String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
                stringBuilder.append(string);
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            int n = 3408428;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationChange(ConfigEntry configEntry) {
        Object object;
        Object object2;
        int n;
        Object object3;
        boolean bl;
        AccountStatusNotificationHandler accountStatusNotificationHandler;
        ArrayList<String> arrayList;
        boolean bl2;
        ResultCode resultCode;
        DN dN;
        block22: {
            assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationChange", String.valueOf(configEntry)));
            dN = configEntry.getDN();
            resultCode = ResultCode.SUCCESS;
            bl2 = false;
            arrayList = new ArrayList<String>();
            if (!configEntry.hasObjectClass("ds-cfg-account-status-notification-handler")) {
                int n2 = 3408421;
                arrayList.add(MessageHandler.getMessage(n2, String.valueOf(dN)));
                resultCode = ResultCode.UNWILLING_TO_PERFORM;
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            accountStatusNotificationHandler = this.notificationHandlers.get(dN);
            bl = false;
            try {
                object3 = new BooleanConfigAttribute("ds-cfg-account-status-notification-handler-enabled", MessageHandler.getMessage(3146282), false);
                BooleanConfigAttribute booleanConfigAttribute = (BooleanConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object3);
                if (booleanConfigAttribute == null) {
                    int n3 = 3408427;
                    arrayList.add(MessageHandler.getMessage(n3, String.valueOf(dN)));
                    resultCode = ResultCode.UNWILLING_TO_PERFORM;
                    return new ConfigChangeResult(resultCode, bl2, arrayList);
                }
                if (booleanConfigAttribute.activeValue()) {
                    if (accountStatusNotificationHandler == null) {
                        bl = true;
                    }
                    break block22;
                }
                if (accountStatusNotificationHandler == null) {
                    return new ConfigChangeResult(resultCode, bl2, arrayList);
                }
                this.notificationHandlers.remove(dN);
                accountStatusNotificationHandler.finalizeStatusNotificationHandler();
                DirectoryServer.deregisterAccountStatusNotificationHandler(dN);
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
                int n4 = 3408428;
                arrayList.add(MessageHandler.getMessage(n4, String.valueOf(dN), String.valueOf(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
        }
        try {
            n = 3146278;
            object2 = new StringConfigAttribute("ds-cfg-account-status-notification-handler-class", MessageHandler.getMessage(n), true, false, true);
            object = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object2);
            if (object == null) {
                n = 3408423;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            object3 = ((StringConfigAttribute)object).pendingValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configChangeIsAcceptable", exception));
            int n5 = 3408424;
            arrayList.add(MessageHandler.getMessage(n5, String.valueOf(dN), String.valueOf(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl2, arrayList);
        }
        n = 0;
        object2 = null;
        if (accountStatusNotificationHandler != null) {
            object2 = accountStatusNotificationHandler.getClass().getName();
            int n6 = n = !((String)object3).equals(object2) ? 1 : 0;
        }
        if (n != 0) {
            bl2 = true;
            arrayList.add(MessageHandler.getMessage(3146285, String.valueOf(object2), String.valueOf(object3), String.valueOf(dN)));
            return new ConfigChangeResult(resultCode, bl2, arrayList);
        }
        if (bl) {
            try {
                object = Class.forName((String)object3);
                accountStatusNotificationHandler = (AccountStatusNotificationHandler)((Class)object).newInstance();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                int n7 = 3408425;
                arrayList.add(MessageHandler.getMessage(n7, object3, String.valueOf(dN), String.valueOf(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            try {
                accountStatusNotificationHandler.initializeStatusNotificationHandler(configEntry);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyConfigurationChange", exception));
                int n8 = 3342894;
                arrayList.add(MessageHandler.getMessage(n8, object3, String.valueOf(dN), String.valueOf(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
                return new ConfigChangeResult(resultCode, bl2, arrayList);
            }
            this.notificationHandlers.put(dN, accountStatusNotificationHandler);
            DirectoryServer.registerAccountStatusNotificationHandler(dN, accountStatusNotificationHandler);
            return new ConfigChangeResult(resultCode, bl2, arrayList);
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }

    public boolean configAddIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        Object object;
        Object object2;
        Class<?> clazz;
        StringConfigAttribute stringConfigAttribute;
        Object object3;
        assert (Debug.debugEnter(CLASS_NAME, "configAddIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        DN dN = configEntry.getDN();
        if (this.notificationHandlers.containsKey(dN)) {
            int n = 3342895;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            stringBuilder.append(string);
            return false;
        }
        if (!configEntry.hasObjectClass("ds-cfg-account-status-notification-handler")) {
            int n = 3408421;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
            stringBuilder.append(string);
            return false;
        }
        try {
            int n = 3146278;
            object3 = new StringConfigAttribute("ds-cfg-account-status-notification-handler-class", MessageHandler.getMessage(n), true, false, true);
            stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object3);
            if (stringConfigAttribute == null) {
                n = 3408423;
                String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
                stringBuilder.append(string);
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            int n = 3408424;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        try {
            clazz = Class.forName(stringConfigAttribute.pendingValue());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            int n = 3408424;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        try {
            object3 = (AccountStatusNotificationHandler)clazz.newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            int n = 3408425;
            String string = MessageHandler.getMessage(n, clazz.getName(), String.valueOf(dN), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        if (object3 instanceof ConfigurableComponent && !(object2 = (ConfigurableComponent)object3).hasAcceptableConfiguration(configEntry, (List<String>)(object = new LinkedList()))) {
            if (((AbstractCollection)object).isEmpty()) {
                int n = 3408432;
                stringBuilder.append(MessageHandler.getMessage(n, String.valueOf(dN)));
            } else {
                Iterator iterator = ((AbstractSequentialList)object).iterator();
                stringBuilder.append((String)iterator.next());
                while (iterator.hasNext()) {
                    stringBuilder.append("  ");
                    stringBuilder.append((String)iterator.next());
                }
            }
            return false;
        }
        try {
            object = new BooleanConfigAttribute("ds-cfg-account-status-notification-handler-enabled", MessageHandler.getMessage(3146282), false);
            object2 = (BooleanConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object);
            if (object2 == null) {
                int n = 3408427;
                String string = MessageHandler.getMessage(n, configEntry.getDN().toString());
                stringBuilder.append(string);
                return false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "configAddIsAcceptable", exception));
            int n = 3408428;
            String string = MessageHandler.getMessage(n, configEntry.getDN().toString(), String.valueOf(exception));
            stringBuilder.append(string);
            return false;
        }
        return true;
    }

    public ConfigChangeResult applyConfigurationAdd(ConfigEntry configEntry) {
        AccountStatusNotificationHandler accountStatusNotificationHandler;
        Object object;
        Object object2;
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationAdd", String.valueOf(configEntry)));
        DN dN = configEntry.getDN();
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!configEntry.hasObjectClass("ds-cfg-account-status-notification-handler")) {
            int n = 3408421;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
            resultCode = ResultCode.UNWILLING_TO_PERFORM;
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            object2 = new BooleanConfigAttribute("ds-cfg-account-status-notification-handler-enabled", MessageHandler.getMessage(3146282), false);
            BooleanConfigAttribute booleanConfigAttribute = (BooleanConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object2);
            if (booleanConfigAttribute == null) {
                int n = 3408427;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.SUCCESS;
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            if (!booleanConfigAttribute.activeValue()) {
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            int n = 3408428;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            int n = 3146278;
            object = new StringConfigAttribute("ds-cfg-account-status-notification-handler-class", MessageHandler.getMessage(n), true, false, true);
            StringConfigAttribute stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object);
            if (stringConfigAttribute == null) {
                n = 3408423;
                arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN)));
                resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                return new ConfigChangeResult(resultCode, bl, arrayList);
            }
            object2 = stringConfigAttribute.pendingValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            int n = 3408424;
            arrayList.add(MessageHandler.getMessage(n, String.valueOf(dN), String.valueOf(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            object = Class.forName((String)object2);
            accountStatusNotificationHandler = (AccountStatusNotificationHandler)((Class)object).newInstance();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            int n = 3408425;
            arrayList.add(MessageHandler.getMessage(n, object2, String.valueOf(dN), String.valueOf(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        try {
            accountStatusNotificationHandler.initializeStatusNotificationHandler(configEntry);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "applyConfigurationAdd", exception));
            int n = 3342894;
            arrayList.add(MessageHandler.getMessage(n, object2, String.valueOf(dN), String.valueOf(exception)));
            resultCode = DirectoryServer.getServerErrorResultCode();
            return new ConfigChangeResult(resultCode, bl, arrayList);
        }
        this.notificationHandlers.put(dN, accountStatusNotificationHandler);
        DirectoryServer.registerAccountStatusNotificationHandler(dN, accountStatusNotificationHandler);
        return new ConfigChangeResult(resultCode, bl, arrayList);
    }

    public boolean configDeleteIsAcceptable(ConfigEntry configEntry, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "configDeleteIsAcceptable", String.valueOf(configEntry), "java.lang.StringBuilder"));
        return true;
    }

    public ConfigChangeResult applyConfigurationDelete(ConfigEntry configEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "applyConfigurationDelete", String.valueOf(configEntry)));
        DN dN = configEntry.getDN();
        ResultCode resultCode = ResultCode.SUCCESS;
        boolean bl = false;
        AccountStatusNotificationHandler accountStatusNotificationHandler = this.notificationHandlers.remove(dN);
        if (accountStatusNotificationHandler != null) {
            DirectoryServer.deregisterAccountStatusNotificationHandler(dN);
            accountStatusNotificationHandler.finalizeStatusNotificationHandler();
        }
        return new ConfigChangeResult(resultCode, bl);
    }
}

