/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.controls;

import java.util.ArrayList;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.types.Control;

public class PagedResultsControl
extends Control {
    private static final String CLASS_NAME = "org.opends.server.controls.PagedResultsControl";
    private int size;
    private ASN1OctetString cookie;

    public PagedResultsControl(boolean bl, int n, ASN1OctetString aSN1OctetString) {
        super("1.2.840.113556.1.4.319", bl);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(n), aSN1OctetString.toString()));
        this.size = n;
        this.cookie = aSN1OctetString;
        this.setValue(this.encode());
    }

    public PagedResultsControl(boolean bl, ASN1OctetString aSN1OctetString) throws LDAPException {
        super("1.2.840.113556.1.4.319", bl, aSN1OctetString);
        ArrayList<ASN1Element> arrayList;
        if (aSN1OctetString == null) {
            int n = 2294038;
            String string = MessageHandler.getMessage(n);
            throw new LDAPException(2, n, string);
        }
        try {
            ASN1Element aSN1Element = ASN1Element.decode(aSN1OctetString.value());
            arrayList = aSN1Element.decodeAsSequence().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decode", exception));
            int n = 2294039;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string, exception);
        }
        int n = arrayList.size();
        if (n != 2) {
            int n2 = 2294040;
            String string = MessageHandler.getMessage(n2, n);
            throw new LDAPException(2, n2, string);
        }
        try {
            this.size = arrayList.get(0).decodeAsInteger().intValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decode", exception));
            int n3 = 2294041;
            String string = MessageHandler.getMessage(n3, String.valueOf(exception));
            throw new LDAPException(2, n3, string, exception);
        }
        try {
            this.cookie = arrayList.get(1).decodeAsOctetString();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decode", exception));
            int n4 = 2294042;
            String string = MessageHandler.getMessage(n4, String.valueOf(exception));
            throw new LDAPException(2, n4, string, exception);
        }
    }

    public ASN1OctetString encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(2);
        arrayList.add(new ASN1Integer(this.size));
        arrayList.add(this.cookie);
        ASN1Sequence aSN1Sequence = new ASN1Sequence(arrayList);
        return new ASN1OctetString(aSN1Sequence.encode());
    }

    public int getSize() {
        return this.size;
    }

    public ASN1OctetString getCookie() {
        return this.cookie;
    }
}

