/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.config;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.management.AttributeList;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanParameterInfo;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigConstants;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiChoiceConfigAttribute
extends ConfigAttribute {
    private static final String CLASS_NAME = "org.opends.server.config.MultiChoiceConfigAttribute";
    private List<String> activeValues;
    private List<String> pendingValues;
    private Set<String> allowedValues;

    public MultiChoiceConfigAttribute(String string, String string2, boolean bl, boolean bl2, boolean bl3, Set<String> set) {
        super(string, string2, bl, bl2, bl3);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(bl2), String.valueOf(string2), String.valueOf(bl3), String.valueOf(set)));
        this.allowedValues = set;
        this.activeValues = new ArrayList<String>();
        this.pendingValues = this.activeValues;
    }

    public MultiChoiceConfigAttribute(String string, String string2, boolean bl, boolean bl2, boolean bl3, Set<String> set, String string3) {
        super(string, string2, bl, bl2, bl3, MultiChoiceConfigAttribute.getValueSet(string3));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(bl2), String.valueOf(string2), String.valueOf(bl3), String.valueOf(set), String.valueOf(string3)));
        this.allowedValues = set;
        if (string3 == null) {
            this.activeValues = new ArrayList<String>();
        } else {
            this.activeValues = new ArrayList<String>(1);
            this.activeValues.add(string3);
        }
        this.pendingValues = this.activeValues;
    }

    public MultiChoiceConfigAttribute(String string, String string2, boolean bl, boolean bl2, boolean bl3, Set<String> set, List<String> list) {
        super(string, string2, bl, bl2, bl3, MultiChoiceConfigAttribute.getValueSet(list));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(bl2), String.valueOf(string2), String.valueOf(bl3), String.valueOf(set), String.valueOf(list)));
        this.allowedValues = set;
        if (list == null) {
            this.activeValues = new ArrayList<String>();
            this.pendingValues = this.activeValues;
        } else {
            this.activeValues = list;
            this.pendingValues = this.activeValues;
        }
    }

    public MultiChoiceConfigAttribute(String string, String string2, boolean bl, boolean bl2, boolean bl3, Set<String> set, List<String> list, List<String> list2) {
        super(string, string2, bl, bl2, bl3, MultiChoiceConfigAttribute.getValueSet(list), list2 != null, MultiChoiceConfigAttribute.getValueSet(list2));
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(bl), String.valueOf(bl2), String.valueOf(string2), String.valueOf(bl3), String.valueOf(set), String.valueOf(list), String.valueOf(list2)));
        this.allowedValues = set;
        this.activeValues = list == null ? new ArrayList<String>() : list;
        this.pendingValues = list2 == null ? this.activeValues : list2;
    }

    @Override
    public String getDataType() {
        assert (Debug.debugEnter(CLASS_NAME, "getDataType", new String[0]));
        return "MultiChoice";
    }

    @Override
    public AttributeSyntax getSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntax", new String[0]));
        return DirectoryServer.getDefaultStringSyntax();
    }

    public String activeValue() throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "activeValue", new String[0]));
        if (this.activeValues == null || this.activeValues.isEmpty()) {
            int n = 0x33000F;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        if (this.activeValues.size() > 1) {
            int n = 0x330010;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        return this.activeValues.get(0);
    }

    public List<String> activeValues() {
        assert (Debug.debugEnter(CLASS_NAME, "activeValues", new String[0]));
        return this.activeValues;
    }

    public String pendingValue() throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "pendingValue", new String[0]));
        if (!this.hasPendingValues()) {
            return this.activeValue();
        }
        if (this.pendingValues == null || this.pendingValues.isEmpty()) {
            int n = 0x33000F;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        if (this.pendingValues.size() > 1) {
            int n = 0x330010;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        return this.pendingValues.get(0);
    }

    public List<String> pendingValues() {
        assert (Debug.debugEnter(CLASS_NAME, "pendingValues", new String[0]));
        if (!this.hasPendingValues()) {
            return this.activeValues;
        }
        return this.pendingValues;
    }

    public Set<String> allowedValues() {
        assert (Debug.debugEnter(CLASS_NAME, "getAllowedValues", new String[0]));
        return this.allowedValues;
    }

    public void setValue(String string) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", String.valueOf(string)));
        if (string == null || string.length() == 0) {
            int n = 0x330011;
            String string2 = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string2);
        }
        if (!this.allowedValues.contains(string.toLowerCase())) {
            int n = 3342354;
            String string3 = MessageHandler.getMessage(n, string, this.getName());
            throw new ConfigException(n, string3);
        }
        if (this.requiresAdminAction()) {
            this.pendingValues = new ArrayList<String>(1);
            this.pendingValues.add(string);
            this.setPendingValues(MultiChoiceConfigAttribute.getValueSet(string));
        } else {
            this.activeValues.clear();
            this.activeValues.add(string);
            this.pendingValues = this.activeValues;
            this.setActiveValues(MultiChoiceConfigAttribute.getValueSet(string));
        }
    }

    public void setValues(List<String> list) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "setValues", String.valueOf(list)));
        if (list == null || list.isEmpty()) {
            if (this.isRequired()) {
                int n = 0x330001;
                String string = MessageHandler.getMessage(n, this.getName());
                throw new ConfigException(n, string);
            }
            if (this.requiresAdminAction()) {
                this.setPendingValues(new LinkedHashSet<AttributeValue>(0));
                this.pendingValues = new ArrayList<String>();
            } else {
                this.setActiveValues(new LinkedHashSet<AttributeValue>(0));
                this.activeValues.clear();
            }
        }
        int n = list.size();
        if (!this.isMultiValued() && n > 1) {
            int n2 = 0x330003;
            String string = MessageHandler.getMessage(n2, this.getName());
            throw new ConfigException(n2, string);
        }
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(n);
        for (String string : list) {
            if (string == null || string.length() == 0) {
                int n3 = 0x330011;
                String string2 = MessageHandler.getMessage(n3, this.getName());
                throw new ConfigException(n3, string2);
            }
            if (!this.allowedValues.contains(string.toLowerCase())) {
                int n4 = 3342354;
                String string3 = MessageHandler.getMessage(n4, string, this.getName());
                throw new ConfigException(n4, string3);
            }
            AttributeValue attributeValue = new AttributeValue(new ASN1OctetString(string), (ByteString)new ASN1OctetString(string));
            if (linkedHashSet.contains(attributeValue)) {
                int n5 = 0x330005;
                String string4 = MessageHandler.getMessage(n5, this.getName(), string);
                throw new ConfigException(n5, string4);
            }
            linkedHashSet.add(attributeValue);
        }
        if (this.requiresAdminAction()) {
            this.pendingValues = list;
            this.setPendingValues(linkedHashSet);
        } else {
            this.activeValues = list;
            this.pendingValues = this.activeValues;
            this.setActiveValues(linkedHashSet);
        }
    }

    private static LinkedHashSet<AttributeValue> getValueSet(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getValueSet", String.valueOf(string)));
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(1);
        linkedHashSet.add(new AttributeValue(new ASN1OctetString(string), (ByteString)new ASN1OctetString(string)));
        return linkedHashSet;
    }

    private static LinkedHashSet<AttributeValue> getValueSet(List<String> list) {
        assert (Debug.debugEnter(CLASS_NAME, "getValueSet", String.valueOf(list)));
        if (list == null) {
            return null;
        }
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(list.size());
        for (String string : list) {
            linkedHashSet.add(new AttributeValue(new ASN1OctetString(string), (ByteString)new ASN1OctetString(string)));
        }
        return linkedHashSet;
    }

    @Override
    public void applyPendingValues() {
        assert (Debug.debugEnter(CLASS_NAME, "applyPendingValues", new String[0]));
        if (!this.hasPendingValues()) {
            return;
        }
        super.applyPendingValues();
        this.activeValues = this.pendingValues;
    }

    @Override
    public boolean valueIsAcceptable(AttributeValue attributeValue, StringBuilder stringBuilder) {
        String string;
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(attributeValue), "java.lang.StringBuilder"));
        if (attributeValue == null || (string = attributeValue.getStringValue()).length() == 0) {
            stringBuilder.append(MessageHandler.getMessage(0x330011, this.getName()));
            return false;
        }
        if (!this.allowedValues.contains(string.toLowerCase())) {
            stringBuilder.append(MessageHandler.getMessage(3342354, string, this.getName()));
            return false;
        }
        return true;
    }

    @Override
    public LinkedHashSet<AttributeValue> stringsToValues(List<String> list, boolean bl) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "stringsToValues", String.valueOf(list), String.valueOf(bl)));
        if (list == null || list.isEmpty()) {
            if (this.isRequired()) {
                int n = 0x330001;
                String string = MessageHandler.getMessage(n, this.getName());
                throw new ConfigException(n, string);
            }
            return new LinkedHashSet<AttributeValue>();
        }
        int n = list.size();
        if (!this.isMultiValued() && n > 1) {
            int n2 = 0x330003;
            String string = MessageHandler.getMessage(n2, this.getName());
            throw new ConfigException(n2, string);
        }
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(n);
        for (String string : list) {
            String string2;
            int n3;
            if (string == null || string.length() == 0) {
                n3 = 0x330011;
                string2 = MessageHandler.getMessage(n3, this.getName());
                if (bl) {
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, string2, n3);
                    continue;
                }
                throw new ConfigException(n3, string2);
            }
            if (!this.allowedValues.contains(string.toLowerCase())) {
                n3 = 3342354;
                string2 = MessageHandler.getMessage(n3, string, this.getName());
                if (bl) {
                    Error.logError(ErrorLogCategory.CONFIGURATION, ErrorLogSeverity.MILD_ERROR, string2, n3);
                    continue;
                }
                throw new ConfigException(n3, string2);
            }
            linkedHashSet.add(new AttributeValue(new ASN1OctetString(string), (ByteString)new ASN1OctetString(string)));
        }
        if (this.isRequired() && linkedHashSet.isEmpty()) {
            String string;
            int n4 = 0x330001;
            string = MessageHandler.getMessage(n4, this.getName());
            throw new ConfigException(n4, string);
        }
        return linkedHashSet;
    }

    @Override
    public List<String> activeValuesToStrings() {
        assert (Debug.debugEnter(CLASS_NAME, "activeValuesToStrings", new String[0]));
        return this.activeValues;
    }

    @Override
    public List<String> pendingValuesToStrings() {
        assert (Debug.debugEnter(CLASS_NAME, "pendingValuesToStrings", new String[0]));
        if (this.hasPendingValues()) {
            return this.pendingValues;
        }
        return null;
    }

    @Override
    public ConfigAttribute getConfigAttribute(List<Attribute> list) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigAttribute", String.valueOf(list)));
        ArrayList<String> arrayList = null;
        ArrayList<String> arrayList2 = null;
        for (Attribute object : list) {
            String string;
            Object n3;
            int string2;
            LinkedHashSet<AttributeValue> n2;
            if (object.hasOptions()) {
                if (object.hasOption("pending")) {
                    if (arrayList2 != null) {
                        int n5 = 0x330040;
                        String string4 = MessageHandler.getMessage(n5, object.getName());
                        throw new ConfigException(n5, string4);
                    }
                    n2 = object.getValues();
                    if (n2.isEmpty()) {
                        if (this.isRequired()) {
                            string2 = 0x330001;
                            n3 = MessageHandler.getMessage(string2, object.getName());
                            throw new ConfigException(string2, (String)n3);
                        }
                        arrayList2 = new ArrayList(0);
                        continue;
                    }
                    string2 = n2.size();
                    if (string2 > 1 && !this.isMultiValued()) {
                        int n7 = 0x330003;
                        String string3 = MessageHandler.getMessage(n7, object.getName());
                        throw new ConfigException(n7, string3);
                    }
                    arrayList2 = new ArrayList(string2);
                    for (AttributeValue attributeValue : n2) {
                        string = attributeValue.getStringValue().toLowerCase();
                        if (!this.allowedValues.contains(string)) {
                            int n = 3342354;
                            String string4 = MessageHandler.getMessage(n, attributeValue.getStringValue(), object.getName());
                            throw new ConfigException(n, string4);
                        }
                        arrayList2.add(attributeValue.getStringValue());
                    }
                    continue;
                }
                int n6 = 3342366;
                String string5 = MessageHandler.getMessage(n6, object.getName());
                throw new ConfigException(n6, string5);
            }
            if (arrayList != null) {
                int n = 3342401;
                String string5 = MessageHandler.getMessage(n, object.getName());
                throw new ConfigException(n, string5);
            }
            n2 = object.getValues();
            if (n2.isEmpty()) {
                if (this.isRequired()) {
                    string2 = 0x330001;
                    n3 = MessageHandler.getMessage(string2, object.getName());
                    throw new ConfigException(string2, (String)n3);
                }
                arrayList = new ArrayList<String>(0);
                continue;
            }
            string2 = n2.size();
            if (string2 > 1 && !this.isMultiValued()) {
                int n = 0x330003;
                String string6 = MessageHandler.getMessage(n, object.getName());
                throw new ConfigException(n, string6);
            }
            arrayList = new ArrayList(string2);
            for (AttributeValue attributeValue : n2) {
                string = attributeValue.getStringValue().toLowerCase();
                if (!this.allowedValues.contains(string)) {
                    int n = 3342354;
                    String string7 = MessageHandler.getMessage(n, attributeValue.getStringValue(), object.getName());
                    throw new ConfigException(n, string7);
                }
                arrayList.add(attributeValue.getStringValue());
            }
        }
        if (arrayList == null) {
            int n = 3342402;
            String string = MessageHandler.getMessage(n, this.getName());
            throw new ConfigException(n, string);
        }
        if (arrayList2 == null) {
            arrayList2 = arrayList;
        }
        return new MultiChoiceConfigAttribute(this.getName(), this.getDescription(), this.isRequired(), this.isMultiValued(), this.requiresAdminAction(), this.allowedValues, arrayList, arrayList2);
    }

    private javax.management.Attribute _toJMXAttribute(boolean bl) {
        String string;
        List<String> list;
        assert (Debug.debugEnter(CLASS_NAME, "_toJMXAttribute", new String[0]));
        if (bl) {
            list = this.pendingValues;
            string = this.getName() + ";" + "pending";
        } else {
            list = this.activeValues;
            string = this.getName();
        }
        if (this.isMultiValued()) {
            String[] stringArray = new String[list.size()];
            list.toArray(stringArray);
            return new javax.management.Attribute(string, stringArray);
        }
        if (list.isEmpty()) {
            return null;
        }
        return new javax.management.Attribute(string, list.get(0));
    }

    @Override
    public javax.management.Attribute toJMXAttribute() {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXAttribute", new String[0]));
        return this._toJMXAttribute(false);
    }

    @Override
    public javax.management.Attribute toJMXAttributePending() {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXAttributePending", new String[0]));
        return this._toJMXAttribute(true);
    }

    @Override
    public void toJMXAttribute(AttributeList attributeList) {
        Object object;
        assert (Debug.debugEnter(CLASS_NAME, "toJMXAttribute", String.valueOf(attributeList)));
        if (this.activeValues.size() > 0) {
            if (this.isMultiValued()) {
                object = new String[this.activeValues.size()];
                this.activeValues.toArray((T[])object);
                attributeList.add(new javax.management.Attribute(this.getName(), object));
            } else {
                attributeList.add(new javax.management.Attribute(this.getName(), this.activeValues.get(0)));
            }
        } else if (this.isMultiValued()) {
            attributeList.add(new javax.management.Attribute(this.getName(), new String[0]));
        } else {
            attributeList.add(new javax.management.Attribute(this.getName(), null));
        }
        if (this.requiresAdminAction() && this.pendingValues != null && this.pendingValues != this.activeValues) {
            object = this.getName() + ";" + "pending";
            if (this.isMultiValued()) {
                String[] stringArray = new String[this.pendingValues.size()];
                this.pendingValues.toArray(stringArray);
                attributeList.add(new javax.management.Attribute((String)object, stringArray));
            } else if (!this.pendingValues.isEmpty()) {
                attributeList.add(new javax.management.Attribute((String)object, this.pendingValues.get(0)));
            }
        }
    }

    @Override
    public void toJMXAttributeInfo(List<MBeanAttributeInfo> list) {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXAttributeInfo", String.valueOf(list)));
        if (this.isMultiValued()) {
            list.add(new MBeanAttributeInfo(this.getName(), ConfigConstants.JMX_TYPE_STRING_ARRAY, this.getDescription(), true, true, false));
        } else {
            list.add(new MBeanAttributeInfo(this.getName(), String.class.getName(), this.getDescription(), true, true, false));
        }
        if (this.requiresAdminAction()) {
            String string = this.getName() + ";" + "pending";
            if (this.isMultiValued()) {
                list.add(new MBeanAttributeInfo(string, ConfigConstants.JMX_TYPE_STRING_ARRAY, this.getDescription(), true, false, false));
            } else {
                list.add(new MBeanAttributeInfo(string, String.class.getName(), this.getDescription(), true, false, false));
            }
        }
    }

    @Override
    public MBeanParameterInfo toJMXParameterInfo() {
        assert (Debug.debugEnter(CLASS_NAME, "toJMXParameterInfo", new String[0]));
        if (this.isMultiValued()) {
            return new MBeanParameterInfo(this.getName(), ConfigConstants.JMX_TYPE_STRING_ARRAY, this.getDescription());
        }
        return new MBeanParameterInfo(this.getName(), String.class.getName(), this.getDescription());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setValue(javax.management.Attribute attribute) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", String.valueOf(attribute)));
        Object object = attribute.getValue();
        if (object instanceof String) {
            this.setValue((String)object);
            return;
        }
        if (!object.getClass().isArray()) {
            int n = 3342406;
            String string = MessageHandler.getMessage(n, String.valueOf(object), this.getName(), object.getClass().getName());
            throw new ConfigException(n, string);
        }
        String string = object.getClass().getComponentType().getName();
        int n = Array.getLength(object);
        if (!string.equals(String.class.getName())) {
            int n2 = 3342407;
            String string2 = MessageHandler.getMessage(n2, string);
            throw new ConfigException(n2, string2);
        }
        try {
            ArrayList<String> arrayList = new ArrayList<String>(n);
            int n3 = 0;
            while (true) {
                if (n3 >= n) {
                    this.setValues(arrayList);
                    return;
                }
                arrayList.add((String)Array.get(object, n3));
                ++n3;
            }
        }
        catch (ConfigException configException) {
            if ($assertionsDisabled) throw configException;
            if (Debug.debugException(CLASS_NAME, "setValue", configException)) throw configException;
            throw new AssertionError();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "setValue", exception));
            int n4 = 3342405;
            String string3 = MessageHandler.getMessage(n4, this.getName(), String.valueOf(object), String.valueOf(exception));
            throw new ConfigException(n4, string3, exception);
        }
    }

    @Override
    public ConfigAttribute duplicate() {
        assert (Debug.debugEnter(CLASS_NAME, "duplicate", new String[0]));
        return new MultiChoiceConfigAttribute(this.getName(), this.getDescription(), this.isRequired(), this.isMultiValued(), this.requiresAdminAction(), this.allowedValues, this.activeValues, this.pendingValues);
    }
}

