/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.changelog;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.zip.DataFormatException;
import org.opends.server.changelog.ProtocolSession;
import org.opends.server.synchronization.SynchronizationMessage;

public class SocketSession
implements ProtocolSession {
    private Socket socket;
    private InputStream input;
    private OutputStream output;
    byte[] rcvLengthBuf = new byte[8];

    public SocketSession(Socket socket) throws IOException {
        this.socket = socket;
        this.input = socket.getInputStream();
        this.output = socket.getOutputStream();
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public synchronized void publish(SynchronizationMessage synchronizationMessage) throws IOException {
        byte[] byArray = synchronizationMessage.getBytes();
        String string = String.format("%08x", byArray.length);
        byte[] byArray2 = string.getBytes();
        this.output.write(byArray2);
        this.output.write(byArray);
        this.output.flush();
    }

    public SynchronizationMessage receive() throws IOException, ClassNotFoundException, DataFormatException {
        int n;
        int n2;
        for (n = 0; n < 8; n += n2) {
            n2 = this.input.read(this.rcvLengthBuf, n, 8 - n);
            if (n2 != -1) continue;
            throw new IOException("no more data");
        }
        n2 = Integer.parseInt(new String(this.rcvLengthBuf), 16);
        try {
            byte[] byArray = new byte[n2];
            for (n = 0; n < n2; n += this.input.read(byArray, n, n2 - n)) {
            }
            return SynchronizationMessage.generateMsg(byArray);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new IOException("Packet too large, can't allocate " + n2 + " bytes.");
        }
    }

    public String getRemoteAddress() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public void setSoTimeout(int n) throws SocketException {
        this.socket.setSoTimeout(n);
    }
}

