/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.changelog;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.opends.server.changelog.ProtocolSession;
import org.opends.server.synchronization.SynchronizationMessage;

public class SerializingProtocolSession
implements ProtocolSession {
    Socket socket;
    ObjectOutputStream socketOutput = null;
    ObjectInputStream socketInput = null;
    private int count = 0;

    public SerializingProtocolSession(Socket socket) throws IOException {
        this.socket = socket;
        this.socketOutput = new ObjectOutputStream(socket.getOutputStream());
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public synchronized void publish(SynchronizationMessage synchronizationMessage) throws IOException, SocketException {
        this.socketOutput.writeObject(synchronizationMessage);
        this.socketOutput.flush();
        if (this.count++ >= 5000) {
            this.socketOutput.reset();
            this.count = 0;
        }
    }

    public SynchronizationMessage receive() throws IOException, ClassNotFoundException {
        if (this.socketInput == null) {
            this.socketInput = new ObjectInputStream(this.socket.getInputStream());
        }
        return (SynchronizationMessage)this.socketInput.readObject();
    }

    public String getRemoteAddress() {
        return this.socket.getInetAddress().getHostAddress();
    }

    public void setSoTimeout(int n) throws SocketException {
        this.socket.setSoTimeout(n);
    }
}

