/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.changelog;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import java.io.File;
import java.io.UnsupportedEncodingException;
import org.opends.server.changelog.Changelog;
import org.opends.server.changelog.ChangelogDBException;
import org.opends.server.changelog.DbHandler;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;

public class ChangelogDbEnv {
    private Environment dbEnvironment = null;
    private Database stateDb = null;
    private Changelog changelog = null;

    public ChangelogDbEnv(String string, Changelog changelog) throws DatabaseException, ChangelogDBException {
        this.changelog = changelog;
        EnvironmentConfig environmentConfig = new EnvironmentConfig();
        environmentConfig.setAllowCreate(true);
        environmentConfig.setTransactional(true);
        environmentConfig.setConfigParam("je.cleaner.expunge", "true");
        environmentConfig.setConfigParam("je.maxMemory", "5000000");
        this.dbEnvironment = new Environment(new File(string), environmentConfig);
        DatabaseConfig databaseConfig = new DatabaseConfig();
        databaseConfig.setAllowCreate(true);
        databaseConfig.setTransactional(true);
        this.stateDb = this.dbEnvironment.openDatabase(null, "changelogstate", databaseConfig);
        this.start();
    }

    private void start() throws DatabaseException, ChangelogDBException {
        Cursor cursor = this.stateDb.openCursor(null, null);
        DatabaseEntry databaseEntry = new DatabaseEntry();
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        try {
            OperationStatus operationStatus = cursor.getFirst(databaseEntry, databaseEntry2, LockMode.DEFAULT);
            while (operationStatus == OperationStatus.SUCCESS) {
                try {
                    String string = new String(databaseEntry2.getData(), "UTF-8");
                    String[] stringArray = string.split(" ", 2);
                    short s = new Short(stringArray[0]);
                    DN dN = null;
                    try {
                        dN = DN.decode(stringArray[1]);
                    }
                    catch (DirectoryException directoryException) {
                        int n = 17039387;
                        String string2 = MessageHandler.getMessage(n, stringArray[1]);
                        Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string2, n);
                    }
                    DbHandler dbHandler = new DbHandler(s, dN, this.changelog, this);
                    this.changelog.getChangelogCache(dN).newDb(s, dbHandler);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new ChangelogDBException(0, "changelog state database has a wrong format");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new ChangelogDBException(0, "need UTF-8 support");
                }
                operationStatus = cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT);
            }
            cursor.close();
        }
        catch (DatabaseException databaseException) {
            cursor.close();
            throw databaseException;
        }
    }

    public Database getOrAddDb(Short s, DN dN) throws DatabaseException {
        try {
            String string = s.toString() + " " + dN.toNormalizedString();
            byte[] byArray = string.getBytes("UTF-8");
            DatabaseConfig databaseConfig = new DatabaseConfig();
            databaseConfig.setAllowCreate(true);
            databaseConfig.setTransactional(true);
            Database database = this.dbEnvironment.openDatabase(null, string, databaseConfig);
            DatabaseEntry databaseEntry = new DatabaseEntry();
            databaseEntry.setData(byArray);
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = this.stateDb.get(null, databaseEntry, databaseEntry2, LockMode.DEFAULT);
            if (operationStatus == OperationStatus.NOTFOUND) {
                Transaction transaction = this.dbEnvironment.beginTransaction(null, null);
                try {
                    databaseEntry2.setData(byArray);
                    this.stateDb.put(transaction, databaseEntry, databaseEntry2);
                    transaction.commitWriteNoSync();
                }
                catch (DatabaseException databaseException) {
                    transaction.abort();
                    throw databaseException;
                }
            }
            return database;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public Transaction beginTransaction() throws DatabaseException {
        return this.dbEnvironment.beginTransaction(null, null);
    }

    public void shutdown() {
        try {
            this.stateDb.close();
            this.dbEnvironment.close();
        }
        catch (DatabaseException databaseException) {
            int n = 17039388;
            String string = MessageHandler.getMessage(n) + StaticUtils.stackTraceToSingleLineString(databaseException);
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
    }
}

