/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.changelog;

import com.sleepycat.je.DatabaseException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.DirectoryThread;
import org.opends.server.changelog.ChangelogCache;
import org.opends.server.changelog.ChangelogDBException;
import org.opends.server.changelog.ChangelogDbEnv;
import org.opends.server.changelog.DbHandler;
import org.opends.server.changelog.ServerHandler;
import org.opends.server.changelog.SocketSession;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.IntegerConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Changelog
implements Runnable,
ConfigurableComponent {
    private short serverId;
    private String serverURL;
    private ServerSocket listenSocket;
    private Thread myListenThread;
    private Thread myConnectThread;
    private boolean runListen = true;
    private List<String> changelogServers;
    private HashMap<DN, ChangelogCache> baseDNs = new HashMap();
    private String localURL = "null";
    private boolean shutdown = false;
    private short changelogServerId;
    private DN configDn;
    private List<ConfigAttribute> configAttributes = new ArrayList<ConfigAttribute>();
    private ChangelogDbEnv dbEnv;
    private int rcvWindow;
    static final String CHANGELOG_SERVER_ATTR = "ds-cfg-changelog-server";
    static final String SERVER_ID_ATTR = "ds-cfg-changelog-server-id";
    static final String CHANGELOG_PORT_ATTR = "ds-cfg-changelog-port";
    static final String WINDOW_SIZE_ATTR = "ds-cfg-window-size";
    static final IntegerConfigAttribute changelogPortStub = new IntegerConfigAttribute("ds-cfg-changelog-port", "changelog port", true, false, false, true, 0L, true, 65535L);
    static final IntegerConfigAttribute serverIdStub = new IntegerConfigAttribute("ds-cfg-changelog-server-id", "server ID", true, false, false, true, 0L, true, 65535L);
    static final StringConfigAttribute changelogStub = new StringConfigAttribute("ds-cfg-changelog-server", "changelog server information", true, true, false);
    static final IntegerConfigAttribute windowStub = new IntegerConfigAttribute("ds-cfg-window-size", "window size", false, false, false, true, 0L, false, 0L);

    public static boolean checkConfigEntry(ConfigEntry configEntry, StringBuilder stringBuilder) {
        try {
            IntegerConfigAttribute integerConfigAttribute;
            IntegerConfigAttribute integerConfigAttribute2 = (IntegerConfigAttribute)configEntry.getConfigAttribute(changelogPortStub);
            if (integerConfigAttribute2 == null) {
                stringBuilder.append(MessageHandler.getMessage(16973837, configEntry.getDN().toString()));
            }
            if ((integerConfigAttribute = (IntegerConfigAttribute)configEntry.getConfigAttribute(serverIdStub)) == null) {
                stringBuilder.append(MessageHandler.getMessage(0x1030003, configEntry.getDN().toString()));
            }
            return true;
        }
        catch (ConfigException configException) {
            return false;
        }
    }

    public Changelog(ConfigEntry configEntry) throws ConfigException {
        IntegerConfigAttribute integerConfigAttribute = (IntegerConfigAttribute)configEntry.getConfigAttribute(changelogPortStub);
        if (integerConfigAttribute == null) {
            throw new ConfigException(16973837, MessageHandler.getMessage(16973837, configEntry.getDN().toString()));
        }
        int n = integerConfigAttribute.activeIntValue();
        this.configAttributes.add(integerConfigAttribute);
        IntegerConfigAttribute integerConfigAttribute2 = (IntegerConfigAttribute)configEntry.getConfigAttribute(serverIdStub);
        if (integerConfigAttribute2 == null) {
            throw new ConfigException(0x1030003, MessageHandler.getMessage(0x1030003, configEntry.getDN().toString()));
        }
        this.changelogServerId = (short)integerConfigAttribute2.activeIntValue();
        this.configAttributes.add(integerConfigAttribute2);
        StringConfigAttribute stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(changelogStub);
        this.changelogServers = new ArrayList<String>();
        if (stringConfigAttribute != null) {
            for (String string : stringConfigAttribute.activeValues()) {
                String[] stringArray = string.split(":");
                try {
                    this.changelogServers.add(InetAddress.getByName(stringArray[0]).getHostAddress() + ":" + stringArray[1]);
                }
                catch (UnknownHostException unknownHostException) {
                    throw new ConfigException(16973829, unknownHostException.getLocalizedMessage());
                }
            }
        }
        this.configAttributes.add(stringConfigAttribute);
        IntegerConfigAttribute integerConfigAttribute3 = (IntegerConfigAttribute)configEntry.getConfigAttribute(windowStub);
        if (integerConfigAttribute3 == null) {
            this.rcvWindow = 100;
        } else {
            this.rcvWindow = integerConfigAttribute3.activeIntValue();
            this.configAttributes.add(integerConfigAttribute3);
        }
        this.initialize(this.changelogServerId, n);
        this.configDn = configEntry.getDN();
        DirectoryServer.registerConfigurableComponent(this);
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        return this.configDn;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        return this.configAttributes;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        return false;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        return null;
    }

    @Override
    public void run() {
        if (this.runListen) {
            this.runListen = false;
            this.runListen();
        } else {
            this.runConnect();
        }
    }

    private void runListen() {
        Socket socket = null;
        while (!this.shutdown) {
            try {
                socket = this.listenSocket.accept();
                socket.setReceiveBufferSize(1000000);
                ServerHandler serverHandler = new ServerHandler(new SocketSession(socket));
                serverHandler.start(null, this.serverId, this.serverURL, this.rcvWindow, this);
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runConnect() {
        while (!this.shutdown) {
            for (ChangelogCache changelogCache : this.baseDNs.values()) {
                Set<String> set = changelogCache.getChangelogs();
                for (String string : this.changelogServers) {
                    if (string.compareTo(this.localURL) == 0 || set.contains(string)) continue;
                    this.connect(string, changelogCache.getBaseDn());
                }
            }
            try {
                Changelog changelog = this;
                synchronized (changelog) {
                    this.wait(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
    }

    private void connect(String string, DN dN) {
        String[] stringArray = string.split(":");
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        try {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(InetAddress.getByName(string2), Integer.parseInt(string3));
            Socket socket = new Socket();
            socket.setReceiveBufferSize(1000000);
            socket.connect(inetSocketAddress, 500);
            ServerHandler serverHandler = new ServerHandler(new SocketSession(socket));
            serverHandler.start(dN, this.serverId, string, this.rcvWindow, this);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initialize(short s, int n) {
        try {
            this.dbEnv = new ChangelogDbEnv(DirectoryServer.getServerRoot() + File.separator + "changelogDb", this);
            this.serverId = s;
            String string = InetAddress.getLocalHost().getHostName();
            String string2 = InetAddress.getLocalHost().getHostAddress();
            this.serverURL = string + ":" + String.valueOf(n);
            this.localURL = string2 + ":" + String.valueOf(n);
            this.listenSocket = new ServerSocket();
            this.listenSocket.setReceiveBufferSize(1000000);
            this.listenSocket.bind(new InetSocketAddress(n));
            this.myListenThread = new DirectoryThread(this, "Changelog Listener");
            this.myListenThread.start();
            this.myConnectThread = new DirectoryThread(this, "Changelog Connect");
            this.myConnectThread.start();
        }
        catch (DatabaseException databaseException) {
            int n2 = 16973834;
            String string = MessageHandler.getMessage(n2, "changelogDb");
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n2);
        }
        catch (ChangelogDBException changelogDBException) {
            int n3 = 16973835;
            String string = MessageHandler.getMessage(n3, "changelogDb");
            string = string + MessageHandler.getMessage(changelogDBException.getMessageID());
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n3);
        }
        catch (UnknownHostException unknownHostException) {
            int n4 = 16973829;
            String string = MessageHandler.getMessage(n4);
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n4);
        }
        catch (IOException iOException) {
            int n5 = 16973830;
            String string = MessageHandler.getMessage(n5, n, iOException.getMessage());
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n5);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ChangelogCache getChangelogCache(DN dN) {
        ChangelogCache changelogCache;
        HashMap<DN, ChangelogCache> hashMap = this.baseDNs;
        synchronized (hashMap) {
            changelogCache = this.baseDNs.get(dN);
            if (changelogCache == null) {
                changelogCache = new ChangelogCache(dN, this);
            }
            this.baseDNs.put(dN, changelogCache);
        }
        return changelogCache;
    }

    public void shutdown() {
        this.shutdown = true;
        this.myConnectThread.interrupt();
        try {
            this.listenSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        for (ChangelogCache changelogCache : this.baseDNs.values()) {
            changelogCache.shutdown();
        }
        this.dbEnv.shutdown();
    }

    public DbHandler newDbHandler(short s, DN dN) throws DatabaseException {
        return new DbHandler(s, dN, this, this.dbEnv);
    }
}

