/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.task;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.api.Backend;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.backends.task.RecurringTask;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskScheduler;
import org.opends.server.backends.task.TaskState;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.IntegerWithUnitConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.BackupConfig;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.CancelledOperationException;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.types.RestoreConfig;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskBackend
extends Backend
implements ConfigurableComponent {
    private static final String CLASS_NAME = "org.opends.server.backends.task.TaskBackend";
    private static final LinkedHashMap<String, Double> timeUnits = new LinkedHashMap();
    private DN configEntryDN;
    private DN recurringTaskParentDN;
    private DN scheduledTaskParentDN;
    private DN taskRootDN;
    private DN[] baseDNs;
    private HashSet<String> supportedControls;
    private HashSet<String> supportedFeatures;
    private long retentionTime;
    private String taskBackingFile;
    private TaskScheduler taskScheduler;

    public TaskBackend() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeBackend(ConfigEntry configEntry, DN[] dNArray) throws ConfigException, InitializationException {
        ConfigAttribute configAttribute;
        assert (Debug.debugEnter(CLASS_NAME, "initializeBackend", String.valueOf(configEntry)));
        if (configEntry == null) {
            int n = 9699439;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        this.configEntryDN = configEntry.getDN();
        if (dNArray == null || dNArray.length == 0) {
            int n = 9699440;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        if (dNArray.length > 1) {
            int n = 9699441;
            String string = MessageHandler.getMessage(n);
            throw new ConfigException(n, string);
        }
        this.baseDNs = dNArray;
        this.taskRootDN = dNArray[0];
        String string = "cn=Recurring Tasks," + this.taskRootDN.toString();
        try {
            this.recurringTaskParentDN = DN.decode(string);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeBackend", exception));
            int n = 9699442;
            String string2 = MessageHandler.getMessage(n, String.valueOf(string), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string2, exception);
        }
        Object object = "cn=Scheduled Tasks," + this.taskRootDN.toString();
        try {
            this.scheduledTaskParentDN = DN.decode((String)object);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeBackend", exception));
            int n = 9699443;
            String string3 = MessageHandler.getMessage(n, String.valueOf(object), StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string3, exception);
        }
        int n = 9437300;
        object = new IntegerWithUnitConfigAttribute("ds-cfg-task-retention-time", MessageHandler.getMessage(n), false, timeUnits, true, 0L, false, 0L);
        try {
            configAttribute = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute((ConfigAttribute)object);
            this.retentionTime = configAttribute == null ? 86400L : configAttribute.activeCalculatedValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeBackend", exception));
            n = 9699445;
            String string4 = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string4, exception);
        }
        n = 9437302;
        configAttribute = new StringConfigAttribute("ds-cfg-task-backing-file", MessageHandler.getMessage(n), true, false, false);
        try {
            StringConfigAttribute stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(configAttribute);
            this.taskBackingFile = stringConfigAttribute == null ? DirectoryServer.getServerRoot() + File.separator + "config" + File.separator + "tasks.ldif" : stringConfigAttribute.activeValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "initializeBackend", exception));
            n = 9699447;
            String string5 = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new InitializationException(n, string5, exception);
        }
        this.taskScheduler = new TaskScheduler(this);
        this.taskScheduler.start();
        this.supportedControls = new HashSet(0);
        this.supportedFeatures = new HashSet(0);
        DirectoryServer.registerConfigurableComponent(this);
        DirectoryServer.registerPrivateSuffix(dNArray[0], this);
    }

    @Override
    public void finalizeBackend() {
        block6: {
            block5: {
                assert (Debug.debugEnter(CLASS_NAME, "finalizeBackend", new String[0]));
                DirectoryServer.deregisterConfigurableComponent(this);
                try {
                    this.taskScheduler.stopScheduler();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "finalizeBackend", exception)) break block5;
                    throw new AssertionError();
                }
            }
            try {
                int n = 0x90009C;
                String string = MessageHandler.getMessage(n);
                this.taskScheduler.interruptRunningTasks(TaskState.STOPPED_BY_SHUTDOWN, string, true);
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "finalizeBackend", exception)) break block6;
                throw new AssertionError();
            }
        }
    }

    @Override
    public DN[] getBaseDNs() {
        assert (Debug.debugEnter(CLASS_NAME, "getBaseDNs", new String[0]));
        return this.baseDNs;
    }

    @Override
    public boolean isLocal() {
        assert (Debug.debugEnter(CLASS_NAME, "isLocal", new String[0]));
        return true;
    }

    @Override
    public Entry getEntry(DN dN) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getEntry", String.valueOf(dN)));
        if (dN == null) {
            return null;
        }
        if (dN.equals(this.taskRootDN)) {
            return this.taskScheduler.getTaskRootEntry();
        }
        if (dN.equals(this.scheduledTaskParentDN)) {
            return this.taskScheduler.getScheduledTaskParentEntry();
        }
        if (dN.equals(this.recurringTaskParentDN)) {
            return this.taskScheduler.getRecurringTaskParentEntry();
        }
        DN dN2 = dN.getParentDNInSuffix();
        if (dN2 == null) {
            return null;
        }
        if (dN2.equals(this.scheduledTaskParentDN)) {
            return this.taskScheduler.getScheduledTaskEntry(dN);
        }
        if (dN2.equals(this.recurringTaskParentDN)) {
            return this.taskScheduler.getRecurringTaskEntry(dN);
        }
        return null;
    }

    @Override
    public boolean entryExists(DN dN) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "entryExists", String.valueOf(dN)));
        if (dN == null) {
            return false;
        }
        if (dN.equals(this.taskRootDN) || dN.equals(this.scheduledTaskParentDN) || dN.equals(this.recurringTaskParentDN)) {
            return true;
        }
        DN dN2 = dN.getParentDNInSuffix();
        if (dN2 == null) {
            return false;
        }
        if (dN2.equals(this.scheduledTaskParentDN)) {
            return this.taskScheduler.getScheduledTaskEntry(dN) != null;
        }
        if (dN2.equals(this.recurringTaskParentDN)) {
            return this.taskScheduler.getRecurringTaskEntry(dN) != null;
        }
        return false;
    }

    @Override
    public void addEntry(Entry entry, AddOperation addOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "addEntry", String.valueOf(entry), String.valueOf(addOperation)));
        DN dN = entry.getDN();
        DN dN2 = dN.getParentDNInSuffix();
        if (dN2 == null) {
            int n = 9699458;
            String string = MessageHandler.getMessage(n, String.valueOf(this.scheduledTaskParentDN), String.valueOf(this.recurringTaskParentDN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
        }
        if (dN2.equals(this.scheduledTaskParentDN)) {
            Task task = this.taskScheduler.entryToScheduledTask(entry);
            this.taskScheduler.scheduleTask(task, true);
            return;
        }
        if (dN2.equals(this.recurringTaskParentDN)) {
            RecurringTask recurringTask = this.taskScheduler.entryToRecurringTask(entry);
            this.taskScheduler.addRecurringTask(recurringTask, true);
            return;
        }
        int n = 9699458;
        String string = MessageHandler.getMessage(n, String.valueOf(this.scheduledTaskParentDN), String.valueOf(this.recurringTaskParentDN));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void deleteEntry(DN dN, DeleteOperation deleteOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "deleteEntry", String.valueOf(dN), String.valueOf(deleteOperation)));
        DN dN2 = dN.getParentDNInSuffix();
        if (dN2 == null) {
            int n = 9699492;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
        }
        if (dN2.equals(this.scheduledTaskParentDN)) {
            Task task = this.taskScheduler.getScheduledTask(dN);
            if (task == null) {
                int n = 9699493;
                String string = MessageHandler.getMessage(n, String.valueOf(dN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
            }
            TaskState taskState = task.getTaskState();
            if (TaskState.isPending(taskState)) {
                this.taskScheduler.removePendingTask(task.getTaskID());
                return;
            }
            if (TaskState.isDone(task.getTaskState())) {
                this.taskScheduler.removeCompletedTask(task.getTaskID());
                return;
            }
            int n = 9699494;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
        }
        if (!dN2.equals(this.recurringTaskParentDN)) {
            int n = 9699492;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
        }
        RecurringTask recurringTask = this.taskScheduler.getRecurringTask(dN);
        if (recurringTask == null) {
            int n = 9699495;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
        }
        this.taskScheduler.removeRecurringTask(recurringTask.getRecurringTaskID());
    }

    @Override
    public void replaceEntry(Entry entry, ModifyOperation modifyOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "replaceEntry", String.valueOf(entry), String.valueOf(modifyOperation)));
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, "Modify operations are not yet supported in the task backend", 1);
    }

    @Override
    public void renameEntry(DN dN, Entry entry, ModifyDNOperation modifyDNOperation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "renameEntry", String.valueOf(dN), String.valueOf(entry), String.valueOf(modifyDNOperation)));
        int n = 9699459;
        String string = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public void search(SearchOperation searchOperation) throws DirectoryException, CancelledOperationException {
        Entry entry;
        assert (Debug.debugEnter(CLASS_NAME, "search", String.valueOf(searchOperation)));
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        DN dN = searchOperation.getBaseDN();
        SearchScope searchScope = searchOperation.getScope();
        SearchFilter searchFilter = searchOperation.getFilter();
        if (dN.equals(this.taskRootDN)) {
            switch (searchScope) {
                case BASE_OBJECT: {
                    bl = true;
                    break;
                }
                case SINGLE_LEVEL: {
                    bl2 = true;
                    bl4 = true;
                    break;
                }
                case WHOLE_SUBTREE: {
                    bl = true;
                    bl2 = true;
                    bl4 = true;
                    bl3 = true;
                    bl5 = true;
                    break;
                }
                case SUBORDINATE_SUBTREE: {
                    bl2 = true;
                    bl4 = true;
                    bl3 = true;
                    bl5 = true;
                }
            }
        } else if (dN.equals(this.scheduledTaskParentDN)) {
            switch (searchScope) {
                case BASE_OBJECT: {
                    bl2 = true;
                    break;
                }
                case SINGLE_LEVEL: {
                    bl3 = true;
                    break;
                }
                case WHOLE_SUBTREE: {
                    bl2 = true;
                    bl3 = true;
                    break;
                }
                case SUBORDINATE_SUBTREE: {
                    bl3 = true;
                }
            }
        } else if (dN.equals(this.recurringTaskParentDN)) {
            switch (searchScope) {
                case BASE_OBJECT: {
                    bl4 = true;
                    break;
                }
                case SINGLE_LEVEL: {
                    bl5 = true;
                    break;
                }
                case WHOLE_SUBTREE: {
                    bl4 = true;
                    bl5 = true;
                    break;
                }
                case SUBORDINATE_SUBTREE: {
                    bl5 = true;
                }
            }
        } else {
            DN dN2 = dN.getParentDNInSuffix();
            if (dN2 == null) {
                int n = 9699496;
                String string = MessageHandler.getMessage(n, String.valueOf(dN));
                throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
            }
            if (dN2.equals(this.scheduledTaskParentDN)) {
                Entry entry2 = this.taskScheduler.getScheduledTaskEntry(dN);
                if (entry2 == null) {
                    int n = 9699497;
                    String string = MessageHandler.getMessage(n, String.valueOf(dN));
                    throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n, this.scheduledTaskParentDN, null);
                }
                if ((searchScope == SearchScope.BASE_OBJECT || searchScope == SearchScope.WHOLE_SUBTREE) && searchFilter.matchesEntry(entry2)) {
                    searchOperation.returnEntry(entry2, null);
                }
                return;
            }
            if (dN2.equals(this.recurringTaskParentDN)) {
                Entry entry3 = this.taskScheduler.getRecurringTaskEntry(dN);
                if (entry3 == null) {
                    int n = 9699498;
                    String string = MessageHandler.getMessage(n, String.valueOf(dN));
                    throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n, this.recurringTaskParentDN, null);
                }
                if ((searchScope == SearchScope.BASE_OBJECT || searchScope == SearchScope.WHOLE_SUBTREE) && searchFilter.matchesEntry(entry3)) {
                    searchOperation.returnEntry(entry3, null);
                }
                return;
            }
            int n = 9699496;
            String string = MessageHandler.getMessage(n, String.valueOf(dN));
            throw new DirectoryException(ResultCode.NO_SUCH_OBJECT, string, n);
        }
        if (bl && searchFilter.matchesEntry(entry = this.taskScheduler.getTaskRootEntry()) && !searchOperation.returnEntry(entry, null)) {
            return;
        }
        if (bl2 && searchFilter.matchesEntry(entry = this.taskScheduler.getScheduledTaskParentEntry()) && !searchOperation.returnEntry(entry, null)) {
            return;
        }
        if (bl3 && !this.taskScheduler.searchScheduledTasks(searchOperation)) {
            return;
        }
        if (bl4 && searchFilter.matchesEntry(entry = this.taskScheduler.getRecurringTaskParentEntry()) && !searchOperation.returnEntry(entry, null)) {
            return;
        }
        if (bl5 && !this.taskScheduler.searchRecurringTasks(searchOperation)) {
            return;
        }
    }

    public HashSet<String> getSupportedControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedControls", new String[0]));
        return this.supportedControls;
    }

    @Override
    public boolean supportsControl(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsControl", String.valueOf(string)));
        return false;
    }

    public HashSet<String> getSupportedFeatures() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedFeatures", new String[0]));
        return this.supportedFeatures;
    }

    @Override
    public boolean supportsFeature(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsFeature", String.valueOf(string)));
        return false;
    }

    @Override
    public boolean supportsLDIFExport() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsLDIFExport", new String[0]));
        return true;
    }

    @Override
    public void exportLDIF(ConfigEntry configEntry, DN[] dNArray, LDIFExportConfig lDIFExportConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "exportLDIF", String.valueOf(lDIFExportConfig)));
    }

    @Override
    public boolean supportsLDIFImport() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsLDIFImport", new String[0]));
        return false;
    }

    @Override
    public void importLDIF(ConfigEntry configEntry, DN[] dNArray, LDIFImportConfig lDIFImportConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "importLDIF", String.valueOf(lDIFImportConfig)));
        int n = 9699483;
        String string = MessageHandler.getMessage(n);
        throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n);
    }

    @Override
    public boolean supportsBackup() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsBackup", new String[0]));
        return true;
    }

    @Override
    public boolean supportsBackup(BackupConfig backupConfig, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "supportsBackup", new String[0]));
        return true;
    }

    @Override
    public void createBackup(ConfigEntry configEntry, BackupConfig backupConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "createBackup", String.valueOf(backupConfig)));
    }

    @Override
    public void removeBackup(BackupDirectory backupDirectory, String string) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "removeBackup", String.valueOf(backupDirectory), String.valueOf(string)));
    }

    @Override
    public boolean supportsRestore() {
        assert (Debug.debugEnter(CLASS_NAME, "supportsRestore", new String[0]));
        return true;
    }

    @Override
    public void restoreBackup(ConfigEntry configEntry, RestoreConfig restoreConfig) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "restoreBackup", String.valueOf(restoreConfig)));
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurableComponentEntryDN", new String[0]));
        return this.configEntryDN;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigurationAttributes", new String[0]));
        LinkedList<ConfigAttribute> linkedList = new LinkedList<ConfigAttribute>();
        String string = MessageHandler.getMessage(9437302);
        linkedList.add(new StringConfigAttribute("ds-cfg-task-backing-file", string, true, false, false, this.taskBackingFile));
        string = MessageHandler.getMessage(9437300);
        linkedList.add(new IntegerWithUnitConfigAttribute("ds-cfg-task-retention-time", string, false, timeUnits, true, 0L, false, 0L, this.retentionTime, "seconds"));
        return linkedList;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        int n;
        ConfigAttribute configAttribute;
        assert (Debug.debugEnter(CLASS_NAME, "hasAcceptableConfiguration", String.valueOf(configEntry), "java.util.List<String>"));
        boolean bl = true;
        String string = MessageHandler.getMessage(9437302);
        StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-task-backing-file", string, true, false, false);
        try {
            configAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
            if (configAttribute == null) {
                n = 9699448;
                list.add(MessageHandler.getMessage(n, "ds-cfg-task-backing-file"));
                bl = false;
            } else {
                String string2 = configAttribute.pendingValue();
                if (!this.taskBackingFile.equals(string2)) {
                    File file = StaticUtils.getFileForPath(string2);
                    if (file.exists()) {
                        int n2 = 9699449;
                        list.add(MessageHandler.getMessage(n2, string2));
                        bl = false;
                    } else {
                        File file2 = file.getParentFile();
                        if (file2 == null) {
                            int n3 = 9699450;
                            list.add(MessageHandler.getMessage(n3, string2));
                            bl = false;
                        } else if (!file2.exists()) {
                            int n4 = 9699451;
                            list.add(MessageHandler.getMessage(n4, file2.getPath(), string2));
                            bl = false;
                        } else if (!file2.isDirectory()) {
                            int n5 = 9699452;
                            list.add(MessageHandler.getMessage(n5, file2.getPath(), string2));
                            bl = false;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            n = 9699453;
            list.add(MessageHandler.getMessage(n, "ds-cfg-task-backing-file", StaticUtils.stackTraceToSingleLineString(exception)));
            bl = false;
        }
        string = MessageHandler.getMessage(9437300);
        configAttribute = new IntegerWithUnitConfigAttribute("ds-cfg-task-retention-time", string, false, timeUnits, true, 0L, false, 0L);
        try {
            IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(configAttribute);
            if (integerWithUnitConfigAttribute == null) {
                int n6 = 9699454;
                list.add(MessageHandler.getMessage(n6, "ds-cfg-task-retention-time"));
                bl = false;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasAcceptableConfiguration", exception));
            int n7 = 9699455;
            list.add(MessageHandler.getMessage(n7, "ds-cfg-task-retention-time", StaticUtils.stackTraceToSingleLineString(exception)));
            bl = false;
        }
        return bl;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        long l;
        String string;
        ArrayList<String> arrayList;
        boolean bl2;
        ResultCode resultCode;
        block23: {
            assert (Debug.debugEnter(CLASS_NAME, "applyNewConfiguration", String.valueOf(configEntry), String.valueOf(bl)));
            resultCode = ResultCode.SUCCESS;
            bl2 = false;
            arrayList = new ArrayList<String>();
            string = this.taskBackingFile;
            String string2 = MessageHandler.getMessage(9437302);
            StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-task-backing-file", string2, true, false, false);
            try {
                StringConfigAttribute stringConfigAttribute2 = (StringConfigAttribute)configEntry.getConfigAttribute(stringConfigAttribute);
                if (stringConfigAttribute2 == null) {
                    int n = 9699448;
                    arrayList.add(MessageHandler.getMessage(n, "ds-cfg-task-backing-file"));
                    resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                } else {
                    string = stringConfigAttribute2.pendingValue();
                    if (!this.taskBackingFile.equals(string)) {
                        File file = StaticUtils.getFileForPath(string);
                        if (file.exists()) {
                            int n = 9699449;
                            arrayList.add(MessageHandler.getMessage(n, string));
                            resultCode = ResultCode.CONSTRAINT_VIOLATION;
                        } else {
                            int n;
                            File file2 = file.getParentFile();
                            if (file2 == null) {
                                n = 9699450;
                                arrayList.add(MessageHandler.getMessage(n, string));
                                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                            } else if (!file2.exists()) {
                                n = 9699451;
                                arrayList.add(MessageHandler.getMessage(n, string));
                                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                            } else if (!file2.isDirectory()) {
                                n = 9699452;
                                arrayList.add(MessageHandler.getMessage(n, string));
                                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                int n = 9699453;
                arrayList.add(MessageHandler.getMessage(n, "ds-cfg-task-backing-file", StaticUtils.stackTraceToSingleLineString(exception)));
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
            l = this.retentionTime;
            string2 = MessageHandler.getMessage(9437300);
            IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute = new IntegerWithUnitConfigAttribute("ds-cfg-task-retention-time", string2, false, timeUnits, true, 0L, false, 0L);
            try {
                IntegerWithUnitConfigAttribute integerWithUnitConfigAttribute2 = (IntegerWithUnitConfigAttribute)configEntry.getConfigAttribute(integerWithUnitConfigAttribute);
                if (integerWithUnitConfigAttribute2 == null) {
                    int n = 9699454;
                    arrayList.add(MessageHandler.getMessage(n, "ds-cfg-task-retention-time"));
                    if (resultCode == ResultCode.SUCCESS) {
                        resultCode = ResultCode.OBJECTCLASS_VIOLATION;
                    }
                } else {
                    l = integerWithUnitConfigAttribute2.activeCalculatedValue();
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "applyNewConfiguration", exception));
                int n = 9699455;
                arrayList.add(MessageHandler.getMessage(n, "ds-cfg-task-retention-time", StaticUtils.stackTraceToSingleLineString(exception)));
                if (resultCode != ResultCode.SUCCESS) break block23;
                resultCode = DirectoryServer.getServerErrorResultCode();
            }
        }
        if (resultCode == ResultCode.SUCCESS) {
            if (this.retentionTime != l) {
                this.retentionTime = l;
                int n = 0x900080;
                arrayList.add(MessageHandler.getMessage(n, this.retentionTime));
            }
            if (!this.taskBackingFile.equals(string)) {
                this.taskBackingFile = string;
                this.taskScheduler.writeState();
                int n = 9437313;
                arrayList.add(MessageHandler.getMessage(n, this.taskBackingFile));
            }
        }
        return new ConfigChangeResult(resultCode, bl2, arrayList);
    }

    public DN getConfigEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigEntryDN", new String[0]));
        return this.configEntryDN;
    }

    public String getTaskBackingFile() {
        assert (Debug.debugEnter(CLASS_NAME, "getTaskBackingFile", new String[0]));
        File file = StaticUtils.getFileForPath(this.taskBackingFile);
        return file.getPath();
    }

    public long getRetentionTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getRetentionTime", new String[0]));
        return this.retentionTime;
    }

    public DN getTaskRootDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getTaskRootDN", new String[0]));
        return this.taskRootDN;
    }

    public DN getRecurringTasksParentDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getRecurringTasksParentDN", new String[0]));
        return this.recurringTaskParentDN;
    }

    public DN getScheduledTasksParentDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getScheduledTasksParentDN", new String[0]));
        return this.scheduledTaskParentDN;
    }

    static {
        timeUnits.put("s", 1.0);
        timeUnits.put("seconds", 1.0);
        timeUnits.put("m", 60.0);
        timeUnits.put("minutes", 60.0);
        timeUnits.put("h", 3600.0);
        timeUnits.put("hours", 3600.0);
        timeUnits.put("d", 86400.0);
        timeUnits.put("days", 86400.0);
        timeUnits.put("w", 604800.0);
        timeUnits.put("weeks", 604800.0);
    }
}

