/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.opends.server.api.MatchingRule;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.Config;
import org.opends.server.backends.jeb.DN2ID;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.EntryIDSet;
import org.opends.server.backends.jeb.ID2Entry;
import org.opends.server.backends.jeb.Index;
import org.opends.server.backends.jeb.IndexConfig;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.backends.jeb.RootContainer;
import org.opends.server.backends.jeb.VerifyConfig;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerifyJob {
    private static final String CLASS_NAME = "org.opends.server.backends.jeb.VerifyJob";
    private VerifyConfig verifyConfig;
    private Config config;
    RootContainer rootContainer;
    private long progressInterval = 10000L;
    private long keyCount = 0L;
    private long errorCount = 0L;
    long entryLimitExceededCount = 0L;
    long multiReferenceCount = 0L;
    long entryReferencesCount = 0L;
    long maxEntryPerValue = 0L;
    IdentityHashMap<Index, HashMap<ByteString, Long>> entryLimitMap = new IdentityHashMap();
    private boolean verifyDN2ID = false;
    private boolean verifyID2Children = false;
    private boolean verifyID2Subtree = false;
    ID2Entry id2entry = null;
    DN2ID dn2id = null;
    Index id2c = null;
    Index id2s = null;
    ArrayList<AttributeIndex> attrIndexList = new ArrayList();

    public VerifyJob(Config config, VerifyConfig verifyConfig) {
        this.verifyConfig = verifyConfig;
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void verifyBackend(RootContainer rootContainer, Entry entry) throws DatabaseException, JebException {
        Object object;
        Object object22;
        Object object3;
        this.rootContainer = rootContainer;
        EntryContainer entryContainer = rootContainer.getEntryContainer(this.verifyConfig.getBaseDN());
        ArrayList<String> arrayList = this.verifyConfig.getCompleteList();
        ArrayList<String> arrayList2 = this.verifyConfig.getCleanList();
        boolean bl = false;
        if (arrayList.isEmpty() && arrayList2.isEmpty()) {
            this.verifyDN2ID = true;
            this.verifyID2Children = true;
            this.verifyID2Subtree = true;
            object3 = this.config.getIndexConfigMap();
            for (Object object22 : object3.values()) {
                object = entryContainer.getAttributeIndex(((IndexConfig)object22).getAttributeType());
                this.attrIndexList.add((AttributeIndex)object);
            }
        } else {
            if (!arrayList.isEmpty()) {
                object3 = arrayList;
            } else {
                object3 = arrayList2;
                bl = true;
            }
            Iterator<String> iterator = ((ArrayList)object3).iterator();
            while (iterator.hasNext()) {
                object22 = iterator.next();
                object = ((String)object22).toLowerCase();
                if (((String)object).equals("dn2id")) {
                    this.verifyDN2ID = true;
                    continue;
                }
                if (((String)object).equals("id2children")) {
                    this.verifyID2Children = true;
                    continue;
                }
                if (((String)object).equals("id2subtree")) {
                    this.verifyID2Subtree = true;
                    continue;
                }
                AttributeType attributeType = DirectoryServer.getAttributeType((String)object);
                if (attributeType == null) {
                    int n = 8585261;
                    String string = MessageHandler.getMessage(n, object22);
                    throw new JebException(n, string);
                }
                AttributeIndex attributeIndex = entryContainer.getAttributeIndex(attributeType);
                if (attributeIndex == null) {
                    int n = 8585261;
                    String string = MessageHandler.getMessage(n, object22);
                    throw new JebException(n, string);
                }
                this.attrIndexList.add(attributeIndex);
            }
        }
        this.entryLimitMap = new IdentityHashMap(this.attrIndexList.size());
        this.id2entry = entryContainer.getID2Entry();
        this.dn2id = entryContainer.getDN2ID();
        this.id2c = entryContainer.getID2Children();
        this.id2s = entryContainer.getID2Subtree();
        long l = System.currentTimeMillis();
        object22 = new Timer();
        object = new ProgressTask();
        ((Timer)object22).scheduleAtFixedRate((TimerTask)object, this.progressInterval, this.progressInterval);
        try {
            if (bl) {
                this.iterateIndex();
            } else {
                this.iterateID2Entry();
            }
        }
        finally {
            ((Timer)object22).cancel();
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        float f = 0.0f;
        if (l3 > 0L) {
            f = 1000.0f * (float)this.keyCount / (float)l3;
        }
        this.addStatEntry(entry, "verify-error-count", String.valueOf(this.errorCount));
        this.addStatEntry(entry, "verify-key-count", String.valueOf(this.keyCount));
        if (bl) {
            int n = 8388709;
            String string = MessageHandler.getMessage(n, this.keyCount, this.errorCount, l3 / 1000L, Float.valueOf(f));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n);
            if (this.multiReferenceCount > 0L) {
                float f2 = 0.0f;
                if (this.keyCount > 0L) {
                    f2 = (float)this.entryReferencesCount / (float)this.keyCount;
                }
                n = 0x800066;
                string = MessageHandler.getMessage(n, this.multiReferenceCount);
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n);
                this.addStatEntry(entry, "verify-multiple-reference-count", String.valueOf(this.multiReferenceCount));
                n = 8388711;
                string = MessageHandler.getMessage(n, this.entryLimitExceededCount);
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n);
                this.addStatEntry(entry, "verify-entry-limit-exceeded-count", String.valueOf(this.entryLimitExceededCount));
                n = 0x800068;
                string = MessageHandler.getMessage(n, Float.valueOf(f2));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n);
                this.addStatEntry(entry, "verify-average-reference-count", String.valueOf(f2));
                n = 8388713;
                string = MessageHandler.getMessage(n, this.maxEntryPerValue);
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n);
                this.addStatEntry(entry, "verify-max-reference-count", String.valueOf(this.maxEntryPerValue));
            }
        } else {
            int n = 8388714;
            String string = MessageHandler.getMessage(n, this.keyCount, this.errorCount, l3 / 1000L, Float.valueOf(f));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n);
            if (this.entryLimitMap.size() > 0) {
                n = 8388715;
                string = MessageHandler.getMessage(n);
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n);
                for (Map.Entry<Index, HashMap<ByteString, Long>> entry2 : this.entryLimitMap.entrySet()) {
                    Index index = entry2.getKey();
                    Object[] objectArray = entry2.getValue().values().toArray(new Long[0]);
                    Arrays.sort(objectArray);
                    int n2 = objectArray.length / 2;
                    long l4 = objectArray.length % 2 == 0 ? ((Long)objectArray[n2] + (Long)objectArray[n2 - 1]) / 2L : (Long)objectArray[n2];
                    n = 8388716;
                    string = MessageHandler.getMessage(n, index.toString(), objectArray.length, objectArray[0], objectArray[objectArray.length - 1], l4);
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateID2Entry() throws DatabaseException {
        Cursor cursor = this.id2entry.openCursor(null, new CursorConfig());
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            Long l = null;
            OperationStatus operationStatus = cursor.getFirst(databaseEntry, databaseEntry2, LockMode.DEFAULT);
            while (operationStatus == OperationStatus.SUCCESS) {
                block15: {
                    EntryID entryID;
                    try {
                        entryID = new EntryID(databaseEntry);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "iterateID2Entry", exception));
                        ++this.errorCount;
                        System.err.printf("Malformed id2entry ID %s.%n", StaticUtils.bytesToHex(databaseEntry.getData()));
                        break block15;
                    }
                    if (entryID.longValue() == 0L) {
                        l = JebFormat.entryIDFromDatabase(databaseEntry2.getData());
                    } else {
                        Entry entry;
                        ++this.keyCount;
                        try {
                            entry = JebFormat.entryFromDatabase(databaseEntry2.getData());
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "iterateID2Entry", exception));
                            ++this.errorCount;
                            System.err.printf("Malformed id2entry record for ID %d:%n%s%n", entryID.longValue(), StaticUtils.bytesToHex(databaseEntry2.getData()));
                            break block15;
                        }
                        this.verifyEntry(entryID, entry);
                    }
                }
                operationStatus = cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT);
            }
            if (l != null) {
                if (this.keyCount != l) {
                    ++this.errorCount;
                    System.err.printf("The stored entry count in id2entry (%d) does not agree with the actual number of entry records found (%d).%n", l, this.keyCount);
                }
            } else {
                ++this.errorCount;
                System.err.printf("Missing record count in id2entry.%n", new Object[0]);
            }
        }
        finally {
            cursor.close();
        }
    }

    private void iterateIndex() throws JebException, DatabaseException {
        if (this.verifyDN2ID) {
            this.iterateDN2ID();
        } else if (this.verifyID2Children) {
            this.iterateID2Children();
        } else if (this.verifyID2Subtree) {
            this.iterateID2Subtree();
        } else {
            AttributeIndex attributeIndex = this.attrIndexList.get(0);
            this.iterateAttrIndex(attributeIndex.getAttributeType(), attributeIndex.equalityIndex, IndexType.EQ);
            this.iterateAttrIndex(attributeIndex.getAttributeType(), attributeIndex.presenceIndex, IndexType.PRES);
            this.iterateAttrIndex(attributeIndex.getAttributeType(), attributeIndex.substringIndex, IndexType.SUBSTRING);
            this.iterateAttrIndex(attributeIndex.getAttributeType(), attributeIndex.orderingIndex, IndexType.ORDERING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateDN2ID() throws DatabaseException {
        Cursor cursor = this.dn2id.openCursor(null, new CursorConfig());
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = cursor.getFirst(databaseEntry, databaseEntry2, LockMode.DEFAULT);
            while (operationStatus == OperationStatus.SUCCESS) {
                block16: {
                    Entry entry;
                    EntryID entryID;
                    DN dN;
                    ++this.keyCount;
                    try {
                        dN = DN.decode(new ASN1OctetString(databaseEntry.getData()));
                    }
                    catch (DirectoryException directoryException) {
                        assert (Debug.debugException(CLASS_NAME, "iterateDN2ID", directoryException));
                        ++this.errorCount;
                        System.err.printf("File dn2id has malformed key %s.%n", StaticUtils.bytesToHex(databaseEntry.getData()));
                        break block16;
                    }
                    try {
                        entryID = new EntryID(databaseEntry2);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "iterateDN2ID", exception));
                        ++this.errorCount;
                        System.err.printf("File dn2id has malformed ID for DN <%s>:%n%s%n", dN.toNormalizedString(), StaticUtils.bytesToHex(databaseEntry2.getData()));
                        break block16;
                    }
                    try {
                        entry = this.id2entry.get(null, entryID);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "iterateDN2ID", exception));
                        ++this.errorCount;
                        System.err.println(exception.getMessage());
                        break block16;
                    }
                    if (entry == null) {
                        ++this.errorCount;
                        System.err.printf("File dn2id has DN <%s> referencing unknown ID %d%n", dN.toNormalizedString(), entryID.longValue());
                    } else if (!entry.getDN().equals(dN)) {
                        ++this.errorCount;
                        System.err.printf("File dn2id has DN <%s> referencing entry with wrong DN <%s>%n", dN.toNormalizedString(), entry.getDN().toNormalizedString());
                    }
                }
                operationStatus = cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT);
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateID2Children() throws JebException, DatabaseException {
        Cursor cursor = this.id2c.openCursor(null, new CursorConfig());
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = cursor.getFirst(databaseEntry, databaseEntry2, LockMode.DEFAULT);
            while (operationStatus == OperationStatus.SUCCESS) {
                block21: {
                    EntryIDSet entryIDSet;
                    EntryID entryID;
                    ++this.keyCount;
                    try {
                        entryID = new EntryID(databaseEntry);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "iterateID2Children", exception));
                        ++this.errorCount;
                        System.err.printf("File id2children has malformed ID %s%n", StaticUtils.bytesToHex(databaseEntry.getData()));
                        break block21;
                    }
                    try {
                        JebFormat.entryIDListFromDatabase(databaseEntry2.getData());
                        entryIDSet = new EntryIDSet(databaseEntry.getData(), databaseEntry2.getData());
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "iterateID2Children", exception));
                        ++this.errorCount;
                        System.err.printf("File id2children has malformed ID list for ID %s:%n%s%n", entryID, StaticUtils.bytesToHex(databaseEntry2.getData()));
                        break block21;
                    }
                    this.updateIndexStats(entryIDSet);
                    if (entryIDSet.isDefined()) {
                        Entry entry;
                        try {
                            entry = this.id2entry.get(null, entryID);
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "iterateID2Children", exception));
                            ++this.errorCount;
                            System.err.println(exception.getMessage());
                            break block21;
                        }
                        if (entry == null) {
                            ++this.errorCount;
                            System.err.printf("File id2children has unknown ID %d%n", entryID.longValue());
                        } else {
                            for (EntryID entryID2 : entryIDSet) {
                                Entry entry2;
                                try {
                                    entry2 = this.id2entry.get(null, entryID2);
                                }
                                catch (Exception exception) {
                                    assert (Debug.debugException(CLASS_NAME, "iterateID2Children", exception));
                                    ++this.errorCount;
                                    System.err.println(exception.getMessage());
                                    continue;
                                }
                                if (entry2 == null) {
                                    ++this.errorCount;
                                    System.err.printf("File id2children has ID %d referencing unknown ID %d%n", entryID.longValue(), entryID2.longValue());
                                    continue;
                                }
                                if (entry2.getDN().isDescendantOf(entry.getDN()) && entry2.getDN().getNumComponents() == entry.getDN().getNumComponents() + 1) continue;
                                ++this.errorCount;
                                System.err.printf("File id2children has ID %d with DN <%s> referencing ID %d with non-child DN <%s>%n", entryID.longValue(), entry.getDN().toString(), entryID2.longValue(), entry2.getDN().toString());
                            }
                        }
                    }
                }
                operationStatus = cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT);
            }
        }
        finally {
            cursor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateID2Subtree() throws JebException, DatabaseException {
        Cursor cursor = this.id2s.openCursor(null, new CursorConfig());
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = cursor.getFirst(databaseEntry, databaseEntry2, LockMode.DEFAULT);
            while (operationStatus == OperationStatus.SUCCESS) {
                block21: {
                    EntryIDSet entryIDSet;
                    EntryID entryID;
                    ++this.keyCount;
                    try {
                        entryID = new EntryID(databaseEntry);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "iterateID2Subtree", exception));
                        ++this.errorCount;
                        System.err.printf("File id2subtree has malformed ID %s%n", StaticUtils.bytesToHex(databaseEntry.getData()));
                        break block21;
                    }
                    try {
                        JebFormat.entryIDListFromDatabase(databaseEntry2.getData());
                        entryIDSet = new EntryIDSet(databaseEntry.getData(), databaseEntry2.getData());
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "iterateID2Subtree", exception));
                        ++this.errorCount;
                        System.err.printf("File id2subtree has malformed ID list for ID %s:%n%s%n", entryID, StaticUtils.bytesToHex(databaseEntry2.getData()));
                        break block21;
                    }
                    this.updateIndexStats(entryIDSet);
                    if (entryIDSet.isDefined()) {
                        Entry entry;
                        try {
                            entry = this.id2entry.get(null, entryID);
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "iterateID2Subtree", exception));
                            ++this.errorCount;
                            System.err.println(exception.getMessage());
                            break block21;
                        }
                        if (entry == null) {
                            ++this.errorCount;
                            System.err.printf("File id2subtree has unknown ID %d%n", entryID.longValue());
                        } else {
                            for (EntryID entryID2 : entryIDSet) {
                                Entry entry2;
                                try {
                                    entry2 = this.id2entry.get(null, entryID2);
                                }
                                catch (Exception exception) {
                                    assert (Debug.debugException(CLASS_NAME, "iterateID2Subtree", exception));
                                    ++this.errorCount;
                                    System.err.println(exception.getMessage());
                                    continue;
                                }
                                if (entry2 == null) {
                                    ++this.errorCount;
                                    System.err.printf("File id2subtree has ID %d referencing unknown ID %d%n", entryID.longValue(), entryID2.longValue());
                                    continue;
                                }
                                if (entry2.getDN().isDescendantOf(entry.getDN())) continue;
                                ++this.errorCount;
                                System.err.printf("File id2subtree has ID %d with DN <%s> referencing ID %d with non-subordinate DN <%s>%n", entryID.longValue(), entry.getDN().toString(), entryID2.longValue(), entry2.getDN().toString());
                            }
                        }
                    }
                }
                operationStatus = cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT);
            }
        }
        finally {
            cursor.close();
        }
    }

    private void incrEntryLimitStats(Index index, byte[] byArray) {
        ASN1OctetString aSN1OctetString;
        Long l;
        HashMap<ByteString, Long> hashMap = this.entryLimitMap.get(index);
        if (hashMap == null) {
            hashMap = new HashMap();
            this.entryLimitMap.put(index, hashMap);
        }
        if ((l = hashMap.get(aSN1OctetString = new ASN1OctetString(byArray))) == null) {
            l = 1L;
        } else {
            Long l2 = l;
            Long l3 = l = Long.valueOf(l + 1L);
        }
        hashMap.put(aSN1OctetString, l);
    }

    private void updateIndexStats(EntryIDSet entryIDSet) {
        if (!entryIDSet.isDefined()) {
            ++this.entryLimitExceededCount;
            ++this.multiReferenceCount;
        } else {
            if (entryIDSet.size() > 1) {
                ++this.multiReferenceCount;
            }
            this.entryReferencesCount += (long)entryIDSet.size();
            this.maxEntryPerValue = Math.max(this.maxEntryPerValue, (long)entryIDSet.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateAttrIndex(AttributeType attributeType, Index index, IndexType indexType) throws JebException, DatabaseException {
        if (index == null) {
            return;
        }
        Cursor cursor = index.openCursor(null, new CursorConfig());
        try {
            DatabaseEntry databaseEntry = new DatabaseEntry();
            DatabaseEntry databaseEntry2 = new DatabaseEntry();
            OperationStatus operationStatus = cursor.getFirst(databaseEntry, databaseEntry2, LockMode.DEFAULT);
            while (operationStatus == OperationStatus.SUCCESS) {
                block22: {
                    SearchFilter searchFilter;
                    Object object;
                    EntryIDSet entryIDSet;
                    ++this.keyCount;
                    try {
                        JebFormat.entryIDListFromDatabase(databaseEntry2.getData());
                        entryIDSet = new EntryIDSet(databaseEntry.getData(), databaseEntry2.getData());
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "iterateAttrIndex", exception));
                        ++this.errorCount;
                        System.err.printf("Malformed ID list: %s%n%s", StaticUtils.bytesToHex(databaseEntry2.getData()), this.keyDump(index, databaseEntry.getData()));
                        break block22;
                    }
                    this.updateIndexStats(entryIDSet);
                    if (!entryIDSet.isDefined()) break block22;
                    byte[] byArray = databaseEntry.getData();
                    switch (indexType) {
                        case SUBSTRING: {
                            object = new ArrayList<ByteString>(1);
                            ((ArrayList)object).add(new ASN1OctetString(byArray));
                            searchFilter = SearchFilter.createSubstringFilter(attributeType, null, object, null);
                            break;
                        }
                        case EQ: {
                            AttributeValue attributeValue = new AttributeValue(attributeType, (ByteString)new ASN1OctetString(byArray));
                            searchFilter = SearchFilter.createEqualityFilter(attributeType, attributeValue);
                            break;
                        }
                        case PRES: {
                            searchFilter = SearchFilter.createPresenceFilter(attributeType);
                            break;
                        }
                        default: {
                            ++this.errorCount;
                            System.err.printf("Malformed value%n%s", this.keyDump(index, byArray));
                            break block22;
                        }
                    }
                    object = null;
                    for (EntryID entryID : entryIDSet) {
                        Entry entry;
                        if (object != null && entryID.equals(object)) {
                            System.err.printf("Duplicate reference to ID %d%n%s", entryID.longValue(), this.keyDump(index, databaseEntry.getData()));
                        }
                        object = entryID;
                        try {
                            entry = this.id2entry.get(null, entryID);
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "iterateAttrIndex", exception));
                            ++this.errorCount;
                            System.err.println(exception.getMessage());
                            continue;
                        }
                        if (entry == null) {
                            ++this.errorCount;
                            System.err.printf("Reference to unknown ID %d%n%s", entryID.longValue(), this.keyDump(index, databaseEntry.getData()));
                            continue;
                        }
                        try {
                            if (searchFilter.matchesEntry(entry)) continue;
                            ++this.errorCount;
                            System.err.printf("Reference to entry <%s> which does not match the value%n%s", entry.getDN(), this.keyDump(index, byArray));
                        }
                        catch (DirectoryException directoryException) {
                            assert (Debug.debugException(CLASS_NAME, "iterateAttrIndex", directoryException));
                        }
                    }
                }
                operationStatus = cursor.getNext(databaseEntry, databaseEntry2, LockMode.DEFAULT);
            }
        }
        finally {
            cursor.close();
        }
    }

    private void verifyEntry(EntryID entryID, Entry entry) {
        if (this.verifyDN2ID) {
            this.verifyDN2ID(entryID, entry);
        }
        if (this.verifyID2Children) {
            this.verifyID2Children(entryID, entry);
        }
        if (this.verifyID2Subtree) {
            this.verifyID2Subtree(entryID, entry);
        }
        this.verifyAttrIndex(entryID, entry);
    }

    private void verifyDN2ID(EntryID entryID, Entry entry) {
        Comparable<EntryID> comparable;
        DN dN = entry.getDN();
        try {
            comparable = this.dn2id.get(null, dN);
            if (comparable == null) {
                System.err.printf("File dn2id is missing key %s.%n", dN.toNormalizedString());
                ++this.errorCount;
            } else if (!((EntryID)comparable).equals(entryID)) {
                System.err.printf("File dn2id has ID %d instead of %d for key %s.%n", ((EntryID)comparable).longValue(), entryID.longValue(), dN.toNormalizedString());
                ++this.errorCount;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "verifyDN2ID", exception));
            System.err.printf("File dn2id has error reading key %s: %s.%n", dN.toNormalizedString(), exception.getMessage());
            ++this.errorCount;
        }
        comparable = this.getParent(dN);
        if (comparable != null) {
            try {
                EntryID entryID2 = this.dn2id.get(null, (DN)comparable);
                if (entryID2 == null) {
                    System.err.printf("File dn2id is missing key %s.%n", ((DN)comparable).toNormalizedString());
                    ++this.errorCount;
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "verifyDN2ID", exception));
                System.err.printf("File dn2id has error reading key %s: %s.%n", ((DN)comparable).toNormalizedString(), exception.getMessage());
                ++this.errorCount;
            }
        }
    }

    private void verifyID2Children(EntryID entryID, Entry entry) {
        DN dN = entry.getDN();
        DN dN2 = this.getParent(dN);
        if (dN2 != null) {
            EntryID entryID2 = null;
            try {
                entryID2 = this.dn2id.get(null, dN2);
                if (entryID2 == null) {
                    System.err.printf("File dn2id is missing key %s.%n", dN2.toNormalizedString());
                    ++this.errorCount;
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "verifyID2Children", exception));
                System.err.printf("File dn2id has error reading key %s: %s.", dN2.toNormalizedString(), exception.getMessage());
                ++this.errorCount;
            }
            if (entryID2 != null) {
                try {
                    ConditionResult conditionResult = this.id2c.containsID(null, entryID2.getDatabaseEntry(), entryID);
                    if (conditionResult == ConditionResult.FALSE) {
                        System.err.printf("File id2children is missing ID %d for key %d.%n", entryID.longValue(), entryID2.longValue());
                        ++this.errorCount;
                    } else if (conditionResult == ConditionResult.UNDEFINED) {
                        this.incrEntryLimitStats(this.id2c, entryID2.getDatabaseEntry().getData());
                    }
                }
                catch (DatabaseException databaseException) {
                    assert (Debug.debugException(CLASS_NAME, "verifyID2Children", databaseException));
                    System.err.printf("File id2children has error reading key %d: %s.", entryID2.longValue(), databaseException.getMessage());
                    ++this.errorCount;
                }
            }
        }
    }

    private void verifyID2Subtree(EntryID entryID, Entry entry) {
        DN dN = this.getParent(entry.getDN());
        while (dN != null) {
            EntryID entryID2 = null;
            try {
                entryID2 = this.dn2id.get(null, dN);
                if (entryID2 == null) {
                    System.err.printf("File dn2id is missing key %s.%n", dN.toNormalizedString());
                    ++this.errorCount;
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "verifyID2Children", exception));
                System.err.printf("File dn2id has error reading key %s: %s.%n", dN.toNormalizedString(), exception.getMessage());
                ++this.errorCount;
            }
            if (entryID2 != null) {
                try {
                    ConditionResult conditionResult = this.id2s.containsID(null, entryID2.getDatabaseEntry(), entryID);
                    if (conditionResult == ConditionResult.FALSE) {
                        System.err.printf("File id2subtree is missing ID %d for key %d.%n", entryID.longValue(), entryID2.longValue());
                        ++this.errorCount;
                    } else if (conditionResult == ConditionResult.UNDEFINED) {
                        this.incrEntryLimitStats(this.id2s, entryID2.getDatabaseEntry().getData());
                    }
                }
                catch (DatabaseException databaseException) {
                    assert (Debug.debugException(CLASS_NAME, "verifyID2Subtree", databaseException));
                    System.err.printf("File id2subtree has error reading key %d: %s.%n", entryID2.longValue(), databaseException.getMessage());
                    ++this.errorCount;
                }
            }
            dN = this.getParent(dN);
        }
    }

    public String keyDump(Index index, byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("File: ");
        stringBuilder.append(index.toString());
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("Key:");
        stringBuilder.append(ServerConstants.EOL);
        StaticUtils.byteArrayToHexPlusAscii(stringBuilder, byArray, 6);
        return stringBuilder.toString();
    }

    private void verifyAttrIndex(EntryID entryID, Entry entry) {
        for (AttributeIndex attributeIndex : this.attrIndexList) {
            try {
                List<Attribute> list = entry.getAttribute(attributeIndex.getAttributeType());
                if (list == null) continue;
                this.verifyAttribute(attributeIndex, entryID, list);
            }
            catch (DirectoryException directoryException) {
                assert (Debug.debugException(CLASS_NAME, "verifyAttrIndex", directoryException));
                System.err.printf("Error normalizing values of attribute %s in entry <%s>: %s.%n", attributeIndex.getAttributeType().toString(), entry.getDN().toString(), directoryException.getErrorMessage());
            }
        }
    }

    public void verifyAttribute(AttributeIndex attributeIndex, EntryID entryID, List<Attribute> list) throws DirectoryException {
        Transaction transaction = null;
        Index index = attributeIndex.equalityIndex;
        Index index2 = attributeIndex.presenceIndex;
        Index index3 = attributeIndex.substringIndex;
        Index index4 = attributeIndex.orderingIndex;
        IndexConfig indexConfig = attributeIndex.indexConfig;
        DatabaseEntry databaseEntry = AttributeIndex.presenceKey;
        if (!list.isEmpty() && indexConfig.isPresenceIndex()) {
            try {
                Object object = index2.containsID(transaction, databaseEntry, entryID);
                if (object == ConditionResult.FALSE) {
                    System.err.printf("Missing ID %d%n%s", entryID.longValue(), this.keyDump(index2, databaseEntry.getData()));
                    ++this.errorCount;
                } else if (object == ConditionResult.UNDEFINED) {
                    this.incrEntryLimitStats(index2, databaseEntry.getData());
                }
            }
            catch (DatabaseException databaseException) {
                assert (Debug.debugException(CLASS_NAME, "verifyAttribute", databaseException));
                System.err.printf("Error reading database: %s%n%s", databaseException.getMessage(), this.keyDump(index2, databaseEntry.getData()));
                ++this.errorCount;
            }
        }
        if (list != null) {
            for (Attribute attribute : list) {
                LinkedHashSet<AttributeValue> linkedHashSet = attribute.getValues();
                for (AttributeValue attributeValue : linkedHashSet) {
                    Object object;
                    Object object2;
                    Object object3;
                    byte[] byArray = attributeValue.getNormalizedValue().value();
                    if (indexConfig.isEqualityIndex()) {
                        object3 = new DatabaseEntry(byArray);
                        try {
                            object2 = index.containsID(transaction, (DatabaseEntry)object3, entryID);
                            if (object2 == ConditionResult.FALSE) {
                                System.err.printf("Missing ID %d%n%s", entryID.longValue(), this.keyDump(index, byArray));
                                ++this.errorCount;
                            } else if (object2 == ConditionResult.UNDEFINED) {
                                this.incrEntryLimitStats(index, byArray);
                            }
                        }
                        catch (DatabaseException databaseException) {
                            assert (Debug.debugException(CLASS_NAME, "verifyAttribute", databaseException));
                            System.err.printf("Error reading database: %s%n%s", databaseException.getMessage(), this.keyDump(index, byArray));
                            ++this.errorCount;
                        }
                    }
                    if (indexConfig.isSubstringIndex()) {
                        object3 = attributeIndex.substringKeys(byArray);
                        object2 = new DatabaseEntry();
                        object = object3.iterator();
                        while (object.hasNext()) {
                            ByteString byteString = (ByteString)object.next();
                            object2.setData(byteString.value());
                            try {
                                ConditionResult conditionResult = index3.containsID(transaction, (DatabaseEntry)object2, entryID);
                                if (conditionResult == ConditionResult.FALSE) {
                                    System.err.printf("Missing ID %d%n%s", entryID.longValue(), this.keyDump(index3, object2.getData()));
                                    ++this.errorCount;
                                    continue;
                                }
                                if (conditionResult != ConditionResult.UNDEFINED) continue;
                                this.incrEntryLimitStats(index3, object2.getData());
                            }
                            catch (DatabaseException databaseException) {
                                assert (Debug.debugException(CLASS_NAME, "verifyAttribute", databaseException));
                                System.err.printf("Error reading database: %s%n%s", databaseException.getMessage(), this.keyDump(index3, object2.getData()));
                                ++this.errorCount;
                            }
                        }
                    }
                    if (!indexConfig.isOrderingIndex()) continue;
                    object3 = attribute.getAttributeType().getOrderingMatchingRule();
                    byArray = ((MatchingRule)object3).normalizeValue(attributeValue.getValue()).value();
                    object2 = new DatabaseEntry(byArray);
                    try {
                        object = index4.containsID(transaction, (DatabaseEntry)object2, entryID);
                        if (object == ConditionResult.FALSE) {
                            System.err.printf("Missing ID %d%n%s", entryID.longValue(), this.keyDump(index4, byArray));
                            ++this.errorCount;
                            continue;
                        }
                        if (object != ConditionResult.UNDEFINED) continue;
                        this.incrEntryLimitStats(index4, byArray);
                    }
                    catch (DatabaseException databaseException) {
                        assert (Debug.debugException(CLASS_NAME, "verifyAttribute", databaseException));
                        System.err.printf("Error reading database: %s%n%s", databaseException.getMessage(), this.keyDump(index4, byArray));
                        ++this.errorCount;
                    }
                }
            }
        }
    }

    public DN getParent(DN dN) {
        if (dN.equals(this.verifyConfig.getBaseDN())) {
            return null;
        }
        return dN.getParentDNInSuffix();
    }

    private void addStatEntry(Entry entry, String string, String string2) {
        if (entry != null) {
            Attribute attribute = new Attribute(string, string2);
            entry.addAttribute(attribute, null);
        }
    }

    class ProgressTask
    extends TimerTask {
        private static final String CLASS_NAME = "org.opends.server.backends.jeb.VerifyJob.ProgressTask";
        private long previousCount = 0L;
        private long previousTime = System.currentTimeMillis();
        private EnvironmentStats prevEnvStats;
        private static final int bytesPerMegabyte = 0x100000;

        public ProgressTask() throws DatabaseException {
            this.prevEnvStats = VerifyJob.this.rootContainer.getEnvironmentStats(new StatsConfig());
        }

        public void run() {
            long l = VerifyJob.this.keyCount;
            long l2 = l - this.previousCount;
            long l3 = System.currentTimeMillis();
            long l4 = l3 - this.previousTime;
            if (l4 == 0L) {
                return;
            }
            float f = 1000.0f * (float)l2 / (float)l4;
            int n = 8388717;
            String string = MessageHandler.getMessage(n, l, VerifyJob.this.errorCount, Float.valueOf(f));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n);
            try {
                Runtime runtime = Runtime.getRuntime();
                long l5 = runtime.freeMemory() / 0x100000L;
                EnvironmentStats environmentStats = VerifyJob.this.rootContainer.getEnvironmentStats(new StatsConfig());
                long l6 = environmentStats.getNCacheMiss() - this.prevEnvStats.getNCacheMiss();
                float f2 = 0.0f;
                if (l2 > 0L) {
                    f2 = (float)l6 / (float)l2;
                }
                n = 8388718;
                string = MessageHandler.getMessage(n, l5, Float.valueOf(f2));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n);
                this.prevEnvStats = environmentStats;
            }
            catch (DatabaseException databaseException) {
                Debug.debugException(CLASS_NAME, "run", databaseException);
            }
            this.previousCount = l;
            this.previousTime = l3;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum IndexType {
        PRES,
        EQ,
        SUBSTRING,
        ORDERING;

    }
}

