/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Transaction;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.IndexConfig;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstringIndexer
extends Indexer {
    private static final String CLASS_NAME = "org.opends.server.backends.jeb.SubstringIndexer";
    private static final Comparator<byte[]> comparator = new AttributeIndex.KeyComparator();
    private IndexConfig indexConfig;

    public SubstringIndexer(IndexConfig indexConfig) {
        this.indexConfig = indexConfig;
    }

    public String toString() {
        return this.indexConfig.getAttributeType().getNameOrOID() + ".substring";
    }

    @Override
    public Comparator<byte[]> getComparator() {
        return comparator;
    }

    @Override
    public void indexEntry(Transaction transaction, Entry entry, Set<ASN1OctetString> set) {
        List<Attribute> list = entry.getAttribute(this.indexConfig.getAttributeType());
        if (list != null) {
            this.indexAttribute(list, set);
        }
    }

    @Override
    public void replaceEntry(Transaction transaction, Entry entry, Entry entry2, Set<ASN1OctetString> set, Set<ASN1OctetString> set2) {
        List<Attribute> list = entry.getAttribute(this.indexConfig.getAttributeType());
        HashSet<ASN1OctetString> hashSet = new HashSet<ASN1OctetString>();
        this.indexAttribute(list, hashSet);
        list = entry2.getAttribute(this.indexConfig.getAttributeType());
        HashSet<ASN1OctetString> hashSet2 = new HashSet<ASN1OctetString>();
        this.indexAttribute(list, hashSet2);
        HashSet<ASN1OctetString> hashSet3 = new HashSet<ASN1OctetString>(hashSet);
        hashSet3.removeAll(hashSet2);
        for (ASN1OctetString object2 : hashSet3) {
            set2.add(object2);
        }
        HashSet<ASN1OctetString> hashSet4 = new HashSet<ASN1OctetString>(hashSet2);
        hashSet4.removeAll(hashSet);
        Iterator iterator = hashSet4.iterator();
        while (iterator.hasNext()) {
            ASN1OctetString aSN1OctetString = (ASN1OctetString)iterator.next();
            set.add(aSN1OctetString);
        }
    }

    @Override
    public void modifyEntry(Transaction transaction, Entry entry, Entry entry2, List<Modification> list, Set<ASN1OctetString> set, Set<ASN1OctetString> set2) {
        this.replaceEntry(transaction, entry, entry2, set, set2);
    }

    private void indexAttribute(List<Attribute> list, Set<ASN1OctetString> set) {
        if (list == null) {
            return;
        }
        for (Attribute attribute : list) {
            LinkedHashSet<AttributeValue> linkedHashSet = attribute.getValues();
            for (AttributeValue attributeValue : linkedHashSet) {
                try {
                    byte[] byArray = attributeValue.getNormalizedValue().value();
                    this.substringKeys(byArray, set);
                }
                catch (DirectoryException directoryException) {
                    assert (Debug.debugException(CLASS_NAME, "indexAttribute", directoryException));
                }
            }
        }
    }

    private void substringKeys(byte[] byArray, Set<ASN1OctetString> set) {
        int n = this.indexConfig.getSubstringLength();
        int n2 = 0;
        for (int i = byArray.length; i > 0; --i) {
            int n3 = Math.min(n, i);
            byte[] byArray2 = this.makeSubstringKey(byArray, n2, n3);
            set.add(new ASN1OctetString(byArray2));
            ++n2;
        }
    }

    private byte[] makeSubstringKey(byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        return byArray2;
    }
}

