/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.EnvironmentStats;
import com.sleepycat.je.PreloadConfig;
import com.sleepycat.je.PreloadStatus;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.config.ConfigParam;
import com.sleepycat.je.config.EnvironmentParams;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.opends.server.api.Backend;
import org.opends.server.backends.jeb.Config;
import org.opends.server.backends.jeb.ConfigurableEnvironment;
import org.opends.server.backends.jeb.DbPreloadComparator;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.monitors.DatabaseEnvironmentMonitor;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.FilePermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootContainer {
    private static final String CLASS_NAME = "org.opends.server.backends.jeb.RootContainer";
    private Environment env = null;
    private Config config;
    private Backend backend;
    private DatabaseEnvironmentMonitor monitor = null;
    private ConfigurableEnvironment configurableEnv = null;
    private ConcurrentHashMap<DN, EntryContainer> entryContainers;
    private AtomicLong nextid = new AtomicLong(1L);

    public RootContainer(Config config, Backend backend) {
        this.entryContainers = new ConcurrentHashMap();
        this.backend = backend;
        this.config = config;
    }

    private void open(File file, FilePermission filePermission, EnvironmentConfig environmentConfig) throws DatabaseException {
        try {
            if (!FilePermission.setPermissions(file, filePermission)) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            int n = 0x820080;
            String string = MessageHandler.getMessage(n, file.getPath());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, string, n);
        }
        this.env = new Environment(file, environmentConfig);
        Debug.debugMessage(DebugLogCategory.BACKEND, DebugLogSeverity.INFO, CLASS_NAME, "initializeBackend", this.env.getConfig().toString());
    }

    public void open() throws DatabaseException {
        this.open(this.config.getBackendDirectory(), this.config.getBackendPermission(), this.config.getEnvironmentConfig());
    }

    public void open(File file, FilePermission filePermission, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) throws DatabaseException {
        EnvironmentConfig environmentConfig = this.config.getEnvironmentConfig() != null ? this.config.getEnvironmentConfig() : new EnvironmentConfig();
        environmentConfig.setReadOnly(bl);
        environmentConfig.setAllowCreate(bl2);
        environmentConfig.setTransactional(bl3);
        environmentConfig.setTxnNoSync(bl4);
        environmentConfig.setConfigParam("je.env.isLocking", String.valueOf(bl5));
        environmentConfig.setConfigParam("je.env.runCheckpointer", String.valueOf(bl6));
        this.open(file, filePermission, environmentConfig);
    }

    public EntryContainer openEntryContainer(DN dN) throws DatabaseException {
        EntryContainer entryContainer = new EntryContainer(dN, this.backend, this.config, this.env, this);
        EntryContainer entryContainer2 = this.entryContainers.get(dN);
        if (entryContainer2 != null) {
            throw new DatabaseException("Entry container for baseDN " + dN.toString() + " already is open.");
        }
        if (this.env.getConfig().getReadOnly()) {
            entryContainer.openReadOnly();
        } else if (!this.env.getConfig().getTransactional()) {
            entryContainer.openNonTransactional(true);
        } else {
            entryContainer.open();
        }
        this.entryContainers.put(dN, entryContainer);
        return entryContainer;
    }

    public void openEntryContainers(DN[] dNArray) throws DatabaseException {
        EntryID entryID = null;
        EntryID entryID2 = null;
        for (DN dN : dNArray) {
            EntryContainer entryContainer = this.openEntryContainer(dN);
            entryID = entryContainer.getHighestEntryID();
            if (entryID2 != null && entryID.compareTo(entryID2) <= 0) continue;
            entryID2 = entryID;
        }
        this.nextid = new AtomicLong(entryID2.longValue() + 1L);
    }

    public void closeEntryContainer(DN dN) throws DatabaseException {
        this.getEntryContainer(dN).close();
        this.entryContainers.remove(dN);
    }

    public void removeEntryContainer(DN dN) throws DatabaseException {
        this.getEntryContainer(dN).close();
        this.getEntryContainer(dN).removeContainer();
        this.entryContainers.remove(dN);
    }

    public ConfigurableEnvironment getConfigurableEnvironment() {
        DN dN;
        if (this.configurableEnv == null && (dN = this.config.getEnvConfigDN()) != null) {
            this.configurableEnv = new ConfigurableEnvironment(dN, this.env);
        }
        return this.configurableEnv;
    }

    public DatabaseEnvironmentMonitor getMonitorProvider() {
        if (this.monitor == null) {
            String string = this.backend.getBackendID() + " Database Environment";
            this.monitor = new DatabaseEnvironmentMonitor(string, this.env);
        }
        return this.monitor;
    }

    public void preload() {
        block6: {
            assert (Debug.debugEnter(CLASS_NAME, "preload", new String[0]));
            long l = this.config.getPreloadTimeLimit();
            if (l > 0L) {
                ArrayList<Database> arrayList = new ArrayList<Database>();
                for (EntryContainer entryContainer : this.entryContainers.values()) {
                    entryContainer.listDatabases(arrayList);
                }
                Collections.sort(arrayList, new DbPreloadComparator());
                try {
                    Object object;
                    long l2 = System.currentTimeMillis() + l;
                    PreloadConfig preloadConfig = new PreloadConfig();
                    preloadConfig.setLoadLNs(true);
                    for (Database database : arrayList) {
                        long l3 = l2 - System.currentTimeMillis();
                        if (l3 <= 0L) break;
                        preloadConfig.setMaxMillisecs(l3);
                        object = database.preload(preloadConfig);
                        if (object.getStatus() == PreloadStatus.SUCCESS) continue;
                        break;
                    }
                    EnvironmentStats environmentStats = this.env.getStats(new StatsConfig());
                    long l4 = environmentStats.getCacheTotalBytes();
                    int n = 8847421;
                    object = MessageHandler.getMessage(n, l4 / 0x100000L);
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, (String)object, n);
                }
                catch (DatabaseException databaseException) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "preload", databaseException)) break block6;
                    throw new AssertionError();
                }
            }
        }
    }

    private void cleanDatabase() throws DatabaseException {
        assert (Debug.debugEnter(CLASS_NAME, "cleanDatabase", new String[0]));
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".jdb");
            }
        };
        File file = this.env.getHome();
        int n = file.list(filenameFilter).length;
        int n2 = 8847389;
        String string = MessageHandler.getMessage(n2, n, file.getPath());
        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n2);
        int n3 = 0;
        int n4 = 0;
        while ((n3 = this.env.cleanLog()) > 0) {
            n4 += n3;
        }
        n2 = 8847390;
        string = MessageHandler.getMessage(n2, n4);
        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n2);
        if (n4 > 0) {
            CheckpointConfig checkpointConfig = new CheckpointConfig();
            checkpointConfig.setForce(true);
            this.env.checkpoint(checkpointConfig);
        }
        int n5 = file.list(filenameFilter).length;
        n2 = 8847391;
        string = MessageHandler.getMessage(n2, n5);
        Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.NOTICE, string, n2);
    }

    public void close() throws DatabaseException {
        for (DN dN : this.entryContainers.keySet()) {
            this.entryContainers.get(dN).close();
            this.entryContainers.remove(dN);
        }
        this.env.close();
    }

    public Collection<EntryContainer> getEntryContainers() {
        return this.entryContainers.values();
    }

    public Set<DN> getBaseDNs() {
        return this.entryContainers.keySet();
    }

    public EntryContainer getEntryContainer(DN dN) {
        EntryContainer entryContainer = null;
        DN dN2 = dN;
        while (entryContainer == null && dN2 != null) {
            entryContainer = this.entryContainers.get(dN2);
            if (entryContainer != null) continue;
            dN2 = dN2.getParentDNInSuffix();
        }
        return entryContainer;
    }

    public void applyNewConfig(Config config) throws DatabaseException {
        Object object;
        FilePermission filePermission = this.config.getBackendPermission();
        FilePermission filePermission2 = config.getBackendPermission();
        if (!FilePermission.toUNIXMode(filePermission).equals(FilePermission.toUNIXMode(filePermission2))) {
            try {
                if (!FilePermission.setPermissions(config.getBackendDirectory(), filePermission2)) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                int n = 0x820080;
                object = MessageHandler.getMessage(n, this.config.getBackendDirectory().getPath());
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, (String)object, n);
            }
        }
        EnvironmentConfig environmentConfig = this.config.getEnvironmentConfig();
        EnvironmentConfig environmentConfig2 = config.getEnvironmentConfig();
        object = EnvironmentParams.SUPPORTED_PARAMS;
        for (Object v : object.values()) {
            String string;
            String string2;
            ConfigParam configParam = (ConfigParam)v;
            if (configParam.isMutable() || (string2 = environmentConfig.getConfigParam(configParam.getName())).equalsIgnoreCase(string = environmentConfig2.getConfigParam(configParam.getName()))) continue;
            System.out.println("The change to the following property will take effect when the backend is restarted: " + configParam.getName());
        }
        this.env.setMutableConfig((EnvironmentMutableConfig)config.getEnvironmentConfig());
        this.config = config;
        Debug.debugMessage(DebugLogCategory.BACKEND, DebugLogSeverity.INFO, CLASS_NAME, "applyNewConfiguration", this.env.getConfig().toString());
    }

    public EnvironmentStats getEnvironmentStats(StatsConfig statsConfig) throws DatabaseException {
        return this.env.getStats(statsConfig);
    }

    public EnvironmentConfig getEnvironmentConfig() throws DatabaseException {
        return this.env.getConfig();
    }

    public long getEntryCount() throws DatabaseException {
        long l = 0L;
        for (EntryContainer entryContainer : this.entryContainers.values()) {
            l += entryContainer.getEntryCount();
        }
        return l;
    }

    public EntryID getNextEntryID() {
        return new EntryID(this.nextid.getAndIncrement());
    }

    public Long getLowestEntryID() {
        return 1L;
    }

    public Long getHighestEntryID() {
        return this.nextid.get() - 1L;
    }
}

