/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Transaction;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.opends.server.backends.jeb.AttributeIndex;
import org.opends.server.backends.jeb.IndexConfig;
import org.opends.server.backends.jeb.Indexer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.Entry;
import org.opends.server.types.Modification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresenceIndexer
extends Indexer {
    private static final String CLASS_NAME = "org.opends.server.backends.jeb.PresenceIndexer";
    private static final Comparator<byte[]> comparator = new AttributeIndex.KeyComparator();
    private IndexConfig indexConfig;

    public PresenceIndexer(IndexConfig indexConfig) {
        this.indexConfig = indexConfig;
    }

    public String toString() {
        return this.indexConfig.getAttributeType().getNameOrOID() + ".presence";
    }

    @Override
    public Comparator<byte[]> getComparator() {
        return comparator;
    }

    @Override
    public void indexEntry(Transaction transaction, Entry entry, Set<ASN1OctetString> set) throws DatabaseException {
        List<Attribute> list = entry.getAttribute(this.indexConfig.getAttributeType());
        if (list != null && !list.isEmpty()) {
            set.add(new ASN1OctetString(AttributeIndex.presenceKey.getData()));
        }
    }

    @Override
    public void replaceEntry(Transaction transaction, Entry entry, Entry entry2, Set<ASN1OctetString> set, Set<ASN1OctetString> set2) throws DatabaseException {
        List<Attribute> list = entry.getAttribute(this.indexConfig.getAttributeType());
        List<Attribute> list2 = entry2.getAttribute(this.indexConfig.getAttributeType());
        if (list == null || list.isEmpty()) {
            if (list2 != null && !list2.isEmpty()) {
                set.add(new ASN1OctetString(AttributeIndex.presenceKey.getData()));
            }
        } else if (list2 == null || list2.isEmpty()) {
            set2.add(new ASN1OctetString(AttributeIndex.presenceKey.getData()));
        }
    }

    @Override
    public void modifyEntry(Transaction transaction, Entry entry, Entry entry2, List<Modification> list, Set<ASN1OctetString> set, Set<ASN1OctetString> set2) throws DatabaseException {
        this.replaceEntry(transaction, entry, entry2, set, set2);
    }
}

