/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.zip.DataFormatException;
import org.opends.server.backends.jeb.DataConfig;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.asn1.ASN1Set;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.CryptoManager;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ObjectClass;

public class JebFormat {
    private static final String CLASS_NAME = "org.opends.server.backends.je.JebFormat";
    public static final byte FORMAT_VERSION = 1;
    public static final byte TAG_DATABASE_ENTRY = 96;
    public static final byte TAG_DIRECTORY_SERVER_ENTRY = 97;

    public static byte[] decodeDatabaseEntry(byte[] byArray) throws ASN1Exception, DataFormatException {
        byte[] byArray2;
        assert (Debug.debugEnter(CLASS_NAME, "decodeDatabaseEntry", String.valueOf(byArray)));
        byte[] byArray3 = new byte[byArray.length - 1];
        System.arraycopy(byArray, 1, byArray3, 0, byArray3.length);
        ArrayList<ASN1Element> arrayList = ASN1Sequence.decodeAsSequence(byArray3).elements();
        int n = ((ASN1Element)arrayList.get(0)).decodeAsInteger().intValue();
        byte[] byArray4 = ((ASN1Element)arrayList.get(1)).decodeAsOctetString().value();
        if (n == 0) {
            byArray2 = byArray4;
        } else {
            CryptoManager cryptoManager = DirectoryServer.getCryptoManager();
            byArray2 = new byte[n];
            cryptoManager.uncompress(byArray4, byArray2);
        }
        return byArray2;
    }

    public static Entry entryFromDatabase(byte[] byArray) throws DirectoryException, ASN1Exception, LDAPException, DataFormatException {
        assert (Debug.debugEnter(CLASS_NAME, "entryFromDatabase", String.valueOf(byArray)));
        byte[] byArray2 = JebFormat.decodeDatabaseEntry(byArray);
        return JebFormat.decodeDirectoryServerEntry(byArray2);
    }

    private static Entry decodeDirectoryServerEntry(byte[] byArray) throws DirectoryException, ASN1Exception, LDAPException {
        List<Attribute> list;
        Object object;
        assert (Debug.debugEnter(CLASS_NAME, "decodeDirectoryServerEntry", String.valueOf(byArray)));
        HashMap<AttributeType, List<Attribute>> hashMap = new HashMap<AttributeType, List<Attribute>>();
        HashMap<AttributeType, List<Attribute>> hashMap2 = new HashMap<AttributeType, List<Attribute>>();
        ArrayList<ASN1Element> arrayList = ASN1Sequence.decodeAsSequence(byArray).elements();
        DN dN = DN.decode(((ASN1Element)arrayList.get(0)).decodeAsOctetString().stringValue());
        ArrayList<ASN1Element> arrayList2 = ((ASN1Element)arrayList.get(1)).decodeAsSet().elements();
        HashMap<ObjectClass, String> hashMap3 = new HashMap<ObjectClass, String>(arrayList2.size() * 4 / 3);
        for (ASN1Element aSN1Element : arrayList2) {
            object = aSN1Element.decodeAsOctetString().stringValue();
            list = ((String)object).toLowerCase();
            ObjectClass objectClass = DirectoryServer.getObjectClass((String)((Object)list));
            if (objectClass == null) {
                objectClass = DirectoryServer.getDefaultObjectClass((String)object);
            }
            hashMap3.put(objectClass, (String)object);
        }
        arrayList2 = ((ASN1Element)arrayList.get(2)).decodeAsSequence().elements();
        for (ASN1Element aSN1Element : arrayList2) {
            object = LDAPAttribute.decode(aSN1Element).toAttribute();
            list = (List)hashMap.get(((Attribute)object).getAttributeType());
            if (list == null) {
                list = new ArrayList<Object>(1);
                list.add((Attribute)object);
                hashMap.put(((Attribute)object).getAttributeType(), list);
                continue;
            }
            list.add((Attribute)object);
        }
        arrayList2 = ((ASN1Element)arrayList.get(3)).decodeAsSequence().elements();
        for (ASN1Element aSN1Element : arrayList2) {
            object = LDAPAttribute.decode(aSN1Element).toAttribute();
            list = hashMap2.get(((Attribute)object).getAttributeType());
            if (list == null) {
                list = new ArrayList(1);
                list.add((Attribute)object);
                hashMap2.put(((Attribute)object).getAttributeType(), list);
                continue;
            }
            list.add((Attribute)object);
        }
        return new Entry(dN, hashMap3, hashMap, hashMap2);
    }

    public static byte[] encodeDatabaseEntry(byte[] byArray, DataConfig dataConfig) {
        Object object;
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "encodeDatabaseEntry", String.valueOf(dataConfig)));
        int n2 = 0;
        CryptoManager cryptoManager = DirectoryServer.getCryptoManager();
        if (dataConfig.isCompressed() && cryptoManager != null && (n = cryptoManager.compress(byArray, (byte[])(object = (Object)new byte[byArray.length]))) != -1) {
            n2 = byArray.length;
            byArray = new byte[n];
            System.arraycopy(object, 0, byArray, 0, n);
        }
        object = new ArrayList(2);
        ((ArrayList)object).add(new ASN1Integer(n2));
        ((ArrayList)object).add(new ASN1OctetString(byArray));
        byte[] byArray2 = new ASN1Sequence(96, (ArrayList<ASN1Element>)object).encode();
        byte[] byArray3 = new byte[byArray2.length + 1];
        byArray3[0] = 1;
        System.arraycopy(byArray2, 0, byArray3, 1, byArray2.length);
        return byArray3;
    }

    public static byte[] entryToDatabase(Entry entry, DataConfig dataConfig) {
        assert (Debug.debugEnter(CLASS_NAME, "entryToDatabase", String.valueOf(dataConfig)));
        byte[] byArray = JebFormat.encodeDirectoryServerEntry(entry);
        return JebFormat.encodeDatabaseEntry(byArray, dataConfig);
    }

    public static byte[] entryToDatabase(Entry entry) {
        assert (Debug.debugEnter(CLASS_NAME, "entryToDatabase", new String[0]));
        return JebFormat.entryToDatabase(entry, new DataConfig());
    }

    private static byte[] encodeDirectoryServerEntry(Entry entry) {
        assert (Debug.debugEnter(CLASS_NAME, "encodeDirectoryServerEntry", new String[0]));
        ArrayList<ASN1Element> arrayList2 = new ArrayList<ASN1Element>(4);
        arrayList2.add(new ASN1OctetString(entry.getDN().toString()));
        Collection<String> collection = entry.getObjectClasses().values();
        ArrayList<ASN1Element> arrayList3 = new ArrayList<ASN1Element>(collection.size());
        for (String arrayList4 : collection) {
            arrayList3.add(new ASN1OctetString(arrayList4));
        }
        arrayList2.add(new ASN1Set(arrayList3));
        ArrayList arrayList5 = new ArrayList();
        for (List<Attribute> list : entry.getUserAttributes().values()) {
            for (Object object : list) {
                arrayList5.add(new LDAPAttribute((Attribute)object).encode());
            }
        }
        arrayList2.add(new ASN1Sequence(arrayList5));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>();
        for (List<Attribute> list : entry.getOperationalAttributes().values()) {
            for (Attribute attribute : list) {
                arrayList.add(new LDAPAttribute(attribute).encode());
            }
        }
        arrayList2.add(new ASN1Sequence(arrayList));
        return new ASN1Sequence(97, arrayList2).encode();
    }

    public static long entryIDFromDatabase(byte[] byArray) {
        long l = 0L;
        for (int i = 0; i < 8; ++i) {
            l <<= 8;
            l |= (long)(byArray[i] & 0xFF);
        }
        return l;
    }

    public static long[] entryIDListFromDatabase(byte[] byArray) {
        if (byArray == null) {
            return new long[0];
        }
        if (byArray.length == 0) {
            return null;
        }
        byte[] byArray2 = byArray;
        int n = byArray2.length / 8;
        long[] lArray = new long[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            long l = 0L;
            l |= ((long)byArray2[n2++] & 0xFFL) << 56;
            l |= ((long)byArray2[n2++] & 0xFFL) << 48;
            l |= ((long)byArray2[n2++] & 0xFFL) << 40;
            l |= ((long)byArray2[n2++] & 0xFFL) << 32;
            l |= ((long)byArray2[n2++] & 0xFFL) << 24;
            l |= ((long)byArray2[n2++] & 0xFFL) << 16;
            l |= ((long)byArray2[n2++] & 0xFFL) << 8;
            lArray[i] = l |= (long)byArray2[n2++] & 0xFFL;
        }
        return lArray;
    }

    public static byte[] entryIDToDatabase(long l) {
        byte[] byArray = new byte[8];
        long l2 = l;
        for (int i = 7; i >= 0; --i) {
            byArray[i] = (byte)(l2 & 0xFFL);
            l2 >>>= 8;
        }
        return byArray;
    }

    public static byte[] entryIDListToDatabase(long[] lArray) {
        if (lArray == null) {
            return new byte[0];
        }
        if (lArray.length == 0) {
            return null;
        }
        byte[] byArray = new byte[8 * lArray.length];
        int n = 0;
        for (int i = 0; i < lArray.length; ++i) {
            long l = lArray[i];
            byArray[n++] = (byte)(l >>> 56 & 0xFFL);
            byArray[n++] = (byte)(l >>> 48 & 0xFFL);
            byArray[n++] = (byte)(l >>> 40 & 0xFFL);
            byArray[n++] = (byte)(l >>> 32 & 0xFFL);
            byArray[n++] = (byte)(l >>> 24 & 0xFFL);
            byArray[n++] = (byte)(l >>> 16 & 0xFFL);
            byArray[n++] = (byte)(l >>> 8 & 0xFFL);
            byArray[n++] = (byte)(l & 0xFFL);
        }
        return byArray;
    }

    public static byte getEntryVersion(byte[] byArray) {
        return byArray[0];
    }
}

