/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.backends.jeb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import org.opends.server.backends.jeb.DataConfig;
import org.opends.server.backends.jeb.EntryContainer;
import org.opends.server.backends.jeb.EntryID;
import org.opends.server.backends.jeb.JebException;
import org.opends.server.backends.jeb.JebFormat;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.Entry;

public class ID2Entry {
    private EntryContainer entryContainer;
    private DatabaseConfig dbConfig;
    private DataConfig dataConfig;
    private String name;
    private ThreadLocal<Database> threadLocalDatabase = new ThreadLocal();

    public ID2Entry(EntryContainer entryContainer, DatabaseConfig databaseConfig, DataConfig dataConfig, String string) {
        this.entryContainer = entryContainer;
        this.dbConfig = databaseConfig;
        this.name = string;
        this.dataConfig = dataConfig;
    }

    public void open() throws DatabaseException {
        this.getDatabase();
    }

    private Database getDatabase() throws DatabaseException {
        Database database = this.threadLocalDatabase.get();
        if (database == null) {
            database = this.entryContainer.openDatabase(this.dbConfig, this.name);
            this.threadLocalDatabase.set(database);
        }
        return database;
    }

    private DatabaseEntry entryData(Entry entry) {
        byte[] byArray = JebFormat.entryToDatabase(entry, this.dataConfig);
        return new DatabaseEntry(byArray);
    }

    public boolean insert(Transaction transaction, EntryID entryID, Entry entry) throws DatabaseException {
        DatabaseEntry databaseEntry = entryID.getDatabaseEntry();
        DatabaseEntry databaseEntry2 = this.entryData(entry);
        OperationStatus operationStatus = EntryContainer.insert(this.getDatabase(), transaction, databaseEntry, databaseEntry2);
        return operationStatus == OperationStatus.SUCCESS;
    }

    public boolean put(Transaction transaction, EntryID entryID, Entry entry) throws DatabaseException {
        DatabaseEntry databaseEntry = entryID.getDatabaseEntry();
        DatabaseEntry databaseEntry2 = this.entryData(entry);
        OperationStatus operationStatus = EntryContainer.put(this.getDatabase(), transaction, databaseEntry, databaseEntry2);
        return operationStatus == OperationStatus.SUCCESS;
    }

    public boolean putRaw(Transaction transaction, DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        OperationStatus operationStatus = EntryContainer.put(this.getDatabase(), transaction, databaseEntry, databaseEntry2);
        return operationStatus == OperationStatus.SUCCESS;
    }

    public boolean remove(Transaction transaction, EntryID entryID) throws DatabaseException {
        DatabaseEntry databaseEntry = entryID.getDatabaseEntry();
        OperationStatus operationStatus = EntryContainer.delete(this.getDatabase(), transaction, databaseEntry);
        return operationStatus == OperationStatus.SUCCESS;
    }

    public Entry get(Transaction transaction, EntryID entryID) throws JebException, DatabaseException {
        DatabaseEntry databaseEntry = entryID.getDatabaseEntry();
        DatabaseEntry databaseEntry2 = new DatabaseEntry();
        OperationStatus operationStatus = EntryContainer.read(this.getDatabase(), transaction, databaseEntry, databaseEntry2, LockMode.DEFAULT);
        if (operationStatus != OperationStatus.SUCCESS) {
            return null;
        }
        byte[] byArray = databaseEntry2.getData();
        byte by = JebFormat.getEntryVersion(byArray);
        switch (by) {
            case 1: {
                try {
                    return JebFormat.entryFromDatabase(byArray);
                }
                catch (Exception exception) {
                    int n = 8650764;
                    String string = MessageHandler.getMessage(n, entryID.toString());
                    throw new JebException(n, string);
                }
            }
        }
        int n = 8650878;
        String string = MessageHandler.getMessage(n, entryID.toString(), by);
        throw new JebException(n, string);
    }

    public Cursor openCursor(Transaction transaction, CursorConfig cursorConfig) throws DatabaseException {
        Database database = this.getDatabase();
        return database.openCursor(transaction, cursorConfig);
    }

    public long getRecordCount(Transaction transaction) throws DatabaseException {
        DatabaseEntry databaseEntry = new DatabaseEntry();
        EntryID entryID = new EntryID(0L);
        DatabaseEntry databaseEntry2 = entryID.getDatabaseEntry();
        OperationStatus operationStatus = EntryContainer.read(this.getDatabase(), transaction, databaseEntry2, databaseEntry, LockMode.DEFAULT);
        long l = 0L;
        if (operationStatus == OperationStatus.SUCCESS) {
            l = JebFormat.entryIDFromDatabase(databaseEntry.getData());
        }
        return l;
    }

    public void adjustRecordCount(Transaction transaction, long l) throws DatabaseException {
        DatabaseEntry databaseEntry = new DatabaseEntry();
        EntryID entryID = new EntryID(0L);
        DatabaseEntry databaseEntry2 = entryID.getDatabaseEntry();
        OperationStatus operationStatus = EntryContainer.read(this.getDatabase(), transaction, databaseEntry2, databaseEntry, LockMode.RMW);
        long l2 = 0L;
        if (operationStatus == OperationStatus.SUCCESS) {
            l2 = JebFormat.entryIDFromDatabase(databaseEntry.getData());
        }
        byte[] byArray = JebFormat.entryIDToDatabase(l2 += l);
        databaseEntry.setData(byArray);
        EntryContainer.put(this.getDatabase(), transaction, databaseEntry2, databaseEntry);
    }
}

